/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.server;

import java.util.List;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.database.Database;
import oracle.cluster.database.Service;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerGroupArgs;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.CompositeOperationException;

public interface ServerGroup
extends ManageableEntity {
    public List<ServerGroup> parents() throws ServerGroupException;

    public List<ServerGroup> children() throws ServerGroupException;

    public int getCurrentSize() throws ServerGroupException;

    public int getMinSize() throws ServerGroupException;

    public int getMaxSize() throws ServerGroupException;

    public int getImportance() throws ServerGroupException;

    public void setImportance(int var1) throws ServerGroupException;

    public void setMinSize(int var1) throws ServerGroupException;

    public void setMaxSize(int var1) throws ServerGroupException;

    public void setServers(Server[] var1) throws ServerGroupException;

    public void setServers(boolean var1, Server[] var2) throws ServerGroupException;

    public void setParents(List<ServerGroup> var1) throws ServerGroupException;

    public List<Server> configuredServers() throws ServerGroupException;

    public List<Server> servers() throws ServerGroupException;

    public void addServers(boolean var1, List<Server> var2) throws CompositeOperationException, ServerGroupException;

    public void addServers(List<Server> var1) throws CompositeOperationException, ServerGroupException;

    public String[] relocateServers(List<Server> var1) throws CompositeOperationException, ServerGroupException;

    public String[] relocateServers(boolean var1, List<Server> var2) throws CompositeOperationException, ServerGroupException;

    public void removeServers(List<Server> var1) throws CompositeOperationException, ServerGroupException;

    public void removeServers(boolean var1, List<Server> var2) throws CompositeOperationException, ServerGroupException;

    public List<Database> databases() throws ServerGroupException;

    public List<Service> services() throws ServerGroupException;

    public List<String> serviceNames(String var1) throws ServerGroupException;

    public String getExclusiveGroups() throws ServerGroupException;

    public void setExclusiveGroups(String var1) throws ServerGroupException;

    public void remove() throws CompositeOperationException, ServerGroupException;

    public boolean isServerPool() throws ServerGroupException;

    public void modify(boolean var1, ServerGroupArgs var2) throws ServerGroupException;
}

