/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.server;

import java.util.List;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.Site;
import oracle.cluster.util.NotExistsException;

public interface Server
extends ManageableEntity {
    public List<ServerState> states() throws ServerException;

    public Node node() throws ServerException;

    public boolean isEnabled() throws ServerException;

    public void enable() throws ServerException;

    public void disable() throws ServerException;

    public List<ServerGroup> serverGroups() throws NotExistsException, ServerException;

    public void setWorkload(int var1) throws ServerException;

    public int getWorkload() throws ServerException;

    public int getMemorySize() throws ServerException;

    public int getCPUCount() throws ServerException;

    public int getCPUClockRate() throws ServerException;

    public boolean isCPUHyperThreading() throws ServerException;

    public ServerRole role() throws ServerException;

    public List<ServerCategory> serverCategories() throws ServerException;

    public Site site() throws ServerException;

    public static enum ServerRole {
        HUB("HUB"),
        RIM("LEAF");

        private String m_role;

        private ServerRole(String role) {
            this.m_role = role;
        }

        public String toString() {
            return this.m_role;
        }

        public static ServerRole getMember(String value) {
            for (ServerRole member : ServerRole.values()) {
                if (!member.toString().equalsIgnoreCase(value)) continue;
                return member;
            }
            throw new EnumConstantNotPresentException(ServerRole.class, value);
        }
    }

    public static enum ServerState {
        ONLINE("ONLINE"),
        OFFLINE("OFFLINE"),
        VISIBLE("VISIBLE"),
        JOINING("JOINING"),
        LEAVING("LEAVING"),
        RECONFIGURING("RECONFIGURING");

        private String m_state;

        private ServerState(String state) {
            this.m_state = state;
        }

        public String toString() {
            return this.m_state;
        }

        public static ServerState getMember(String value) {
            for (ServerState member : ServerState.values()) {
                if (!member.toString().equalsIgnoreCase(value)) continue;
                return member;
            }
            throw new EnumConstantNotPresentException(ServerState.class, value);
        }
    }
}

