/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote.timer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import oracle.cluster.remote.timer.TimeoutInfo;
import oracle.cluster.remote.timer.TimerListener;
import oracle.ops.mgmt.trace.Trace;

public class TimeoutChecker {
    private static final int DEFAULT_TIMEOUT_CHECK_INTERVAL = 1;
    private final Map<String, TimeoutInfo> m_expirationTimeMap = new HashMap<String, TimeoutInfo>();
    private final MonitorThread m_monitorThread;
    private int m_timerCount = 0;

    private TimeoutChecker() {
        this(1);
    }

    private TimeoutChecker(int timeoutCheckInterval) {
        this.m_monitorThread = new MonitorThread(timeoutCheckInterval);
    }

    public static TimeoutChecker getInstance() {
        return new TimeoutChecker();
    }

    public static TimeoutChecker getInstance(int timeoutCheckInterval) {
        return new TimeoutChecker(timeoutCheckInterval);
    }

    public synchronized String createTimer(TimerListener timerListener, int secondsTillExpire) {
        ++this.m_timerCount;
        TimeoutInfo timeoutInfo = new TimeoutInfo(System.currentTimeMillis() + (long)(1000 * secondsTillExpire), timerListener);
        this.m_expirationTimeMap.put(String.valueOf(this.m_timerCount), timeoutInfo);
        return String.valueOf(this.m_timerCount);
    }

    public synchronized boolean cancelTimer(String timerID) {
        if (timerID == null) {
            return false;
        }
        return this.m_expirationTimeMap.remove(timerID) != null;
    }

    public void start() {
        this.m_monitorThread.start();
    }

    public void stop() {
        this.m_monitorThread.interrupt();
    }

    public boolean isAlive() {
        return this.m_monitorThread.isAlive();
    }

    private final class MonitorThread
    extends Thread {
        private final int m_timeoutCheckInterval;

        private MonitorThread(int timeoutCheckInterval) {
            this.m_timeoutCheckInterval = timeoutCheckInterval;
        }

        @Override
        public void run() {
            Trace.out("The timeout checker started running...");
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(this.m_timeoutCheckInterval);
                }
                catch (InterruptedException ie) {
                    break;
                }
                this.checkForTimeouts();
            }
            Trace.out("The timeout checker stopped running...");
        }

        public synchronized int getActiveTimers() {
            return TimeoutChecker.this.m_expirationTimeMap.size();
        }

        private void checkForTimeouts() {
            long currTime = System.currentTimeMillis();
            LinkedList<String> removeList = new LinkedList<String>();
            Set keys = TimeoutChecker.this.m_expirationTimeMap.keySet();
            for (String key : keys) {
                final TimeoutInfo timeoutInfo = (TimeoutInfo)TimeoutChecker.this.m_expirationTimeMap.get(key);
                if (currTime <= timeoutInfo.getExpirationTime()) continue;
                removeList.add(key);
                new Thread(){

                    @Override
                    public void run() {
                        timeoutInfo.getTimerListener().timerExpired();
                    }
                }.start();
            }
            for (String key : removeList) {
                TimeoutChecker.this.m_expirationTimeMap.remove(key);
            }
        }
    }
}

