/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.remote.operations.RemotePathException;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.InvalidPathException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.IsCFSCheckFileCommand;
import oracle.ops.mgmt.command.file.PathExistCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class SharedPath {
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static final int SPLIT_CHECK_THRESHOLD = 3;
    private static final MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    static final Comparator<List> groupListComparator = new Comparator<List>(){

        @Override
        public int compare(List list, List list2) {
            return list2.size() - list.size();
        }
    };

    private SharedPath() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isSharedPath(String string, String[] stringArray, String string2) throws InvalidNodeListException, InvalidPathException, ClusterException, ClusterOperationException {
        String string32;
        String string4;
        if (stringArray == null || stringArray.length == 0) {
            Trace.out("nodeList passed is null");
            throw new InvalidNodeListException("Prkc", "1062");
        }
        SharedPath.validateLocalNode(string2);
        if (string == null) {
            Trace.out("pathName passed is null");
            throw new InvalidPathException(MessageBundle.getMessageBundle(PrCtMsgID.facility).getMessage(PrCtMsgID.NULL_FILE_PATH, true));
        }
        File file = new File(string);
        try {
            if (!file.isDirectory() && file.getParentFile() != null) {
                file = file.getParentFile();
            }
        }
        catch (SecurityException securityException) {
            throw new ClusterException(securityException.getMessage());
        }
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string4 = file.getAbsolutePath();
        }
        Trace.out("dirPath=" + file.getPath());
        if (!IS_UNIX_SYSTEM) {
            try {
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                NativeResult nativeResult = nativeSystem.isSharedPath(string4, stringArray, string2);
                return nativeResult.getBooleanResult();
            }
            catch (SharedDeviceException sharedDeviceException) {
                Trace.out("Caught SharedDeviceException while checking for path sharedness");
                Trace.out(sharedDeviceException.getMessage());
                MessageBundle messageBundle = MessageBundle.getMessageBundle("Prkn");
                throw new ClusterException(messageBundle.getMessage("1009", true), sharedDeviceException);
            }
        }
        Trace.out("NodeList=" + Arrays.asList(stringArray));
        HashSet<String> hashSet = new HashSet<String>();
        for (String string32 : stringArray) {
            if (string32.equalsIgnoreCase(string2)) continue;
            hashSet.add(string32);
        }
        String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        String string5 = "CFSFileName" + (int)(Math.random() * 99999.0) + String.valueOf(System.currentTimeMillis());
        Trace.out("pathName=" + string + " tempFile=" + string5);
        File file2 = new File(file, string5);
        string32 = file2.getPath();
        Trace.out("dirPathName is " + string32);
        if (file2.exists()) {
            file2.delete();
        }
        Trace.out("creating file " + string32);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write("This is CFS test file content".getBytes());
            fileOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.out("Failed to create the test CFS file at " + string32);
            if (file2.exists()) {
                file2.delete();
            }
            Object[] objectArray = new Object[]{string};
            throw new ClusterException(s_msgBundle.getMessage("1025", true, objectArray), fileNotFoundException);
        }
        catch (IOException iOException) {
            Trace.out("Failed to write to the test CFS file " + string32);
            if (file2.exists()) {
                file2.delete();
            }
            Object[] objectArray = new Object[]{string32};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, objectArray), iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (IS_UNIX_SYSTEM && stringArray.length == 1 && stringArray[0].equalsIgnoreCase(string2)) {
            file2.delete();
            return true;
        }
        Trace.out("Executing command objects per node: " + Arrays.asList(stringArray2));
        Command[] commandArray = new PathExistCommand[stringArray2.length];
        CommandFactory commandFactory = new CommandFactory();
        NativeResult[] nativeResultArray = new CommandResult[stringArray2.length + 1];
        Vector<String> vector = new Vector<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        ClusterException clusterException = null;
        CommandResult commandResult = new CommandResult();
        commandResult.setNodeName(string2);
        commandResult.setStatus(true);
        for (int i = 0; i < stringArray2.length; ++i) {
            commandArray[i] = (PathExistCommand)commandFactory.CreateCommand(new PathExistCommand(stringArray2[i], string32), 0);
        }
        try {
            clusterCmd.submit(commandArray);
            Trace.out("Successfully executed the test");
        }
        catch (ClusterException clusterException2) {
            Trace.out("Could not submit" + clusterException2.getMessage());
            clusterException = clusterException2;
        }
        finally {
            if (file2.exists()) {
                file2.delete();
            }
        }
        for (int i = 0; i < commandArray.length; ++i) {
            nativeResultArray[i] = commandArray[i].getCommandResult();
            if (nativeResultArray[i] == null) {
                if (clusterException != null) {
                    throw clusterException;
                }
                throw new ClusterException("1042");
            }
            if (nativeResultArray[i].getStatus()) continue;
            vector.add(nativeResultArray[i].getNodeName());
        }
        nativeResultArray[i] = commandResult;
        if (vector.size() > 0) {
            String string6 = Utils.getString(vector, ",");
            Object[] objectArray = new String[]{string32, string2, string6};
            String string7 = "1033";
            throw new ClusterOperationException("Prkn", string7, objectArray, nativeResultArray);
        }
        return true;
    }

    private static void validateLocalNode(String string) throws ClusterException {
        if (string == null || string.length() == 0) {
            Object[] objectArray = new Object[]{"SPvalidNode-01"};
            MessageBundle.getMessageBundle(PrCtMsgID.facility);
            throw new ClusterException(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, objectArray));
        }
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{string};
            MessageBundle.getMessageBundle(PrCnMsgID.facility);
            throw new ClusterException(MessageBundle.getMessage(PrCnMsgID.UNKNOWN_HOST, true, objectArray), unknownHostException);
        }
    }

    private static CommandResult[] executeSharedPathCheck(String[] stringArray, String string, String string2, Constants.CFS_OP_TYPE cFS_OP_TYPE, String string3) throws ClusterException {
        CommandFactory commandFactory = new CommandFactory();
        ClusterCmd clusterCmd = new ClusterCmd();
        ClusterException clusterException = null;
        Command[] commandArray = new IsCFSCheckFileCommand[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            commandArray[i] = (IsCFSCheckFileCommand)commandFactory.CreateCommand(new IsCFSCheckFileCommand(stringArray[i], string, string2, cFS_OP_TYPE, string3), 0);
        }
        try {
            clusterCmd.submit(commandArray);
            Trace.out("Successfully executed the test");
        }
        catch (ClusterException clusterException2) {
            Trace.out("Command submit failed" + clusterException2.getMessage());
            clusterException = clusterException2;
        }
        CommandResult[] commandResultArray = new CommandResult[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < commandArray.length; ++i) {
            commandResultArray[i] = commandArray[i].getCommandResult();
            if (commandResultArray[i] == null) continue;
            if (!commandResultArray[i].getStatus()) {
                arrayList2.add(commandResultArray[i].getNodeName());
                continue;
            }
            arrayList.add(commandResultArray[i].getNodeName());
        }
        if (arrayList.size() == 0 && arrayList2.size() == 0) {
            if (clusterException != null) {
                throw clusterException;
            }
            throw new ClusterException(s_msgBundle.getMessage("1001", true));
        }
        Trace.out("Returning operation results");
        Trace.out("Failed Nodes :" + arrayList2);
        Trace.out("Success Nodes :" + arrayList);
        return commandResultArray;
    }

    private static List<String> processExecutionResult(CommandResult[] commandResultArray, Map<String, CommandResult> map, List<List<String>> list, Constants.CFS_OP_TYPE cFS_OP_TYPE, String string, String string2) throws RemotePathException, ClusterException {
        HashMap<String, CommandResult> hashMap = new HashMap<String, CommandResult>();
        if (cFS_OP_TYPE != Constants.CFS_OP_TYPE.FILE_DEL) {
            for (int i = 0; i < commandResultArray.length; ++i) {
                if (commandResultArray[i] == null) continue;
                if (!commandResultArray[i].getStatus()) {
                    map.put(commandResultArray[i].getNodeName().toLowerCase(), commandResultArray[i]);
                    continue;
                }
                hashMap.put(commandResultArray[i].getNodeName().toLowerCase(), commandResultArray[i]);
            }
        }
        if (cFS_OP_TYPE == Constants.CFS_OP_TYPE.FILE_WRITE) {
            Trace.out("Processing Write phase result");
            if (hashMap.size() == 0) {
                Object[] objectArray = new Object[]{string};
                throw new ClusterException(s_msgBundle.getMessage("1025", true, objectArray));
            }
            return new ArrayList<String>(hashMap.keySet());
        }
        if (cFS_OP_TYPE == Constants.CFS_OP_TYPE.FILE_LIST) {
            Trace.out("Processing List phase result");
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            int n = 0;
            boolean bl = false;
            CommandResult commandResult = (CommandResult)hashMap.get(string2.toLowerCase());
            if (commandResult != null) {
                ArrayList arrayList = new ArrayList();
                Object object = commandResult.getResultString();
                if (((String[])object).length != 1) {
                    for (Object object2 : object) {
                        arrayList.add(object2);
                        hashMap2.put(((String)object2).toLowerCase(), n);
                    }
                    list.add(arrayList);
                    Trace.out("Node " + string2 + " Starting a new group at index " + n + "for " + Arrays.toString((Object[])object));
                } else {
                    Trace.out("Alert: Path exists on local node " + string2 + ", but not shared");
                    bl = true;
                }
                map.put(string2.toLowerCase(), commandResult);
            }
            for (Object object : hashMap.values()) {
                Object object2;
                boolean bl2 = false;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string3 = ((NativeResult)object).getNodeName();
                object2 = ((NativeResult)object).getResultString();
                map.put(string3.toLowerCase(), (CommandResult)object);
                if (((String[])object2).length == 1 || hashMap2.containsKey(string3.toLowerCase()) || string3.equalsIgnoreCase(string2)) continue;
                Trace.out("Node " + string3 + " Starting a new group at index " + ++n + "for " + Arrays.toString((Object[])object2));
                for (Object object3 : object2) {
                    arrayList.add(object3);
                    hashMap2.put(((String)object3).toLowerCase(), n);
                }
                list.add(arrayList);
            }
            if (bl) {
                Collections.sort(list, groupListComparator);
            }
            return new ArrayList<String>(hashMap.keySet());
        }
        if (cFS_OP_TYPE == Constants.CFS_OP_TYPE.FILE_DEL) {
            Trace.out("Processing Del phase result");
            RemotePathException remotePathException = new RemotePathException("1183", map.values().toArray(new CommandResult[0]), list);
            for (int i = 0; i < commandResultArray.length; ++i) {
                if (commandResultArray[i] == null || commandResultArray[i].getStatus()) continue;
                Trace.out("Warning on node: " + commandResultArray[i].getNodeName());
                remotePathException.setWarningNode(commandResultArray[i].getNodeName().toLowerCase(), "Warning: " + commandResultArray[i].getOSString());
            }
            List<String> list2 = remotePathException.getWarningNodes();
            if (list2 != null && list2.size() != 0) {
                Trace.out("Warning on nodes: " + remotePathException.getWarningNodes());
                throw remotePathException;
            }
        } else {
            Trace.out("Invalid operation type specified");
        }
        return new ArrayList<String>(map.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public static List<List<String>> sharedPathExists(String string, String[] stringArray, String string2) throws InvalidNodeListException, InvalidPathException, ClusterException, RemotePathException {
        String string3 = "CFSFileName" + (int)Math.random() * 9999 + String.valueOf(System.currentTimeMillis());
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        if (stringArray == null || stringArray.length == 0) {
            throw new InvalidNodeListException("Prkc", "1062");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            Trace.out("Node list has null at index: [" + i + "]");
            throw new InvalidNodeListException("Prkc", "1062");
        }
        SharedPath.validateLocalNode(string2);
        if (string == null) {
            Trace.out("PathName passed is null");
            throw new InvalidPathException(MessageBundle.getMessageBundle(PrCtMsgID.facility).getMessage(PrCtMsgID.NULL_FILE_PATH, true));
        }
        Trace.out("NodeList=" + Arrays.asList(stringArray));
        HashSet<String> hashSet = new HashSet<String>();
        for (String commandResultArray2 : stringArray) {
            hashSet.add(commandResultArray2);
        }
        String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        try {
            if (stringArray2.length <= 3 || !IS_UNIX_SYSTEM) {
                Trace.out("Falling back to quick check mode");
                int n = 0;
                n = SharedPath.isSharedPath(string, stringArray2, string2) ? 1 : 0;
                if (n != 0) {
                    arrayList.add(Arrays.asList(stringArray2));
                    return arrayList;
                }
                if (!IS_UNIX_SYSTEM) {
                    throw new ClusterException("1042");
                }
                Trace.out("Fallback to quick check mode didn't help");
            }
        }
        catch (ClusterOperationException clusterOperationException) {
            if (!IS_UNIX_SYSTEM) {
                NativeResult[] nativeResultArray = new NativeResult[stringArray2.length];
                try {
                    void noSuchNodeException;
                    boolean i = false;
                    while (noSuchNodeException < stringArray2.length) {
                        nativeResultArray[noSuchNodeException] = clusterOperationException.getNativeResult(stringArray2[noSuchNodeException]);
                        ++noSuchNodeException;
                    }
                }
                catch (NoSuchNodeException noSuchNodeException) {
                    Trace.out("No such Node exception" + noSuchNodeException.getMessage());
                }
                throw new RemotePathException("Prkn", "1042", nativeResultArray);
            }
            Trace.out("Received exception in quick check mode. Ignoring..");
        }
        Trace.out("Performing extended check for sharedness");
        HashMap<String, CommandResult> hashMap = new HashMap<String, CommandResult>();
        CommandResult[] commandResultArray = SharedPath.executeSharedPathCheck(stringArray2, string, string3, Constants.CFS_OP_TYPE.FILE_WRITE, string2);
        List<String> list = SharedPath.processExecutionResult(commandResultArray, hashMap, null, Constants.CFS_OP_TYPE.FILE_WRITE, string, string2);
        Object[] objectArray = list.toArray(new String[list.size()]);
        Trace.out("Nodes passed at write phase: " + Arrays.toString(objectArray));
        CommandResult[] commandResultArray2 = SharedPath.executeSharedPathCheck((String[])objectArray, string, string3, Constants.CFS_OP_TYPE.FILE_LIST, string2);
        List<String> list2 = SharedPath.processExecutionResult(commandResultArray2, hashMap, arrayList, Constants.CFS_OP_TYPE.FILE_LIST, null, string2);
        CommandResult[] commandResultArray3 = SharedPath.executeSharedPathCheck((String[])objectArray, string, string3, Constants.CFS_OP_TYPE.FILE_DEL, string2);
        SharedPath.processExecutionResult(commandResultArray3, hashMap, arrayList, Constants.CFS_OP_TYPE.FILE_DEL, null, string2);
        if (list2.size() == stringArray2.length) {
            Trace.out("All nodes passed the sharedness check");
            return arrayList;
        }
        Trace.out("Nodes partially share given path");
        Trace.out("Preferred list of nodes size: " + (arrayList.size() > 0 ? Integer.valueOf(((List)arrayList.get(0)).size()) : "None"));
        throw new RemotePathException("1180", hashMap.values().toArray(new CommandResult[0]), arrayList);
    }
}

