/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;

public class RemoteOperationException
extends ClusterOperationException {
    private static final String LSEP = System.getProperty("line.separator");
    private List<String> m_failedNodes;
    private Map<String, String> m_warningMap = new HashMap<String, String>();
    protected List<String> m_successNodes;

    RemoteOperationException(String string, NativeResult[] nativeResultArray) {
        super(string, nativeResultArray);
        this.setStatusLists(nativeResultArray);
    }

    RemoteOperationException(String string, Object[] objectArray, NativeResult[] nativeResultArray) {
        super(string, objectArray, nativeResultArray);
        this.setStatusLists(nativeResultArray);
    }

    RemoteOperationException(String string, String string2, NativeResult[] nativeResultArray) {
        super(string, string2, nativeResultArray);
        this.setStatusLists(nativeResultArray);
    }

    RemoteOperationException(String string, String string2, Object[] objectArray, NativeResult[] nativeResultArray) {
        super("Prkc", string2, objectArray, nativeResultArray);
        this.setStatusLists(nativeResultArray);
    }

    private void setStatusLists(NativeResult[] nativeResultArray) {
        this.m_successNodes = new ArrayList<String>();
        this.m_failedNodes = new ArrayList<String>();
        Trace.out("Setting result map of length:" + nativeResultArray.length);
        for (int i = 0; i < nativeResultArray.length; ++i) {
            if (!nativeResultArray[i].getStatus()) {
                this.m_failedNodes.add(nativeResultArray[i].getNodeName());
                continue;
            }
            this.m_successNodes.add(nativeResultArray[i].getNodeName());
        }
    }

    public List<String> getFailedNodes() {
        return this.m_failedNodes;
    }

    public List<String> getSuccessNodes() {
        return this.m_successNodes;
    }

    public boolean isWarningOnly() {
        return this.m_failedNodes.size() == 0 && this.m_warningMap.size() != 0;
    }

    public List<String> getWarningNodes() {
        return new ArrayList<String>(this.m_warningMap.keySet());
    }

    public String getWarning(String string) {
        return this.m_warningMap.get(string.toLowerCase());
    }

    void setWarningNode(String string, String string2) {
        String string3 = this.m_warningMap.get(string.toLowerCase());
        if (string3 == null) {
            this.m_warningMap.put(string.toLowerCase(), string2);
        } else {
            this.m_warningMap.put(string.toLowerCase(), string3 + LSEP + string2);
        }
    }

    @Override
    public String getErrorMessage(String string) throws NoSuchNodeException {
        this.assertNode(string);
        NativeResult nativeResult = (NativeResult)this.m_resultMap.get(string);
        String string2 = nativeResult.getOSString();
        if (string2 != null) {
            return string2;
        }
        Object[] objectArray = nativeResult.getResultString();
        if (objectArray != null && objectArray.length > 0) {
            return Arrays.toString(objectArray);
        }
        return string2;
    }
}

