/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote.operations;

import java.util.List;
import oracle.cluster.remote.operations.RemoteOperationException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class ClusterRemoteOp {
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static final int PRINT_LIMIT = 15;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");

    public boolean createDirInNodes(String[] stringArray, String string) throws ClusterException, RemoteOperationException {
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.createDirInNodes(stringArray, string);
        }
        catch (ClusterException clusterException) {
            this.transformAndThrow(clusterException.getCommandResult(), "1007");
            Trace.out("Fatal error at create operation. Details:\n" + clusterException.getMessage());
            throw clusterException;
        }
        return true;
    }

    public boolean removeFileFromNodes(String[] stringArray, String string) throws ClusterException, RemoteOperationException {
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.removeFileFromNodes(stringArray, string);
        }
        catch (ClusterException clusterException) {
            this.transformAndThrow(clusterException.getCommandResult(), "1005");
            Trace.out("Fatal error at remove operation. Details:\n" + clusterException.getMessage());
            throw clusterException;
        }
        return true;
    }

    private void transformAndThrow(List<CommandResult> list, String string) throws RemoteOperationException {
        boolean bl = false;
        if (list != null && list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getStatus()) continue;
                Trace.out("Result of node [" + list.get(i).getNodeName() + "] : false");
                bl = true;
                break;
            }
            if (bl) {
                throw new RemoteOperationException(string, list.toArray(new CommandResult[list.size()]));
            }
        }
    }
}

