/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote;

import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteUserInfo;

public class RemoteArgs {
    private static final String ROOT = Utils.getRootUserName();
    private String m_sudoUser = null;
    private String m_password = null;
    private String m_sudoLocation = null;
    private ConfigurationSetup.ConfigMethod m_mode = null;
    private String m_asUser = null;
    private NodeProgressListener m_npListener = null;
    private String[] m_stdin = null;

    public RemoteArgs(String sudoUser, String sudoPassword, String sudoLocation) throws InvalidArgsException, ExecException {
        RemoteArgs.validateUserPass(sudoUser, sudoPassword, sudoLocation);
        this.m_sudoUser = sudoUser.trim();
        this.m_password = sudoPassword;
        this.m_sudoLocation = sudoLocation;
        this.m_mode = ConfigurationSetup.ConfigMethod.SUDO;
    }

    public RemoteArgs(String rootPassword) throws InvalidArgsException, ExecException {
        Utils.assertInputNotNull(rootPassword, "rootPassword");
        this.m_password = rootPassword;
        this.m_mode = ConfigurationSetup.ConfigMethod.ROOT;
    }

    public RemoteArgs(RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        Utils.assertInputNotNull(userInfo, "userInfo");
        if (userInfo.getMode() == ConfigurationSetup.ConfigMethod.SUDO) {
            Utils.assertInputNotNull(userInfo.getPassword(), "sudoPassword");
            Utils.assertInput(userInfo.getUsername(), "sudoUser");
            this.m_sudoUser = userInfo.getUsername();
            Utils.assertInput(userInfo.getSudoLocation(), "sudoLocation");
            this.m_sudoLocation = userInfo.getSudoLocation();
        } else if (userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT) {
            Utils.assertInputNotNull(userInfo.getPassword(), "rootPassword");
        }
        this.m_password = userInfo.getPassword();
        this.m_mode = userInfo.getMode();
    }

    public void setAsUser(String asUser) throws InvalidArgsException {
        Utils.assertInput(asUser, "asUser");
        this.m_asUser = asUser.trim();
    }

    public void setStdin(String[] stdin) throws InvalidArgsException {
        Utils.assertInputNotNull(stdin, "stdin");
        this.m_stdin = stdin;
    }

    public void setListener(NodeProgressListener npListener) throws InvalidArgsException {
        Utils.assertInputNotNull(npListener, "npListener");
        this.m_npListener = npListener;
    }

    public String getSudoUser() {
        return this.m_sudoUser;
    }

    public String getPassword() {
        return this.m_password;
    }

    public ConfigurationSetup.ConfigMethod getMode() {
        return this.m_mode;
    }

    public String getSudoLocation() {
        return this.m_sudoLocation;
    }

    public String[] getStdin() {
        return this.m_stdin;
    }

    public String getAsUser() {
        return this.m_asUser;
    }

    public NodeProgressListener getListener() {
        return this.m_npListener;
    }

    static void validateUserPass(String sudoUser, String sudoPassword) throws InvalidArgsException {
        Utils.assertInput(sudoUser, "sudoUser");
        Utils.assertInputNotNull(sudoPassword, "sudoPassword");
    }

    static void validateUserPass(String sudoUser, String sudoPassword, String sudoLocation) throws InvalidArgsException {
        Utils.assertInput(sudoUser, "sudoUser");
        Utils.assertInputNotNull(sudoPassword, "sudoPassword");
        Utils.assertInput(sudoLocation, "sudoLocation");
    }
}

