/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.policy;

import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.policy.ConfigPolicySetFactoryImpl;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.ConfigPolicySet;
import oracle.cluster.policy.ConfigPolicySetException;
import oracle.cluster.resources.PrCpMsgID;
import oracle.cluster.server.ServerException;
import oracle.ops.mgmt.nls.MessageKey;

public class ConfigPolicySetFactory {
    private static ConfigPolicySetFactory s_instance;
    private ConfigPolicySetFactoryImpl s_configPolicySetFactoryImpl = ConfigPolicySetFactoryImpl.getInstance();

    private ConfigPolicySetFactory() throws ServerException, ConfigPolicySetException {
    }

    public static synchronized ConfigPolicySetFactory getInstance() throws ServerException, ConfigPolicySetException {
        if (s_instance == null) {
            s_instance = new ConfigPolicySetFactory();
        }
        return s_instance;
    }

    public ConfigPolicySet getConfigPolicySet() throws ConfigPolicySetException, SoftwareModuleException, ConfigPolicyException, ServerException {
        return this.s_configPolicySetFactoryImpl.getConfigPolicySet();
    }

    public void activatePolicy(String policyName) throws ConfigPolicySetException, CRSException {
        this.activatePolicy(policyName, true);
    }

    public void activatePolicy(String policyName, boolean force) throws ConfigPolicySetException, CRSException {
        if (null == policyName) {
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_PARAMETER, "policy", policyName);
        }
        this.s_configPolicySetFactoryImpl.activatePolicy(policyName, force);
    }

    public ConfigPolicy getLastActivatedPolicy() throws ConfigPolicyException, ConfigPolicySetException, SoftwareModuleException, ServerException {
        return this.s_configPolicySetFactoryImpl.getLastActivatedPolicy();
    }

    public ConfigPolicy getCurrentPolicy() throws ConfigPolicyException, ConfigPolicySetException, SoftwareModuleException, ServerException {
        return this.s_configPolicySetFactoryImpl.getCurrentPolicy();
    }

    public ConfigPolicySet createConfigPolicySet() throws ConfigPolicySetException, SoftwareModuleException, ConfigPolicyException, ServerException {
        return this.s_configPolicySetFactoryImpl.createConfigPolicySet();
    }

    public static void removeDatabases() throws ConfigPolicySetException {
        ConfigPolicySetFactoryImpl.removeDatabases();
    }
}

