/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.policy;

import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.policy.ConfigPolicyFactoryImpl;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.DatabaseRank;
import oracle.cluster.resources.PrCpMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class ConfigPolicyFactory {
    private static ConfigPolicyFactory m_instance;
    private ConfigPolicyFactoryImpl m_factoryImpl = ConfigPolicyFactoryImpl.getInstance();

    private ConfigPolicyFactory() throws ConfigPolicyException, SoftwareModuleException {
    }

    public static synchronized ConfigPolicyFactory getInstance() throws SoftwareModuleException, ConfigPolicyException {
        if (null == m_instance) {
            m_instance = new ConfigPolicyFactory();
        }
        return m_instance;
    }

    public ConfigPolicy createLocalConfigPolicy(String policyName) throws ConfigPolicyException {
        if (null == policyName) {
            throw new ConfigPolicyException((MessageKey)PrCpMsgID.INVALID_PARAMETER, policyName);
        }
        return this.m_factoryImpl.createLocalConfigPolicy(policyName);
    }

    public DatabaseRank createDatabaseRank(String dbUniqueName, int rank) throws ConfigPolicyException {
        if (null == dbUniqueName) {
            throw new ConfigPolicyException((MessageKey)PrCpMsgID.INVALID_PARAMETER, dbUniqueName);
        }
        return this.m_factoryImpl.createDatabaseRank(dbUniqueName, rank);
    }
}

