/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.oc4j;

import oracle.cluster.impl.oc4j.OC4JFactoryImpl;
import oracle.cluster.oc4j.OC4J;
import oracle.cluster.oc4j.OC4JException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class OC4JFactory {
    private static OC4JFactory s_oc4j;
    private OC4JFactoryImpl s_oc4jImpl = OC4JFactoryImpl.getInstance();

    private OC4JFactory() {
    }

    public static synchronized OC4JFactory getInstance() {
        if (null == s_oc4j) {
            s_oc4j = new OC4JFactory();
        }
        return s_oc4j;
    }

    public OC4J createOC4J(Version version) throws AlreadyExistsException, OC4JException {
        if (null == version) {
            throw new OC4JException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_oc4jImpl.createOC4J(version);
    }

    public OC4J createOC4J(Version version, boolean isQOSMSrv) throws AlreadyExistsException, OC4JException {
        if (null == version) {
            throw new OC4JException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_oc4jImpl.createOC4J(version, isQOSMSrv);
    }

    public OC4J createQOSMServer(Version version, boolean isTLSEnabled) throws AlreadyExistsException, OC4JException {
        if (null == version) {
            throw new OC4JException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_oc4jImpl.createOC4J(version, true, isTLSEnabled);
    }

    public OC4J getOC4J() throws NotExistsException, OC4JException {
        return this.s_oc4jImpl.getOC4J();
    }

    public OC4J getOC4J(boolean isQOSMSrv) throws NotExistsException, OC4JException {
        return this.s_oc4jImpl.getOC4J(isQOSMSrv);
    }

    public void upgradeOC4J12102To122FirstPhase() throws UpgradeException {
        this.s_oc4jImpl.upgradeOC4J12102To122FirstPhase();
    }

    public void upgradeOC4J12102To122LastPhase() throws UpgradeException {
        this.s_oc4jImpl.upgradeOC4J12102To122LastPhase();
    }
}

