/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.nodeapps;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.Relocatable;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.Service;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VIPAddress;

public interface VIP
extends SoftwareModule,
Relocatable {
    public Network network() throws VIPException;

    public InetAddress address() throws VIPException;

    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws VIPException;

    public Map<IPAddressUtil.IPAddrType, InetAddress> dynamicAddresses() throws VIPException;

    public InetAddress dhcpaddress() throws VIPException;

    public Node preferredNode() throws VIPException;

    public Node runningNode() throws NotRunningException, VIPException;

    public List<Listener> listeners() throws NotExistsException, VIPException;

    public List<Service> services() throws NotExistsException, VIPException;

    public CRSResource crsResource() throws NotExistsException, VIPException;

    public void remove(boolean var1) throws AlreadyRunningException, VIPException;

    public void modifyAddress(VIPAddress var1) throws VIPException;

    public void modifyNatAddress(VIPAddress var1) throws VIPException;

    public void modifyAddress(VIPAddress var1, boolean var2) throws VIPException;

    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException;

    public void relocate(boolean var1) throws NotRunningException, RelocateException;

    public void relocateTo(Node var1, boolean var2) throws NotRunningException, RelocateException;

    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException;

    public void ntGrantAclsForTransparentHA() throws VIPException;
}

