/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.nodeapps;

import java.net.InetAddress;
import java.util.List;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.ListenerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;

public interface Listener
extends SoftwareModule {
    public ListenerType type() throws ListenerException;

    public String getOracleHome() throws ListenerException;

    public String getOracleHome(Node var1) throws NotExistsException, ListenerException;

    public void setOracleHome(String var1) throws ListenerException;

    public void setOracleHome(Node var1, String var2) throws ListenerException;

    @Deprecated
    public int[] getPorts() throws ListenerException;

    public Endpoints getEndpoints() throws ListenerException;

    public String getGroup() throws ListenerException;

    public void setGroup(String var1) throws ListenerException;

    @Deprecated
    public void setPorts(int[] var1) throws CompositeOperationException, ListenerException;

    public void setEndpoints(Endpoints var1) throws ListenerException;

    public void setEndpoints(Endpoints var1, String var2) throws ListenerException;

    public int[] getPorts(Node var1) throws NotExistsException, ListenerException;

    public void setPorts(Node var1, int[] var2) throws CompositeOperationException, ListenerException;

    public Subnet subnet() throws ListenerException;

    public Network network() throws ListenerException;

    public void setNetwork(Network var1) throws ListenerException;

    public void setOwner(String var1) throws ListenerException;

    public String getOwner() throws ListenerException;

    public void setSubnet(String var1) throws ListenerException;

    public String getSubnet() throws ListenerException;

    public List<VIP> vips(Node var1) throws NotExistsException, ListenerException;

    public List<String> services(Node var1) throws ListenerException;

    public void enable(List<Node> var1) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException;

    public void enable(Node var1) throws SoftwareModuleException, AlreadyEnabledException;

    public void disable(List<Node> var1) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException;

    public void disable(Node var1) throws AlreadyDisabledException, SoftwareModuleException;

    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException;

    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException;

    public CRSResource crsResource() throws NotExistsException, ListenerException;

    public void remove(boolean var1) throws AlreadyRunningException, ListenerException;

    public void ntGrantAclsForTransparentHA() throws ListenerException;

    public void updateDependency4ASMLsnr(boolean var1) throws ListenerException;

    public void updateRemove(boolean var1) throws AlreadyRunningException, ListenerException;

    public String getTNSAddressList() throws ListenerException;

    public InetAddress getMgmtListenerAddress() throws NotExistsException, ListenerException;

    public InetAddress[] getMgmtListenerAddresses() throws NotExistsException, ListenerException;

    public void extendToLeaf(boolean var1) throws ListenerException;

    public boolean isExtended() throws ListenerException;

    public boolean isASMListener() throws ListenerException;
}

