/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.nfs;

import java.util.List;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.nfs.NFSFactoryImpl;
import oracle.cluster.nfs.NFS;
import oracle.cluster.nfs.NFSException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;

public class NFSFactory {
    private static NFSFactory s_instance;
    private NFSFactoryImpl s_factoryImpl = NFSFactoryImpl.getInstance();

    private NFSFactory() throws SoftwareModuleException {
    }

    public static synchronized NFSFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new NFSFactory();
        }
        return s_instance;
    }

    public NFS createNFS(String mountPointPath, String name, String exportPath, String exportServer) throws AlreadyExistsException, NFSException {
        return this.s_factoryImpl.createNFS(mountPointPath, name, exportPath, exportServer);
    }

    public NFS createNFS(FileSystemOptionalArgs fsOptionalArgs) throws AlreadyExistsException, NFSException {
        return this.s_factoryImpl.createNFS(fsOptionalArgs);
    }

    public NFS getNFS(String mountPointPath) throws NotExistsException, NFSException {
        return this.s_factoryImpl.getNFS(mountPointPath);
    }

    public NFS getNFSbyName(String resourceName) throws NotExistsException, NFSException {
        return this.s_factoryImpl.getNFSbyName(resourceName);
    }

    public List<NFS> getNFSList() throws NotExistsException, NFSException {
        return this.s_factoryImpl.getNFSList();
    }
}

