/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.install;

import java.util.Map;
import java.util.Set;
import oracle.cluster.common.ClusterException;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigException;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.NodeStatus;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelFactory;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class RemoteCommand {
    private String m_crsHome;
    private ChannelFactory m_channel;

    public RemoteCommand(String crsHome) throws ConfigException {
        this.m_crsHome = crsHome;
        try {
            this.m_channel = ChannelFactory.getInstance();
        }
        catch (ChannelException ce) {
            Trace.out("exception: " + ce.getMessage());
            throw new ConfigException(ce);
        }
    }

    public void runScript(String crsHome, ConfigurationSetup.ConfigMethod method, String script, String[] args, String[] nodes, UserInfo userInfo, Map<String, NodeStatus> resultMap, String path) throws ConfigException, ClusterException, CompositeOperationException {
        Map<String, CommandResult> sucMap;
        if (null == userInfo) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "userInfo");
        }
        if (null == nodes) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodes list");
        }
        if (null == script) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "script");
        }
        if (null == resultMap) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "resultMap");
        }
        if (null == crsHome) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "crsHome");
        }
        if (null == method) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "method");
        }
        if (method != ConfigurationSetup.ConfigMethod.ROOT && null == path) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "path");
        }
        String username = userInfo.getUsername();
        String password = userInfo.getPassword();
        try {
            sucMap = method == ConfigurationSetup.ConfigMethod.ROOT ? (null != args && 0 != args.length ? this.m_channel.executeCommand(nodes, script, null, args, userInfo, 7200) : this.m_channel.executeCommand(nodes, script, userInfo, 7200)) : (null != args && 0 != args.length ? this.m_channel.executeCommand(nodes, script, null, args, method, path, userInfo, 7200) : this.m_channel.executeCommand(nodes, script, method, path, userInfo, 7200));
        }
        catch (ChannelException ce) {
            Trace.out("exception: " + ce.getMessage());
            throw new ClusterException(ce);
        }
        catch (CompositeOperationException coe) {
            Trace.out("exception: " + coe.getMessage());
            this.loadFail(coe, resultMap);
            throw coe;
        }
        this.loadSuc(sucMap, resultMap);
    }

    public void loadSuc(Map<String, CommandResult> sucMap, Map<String, NodeStatus> nodeStatusMap) {
        for (Map.Entry<String, CommandResult> entry : sucMap.entrySet()) {
            String node = entry.getKey();
            CommandResult result = entry.getValue();
            String[] resultStringArr = result.getResultString();
            String out = Utils.strArrToString(resultStringArr, " ");
            int exitCode = result.getOSErrCode();
            boolean status = result.getStatus();
            Exception excp = result.getException();
            boolean isRebootReqd = false;
            if (null != out) {
                if (-1 != out.indexOf("CLSRSC-400:")) {
                    isRebootReqd = true;
                }
            } else {
                out = " ";
            }
            NodeStatus nStatus = new NodeStatus(status, out, null, excp, exitCode, isRebootReqd);
            nodeStatusMap.put(node, nStatus);
        }
    }

    public void loadFail(CompositeOperationException coe, Map<String, NodeStatus> nodeStatusMap) {
        Trace.out("CompositeOperationException " + coe.getMessage());
        try {
            Set<Object> compositeErrorSet = coe.getOperationIdentifier();
            for (Object obj : compositeErrorSet) {
                NodeStatus nStatus;
                String errMsg;
                String[] ErrStringArr;
                String[] resultStringArr;
                boolean status;
                int exitCode;
                String out;
                String node = (String)obj;
                NativeResult ntvResult = coe.getNativeResult(obj);
                Trace.out("CompositeOperationException status on node " + node + ": " + (Object)((Object)coe.getStatus(obj)));
                if (coe.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                    Trace.out("Execution Successful on node: " + node);
                    CommandResult cmdResult = (CommandResult)ntvResult;
                    String[] resultStringArr2 = cmdResult.getResultString();
                    out = Utils.strArrToString(resultStringArr2, " ");
                    exitCode = cmdResult.getOSErrCode();
                    status = cmdResult.getStatus();
                    Exception excp = cmdResult.getException();
                    boolean isRebootReqd = false;
                    if (null != out) {
                        if (-1 != out.indexOf("CLSRSC-400:")) {
                            isRebootReqd = true;
                        }
                    } else {
                        out = " ";
                    }
                    NodeStatus nStatus2 = new NodeStatus(status, out, null, excp, exitCode, isRebootReqd);
                    nodeStatusMap.put(node, nStatus2);
                    continue;
                }
                if (coe.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                    Trace.out("Execution Failed on node: " + node);
                    resultStringArr = ntvResult.getResultString();
                    ErrStringArr = ntvResult.getOSStrings();
                    out = Utils.strArrToString(resultStringArr, " ");
                    exitCode = ntvResult.getOSErrCode();
                    status = ntvResult.getStatus();
                    errMsg = Utils.strArrToString(ErrStringArr, " ");
                    Exception excp = ntvResult.getException();
                    boolean isRebootReqd = false;
                    if (null != out) {
                        if (-1 != out.indexOf("CLSRSC-400:")) {
                            isRebootReqd = true;
                        }
                    } else {
                        out = " ";
                    }
                    nStatus = new NodeStatus(status, out, errMsg, excp, exitCode, isRebootReqd);
                    nodeStatusMap.put(node, nStatus);
                    continue;
                }
                if (coe.getStatus(obj) == CompositeOperationException.Status.EXCEPTION) {
                    Trace.out("Exception got on node: " + node);
                    resultStringArr = ntvResult.getResultString();
                    ErrStringArr = ntvResult.getOSStrings();
                    out = Utils.strArrToString(resultStringArr, " ");
                    exitCode = ntvResult.getOSErrCode();
                    status = false;
                    errMsg = Utils.strArrToString(ErrStringArr, " ");
                    Exception excp = ntvResult.getException();
                    boolean isRebootReqd = false;
                    if (null != out) {
                        if (-1 != out.indexOf("CLSRSC-400:")) {
                            isRebootReqd = true;
                        }
                    } else {
                        out = " ";
                    }
                    nStatus = new NodeStatus(status, out, errMsg, excp, exitCode, isRebootReqd);
                    nodeStatusMap.put(node, nStatus);
                    continue;
                }
                Trace.out("Undefined status on node: " + node);
                NodeStatus nStatus3 = new NodeStatus(false, null, null, null, -1, false);
                nodeStatusMap.put(node, nStatus3);
            }
        }
        catch (NoSuchIdentifierException ne) {
            Trace.out("Bad Node Identifier " + ne.getMessage());
        }
    }
}

