/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

class WinSecuritySystem {
    WinSecuritySystem() throws WindowsSecurityException {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (nativeSys.isUnixSystem()) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PLATFORM, new Object[0]);
        }
    }

    void checkAdministrator(String username, String node, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        String[] output;
        if (isLocalExecution) {
            WinSecurityNative.isAdministrator(username, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username};
        Trace.out("creating remotexec command srvmIsAdmin on node " + node);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.isAdministrator.toString(), args, null, node, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        if ((output = nativeResult.getResultString()) != null) {
            Trace.out("Output from node (" + node + ") is (" + Utils.getString(output, System.getProperty("line.separator")).trim() + ")");
        } else {
            Trace.out("Output from node (" + node + ") is null");
        }
        if (output != null && "TRUE".equalsIgnoreCase(output[0].trim())) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    void checkUserExist(String username, String node, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        String[] output;
        if (isLocalExecution) {
            WinSecurityNative.checkUserAccountOnNode(username, node, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username};
        Trace.out("creating remotexec command srvmIsUserExist on node " + node);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.isUserExist.toString(), args, null, node, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        if ((output = nativeResult.getResultString()) != null) {
            Trace.out("Output from node (" + node + ") is (" + Utils.getString(output, System.getProperty("line.separator")).trim() + ")");
        } else {
            Trace.out("Output from node (" + node + ") is null");
        }
        if (output != null && "TRUE".equalsIgnoreCase(output[0].trim())) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    void setServiceUserForHome(String username, String oracleHomeKey, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to set service user for node " + nodeName);
        WinSecurityNative.setServiceUserForHome(username, oracleHomeKey, nodeName, nativeResult);
    }

    void getServiceUserForOhome(String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to get service user for node " + nodeName);
        WinSecurityNative.getServiceUserForOhome(nodeName, nativeResult);
    }

    void getServiceUserFromOhomePath(String homePath, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to get service user from path " + homePath + " for node " + nodeName);
        WinSecurityNative.getServiceUserFromOhomePath(homePath, nodeName, nativeResult);
    }

    void checkServiceUserLocalSystem(String homePath, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to check if service user is LSA for node " + nodeName);
        WinSecurityNative.isServiceUserLocalSystem(homePath, nodeName, nativeResult);
    }

    void checkServiceUserPasswordRequired(String homePath, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to check if service user requires password for node " + nodeName);
        WinSecurityNative.isServiceUserPasswordRequired(homePath, nodeName, nativeResult);
    }

    void setOracleHomeType(String homeTypeStr, String oracleHomeKey, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to set home type for node " + nodeName + " homeKey " + oracleHomeKey);
        WinSecurityNative.setOracleHomeType(homeTypeStr, oracleHomeKey, nodeName, nativeResult);
    }

    void getOracleHomeType(String oracleHomeKey, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to get home type for node " + nodeName + " homeKey " + oracleHomeKey);
        WinSecurityNative.getOracleHomeType(oracleHomeKey, nodeName, nativeResult);
    }

    void checkUserPrivilege(String username, String homeTypeStr, String nodeName, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        if (isLocalExecution) {
            WinSecurityNative.checkUserPrivilege(username, homeTypeStr, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username, homeTypeStr};
        Trace.out("creating remotexec command Check User Priv on node " + nodeName);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.checkUserPrivilege.toString(), args, null, nodeName, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        String output = nativeResult.getStringResult();
        Trace.out("output from remote node is " + output);
        if ("WINSEC_NO_MISSING_PRIV_MSG".equalsIgnoreCase(output)) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    void grantPrivilegeToUser(String username, String homeTypeStr, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to grant" + username + " privilege for home type " + homeTypeStr + "on node " + nodeName);
        WinSecurityNative.grantPrivilegeToUser(username, homeTypeStr, nodeName, nativeResult);
    }

    void revokePrivilegeFromUser(String username, String homeTypeStr, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to revoke " + username + " privilege on" + nodeName);
        WinSecurityNative.revokePrivilegeFromUser(username, homeTypeStr, nodeName, nativeResult);
    }

    void setAclForUser(String username, String path, String storageTypeStr, String permissionTypeStr, String inheritable, String nodeName, String installUser, String excludePath, String sizeExcludePath, String checkForAcfs, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        if (isLocalExecution) {
            WinSecurityNative.setAclsForUser(username, path, storageTypeStr, permissionTypeStr, inheritable, installUser, excludePath, sizeExcludePath, checkForAcfs, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username, path, storageTypeStr, permissionTypeStr, inheritable, installUser, excludePath, sizeExcludePath, checkForAcfs};
        Trace.out("creating remotexec command Set Acl For User " + args[0] + " on node " + nodeName);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.setAclForUser.toString(), args, null, nodeName, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
    }

    void revokeAclForUser(String username, String path, String storageTypeStr, String permissionTypeStr, String inheritable, String nodeName, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        if (isLocalExecution) {
            WinSecurityNative.revokeAclsForUser(username, path, storageTypeStr, permissionTypeStr, inheritable, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username, path, storageTypeStr, permissionTypeStr, inheritable};
        Trace.out("creating remotexec command Revoke Acl For User" + args[0] + " on node " + nodeName);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.revokeAclForUser.toString(), args, null, nodeName, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
    }

    void checkAclForUser(String username, String path, String storageTypeStr, String permissionTypeStr, String inheritable, String nodeName, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        String[] output;
        if (isLocalExecution) {
            WinSecurityNative.checkAclsForUser(username, path, storageTypeStr, permissionTypeStr, inheritable, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username, path, storageTypeStr, permissionTypeStr, inheritable};
        Trace.out("creating remotexec command Check Acl For User " + args[0] + " on node " + nodeName);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.checkAclForUser.toString(), args, null, nodeName, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        if ((output = nativeResult.getResultString()) != null) {
            Trace.out("output from remote node is " + output[0]);
        }
        if (output != null && "TRUE".equalsIgnoreCase(output[0].trim())) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    void addAclForUser(String username, String path, String storageTypeStr, String permissionTypeStr, String inheritable, String nodeName, String installUser, String excludePath, String sizeExcludePath, String checkForAcfs, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        if (isLocalExecution) {
            WinSecurityNative.addAclsForUser(username, path, storageTypeStr, permissionTypeStr, inheritable, installUser, excludePath, sizeExcludePath, checkForAcfs, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username, path, storageTypeStr, permissionTypeStr, inheritable, installUser, excludePath, sizeExcludePath, checkForAcfs};
        Trace.out("creating remotexec command Add Acl For User " + args[0] + " on node " + nodeName);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.addAclForUser.toString(), args, null, nodeName, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
    }

    void updateService(String servicename, String binPath, String password, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to update service for node " + nodeName + " service name " + servicename);
        WinSecurityNative.updateService(servicename, binPath, password, nodeName, nativeResult);
    }

    void createService(String servicename, String displayName, String desiredAccessStr, String serviceTypeStr, String startTypeStr, String errorControlStr, String binPath, String loadOrder, String[] dependencies, String username, String password, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to create service for node " + nodeName + " service name " + servicename);
        int desiredAccess = Integer.parseInt(desiredAccessStr);
        int serviceType = Integer.parseInt(serviceTypeStr);
        int startType = Integer.parseInt(startTypeStr);
        int errorControl = Integer.parseInt(errorControlStr);
        WinSecurityNative.createService(servicename, displayName, desiredAccess, serviceType, startType, errorControl, binPath, loadOrder, dependencies, username, password, nodeName, nativeResult);
    }

    void deleteService(String servicename, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to delete service for node " + nodeName + " service name " + servicename);
        WinSecurityNative.deleteService(servicename, nodeName, nativeResult);
    }

    void checkServiceRunningAsLocalSystem(String servicename, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to check if service is running as LSA on node " + nodeName + " service name " + servicename);
        WinSecurityNative.isServiceRunningAsLocalSystem(servicename, nodeName, nativeResult);
    }

    void getServiceUser(String servicename, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to get service user on node " + nodeName + " service name " + servicename);
        WinSecurityNative.getServiceUser(servicename, nodeName, nativeResult);
    }

    void getAllServicesForHome(String username, String homePath, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to get all services for user on node " + nodeName + " home path " + homePath);
        WinSecurityNative.getAllServicesForHome(username, homePath, nodeName, nativeResult);
    }

    void updateAllHomeServicesPasswd(String username, String password, String homePath, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to update password for all services on node " + nodeName + " home path " + homePath);
        WinSecurityNative.updateAllHomeServicesPasswd(username, password, homePath, nodeName, nativeResult);
    }

    void getAllServicesUser(String username, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to get all services for user on node " + nodeName + " username " + username);
        WinSecurityNative.getAllServicesUser(username, nodeName, nativeResult);
    }

    void updateAllUserServicesPasswd(String username, String password, String nodeName, NativeResult nativeResult) {
        Trace.out("calling native method to update password for all services on node " + nodeName + " user name " + username);
        WinSecurityNative.updateAllUserServicesPasswd(username, password, nodeName, nativeResult);
    }

    void createOSGroup(String groupName, String groupDesc, String nodeName, NativeResult result) {
        Trace.out("calling native method to create group " + groupName + " on node " + nodeName);
        WinSecurityNative.createOSGroup(groupName, groupDesc, nodeName, result);
    }

    void deleteOSGroup(String groupName, String nodeName, NativeResult result) {
        Trace.out("calling native method to create group " + groupName + " on node " + nodeName);
        WinSecurityNative.deleteOSGroup(groupName, nodeName, result);
    }

    void checkOSGroupExists(String groupName, String nodeName, NativeResult result) {
        Trace.out("calling native method to check if group " + groupName + " exists on node " + nodeName);
        WinSecurityNative.checkOSGroupExists(groupName, nodeName, result);
    }

    void addMemberToOSGroup(String groupName, String member, String nodeName, NativeResult result) {
        Trace.out("calling native method to add " + member + " to group " + groupName + " on node " + nodeName);
        WinSecurityNative.addMemberToOSGroup(groupName, member, nodeName, result);
    }

    void removeMemberFromOSGroup(String groupName, String member, String nodeName, NativeResult result) {
        Trace.out("calling native method to remove " + member + " from group " + groupName + " on node " + nodeName);
        WinSecurityNative.removeMemberFromOSGroup(groupName, member, nodeName, result);
    }

    void checkMemberOfOSGroup(String groupName, String member, String recurse, String nodeName, NativeResult result) {
        Trace.out("calling native method to check if " + member + " is present in group " + groupName + " on node " + nodeName);
        WinSecurityNative.checkMemberOfOSGroup(groupName, member, Boolean.parseBoolean(recurse), nodeName, result);
    }

    void getUsernameFromSid(String sid, NativeResult nativeResult) {
        Trace.out("Calling native method to convert : " + sid + " : to username");
        WinSecurityNative.getUsernameFromSid(sid, nativeResult);
    }

    void migrateDBServiceSidsForUpgrade() throws WindowsSecurityException {
        NativeResult nativeResult = new NativeResult();
        Trace.out("calling native method to migrate DB sids during upgrade ");
        WinSecurityNative.migrateDBServiceSidsForUpgrade(nativeResult);
        if (!nativeResult.getStatus()) {
            Exception e = nativeResult.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.MIGRATE_DB_SIDS_UPGRADE_FAILED, (Throwable)e, new Object[0]);
        }
    }

    void migrateDBServiceSidsForDowngrade() throws WindowsSecurityException {
        NativeResult nativeResult = new NativeResult();
        Trace.out("calling native method to migrate DB sids during downgrade ");
        WinSecurityNative.migrateDBServiceSidsForDowngrade(nativeResult);
        if (!nativeResult.getStatus()) {
            Exception e = nativeResult.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.MIGRATE_DB_SIDS_DOWNGRADE_FAILED, (Throwable)e, new Object[0]);
        }
    }

    void checkIsUserGroupMSA(String username, String node, String srcloc, String destloc, boolean isLocalExecution, NativeResult nativeResult) {
        String[] output;
        if (isLocalExecution) {
            WinSecurityNative.isUserGroupMSA(username, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{username};
        Trace.out("creating remotexec command srvmIsUserGroupMSA on node " + node);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.isUserGroupMSA.toString(), args, null, node, null, srcloc, destloc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        if ((output = nativeResult.getResultString()) != null) {
            Trace.out("Output from node (" + node + ") is (" + Utils.getString(output, System.getProperty("line.separator")).trim() + ")");
        } else {
            Trace.out("Output from node (" + node + ") is null");
        }
        if (output != null && "TRUE".equalsIgnoreCase(output[0].trim())) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    public void checkHomeServiceUserGMSA(String homePath, String nodeName, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        String[] output;
        Trace.out("calling native method to check if service user is GMSA on node " + nodeName);
        if (isLocalExecution) {
            WinSecurityNative.isServiceUserGMSA(homePath, nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = new String[]{homePath};
        Trace.out("creating remotexec command isServiceUserGMSA on node " + nodeName);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.isHomeServiceUserGMSA.toString(), args, null, nodeName, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        if ((output = nativeResult.getResultString()) != null) {
            Trace.out("Output from node (" + nodeName + ") is (" + Utils.getString(output, System.getProperty("line.separator")).trim() + ")");
        } else {
            Trace.out("Output from node (" + nodeName + ") is null");
        }
        if (output != null && "TRUE".equalsIgnoreCase(output[0].trim())) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    void getVirtualAccountGroupName(String oracleHomeName, NativeResult nativeResult) {
        Trace.out("Calling native method to convert : " + oracleHomeName + " : to virtual home service  username");
        WinSecurityNative.getVirtualAccountGroupName(oracleHomeName, nativeResult);
    }

    void checkDomainController(String node, String srcLoc, String destLoc, boolean isLocalExecution, NativeResult nativeResult) {
        String[] output;
        if (isLocalExecution) {
            WinSecurityNative.checkDomainController(nativeResult);
            return;
        }
        RemoteExecCommand cmd = null;
        String[] args = null;
        Trace.out("creating remotexec command srvmIsDomainController on node " + node);
        cmd = new RemoteExecCommand(WinSecurityCommand.CommandType.isDomainController.toString(), args, null, node, null, srcLoc, destLoc, nativeResult, true);
        cmd.execute();
        if (!nativeResult.getBooleanResult()) {
            nativeResult.setException(new NativeException(nativeResult.getOSStrings()));
        }
        if ((output = nativeResult.getResultString()) != null) {
            Trace.out("Output from node (" + node + ") is (" + Utils.getString(output, System.getProperty("line.separator")).trim() + ")");
        } else {
            Trace.out("Output from node (" + node + ") is null");
        }
        if (output != null && "TRUE".equalsIgnoreCase(output[0].trim())) {
            nativeResult.setBooleanResult(true);
        } else {
            nativeResult.setBooleanResult(false);
        }
    }

    void checkWin8OrAbove(NativeResult nativeResult) {
        WinSecurityNative.checkWin8OrAbove(nativeResult);
    }

    void checkWin7OrAbove(NativeResult nativeResult) {
        WinSecurityNative.checkWin7OrAbove(nativeResult);
    }
}

