/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityCommandExecution;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.Service;
import oracle.cluster.winsecurity.ServiceErrorControl;
import oracle.cluster.winsecurity.ServiceStartType;
import oracle.cluster.winsecurity.ServiceType;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WinSecurityServiceImpl
implements Service,
Constants {
    private String m_servicename;
    private Version m_version;
    private SecureUtil m_secureUtil;
    private String m_srcloc;
    private WinSecurityNative m_secureNative;
    private MessageBundle m_msgBndl;
    private final int BIN_PATH_UPDATE = 0;
    private final int PASSWORD_UPDATE = 1;
    private final int BIN_AND_PASSWORD_UPDATE = 2;
    private final int SERVICE_ALL_ACCESS = 983551;
    private final String DEPENDENCIES_DELIMITER = "::";

    WinSecurityServiceImpl(String serviceName, String srcLoc, Version version) {
        this.m_servicename = serviceName;
        this.m_version = version;
        this.m_secureUtil = new SecureUtil();
        this.m_srcloc = srcLoc;
    }

    @Override
    public void modifyPassword(Credentials credentials) throws WindowsSecurityException {
        this.m_secureUtil.assertCredentials(credentials);
        try {
            this.doInternalModifyPassword(credentials, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void modifyPassword(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertCredentials(credentials);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalModifyPassword(credentials, localNodeName, nodeNames);
    }

    private void doInternalModifyPassword(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        int flags = 1;
        this.m_secureUtil.assertCredentials(credentials);
        this.doInternalModify(null, credentials, flags, localNodeName, nodeNames);
    }

    @Override
    public void modifyBinPath(String binPath) throws WindowsSecurityException {
        int flags = 0;
        try {
            this.assertServiceParams(binPath, null, null, false);
            this.doInternalModify(binPath, null, flags, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void modifyBinPath(String binPath, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        int flags = 0;
        this.assertServiceParams(binPath, localNodeName, nodeNames, true);
        this.doInternalModify(binPath, null, flags, localNodeName, nodeNames);
    }

    @Override
    public void modifyUser(String binPath, Credentials credentials) throws WindowsSecurityException {
        this.m_secureUtil.assertCredentials(credentials);
        try {
            this.assertServiceParams(binPath, null, null, false);
            this.doInternalModifyUser(binPath, credentials, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void modifyUser(String binPath, Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertCredentials(credentials);
        this.assertServiceParams(binPath, localNodeName, nodeNames, true);
        this.doInternalModifyUser(binPath, credentials, localNodeName, nodeNames);
    }

    private void doInternalModifyUser(String binPath, Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        int flags = 2;
        WinSecurityFactory winSecFactory = WinSecurityFactory.getInstance(this.m_srcloc, null);
        File fileBinPath = new File(binPath);
        String newHome = fileBinPath.getParent();
        Home home = winSecFactory.getHome(newHome, this.m_version);
        Credentials homeCredentials = home.getServiceUserForHome();
        String inputUsername = credentials.getUsername();
        String homeUsername = homeCredentials.getUsername();
        if (!credentials.isUserBuiltinUser() && !inputUsername.equals(homeUsername)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_CREDENTIALS_FOR_SERVICE, this.m_servicename, inputUsername, homeUsername);
        }
        this.doInternalModify(binPath, credentials, flags, localNodeName, nodeNames);
    }

    private void doInternalModify(String binPath, Credentials credentials, int flag, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        boolean isLocalOperation;
        String password = null;
        String username = null;
        Trace.out("updating service, modify flag: " + flag);
        if (credentials != null) {
            password = credentials.getPassword();
            username = credentials.getUsername();
            Trace.out("modify for user :" + username);
        }
        if (isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames)) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.updateService(this.m_servicename, binPath, password, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                switch (flag) {
                    case 0: {
                        if (localNodeName == null) {
                            throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PATH_FAILED, (Throwable)e, this.m_servicename, binPath);
                        }
                        throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PATH_FAILED_NODE, (Throwable)e, this.m_servicename, binPath, localNodeName);
                    }
                    case 1: {
                        if (localNodeName == null) {
                            throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FAILED, (Throwable)e, this.m_servicename, username);
                        }
                        throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FAILED_NODE, (Throwable)e, this.m_servicename, username, localNodeName);
                    }
                    case 2: {
                        if (localNodeName == null) {
                            throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_BOTH_FAILED, (Throwable)e, this.m_servicename, username, binPath);
                        }
                        throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_BOTH_FAILED_NODE, (Throwable)e, this.m_servicename, username, binPath, localNodeName);
                    }
                }
            }
            Trace.out("after updating service");
            return;
        }
        String[] args = new String[]{this.m_servicename, binPath, username, password};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the modify service commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.updateService, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            switch (flag) {
                case 0: {
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PATH_FAILED_NODE, resultMap, this.m_servicename, binPath, Utils.strListToList(failedNodes));
                }
                case 1: {
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FAILED_NODE, resultMap, this.m_servicename, username, Utils.strListToList(failedNodes));
                }
                case 2: {
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.UPDATE_SERVICE_BOTH_FAILED_NODE, resultMap, this.m_servicename, username, binPath, Utils.strListToList(failedNodes));
                }
            }
        }
    }

    @Override
    public void create(ServiceStartType startType, String binPath) throws WindowsSecurityException {
        try {
            this.assertServiceParams(binPath, null, null, false);
            this.doInternalCreate(startType, binPath, null, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void create(ServiceStartType startType, String binPath, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertServiceParams(binPath, localNodeName, nodeNames, true);
        this.doInternalCreate(startType, binPath, null, localNodeName, nodeNames);
    }

    @Override
    public void create(ServiceStartType startType, String binPath, Credentials credentials) throws WindowsSecurityException {
        this.m_secureUtil.assertCredentials(credentials);
        try {
            this.assertServiceParams(binPath, null, null, false);
            this.doInternalCreate(startType, binPath, credentials, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void create(ServiceStartType startType, String binPath, Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertCredentials(credentials);
        this.assertServiceParams(binPath, localNodeName, nodeNames, true);
        this.doInternalCreate(startType, binPath, credentials, localNodeName, nodeNames);
    }

    private void assertServiceParams(String binPath, String localNodeName, String[] nodeNames, boolean assertNodesArgs) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isHomePathValid(binPath)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_SERVICE_PATH, binPath, this.m_servicename);
        }
        if (!assertNodesArgs) {
            return;
        }
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
    }

    private void assertCreateParameters(int desiredAccess, String[] dependencies) throws WindowsSecurityException {
        if (desiredAccess <= 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_SERVICE_ACCESS, new Integer(desiredAccess), this.m_servicename);
        }
        if (dependencies != null) {
            Trace.out("evaluating dependencies for service :" + this.m_servicename);
            for (String dependency : dependencies) {
                if (dependency != null && dependency.length() > 0) continue;
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_SERVICE_DEPENDENCY, this.m_servicename);
            }
        }
    }

    @Override
    public void create(String displayName, int desiredAccess, ServiceType serviceType, ServiceStartType startType, ServiceErrorControl errorControl, String binPath, String loadOrder, String[] dependencies) throws WindowsSecurityException {
        this.assertCreateParameters(desiredAccess, dependencies);
        try {
            this.assertServiceParams(binPath, null, null, false);
            this.doInternalCreate(displayName, desiredAccess, serviceType, startType, errorControl, binPath, loadOrder, dependencies, null, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void create(String displayName, int desiredAccess, ServiceType serviceType, ServiceStartType startType, ServiceErrorControl errorControl, String binPath, String loadOrder, String[] dependencies, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertServiceParams(binPath, localNodeName, nodeNames, true);
        this.assertCreateParameters(desiredAccess, dependencies);
        this.doInternalCreate(displayName, desiredAccess, serviceType, startType, errorControl, binPath, loadOrder, dependencies, null, localNodeName, nodeNames);
    }

    @Override
    public void create(String displayName, int desiredAccess, ServiceType serviceType, ServiceStartType startType, ServiceErrorControl errorControl, String binPath, String loadOrder, String[] dependencies, Credentials credentials) throws WindowsSecurityException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        this.assertCreateParameters(desiredAccess, dependencies);
        try {
            this.assertServiceParams(binPath, null, null, false);
            this.doInternalCreate(displayName, desiredAccess, serviceType, startType, errorControl, binPath, loadOrder, dependencies, credentials, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void create(String displayName, int desiredAccess, ServiceType serviceType, ServiceStartType startType, ServiceErrorControl errorControl, String binPath, String loadOrder, String[] dependencies, Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertCredentials(credentials);
        this.assertServiceParams(binPath, localNodeName, nodeNames, true);
        this.assertCreateParameters(desiredAccess, dependencies);
        this.doInternalCreate(displayName, desiredAccess, serviceType, startType, errorControl, binPath, loadOrder, dependencies, credentials, localNodeName, nodeNames);
    }

    private void doInternalCreate(ServiceStartType startType, String binPath, Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String displayName = null;
        int desiredAccess = 983551;
        ServiceType serviceType = ServiceType.SERVICE_WIN32_OWN_PROCESS;
        ServiceErrorControl errorControl = ServiceErrorControl.SERVICE_ERROR_NORMAL;
        String loadOrder = null;
        String[] dependencies = null;
        this.doInternalCreate(displayName, desiredAccess, serviceType, startType, errorControl, binPath, loadOrder, dependencies, credentials, localNodeName, nodeNames);
    }

    private void doInternalCreate(String displayName, int desiredAccess, ServiceType serviceType, ServiceStartType startType, ServiceErrorControl errorControl, String binPath, String loadOrder, String[] dependencies, Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = null;
        String password = null;
        if (credentials != null) {
            username = credentials.getUsername();
            password = credentials.getPassword();
            Trace.out("creating service owned by user: " + username);
        }
        int serviceTypeInt = new Integer(serviceType.getServiceType());
        int startTypeInt = new Integer(startType.ordinal());
        int errorControlInt = new Integer(errorControl.ordinal());
        Trace.out("creating servicename = " + this.m_servicename + "access = " + desiredAccess + "service type = " + serviceTypeInt + "start type = " + startTypeInt + "error control = " + errorControlInt + "load group = " + loadOrder + "path = " + binPath + "service display = " + displayName);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.createService(this.m_servicename, displayName, desiredAccess, serviceTypeInt, startTypeInt, errorControlInt, binPath, loadOrder, dependencies, username, password, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.CREATE_SERVICE_FAILED, (Throwable)e, this.m_servicename);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.CREATE_SERVICE_FAILED_NODE, (Throwable)e, this.m_servicename);
            }
            Trace.out("after creating service");
            return;
        }
        String dependenciesStr = Utils.strArrToString(dependencies, "::");
        String desiredAccessStr = new Integer(desiredAccess).toString();
        String serviceTypeStr = new Integer(serviceTypeInt).toString();
        String startTypeStr = new Integer(startTypeInt).toString();
        String errorControlStr = new Integer(errorControlInt).toString();
        String[] args = new String[]{this.m_servicename, displayName, desiredAccessStr, serviceTypeStr, startTypeStr, errorControlStr, binPath, loadOrder, dependenciesStr, "::", username, password};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the create service commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.createService, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.CREATE_SERVICE_FAILED_NODE, resultMap, this.m_servicename, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public void delete() throws WindowsSecurityException {
        try {
            this.doInternalDelete(null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void delete(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalDelete(localNodeName, nodeNames);
    }

    private void doInternalDelete(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("deleting service " + this.m_servicename);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.deleteService(this.m_servicename, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.DELETE_SERVICE_FAILED, (Throwable)e, this.m_servicename);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.DELETE_SERVICE_FAILED_NODE, (Throwable)e, this.m_servicename, localNodeName);
            }
            Trace.out("after delete service");
            return;
        }
        String[] args = new String[]{this.m_servicename};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the delete service commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.deleteService, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PATH_FAILED_NODE, resultMap, this.m_servicename, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public boolean isRunningAsLocalSystem() throws WindowsSecurityException {
        try {
            Map<String, Boolean> isLSAMap = this.doInternalIsRunningAsLocalSystem(null, null);
            return isLSAMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isRunningAsLocalSystem(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsRunningAsLocalSystem(localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsRunningAsLocalSystem(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("checking if service is running as Local system for service " + this.m_servicename);
        HashMap<String, Boolean> nodeLSAMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isServiceLSA = false;
            WinSecurityNative.isServiceRunningAsLocalSystem(this.m_servicename, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_LSA, (Throwable)e, this.m_servicename);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_LSA_NODE, (Throwable)e, this.m_servicename, localNodeName);
            }
            isServiceLSA = result.getBooleanResult();
            Trace.out("service LSA = " + isServiceLSA);
            nodeLSAMap.put(localNodeName, isServiceLSA);
            return nodeLSAMap;
        }
        String[] args = new String[]{this.m_servicename};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the is service LSA owned commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.isServiceLSA, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_SERVICE_LSA_NODE, resultMap, this.m_servicename, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            boolean nodeStatus = nr.getBooleanResult();
            Trace.out("the service is " + nodeStatus + " on node " + node);
            nodeLSAMap.put((String)node, nodeStatus);
        }
        return nodeLSAMap;
    }

    @Override
    public Credentials getUser() throws WindowsSecurityException {
        try {
            Map<String, Credentials> serviceUserMap = this.doInternalGetUser(null, null);
            return serviceUserMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Credentials> getUser(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalGetUser(localNodeName, nodeNames);
    }

    private Map<String, Credentials> doInternalGetUser(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("getting service user for service " + this.m_servicename);
        HashMap<String, Credentials> nodeUserMap = new HashMap<String, Credentials>();
        Trace.out("checking if service user is local system user");
        ArrayList<String> nonBuiltinList = new ArrayList<String>();
        boolean nonLSAService = false;
        Map<String, Boolean> isBuiltinUser = this.doInternalIsRunningAsLocalSystem(localNodeName, nodeNames);
        for (String node : isBuiltinUser.keySet()) {
            if (isBuiltinUser.get(node).booleanValue()) {
                nodeUserMap.put(node, new Credentials(Credentials.BuiltinUser.LOCALSYSTEM));
                continue;
            }
            nonBuiltinList.add(node);
            nonLSAService = true;
        }
        if (!nonLSAService) {
            return nodeUserMap;
        }
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.getServiceUser(this.m_servicename, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FAILED, (Throwable)e, this.m_servicename);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FAILED_NODE, (Throwable)e, this.m_servicename, localNodeName);
            }
            String serviceUser = result.getStringResult();
            Trace.out("user is = " + serviceUser);
            nodeUserMap.put(localNodeName, new Credentials(serviceUser));
            return nodeUserMap;
        }
        String[] args = new String[]{this.m_servicename};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.getServiceUser, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FAILED_NODE, resultMap, this.m_servicename, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            String nodeUser = nr.getStringResult();
            Trace.out("the service owner is " + nodeUser + " on node " + node);
            nodeUserMap.put((String)node, new Credentials(nodeUser));
        }
        return nodeUserMap;
    }

    @Override
    public String getSidName() throws WindowsSecurityException {
        Trace.out("getting Windows SID for service " + this.m_servicename);
        NativeResult result = new NativeResult();
        WinSecurityNative.getWindowsSIDForService(this.m_servicename, result);
        if (result.getStatus()) {
            String serviceSid = result.getStringResult();
            Trace.out("The service sid is: " + serviceSid);
            return serviceSid;
        }
        Exception e = result.getException();
        Trace.out("native operation failed with " + e.getMessage());
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_SID_FAILED, (Throwable)e, this.m_servicename);
    }
}

