/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityCommandExecution;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.OracleHomeType;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WinSecurityHomeImpl
implements Home,
Constants {
    private String m_homePath;
    private Version m_version;
    private SecureUtil m_secureUtil;
    private String m_srcloc;
    private WinSecurityNative m_secureNative;
    private MessageBundle m_msgBndl;
    private boolean m_isUsertypeCacheInitialized = false;
    private boolean m_isUserVirtualAccountCache = false;
    private Map<String, Boolean> m_isUserLocalSystemMapCache = null;
    private final String BIN_DIR = "bin";
    private final String ORACLE_KEY = "oracle.key";

    WinSecurityHomeImpl(String homePath, String srcLoc, Version version) throws WindowsSecurityException {
        this.m_homePath = homePath;
        this.m_version = version;
        this.m_secureUtil = new SecureUtil();
        this.m_srcloc = srcLoc;
        if (!this.m_secureUtil.isHomePathValid(homePath)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_HOME_PATH_VALUE, this.m_homePath);
        }
    }

    @Override
    public Credentials getServiceUserForHome() throws WindowsSecurityException {
        try {
            Map<String, Credentials> serviceUserMap = this.doInternalGetServiceUserForHome(null, null);
            return serviceUserMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Credentials> getServiceUserForHome(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalGetServiceUserForHome(localNodeName, nodeNames);
    }

    private Map<String, Credentials> doInternalGetServiceUserForHome(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("getting service user current oracle home");
        String FSEP = System.getProperty("file.separator");
        File homeKeyFile = new File(this.m_homePath + FSEP + "bin" + FSEP + "oracle.key");
        boolean isHomeExists = homeKeyFile.exists();
        HashMap<String, Credentials> nodeUserMap = new HashMap<String, Credentials>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        this.m_isUsertypeCacheInitialized = false;
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            String homeUser = null;
            WinSecurityNative.getServiceUserForOhome(localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_OHOME_FAILED, (Throwable)e, new Object[0]);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_OHOME_FAILED_NODE, (Throwable)e, localNodeName);
            }
            homeUser = result.getStringResult();
            Trace.out("user is = " + homeUser);
            Credentials creds = null;
            try {
                creds = this.createCredentialsObject(homeUser, isLocalOperation, localNodeName, nodeNames, localNodeName);
            }
            catch (WindowsSecurityException e) {
                if (!isHomeExists) {
                    creds = new Credentials(homeUser);
                }
                throw e;
            }
            catch (CompositeOperationException e) {
                if (!isHomeExists) {
                    creds = new Credentials(homeUser);
                }
                throw e;
            }
            nodeUserMap.put(localNodeName, creds);
            return nodeUserMap;
        }
        String[] args = new String[]{};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the get home from path commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.getServiceUserForOhome, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_OHOME_FAILED_NODE, resultMap, this.m_homePath, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            String nodeUser = nr.getStringResult();
            Trace.out("the user is " + nodeUser + " on node " + node);
            Credentials creds = null;
            try {
                creds = this.createCredentialsObject(nodeUser, isLocalOperation, localNodeName, nodeNames, (String)node);
            }
            catch (WindowsSecurityException e) {
                if (!isHomeExists) {
                    creds = new Credentials(nodeUser);
                }
                throw e;
            }
            catch (CompositeOperationException e) {
                if (!isHomeExists) {
                    creds = new Credentials(nodeUser);
                }
                throw e;
            }
            nodeUserMap.put((String)node, creds);
        }
        return nodeUserMap;
    }

    @Override
    public Credentials getServiceUserFromHomePath() throws WindowsSecurityException {
        try {
            Map<String, Credentials> serviceUserMap = this.doInternalGetServiceUserFromOhomePath(null, null);
            return serviceUserMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Credentials> getServiceUserFromHomePath(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalGetServiceUserFromOhomePath(localNodeName, nodeNames);
    }

    private Map<String, Credentials> doInternalGetServiceUserFromOhomePath(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("getting service user for path " + this.m_homePath);
        HashMap<String, Credentials> nodeUserMap = new HashMap<String, Credentials>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        this.m_isUsertypeCacheInitialized = false;
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.getServiceUserFromOhomePath(this.m_homePath, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_PATH_FAILED, (Throwable)e, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_PATH_FAILED_NODE, (Throwable)e, this.m_homePath, localNodeName);
            }
            String homeUser = result.getStringResult();
            Trace.out("user is = " + homeUser);
            Credentials creds = this.createCredentialsObject(homeUser, isLocalOperation, localNodeName, nodeNames, localNodeName);
            nodeUserMap.put(localNodeName, creds);
            return nodeUserMap;
        }
        String[] args = new String[]{this.m_homePath};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the get home from path commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.getServiceUserFromPath, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_PATH_FAILED_NODE, resultMap, this.m_homePath, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            String nodeUser = nr.getStringResult();
            Trace.out("the user is " + nodeUser + " on node " + node);
            Credentials creds = this.createCredentialsObject(nodeUser, isLocalOperation, localNodeName, nodeNames, (String)node);
            nodeUserMap.put((String)node, creds);
        }
        return nodeUserMap;
    }

    @Override
    public boolean isServiceUserMSA() throws WindowsSecurityException {
        Trace.out("checking if service user is MSA user for home" + this.m_homePath);
        NativeResult result = new NativeResult();
        WinSecurityNative.isServiceUserMSA(this.m_homePath, result);
        if (result.getStatus()) {
            boolean isUserMSA = result.getBooleanResult();
            Trace.out("The service user isMSA:" + isUserMSA);
            return isUserMSA;
        }
        Exception e = result.getException();
        Trace.out("native operation failed with " + e.getMessage());
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_MSA_FAILED, (Throwable)e, this.m_homePath);
    }

    @Override
    public boolean isServiceUserLocalSystem() throws WindowsSecurityException {
        try {
            Map<String, Boolean> isLocalSystemMap = this.doInternalIsServiceUserLocalSystem(null, null);
            return isLocalSystemMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isServiceUserLocalSystem(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsServiceUserLocalSystem(localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsServiceUserLocalSystem(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("checking if service user is LSA user for home" + this.m_homePath);
        HashMap<String, Boolean> nodeLSAMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isUserLSA = false;
            WinSecurityNative.isServiceUserLocalSystem(this.m_homePath, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_LSA_FAILED, (Throwable)e, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_LSA_FAILED_NODE, (Throwable)e, this.m_homePath, localNodeName);
            }
            isUserLSA = result.getBooleanResult();
            Trace.out("user LSA = " + isUserLSA);
            nodeLSAMap.put(localNodeName, isUserLSA);
            return nodeLSAMap;
        }
        String[] args = new String[]{this.m_homePath};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the isUserLSA commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.isUserLSA, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_SERVICE_USER_LSA_FAILED_NODE, resultMap, this.m_homePath, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            boolean nodeStatus = nr.getBooleanResult();
            Trace.out("the user is " + nodeStatus + " on node " + node);
            nodeLSAMap.put((String)node, nodeStatus);
        }
        return nodeLSAMap;
    }

    @Override
    public boolean isServiceUserLocalService() throws WindowsSecurityException {
        Trace.out("checking if service user is LocalService user for home" + this.m_homePath);
        NativeResult result = new NativeResult();
        WinSecurityNative.isServiceUserLocalService(this.m_homePath, result);
        if (result.getStatus()) {
            boolean isUserLSA = result.getBooleanResult();
            Trace.out("The service user isLocalService :" + isUserLSA);
            return isUserLSA;
        }
        Exception e = result.getException();
        Trace.out("native operation failed with " + e.getMessage());
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_LSERVICE_FAILED, (Throwable)e, this.m_homePath);
    }

    @Override
    public boolean isServiceUserPasswordRequired() throws WindowsSecurityException {
        try {
            Map<String, Boolean> serviceUserMap = this.doInternalIsServiceUserPasswordRequired(null, null);
            return serviceUserMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isServiceUserPasswordRequired(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsServiceUserPasswordRequired(localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsServiceUserPasswordRequired(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("checking if service user requires a password for path " + this.m_homePath);
        HashMap<String, Boolean> nodePasswordMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.isServiceUserPasswordRequired(this.m_homePath, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_PASSWORD_FAILED, (Throwable)e, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_PASSWORD_FAILED_NODE, (Throwable)e, this.m_homePath, localNodeName);
            }
            boolean isPasswordRequired = result.getBooleanResult();
            Trace.out("home user password required is = " + isPasswordRequired);
            nodePasswordMap.put(localNodeName, isPasswordRequired);
            return nodePasswordMap;
        }
        String[] args = new String[]{this.m_homePath};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the is password required commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.isSvcUsrPasswordRequired, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_SERVICE_USER_PASSWORD_FAILED_NODE, resultMap, this.m_homePath, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            boolean isPasswordRequired = nr.getBooleanResult();
            Trace.out("the user is password required " + isPasswordRequired + " on node " + node);
            nodePasswordMap.put((String)node, isPasswordRequired);
        }
        return nodePasswordMap;
    }

    @Override
    public void setOracleHomeType(String oracleHomeKey, OracleHomeType homeType) throws WindowsSecurityException {
        try {
            this.doInternalSetOracleHomeType(oracleHomeKey, homeType, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void setOracleHomeType(String oracleHomeKey, OracleHomeType homeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalSetOracleHomeType(oracleHomeKey, homeType, localNodeName, nodeNames);
    }

    private void doInternalSetOracleHomeType(String oracleHomeKey, OracleHomeType homeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertOracleHomeKey(oracleHomeKey);
        String homeTypeStr = homeType.toString();
        Trace.out("setting home type " + homeTypeStr + " as type of oracle home with key " + oracleHomeKey);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.setOracleHomeType(homeTypeStr, oracleHomeKey, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.SET_HOME_TYPE_FAILED, (Throwable)e, homeTypeStr, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.SET_HOME_TYPE_FAILED_NODE, (Throwable)e, homeTypeStr, this.m_homePath, localNodeName);
            }
            Trace.out("after setting user");
            return;
        }
        String[] args = new String[]{homeTypeStr, oracleHomeKey};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the sethometype commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.setHomeType, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SET_HOME_TYPE_FAILED_NODE, resultMap, homeTypeStr, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public OracleHomeType getOracleHomeType(String oracleHomeKey) throws WindowsSecurityException {
        try {
            Map<String, OracleHomeType> homeTypeMap = this.doInternalGetOracleHomeType(oracleHomeKey, null, null);
            return homeTypeMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, OracleHomeType> getOracleHomeType(String oracleHomeKey, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalGetOracleHomeType(oracleHomeKey, localNodeName, nodeNames);
    }

    private Map<String, OracleHomeType> doInternalGetOracleHomeType(String oracleHomeKey, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("getting home type for key " + oracleHomeKey);
        HashMap<String, OracleHomeType> nodeTypeMap = new HashMap<String, OracleHomeType>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.getOracleHomeType(oracleHomeKey, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_HOME_TYPE_FAILED, (Throwable)e, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_HOME_TYPE_FAILED_NODE, (Throwable)e, this.m_homePath, localNodeName);
            }
            String homeTypeStr = result.getStringResult();
            Trace.out("home type is = " + homeTypeStr);
            OracleHomeType homeTypeEnum = OracleHomeType.fromString(homeTypeStr.trim());
            nodeTypeMap.put(localNodeName, homeTypeEnum);
            return nodeTypeMap;
        }
        String[] args = new String[]{oracleHomeKey};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the get home type commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.getHomeType, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GET_SERVICE_USER_FOR_PATH_FAILED_NODE, resultMap, this.m_homePath, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            String nodeTypeStr = nr.getStringResult();
            Trace.out("the type is " + nodeTypeStr + " on node " + node);
            OracleHomeType homeTypeEnum = OracleHomeType.fromString(nodeTypeStr.trim());
            nodeTypeMap.put((String)node, homeTypeEnum);
        }
        return nodeTypeMap;
    }

    @Override
    public List<String> getAllServicesForUser(Credentials credentials) throws WindowsSecurityException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        try {
            Map<String, List<String>> serviceMap = this.doInternalGetAllServicesForUser(credentials, null, null);
            return serviceMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, List<String>> getAllServicesForUser(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalGetAllServicesForUser(credentials, localNodeName, nodeNames);
    }

    private Map<String, List<String>> doInternalGetAllServicesForUser(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = credentials.getUsername();
        Trace.out("getting services for user " + username + " home is " + this.m_homePath);
        HashMap<String, List<String>> serviceUserMap = new HashMap<String, List<String>>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            List<Object> servicesList;
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.getAllServicesForHome(username, this.m_homePath, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_ALL_SERVICE_FOR_HOME_FAILED, (Throwable)e, username, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_ALL_SERVICE_FOR_HOME_FAILED_NODE, (Throwable)e, username, this.m_homePath, localNodeName);
            }
            String servicesStr = result.getStringResult();
            Trace.out("service are = " + servicesStr);
            if (servicesStr != null && servicesStr.length() > 0) {
                String[] serviceArr = servicesStr.split("::");
                servicesList = Arrays.asList(serviceArr);
            } else {
                servicesList = new ArrayList();
            }
            serviceUserMap.put(localNodeName, servicesList);
            return serviceUserMap;
        }
        String[] args = new String[]{username, this.m_homePath};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the get home from path commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.getAllServicesForHome, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GET_ALL_SERVICE_FOR_HOME_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            List<Object> servicesList;
            NativeResult nr = resultMap.get(node);
            String serviceStr = nr.getStringResult();
            Trace.out("the service list is " + serviceStr + " on node " + node);
            if (serviceStr != null && serviceStr.length() > 0) {
                String[] serviceArr = serviceStr.split("::");
                servicesList = Arrays.asList(serviceArr);
            } else {
                servicesList = new ArrayList();
            }
            serviceUserMap.put((String)node, servicesList);
        }
        return serviceUserMap;
    }

    @Override
    public void modifyPasswordForAllServices(Credentials credentials) throws WindowsSecurityException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        try {
            this.doInternalModifyPasswordForAllServices(credentials, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void modifyPasswordForAllServices(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalModifyPasswordForAllServices(credentials, localNodeName, nodeNames);
    }

    private void doInternalModifyPasswordForAllServices(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        Trace.out("updating password services for user " + username + " home is " + this.m_homePath);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.updateAllHomeServicesPasswd(username, password, this.m_homePath, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_HOME_FAILED, (Throwable)e, username, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_HOME_FAILED_NODE, (Throwable)e, username, this.m_homePath, localNodeName);
            }
            Trace.out("successfully updated password for all services");
            return;
        }
        String[] args = new String[]{username, password, this.m_homePath};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the update all home services password commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.updateAllHomeServicesPasswd, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_HOME_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public boolean isServiceUserGroupMSA() throws WindowsSecurityException {
        try {
            Map<String, Boolean> isServiceUserGroupMSAMap = this.doInternalIsServiceUserGroupMSA(null, null);
            return isServiceUserGroupMSAMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isServiceUserGroupMSA(String localNodeName, String[] nodeArr) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeArr)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsServiceUserGroupMSA(localNodeName, nodeArr);
    }

    private Map<String, Boolean> doInternalIsServiceUserGroupMSA(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("checking if service user is group MSA user for home" + this.m_homePath);
        HashMap<String, Boolean> nodeGMSAMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isUserGMSA = false;
            WinSecurityNative.isServiceUserGMSA(this.m_homePath, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_GMSA_FAILED, (Throwable)e, this.m_homePath);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_GMSA_FAILED_NODE, (Throwable)e, this.m_homePath, localNodeName);
            }
            isUserGMSA = result.getBooleanResult();
            Trace.out("user GMSA = " + isUserGMSA);
            nodeGMSAMap.put(localNodeName, isUserGMSA);
            return nodeGMSAMap;
        }
        String[] args = new String[]{this.m_homePath};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the is service user GMSA commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.isHomeServiceUserGMSA, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_SERVICE_USER_GMSA_FAILED_NODE, resultMap, this.m_homePath, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            boolean nodeStatus = nr.getBooleanResult();
            Trace.out("the user is " + nodeStatus + " on node " + node);
            nodeGMSAMap.put((String)node, nodeStatus);
        }
        return nodeGMSAMap;
    }

    @Override
    public boolean isServiceUserVirtualAccount() throws WindowsSecurityException {
        Trace.out("checking if service user is virtual account user for home" + this.m_homePath);
        NativeResult result = new NativeResult();
        WinSecurityNative.isServiceUserVirtualAccount(this.m_homePath, result);
        if (result.getStatus()) {
            boolean isUserVirtualAccount = result.getBooleanResult();
            Trace.out("The service user isVirtualAccount: " + isUserVirtualAccount);
            return isUserVirtualAccount;
        }
        Exception e = result.getException();
        Trace.out("native operation failed with " + e.getMessage());
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_SERVICE_USER_VIRTUALACCOUNT_FAILED, (Throwable)e, this.m_homePath);
    }

    private Credentials createCredentialsObject(String homeUser, boolean isLocalOperation, String localNodeName, String[] nodeNames, String currentNode) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_isUsertypeCacheInitialized) {
            if (isLocalOperation) {
                this.m_isUserVirtualAccountCache = this.isServiceUserVirtualAccount();
            }
            if (!this.m_isUserVirtualAccountCache) {
                this.m_isUserLocalSystemMapCache = this.doInternalIsServiceUserLocalSystem(localNodeName, nodeNames);
            }
            this.m_isUsertypeCacheInitialized = true;
        }
        boolean m_isLocalSystemUser = false;
        if (this.m_isUserLocalSystemMapCache != null) {
            m_isLocalSystemUser = this.m_isUserLocalSystemMapCache.get(currentNode);
        }
        Credentials creds = new Credentials(homeUser);
        if (this.m_isUserVirtualAccountCache) {
            creds.setBuiltinUser(Credentials.BuiltinUser.VIRTUALACCOUNT);
        } else if (m_isLocalSystemUser) {
            Trace.out("service user is local system");
            creds = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
        }
        return creds;
    }
}

