/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import oracle.cluster.impl.winsecurity.GroupImpl;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.UserImpl;
import oracle.cluster.impl.winsecurity.UserPrivilegeImpl;
import oracle.cluster.impl.winsecurity.WinSecurityHomeImpl;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.impl.winsecurity.WinSecurityServiceImpl;
import oracle.cluster.impl.winsecurity.WinSecuritySystem;
import oracle.cluster.impl.winsecurity.WinSecurityUtilImpl;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Group;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.Service;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.UserPrivilege;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;

public class WinSecurityFactoryImpl {
    private static WinSecurityFactoryImpl s_winSecurityFactoryImpl = null;
    private String m_srcLoc;
    private String m_destLoc;
    private SecureUtil m_secureUtil = new SecureUtil();
    private static NativeResult m_wsecTraceResult = new NativeResult();

    private WinSecurityFactoryImpl(String srcloc, String destLoc) {
        this.m_srcLoc = srcloc;
        this.m_destLoc = destLoc;
        if (destLoc != null) {
            this.m_secureUtil.setDestLoc(this.m_destLoc);
        }
    }

    public static synchronized WinSecurityFactoryImpl getInstance(String srcLoc, String destLoc) throws WindowsSecurityException {
        if (null == s_winSecurityFactoryImpl) {
            s_winSecurityFactoryImpl = new WinSecurityFactoryImpl(srcLoc, destLoc);
        }
        WinSecurityNative.enableWsecTracing(m_wsecTraceResult);
        return s_winSecurityFactoryImpl;
    }

    public User getUserInstance(Credentials credentials, Version version) throws WindowsSecurityException {
        UserImpl userImpl = new UserImpl(credentials, this.getSourceLocation(), version);
        return userImpl;
    }

    public Home getHomeInstance(String homePath, Version version) throws WindowsSecurityException {
        WinSecurityHomeImpl homeImpl = new WinSecurityHomeImpl(homePath, this.getSourceLocation(), version);
        return homeImpl;
    }

    public UserPrivilege getUserPrivilegeInstance(Credentials credentials, Version version) throws WindowsSecurityException {
        UserPrivilegeImpl userPrivilegeImpl = new UserPrivilegeImpl(credentials, this.getSourceLocation(), version);
        return userPrivilegeImpl;
    }

    public Service getServiceInstance(String serviceName, Version version) throws WindowsSecurityException {
        WinSecurityServiceImpl serviceImpl = new WinSecurityServiceImpl(serviceName, this.getSourceLocation(), version);
        return serviceImpl;
    }

    public Group getGroupInstance(String groupName, Version version) throws WindowsSecurityException {
        GroupImpl groupImpl = new GroupImpl(groupName, this.getSourceLocation(), version);
        return groupImpl;
    }

    public void migrateDBServiceSidsForUpgrade() throws WindowsSecurityException {
        WinSecuritySystem winSecuritySystem = new WinSecuritySystem();
        winSecuritySystem.migrateDBServiceSidsForUpgrade();
    }

    public void migrateDBServiceSidsForDowngrade() throws WindowsSecurityException {
        WinSecuritySystem winSecuritySystem = new WinSecuritySystem();
        winSecuritySystem.migrateDBServiceSidsForDowngrade();
    }

    public WinSecurityUtilImpl getWinSecurityUtilInstance(Version version) throws WindowsSecurityException {
        WinSecurityUtilImpl utilImpl = new WinSecurityUtilImpl(version, this.getSourceLocation());
        return utilImpl;
    }

    public String getSourceLocation() {
        return this.m_srcLoc;
    }

    protected void finalize() throws Throwable {
        NativeResult result = new NativeResult();
        WinSecurityNative.freeIndexTracing(result);
    }
}

