/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.util.List;
import java.util.Map;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;

class WinSecurityCommandExecution {
    WinSecurityCommandExecution() {
    }

    public static void executeCommands(String localNodeName, String[] nodeNames, WinSecurityCommand.CommandType cmdType, String[] args, String srcloc, List<String> failedNodes, Map<Object, NativeResult> resultMap) throws WindowsSecurityException, ConcurrencyException, CompositeOperationException {
        SecureUtil secureUtil = new SecureUtil();
        String[] execNodeArr = secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved " + execNodeArr.length);
        Command[] cmdArr = new WinSecurityCommand[execNodeArr.length];
        for (int i = 0; i < execNodeArr.length; ++i) {
            cmdArr[i] = new WinSecurityCommand(cmdType, execNodeArr[i], args, srcloc, secureUtil.getDestLocation(execNodeArr[i]));
        }
        Trace.out("creating parallel execute factory");
        ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(cmdArr, new Version());
        threadExec.submit();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = cmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) continue;
            failedNodes.add(execNodeArr[i]);
        }
    }
}

