/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.InsufficientPrivilegeException;
import oracle.cluster.winsecurity.OracleHomeType;
import oracle.cluster.winsecurity.PermissionType;
import oracle.cluster.winsecurity.UserPrivilege;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.cluster.winsecurity.WindowsStorageType;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class UserPrivilegeImpl
implements UserPrivilege,
Constants {
    private Credentials m_credentials;
    private Version m_version;
    private SecureUtil m_secureUtil;
    private String m_srcloc;
    private WinSecurityNative m_secureNative;
    private final String NO_MISSING_PRIVILEGE = "NO_MISSING_PRIVILEGE";

    UserPrivilegeImpl(Credentials credentials, String srcLoc, Version version) {
        this.m_credentials = credentials;
        this.m_version = version;
        this.m_secureUtil = new SecureUtil();
        this.m_srcloc = srcLoc;
    }

    @Override
    public void check(OracleHomeType oracleHomeType) throws WindowsSecurityException, InsufficientPrivilegeException {
        this.assertHomeType(oracleHomeType);
        try {
            this.doInternalCheck(oracleHomeType, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void check(OracleHomeType oracleHomeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException, InsufficientPrivilegeException {
        this.assertHomeType(oracleHomeType);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalCheck(oracleHomeType, localNodeName, nodeNames);
    }

    private void doInternalCheck(OracleHomeType oracleHomeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException, InsufficientPrivilegeException {
        String username = this.m_credentials.getUsername();
        String homeTypeStr = oracleHomeType.toString();
        Trace.out("checking if user " + username + " has privileges for hometype " + (Object)((Object)oracleHomeType));
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.checkUserPrivilege(username, homeTypeStr, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("check user privilege native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.CHECK_USER_PRIVILEGE_FAILED, (Throwable)e, username);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.CHECK_USER_PRIVILEGE_FAILED_NODE, (Throwable)e, username, localNodeName);
            }
            String missingPrivs = result.getStringResult();
            Trace.out("returned missing privileges are = " + missingPrivs);
            if (!missingPrivs.equals("NO_MISSING_PRIVILEGE")) {
                if (localNodeName == null) {
                    throw new InsufficientPrivilegeException((MessageKey)PrCzMsgID.MISSING_PRIVILEGE, username, missingPrivs, homeTypeStr);
                }
                throw new InsufficientPrivilegeException((MessageKey)PrCzMsgID.MISSING_PRIVILEGE, username, missingPrivs, homeTypeStr, localNodeName);
            }
            return;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved" + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, oracleHomeType.toString()};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.checkUserPrivilege, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.checkUserPrivilege, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            Trace.out("executing the check user priv for home type commands");
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        ArrayList<String> missingPrivNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        HashMap<Object, Exception> exceptionMap = new HashMap<Object, Exception>();
        String missingPrivStr = null;
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) {
                String missingPrivs = nr.getStringResult();
                InsufficientPrivilegeException inex = null;
                Trace.out("the missing privileges are " + missingPrivs + " on node " + execNodeArr[i]);
                if (missingPrivs.equals("NO_MISSING_PRIVILEGE")) continue;
                missingPrivStr = missingPrivStr == null ? missingPrivs : missingPrivStr + "," + missingPrivs;
                inex = new InsufficientPrivilegeException((MessageKey)PrCzMsgID.MISSING_PRIVILEGE, username, missingPrivs, homeTypeStr, execNodeArr[i]);
                missingPrivNodes.add(execNodeArr[i]);
                exceptionMap.put(execNodeArr[i], inex);
                continue;
            }
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.CHECK_USER_PRIVILEGE_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        if (missingPrivNodes.size() > 0) {
            throw new CompositeOperationException(exceptionMap, PrCzMsgID.MISSING_PRIVILEGE, username, missingPrivStr, homeTypeStr, Utils.strListToList(missingPrivNodes));
        }
    }

    @Override
    public void grant(OracleHomeType oracleHomeType) throws WindowsSecurityException {
        this.assertHomeType(oracleHomeType);
        try {
            this.doInternalGrant(oracleHomeType, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void grant(OracleHomeType oracleHomeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertHomeType(oracleHomeType);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalGrant(oracleHomeType, localNodeName, nodeNames);
    }

    private void doInternalGrant(OracleHomeType oracleHomeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String homeTypeStr = oracleHomeType.toString();
        String username = this.m_credentials.getUsername();
        Trace.out("granting " + username + " privilege for home type " + homeTypeStr);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.grantPrivilegeToUser(username, homeTypeStr, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GRANT_USER_PRIVILEGE_FAILED, (Throwable)e, username, homeTypeStr);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GRANT_USER_PRIVILEGE_FAILED_NODE, (Throwable)e, username, homeTypeStr, localNodeName);
            }
            Trace.out("after granting user privileges required");
            return;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved " + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, homeTypeStr};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.grantPrivilegeToUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.grantPrivilegeToUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            Trace.out("executing the grant privilege to user commands");
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) continue;
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GRANT_USER_PRIVILEGE_FAILED_NODE, resultMap, username, homeTypeStr, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public void revoke(OracleHomeType oracleHomeType) throws WindowsSecurityException {
        this.assertHomeType(oracleHomeType);
        try {
            this.doInternalRevoke(oracleHomeType, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void revoke(OracleHomeType oracleHomeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertHomeType(oracleHomeType);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalRevoke(oracleHomeType, localNodeName, nodeNames);
    }

    private void doInternalRevoke(OracleHomeType oracleHomeType, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String homeTypeStr = oracleHomeType.toString();
        String username = this.m_credentials.getUsername();
        Trace.out("revoking " + username + "'s privilege for home type " + homeTypeStr);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.revokePrivilegeFromUser(username, homeTypeStr, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.REVOKE_USER_PRIVILEGE_FAILED, (Throwable)e, username, homeTypeStr);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.REVOKE_USER_PRIVILEGE_FAILED_NODE, (Throwable)e, username, homeTypeStr, localNodeName);
            }
            Trace.out("after revoking user privileges");
            return;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved " + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, homeTypeStr};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.revokePrivilegeFromUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.revokePrivilegeFromUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            Trace.out("executing the revoke privilege from user commands");
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) continue;
            Trace.out("revoke failed on node " + execNodeArr[i]);
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.REVOKE_USER_PRIVILEGE_FAILED_NODE, resultMap, username, homeTypeStr, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public void setAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        try {
            this.doInternalSetAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void setAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String[] excludePathArr) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        try {
            this.doInternalSetAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null, null, excludePathArr);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void setAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, String installUser, String[] excludePathArr, boolean inheritable) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        this.assertInstallUser(installUser);
        try {
            this.doInternalSetAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null, installUser, excludePathArr);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void setAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalSetAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames, null, null);
    }

    @Override
    public void setAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames, String[] excludePathArr) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalSetAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames, null, excludePathArr);
    }

    @Override
    public void setAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames, String installUser, String[] excludePathArr) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        this.assertInstallUser(installUser);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalSetAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames, installUser, excludePathArr);
    }

    private void doInternalSetAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames, String installUser, String[] excludePathArr) throws WindowsSecurityException, CompositeOperationException {
        int storageType = windowsStorageType.ordinal();
        String storageTypeStr = new Integer(storageType).toString();
        String username = this.m_credentials.getUsername();
        int permType = permissionType.ordinal();
        String permTypeStr = new Integer(permType).toString();
        String inheritableStr = Boolean.valueOf(inheritable).toString();
        String excludePathStr = "";
        String sizeExcludePath = null;
        String checkForAcfs = null;
        Trace.out("setting ACL for " + username + " for storage type " + storageTypeStr + " permission type " + permType + "the path is " + path + "inhertiable is " + inheritableStr + "  installuser " + installUser);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (installUser == null) {
            installUser = "";
        }
        if (excludePathArr != null) {
            for (String strExclude : excludePathArr) {
                excludePathStr = excludePathStr + strExclude + "?";
            }
            excludePathStr = excludePathStr.substring(0, excludePathStr.length() - 1);
            sizeExcludePath = Integer.toString(excludePathArr.length);
        } else {
            sizeExcludePath = "0";
        }
        Trace.out("size array exclude path " + sizeExcludePath + " excludePath " + excludePathStr);
        String string = checkForAcfs = this.m_secureUtil.getInventory() == null ? "0" : "1";
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.setAclsForUser(username, path, storageTypeStr, permTypeStr, inheritableStr, installUser, excludePathStr, sizeExcludePath, checkForAcfs, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.SET_ACL_FOR_USER_FAILED, (Throwable)e, username, path);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.SET_ACL_FOR_USER_FAILED_NODE, (Throwable)e, username, path, localNodeName);
            }
            Trace.out("after setting ACL entries");
            return;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved " + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, path, storageTypeStr, permTypeStr, inheritableStr, installUser, excludePathStr, sizeExcludePath, checkForAcfs};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.setAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.setAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        Trace.out("executing the set ACL entries for user commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) continue;
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SET_ACL_FOR_USER_FAILED_NODE, resultMap, username, path, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public void revokeAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        try {
            this.doInternalRevokeAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void revokeAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalRevokeAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames);
    }

    private void doInternalRevokeAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        int storageType = windowsStorageType.ordinal();
        String storageTypeStr = new Integer(storageType).toString();
        String username = this.m_credentials.getUsername();
        String inheritableStr = Boolean.valueOf(inheritable).toString();
        int permType = permissionType.ordinal();
        String permTypeStr = new Integer(permType).toString();
        Trace.out("revoking ACL for " + username + " for storage type " + storageTypeStr + " permission type " + permTypeStr + " the path is " + path + "inheritable is " + inheritableStr);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.revokeAclsForUser(username, path, storageTypeStr, permTypeStr, inheritableStr, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.REVOKE_ACL_FOR_USER_FAILED, (Throwable)e, username, path);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.REVOKE_ACL_FOR_USER_FAILED_NODE, (Throwable)e, username, path, localNodeName);
            }
            Trace.out("after revoking ACL entries");
            return;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved " + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, path, storageTypeStr, permTypeStr, inheritableStr};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.revokeAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.revokeAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]));
        }
        Trace.out("executing the revoke ACL entries for user commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) continue;
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.REVOKE_ACL_FOR_USER_FAILED_NODE, resultMap, username, path, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public boolean checkAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        try {
            Map<String, Boolean> userAclsMap = this.doInternalCheckAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null);
            return userAclsMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> checkAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalCheckAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames);
    }

    public Map<String, Boolean> doInternalCheckAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = this.m_credentials.getUsername();
        int storageType = windowsStorageType.ordinal();
        String storageTypeStr = new Integer(storageType).toString();
        int permType = permissionType.ordinal();
        String permTypeStr = new Integer(permType).toString();
        String inheritableStr = Boolean.valueOf(inheritable).toString();
        Trace.out("checking if user " + username + " has privileges for storage type " + storageTypeStr + " permission type " + permType + " inheritable is " + inheritableStr + " the path is " + path);
        HashMap<String, Boolean> nodeAclsMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.checkAclsForUser(username, path, storageTypeStr, permTypeStr, inheritableStr, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("check user ACL native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.CHECK_ACL_FOR_USER_FAILED, (Throwable)e, username, path);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.CHECK_ACL_FOR_USER_FAILED_NODE, (Throwable)e, username, path, localNodeName);
            }
            Boolean isUserACLPresent = result.getBooleanResult();
            Trace.out("user ACL status is = " + isUserACLPresent);
            nodeAclsMap.put(localNodeName, isUserACLPresent);
            return nodeAclsMap;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved" + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, path, storageTypeStr, permTypeStr, inheritableStr};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.checkAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.checkAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            Trace.out("executing the check user priv for home type commands");
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) {
                Boolean isUserAclsPresent = nr.getBooleanResult();
                Trace.out("the acls statuse for user " + username + " is " + isUserAclsPresent + " on node " + execNodeArr[i]);
                nodeAclsMap.put(execNodeArr[i], isUserAclsPresent);
                continue;
            }
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.CHECK_USER_PRIVILEGE_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        return nodeAclsMap;
    }

    @Override
    public void addAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        try {
            this.doInternalAddAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void addAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String[] excludePathArr) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        try {
            this.doInternalAddAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null, null, excludePathArr);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void addAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, String installUser, String[] excludePathArr, boolean inheritable) throws WindowsSecurityException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        this.assertInstallUser(installUser);
        try {
            this.doInternalAddAclsForUser(windowsStorageType, path, permissionType, inheritable, null, null, installUser, excludePathArr);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void addAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalAddAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames, null, null);
    }

    @Override
    public void addAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames, String[] excludePathArr) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalAddAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames, null, excludePathArr);
    }

    @Override
    public void addAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames, String installUser, String[] excludePathArr) throws WindowsSecurityException, CompositeOperationException {
        this.assertWindowsStorageType(windowsStorageType);
        this.assertPermissionType(permissionType);
        this.m_secureUtil.assertPath(path);
        this.assertExcludePath(excludePathArr);
        this.assertInstallUser(installUser);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalAddAclsForUser(windowsStorageType, path, permissionType, inheritable, localNodeName, nodeNames, installUser, excludePathArr);
    }

    private void doInternalAddAclsForUser(WindowsStorageType windowsStorageType, String path, PermissionType permissionType, boolean inheritable, String localNodeName, String[] nodeNames, String installUser, String[] excludePathArr) throws WindowsSecurityException, CompositeOperationException {
        int storageType = windowsStorageType.ordinal();
        String storageTypeStr = new Integer(storageType).toString();
        String username = this.m_credentials.getUsername();
        int permType = permissionType.ordinal();
        String permTypeStr = new Integer(permType).toString();
        String inheritableStr = Boolean.valueOf(inheritable).toString();
        String excludePathStr = "";
        String sizeExcludePath = null;
        String checkForAcfs = null;
        Trace.out("adding ACL for " + username + " for storage type " + storageTypeStr + " permission type " + permType + "the path is " + path + "inhertiable is " + inheritableStr + "  installUser " + installUser);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (installUser == null) {
            installUser = "";
        }
        if (excludePathArr != null) {
            for (String strExclude : excludePathArr) {
                excludePathStr = excludePathStr + strExclude + "?";
            }
            excludePathStr = excludePathStr.substring(0, excludePathStr.length() - 1);
            sizeExcludePath = Integer.toString(excludePathArr.length);
        } else {
            sizeExcludePath = "0";
        }
        Trace.out("sizeExcludePath " + sizeExcludePath + "  excludePath " + excludePathStr);
        String string = checkForAcfs = this.m_secureUtil.getInventory() == null ? "0" : "1";
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.addAclsForUser(username, path, storageTypeStr, permTypeStr, inheritableStr, installUser, excludePathStr, sizeExcludePath, checkForAcfs, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.ADD_ACL_FOR_USER_FAILED, (Throwable)e, username, path);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.ADD_ACL_FOR_USER_FAILED_NODE, (Throwable)e, username, path, localNodeName);
            }
            Trace.out("after adding ACL entries");
            return;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved " + execNodeArr.length);
        Command[] userPrivCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username, path, storageTypeStr, permTypeStr, inheritableStr, installUser, excludePathStr, sizeExcludePath, checkForAcfs};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userPrivCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.addAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.addAclForUser, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        Trace.out("executing the add ACL entries for user commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userPrivCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userPrivCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) continue;
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.ADD_ACL_FOR_USER_FAILED_NODE, resultMap, username, path, Utils.strListToList(failedNodes));
        }
    }

    private void assertWindowsStorageType(WindowsStorageType windowsStorageType) throws WindowsSecurityException {
        if (windowsStorageType == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "storage type");
        }
    }

    private void assertPermissionType(PermissionType permissionType) throws WindowsSecurityException {
        if (permissionType == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "permission type");
        }
    }

    private void assertHomeType(OracleHomeType oracleHomeType) throws WindowsSecurityException {
        if (oracleHomeType == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "oracle home type");
        }
    }

    private void assertExcludePath(String[] excludePathArr) throws WindowsSecurityException {
        if (excludePathArr == null || excludePathArr.length == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "array exclude path");
        }
        for (String strPath : excludePathArr) {
            if (strPath.trim().length() != 0) continue;
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "array exclude path");
        }
    }

    private void assertInstallUser(String installUser) throws WindowsSecurityException {
        if (installUser == null || installUser.trim().length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "install username");
        }
    }
}

