/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityCommandExecution;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.ServicePasswordUpdateException;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.UserNotDomainUserException;
import oracle.cluster.winsecurity.UserNotExistsException;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class UserImpl
implements User,
Constants {
    private Credentials m_credentials;
    private Version m_version;
    private SecureUtil m_secureUtil;
    private String m_srcloc;
    private WinSecurityNative m_secureNative;
    private MessageBundle m_msgBndl;
    private boolean m_isDomainUser = false;
    private boolean m_isDomainUserEvaluated = false;
    private boolean m_isMSAUser = false;
    private boolean m_isMSAUserEvaluated = false;

    UserImpl(Credentials credentials, String srcLoc, Version version) {
        this.m_credentials = credentials;
        this.m_version = version;
        this.m_secureUtil = new SecureUtil();
        this.m_srcloc = srcLoc;
    }

    @Override
    public boolean isUserDomainUser() throws WindowsSecurityException {
        if (this.m_isDomainUserEvaluated) {
            Trace.out("returning cached result " + this.m_isDomainUser);
            return this.m_isDomainUser;
        }
        String username = this.m_credentials.getUsername();
        NativeResult result = new NativeResult();
        Trace.out("checking if user is a domain user" + username);
        WinSecurityNative.isUserDomainUser(username, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_DOMAIN_USER_FAILED, (Throwable)e, username);
        }
        this.m_isDomainUser = result.getBooleanResult();
        this.m_isDomainUserEvaluated = true;
        return this.m_isDomainUser;
    }

    @Override
    public boolean isValidUser() throws WindowsSecurityException {
        String username = this.m_credentials.getUsername();
        Trace.out("checking if user is a valid user" + username);
        String password = this.m_credentials.getPassword();
        NativeResult result = new NativeResult();
        WinSecurityNative.isValidUser(username, password, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_VALID_USER_FAILED, (Throwable)e, username);
        }
        boolean isValidUser = result.getBooleanResult();
        return isValidUser;
    }

    @Override
    public boolean isUserMSA() throws WindowsSecurityException {
        if (this.m_isMSAUserEvaluated) {
            Trace.out("returning from cache " + this.m_isMSAUser);
            return this.m_isMSAUser;
        }
        String username = this.m_credentials.getUsername();
        Trace.out("checking if user is a MSA user" + username);
        NativeResult result = new NativeResult();
        WinSecurityNative.isUserMSA(username, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_MSA_USER_FAILED, (Throwable)e, username);
        }
        this.m_isMSAUser = result.getBooleanResult();
        this.m_isMSAUserEvaluated = true;
        return this.m_isMSAUser;
    }

    @Override
    public boolean isAdministrator() throws WindowsSecurityException {
        try {
            Map<String, Boolean> isAdminMap = this.doInternalIsAdministrator(this.m_credentials, null, null);
            return isAdminMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isAdministrator(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isDomainUserFormat(this.m_credentials.getUsername())) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.NOT_DOMAIN_USER_FORMAT, this.m_credentials.getUsername());
        }
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsAdministrator(this.m_credentials, localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsAdministrator(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = credentials.getUsername();
        Trace.out("checking admin status for user " + username);
        HashMap<String, Boolean> nodeAdminMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isAdmin = false;
            WinSecurityNative.isAdministrator(username, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_ADMIN_FAILED, (Throwable)e, username);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_ADMIN_FAILED_NODE, (Throwable)e, username, localNodeName);
            }
            isAdmin = result.getBooleanResult();
            Trace.out("user admin = " + isAdmin);
            nodeAdminMap.put(localNodeName, isAdmin);
            return nodeAdminMap;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved" + execNodeArr.length);
        Command[] userCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.isAdministrator, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.isAdministrator, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        Trace.out("executing the isadmin commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) {
                boolean nodeStatus = nr.getBooleanResult();
                Trace.out("the user is " + nodeStatus + " on node " + execNodeArr[i]);
                nodeAdminMap.put(execNodeArr[i], nodeStatus);
                continue;
            }
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_ADMIN_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        return nodeAdminMap;
    }

    @Override
    public void createOracleServiceUser() throws WindowsSecurityException {
        String username = this.m_credentials.getUsername();
        String password = this.m_credentials.getPassword();
        if (this.m_secureUtil.isDomainUserFormat(username)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.DOMAIN_USER_CANNOT_BE_CREATED, username);
        }
        Trace.out("creating oracle service user " + username);
        NativeResult result = new NativeResult();
        WinSecurityNative.createOracleServiceUser(username, password, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.CREATE_USER_FAILED, (Throwable)e, username);
        }
    }

    @Override
    public void deleteOracleServiceUser() throws WindowsSecurityException {
        String username = this.m_credentials.getUsername();
        if (this.m_secureUtil.isDomainUserFormat(username)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.DOMAIN_USER_CANNOT_BE_DELETED, username);
        }
        Trace.out("deleting oracle service user " + username);
        NativeResult result = new NativeResult();
        WinSecurityNative.deleteOracleServiceUser(username, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.DELETE_USER_FAILED, (Throwable)e, username);
        }
    }

    @Override
    public void setServiceUserForHome(String oracleHomeKey) throws WindowsSecurityException {
        try {
            this.doInternalSetServiceUserForHome(this.m_credentials, oracleHomeKey, null, null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void setServiceUserForHome(String oracleHomeKey, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isDomainUserFormat(this.m_credentials.getUsername())) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.NOT_DOMAIN_USER_FORMAT, this.m_credentials.getUsername());
        }
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalSetServiceUserForHome(this.m_credentials, oracleHomeKey, localNodeName, nodeNames);
    }

    private void doInternalSetServiceUserForHome(Credentials credentials, String oracleHomeKey, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertOracleHomeKey(oracleHomeKey);
        String username = credentials.getUsername();
        Trace.out("setting user " + username + " as owner of oracle home with key " + oracleHomeKey);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isAdmin = false;
            WinSecurityNative.setServiceUserForHome(username, oracleHomeKey, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.SET_SERVICE_USER_FAILED, (Throwable)e, username, oracleHomeKey);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.SET_SERVICE_USER_FAILED_NODE, (Throwable)e, username, oracleHomeKey, localNodeName);
            }
            Trace.out("after setting user");
            return;
        }
        String[] args = new String[]{username, oracleHomeKey};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the setserviceuser commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.setServiceUser, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SET_SERVICE_USER_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public List<String> getAllServices() throws WindowsSecurityException {
        try {
            Map<String, List<String>> serviceMap = this.doInternalGetAllServices(this.m_credentials, null, null);
            return serviceMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, List<String>> getAllServices(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalGetAllServices(this.m_credentials, localNodeName, nodeNames);
    }

    private Map<String, List<String>> doInternalGetAllServices(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = credentials.getUsername();
        Trace.out("getting list of services for user " + username);
        HashMap<String, List<String>> nodeServicesMap = new HashMap<String, List<String>>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            List<Object> servicesList;
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.getAllServicesUser(username, localNodeName, result);
            if (result.getStatus()) {
                String servicesStr = result.getStringResult();
                Trace.out("services = " + servicesStr);
                if (servicesStr != null && servicesStr.length() > 0) {
                    String[] servicesArr = servicesStr.split("::");
                    servicesList = Arrays.asList(servicesArr);
                } else {
                    servicesList = new ArrayList();
                }
            } else {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_ALL_SERVICE_FOR_USER_FAILED, (Throwable)e, username);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_ALL_SERVICE_FOR_USER_FAILED_NODE, (Throwable)e, username, localNodeName);
            }
            nodeServicesMap.put(localNodeName, servicesList);
            return nodeServicesMap;
        }
        String[] args = new String[]{username};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the get all services for user commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.getAllServicesUser, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.GET_ALL_SERVICE_FOR_USER_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            List<Object> servicesList;
            NativeResult nr = resultMap.get(node);
            String servicesStr = nr.getStringResult();
            Trace.out("services = " + servicesStr);
            if (servicesStr != null) {
                String[] servicesArr = servicesStr.split("::");
                servicesList = Arrays.asList(servicesArr);
            } else {
                servicesList = new ArrayList();
            }
            nodeServicesMap.put((String)node, servicesList);
        }
        return nodeServicesMap;
    }

    @Override
    public void modifyAllServicesPassword() throws WindowsSecurityException, ServicePasswordUpdateException {
        try {
            this.doInternalModifyAllServicesPassword(this.m_credentials, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void modifyAllServicesPassword(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException, ServicePasswordUpdateException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalModifyAllServicesPassword(this.m_credentials, localNodeName, nodeNames);
    }

    private void doInternalModifyAllServicesPassword(Credentials credentials, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException, ServicePasswordUpdateException {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        Trace.out("updating password of services owned by user " + username);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.updateAllUserServicesPasswd(username, password, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                String resultStr = result.getStringResult();
                if (resultStr != null && resultStr.trim().length() > 0) {
                    Trace.out("services that weren't modified were :" + resultStr);
                    List<Object> failedServicesList = resultStr != null && resultStr.length() > 0 ? Arrays.asList(resultStr.split("::")) : new ArrayList();
                    if (localNodeName == null) {
                        throw new ServicePasswordUpdateException(failedServicesList, PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED, e, username);
                    }
                    throw new ServicePasswordUpdateException(failedServicesList, PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED_NODE, e, username, localNodeName);
                }
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED, (Throwable)e, username);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED_NODE, (Throwable)e, username, localNodeName);
            }
            Trace.out("successfully modifyd password for all services owned by user");
            return;
        }
        String[] args = new String[]{username, password};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the modify all services for user commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.updateAllUserServicesPasswd, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
            HashMap<Object, Exception> exceptMap = new HashMap<Object, Exception>();
            for (int i = 0; i < execNodeArr.length; ++i) {
                NativeResult result = resultMap.get(execNodeArr[i]);
                WindowsSecurityException e = null;
                String resultStr = result.getStringResult();
                if (resultStr != null && resultStr.trim().length() > 0) {
                    Trace.out("services that weren't modified were :" + resultStr);
                    List<String> failedServicesList = resultStr != null && resultStr.length() > 0 ? Arrays.asList(resultStr.split("::")) : new ArrayList<String>();
                    e = new ServicePasswordUpdateException(failedServicesList, PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED_NODE, result.getException(), username, execNodeArr[i]);
                } else {
                    e = new WindowsSecurityException((MessageKey)PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED_NODE, (Throwable)result.getException(), username, execNodeArr[i]);
                }
                exceptMap.put(execNodeArr[i], e);
            }
            throw new CompositeOperationException(exceptMap, PrCzMsgID.UPDATE_SERVICE_PASSWD_FOR_USER_FAILED_NODE, username, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public boolean isExists() throws WindowsSecurityException {
        try {
            this.doInternalGetUserType();
            return true;
        }
        catch (UserNotExistsException e) {
            return false;
        }
    }

    @Override
    public boolean isBuiltinAccount() throws WindowsSecurityException, UserNotExistsException {
        try {
            OsUserType osUserType = this.doInternalGetUserType();
            return osUserType == OsUserType.BuiltinAccount;
        }
        catch (UserNotExistsException e) {
            return false;
        }
    }

    @Override
    public boolean isExistsLocalAccount() throws WindowsSecurityException {
        try {
            OsUserType osUserType = this.doInternalGetUserType();
            return osUserType == OsUserType.LocalAccount;
        }
        catch (UserNotExistsException e) {
            return false;
        }
    }

    @Override
    public boolean isExistsDomainAccount() throws WindowsSecurityException {
        try {
            OsUserType osUserType = this.doInternalGetUserType();
            return osUserType == OsUserType.DomainAccount;
        }
        catch (UserNotExistsException e) {
            return false;
        }
    }

    private OsUserType doInternalGetUserType() throws WindowsSecurityException, UserNotExistsException {
        String username = this.m_credentials.getUsername();
        Trace.out("getting os user type for user " + username);
        NativeResult result = new NativeResult();
        WinSecurityNative.getUserType(username, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.CHECK_USER_TYPE_FAILED, (Throwable)e, username);
        }
        String resultStr = result.getStringResult();
        Trace.out("The user type returned is " + resultStr);
        OsUserType osUserType = OsUserType.fromString(resultStr);
        if (osUserType == OsUserType.InvalidUser) {
            throw new UserNotExistsException((MessageKey)PrCzMsgID.USER_NOT_EXISTS, username);
        }
        return osUserType;
    }

    @Override
    public boolean isValidPassword() throws WindowsSecurityException {
        String password = this.m_credentials.getPassword();
        Trace.out("checking if password is valid ");
        NativeResult result = new NativeResult();
        WinSecurityNative.isValidPassword(password, result);
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_VALID_PASSWORD_FAILED, (Throwable)e, new Object[0]);
        }
        boolean isValidPassword = result.getBooleanResult();
        Trace.out("Result of password validation: " + isValidPassword);
        return isValidPassword;
    }

    @Override
    public boolean isExists(String node) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertNode(node, false);
        Map<String, Boolean> isExisMap = this.internalIsExists(this.m_credentials.getUsername(), null, new String[]{node});
        return isExisMap.get(node);
    }

    @Override
    public Map<String, Boolean> isExists(String localNodeName, String[] nodeList) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertNode(localNodeName, true);
        this.m_secureUtil.isRemoteNodeNamesValid(nodeList);
        try {
            return this.internalIsExists(this.m_credentials.getUsername(), localNodeName, nodeList);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public boolean checkLocalAccountExistence(String node) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertNode(node, false);
        Map<String, Boolean> isExisMap = this.internalIsExists(this.filterUserName(this.m_credentials.getUsername()), null, new String[]{node});
        return isExisMap.get(node);
    }

    @Override
    public Map<String, Boolean> checkLocalAccountExistence(String localNodeName, String[] nodeList) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertNode(localNodeName, true);
        this.m_secureUtil.isRemoteNodeNamesValid(nodeList);
        return this.internalIsExists(this.filterUserName(this.m_credentials.getUsername()), localNodeName, nodeList);
    }

    @Override
    public String getDomainname() throws WindowsSecurityException, UserNotDomainUserException {
        String domainName = null;
        String user = this.m_credentials.getUsername();
        Trace.out("Getting the domain name for user account (" + user + ")");
        NativeResult result = new NativeResult();
        if (this.isUserDomainUser() || this.isUserMSA()) {
            WinSecurityNative.getDomainNameForUser(user, result);
            if (result.getStatus()) {
                domainName = result.getStringResult();
                Trace.out("The domain name for user " + user + " is retrieved as " + domainName);
            }
            if (!result.getStatus()) {
                Exception e = result.getException();
                if (e != null) {
                    Trace.out("native operation failed with " + e.getMessage());
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_USER_DOMAIN_NAME_FAILED, (Throwable)e, user);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_USER_DOMAIN_NAME_FAILED, user);
            }
            if (domainName == null) {
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.GET_USER_DOMAIN_NAME_FAILED, user);
            }
            return domainName;
        }
        throw new UserNotDomainUserException((MessageKey)PrCzMsgID.NOT_DOMAIN_USER_FORMAT, user);
    }

    private Map<String, Boolean> internalIsExists(String username, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("checking existence of user (" + username + ") on nodes");
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        HashMap<String, Boolean> nodeUserExistenceMap = new HashMap<String, Boolean>();
        if (isLocalOperation) {
            Trace.out("local node operation");
            if (localNodeName == null && nodeNames.length > 0) {
                localNodeName = nodeNames[0];
            }
            NativeResult result = new NativeResult();
            boolean isExist = false;
            WinSecurityNative.checkUserAccountOnNode(username, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_USER_EXIST_FAILED, (Throwable)e, username);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_USER_EXIST_FAILED_NODE, (Throwable)e, username, localNodeName);
            }
            isExist = result.getBooleanResult();
            Trace.out("user (" + username + ") exist = " + isExist);
            nodeUserExistenceMap.put(localNodeName, isExist);
            return nodeUserExistenceMap;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved" + execNodeArr.length);
        Command[] userCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.isUserExist, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.isUserExist, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        Trace.out("executing the isUserExist commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) {
                boolean nodeStatus = nr.getBooleanResult();
                Trace.out("the user is " + nodeStatus + " on node " + execNodeArr[i]);
                nodeUserExistenceMap.put(execNodeArr[i], nodeStatus);
                continue;
            }
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_USER_EXIST_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        return nodeUserExistenceMap;
    }

    private String filterUserName(String userNameString) {
        String userName = "";
        if (userNameString != null && !userNameString.isEmpty()) {
            userName = userNameString.contains("\\") ? userNameString.substring(userNameString.lastIndexOf("\\") + 1) : userNameString;
        }
        return userName;
    }

    @Override
    public boolean isGroupMSA() throws WindowsSecurityException {
        try {
            Map<String, Boolean> groupMSAMap = this.doInternalIsGroupMSA(null, null);
            return groupMSAMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isGroupMSA(String localNodename, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodename)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        return this.doInternalIsGroupMSA(localNodename, nodeNames);
    }

    private Map<String, Boolean> doInternalIsGroupMSA(String localNodename, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        String username = this.m_credentials.getUsername();
        Trace.out("checking if user " + username + " is an group MSA user");
        HashMap<String, Boolean> nodeGroupMSAMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodename, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isGroupMSA = false;
            WinSecurityNative.isUserGroupMSA(username, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodename == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_GROUPMSA_FAILED, (Throwable)e, username);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_GROUPMSA_FAILED_NODE, (Throwable)e, username, localNodename);
            }
            isGroupMSA = result.getBooleanResult();
            Trace.out("user isgroupmsa = " + isGroupMSA);
            nodeGroupMSAMap.put(localNodename, isGroupMSA);
            return nodeGroupMSAMap;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodename, nodeNames);
        Trace.out("remote nodes are involved. cmds length= " + execNodeArr.length);
        Command[] userCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = new String[]{username};
        for (int i = 0; i < execNodeArr.length; ++i) {
            userCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodename) ? new WinSecurityCommand(WinSecurityCommand.CommandType.isUserGroupMSA, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.isUserGroupMSA, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        Trace.out("executing the isuser group msa commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(userCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = userCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) {
                boolean nodeStatus = nr.getBooleanResult();
                Trace.out("the user is " + nodeStatus + " on node " + execNodeArr[i]);
                nodeGroupMSAMap.put(execNodeArr[i], nodeStatus);
                continue;
            }
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_GROUPMSA_FAILED_NODE, resultMap, username, Utils.strListToList(failedNodes));
        }
        return nodeGroupMSAMap;
    }

    private static enum OsUserType {
        InvalidUser("INVALID_USER"),
        BuiltinAccount("BUILTIN_USER"),
        LocalAccount("LOCAL_USER"),
        DomainAccount("DOMAIN_USER");

        private String m_value;

        private OsUserType(String value) {
            this.m_value = value;
        }

        static OsUserType fromString(String text) {
            if (text != null) {
                for (OsUserType t : OsUserType.values()) {
                    if (!text.equalsIgnoreCase(t.m_value)) continue;
                    return t;
                }
            }
            return InvalidUser;
        }
    }
}

