/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityCommandExecution;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.Group;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class GroupImpl
implements Group,
Constants {
    private String m_groupName;
    private Version m_version;
    private SecureUtil m_secureUtil;
    private String m_srcloc;
    private WinSecurityNative m_secureNative;
    private String m_groupDesc = null;
    private String m_member = null;

    GroupImpl(String groupName, String srcLoc, Version version) throws WindowsSecurityException {
        this.m_version = version;
        this.m_secureUtil = new SecureUtil();
        this.m_srcloc = srcLoc;
        this.m_secureUtil.assertGroup(groupName);
        this.m_groupName = groupName;
    }

    @Override
    public void create() throws WindowsSecurityException {
        try {
            this.doInternalCreate(null, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void create(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalCreate(null, localNodeName, nodeNames);
    }

    @Override
    public void create(String groupDesc) throws WindowsSecurityException {
        this.m_secureUtil.assertGroupDesc(this.m_groupName, groupDesc);
        try {
            this.doInternalCreate(groupDesc, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void create(String groupDesc, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertGroupDesc(this.m_groupName, groupDesc);
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalCreate(groupDesc, localNodeName, nodeNames);
    }

    private void doInternalCreate(String groupDesc, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_groupDesc = groupDesc;
        Trace.out("Creating group " + this.m_groupName);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.createOSGroup(this.m_groupName, groupDesc, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.CREATE_GROUP_FAILED, (Throwable)e, this.m_groupName);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.CREATE_GROUP_FAILED_NODE, (Throwable)e, this.m_groupName, localNodeName);
            }
            return;
        }
        String[] args = new String[]{this.m_groupName, groupDesc};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the create group commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.createOSGroup, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.CREATE_GROUP_FAILED_NODE, resultMap, this.m_groupName, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public void delete() throws WindowsSecurityException {
        try {
            this.doInternalDelete(null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void delete(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalDelete(localNodeName, nodeNames);
    }

    private void doInternalDelete(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("Deleting group " + this.m_groupName);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.deleteOSGroup(this.m_groupName, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.DELETE_GROUP_FAILED, (Throwable)e, this.m_groupName);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.DELETE_GROUP_FAILED_NODE, (Throwable)e, this.m_groupName, localNodeName);
            }
            return;
        }
        String[] args = new String[]{this.m_groupName};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the delete group commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.deleteOSGroup, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.DELETE_GROUP_FAILED_NODE, resultMap, this.m_groupName, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public boolean isExists() throws WindowsSecurityException {
        try {
            Map<String, Boolean> isGroupMap = this.doInternalIsExists(null, null);
            return isGroupMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isExists(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsExists(localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsExists(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        Trace.out("checking if group exists " + this.m_groupName);
        HashMap<String, Boolean> nodeGroupMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isGrpExists = false;
            WinSecurityNative.checkOSGroupExists(this.m_groupName, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_GROUP_EXISTS_FAILED, (Throwable)e, this.m_groupName);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_GROUP_EXISTS_FAILED_NODE, (Throwable)e, this.m_groupName, localNodeName);
            }
            isGrpExists = result.getBooleanResult();
            Trace.out("group exists = " + isGrpExists);
            nodeGroupMap.put(localNodeName, isGrpExists);
            return nodeGroupMap;
        }
        String[] args = new String[]{this.m_groupName};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the is group exists commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.isOSGroupExists, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_GROUP_EXISTS_FAILED_NODE, resultMap, this.m_groupName, Utils.strListToList(failedNodes));
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            boolean nodeStatus = nr.getBooleanResult();
            Trace.out("the group status is " + nodeStatus + " on node " + node);
            nodeGroupMap.put((String)node, nodeStatus);
        }
        return nodeGroupMap;
    }

    @Override
    public void addMember(String member) throws WindowsSecurityException {
        try {
            this.doInternalAddGroupMember(member, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void addMember(String member, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalAddGroupMember(member, localNodeName, nodeNames);
    }

    public void doInternalAddGroupMember(String member, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertMember(member);
        this.m_member = member;
        Trace.out("Adding " + member + " to group " + this.m_groupName);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.addMemberToOSGroup(this.m_groupName, member, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.ADD_MEMBER_TO_GROUP_FAILED, (Throwable)e, this.m_groupName, member);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.ADD_MEMBER_TO_GROUP_FAILED_NODE, (Throwable)e, this.m_groupName, member, localNodeName);
            }
            return;
        }
        String[] args = new String[]{this.m_groupName, member};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the add member to group commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.addMemberToOSGroup, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.ADD_MEMBER_TO_GROUP_FAILED_NODE, resultMap, this.m_groupName, member, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public void removeMember(String member) throws WindowsSecurityException {
        try {
            this.doInternalRemoveGroupMember(member, null, null);
            return;
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public void removeMember(String member, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        this.doInternalRemoveGroupMember(member, localNodeName, nodeNames);
    }

    private void doInternalRemoveGroupMember(String member, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        this.m_secureUtil.assertMember(member);
        this.m_member = member;
        Trace.out("removing " + member + " from group " + this.m_groupName);
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            WinSecurityNative.removeMemberFromOSGroup(this.m_groupName, member, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.REMOVE_MEMBER_FROM_GROUP_FAILED, (Throwable)e, this.m_groupName, member);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.REMOVE_MEMBER_FROM_GROUP_FAILED_NODE, (Throwable)e, this.m_groupName, member, localNodeName);
            }
            return;
        }
        String[] args = new String[]{this.m_groupName, member};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the remove member from group commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.removeMemberFromOSGroup, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.REMOVE_MEMBER_FROM_GROUP_FAILED_NODE, resultMap, this.m_groupName, member, Utils.strListToList(failedNodes));
        }
    }

    @Override
    public boolean isMemberOf(String member, boolean recurse) throws WindowsSecurityException {
        try {
            Map<String, Boolean> isMemberMap = this.doInternalIsMemberOf(member, recurse, null, null);
            return isMemberMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isMemberOf(String member, boolean recurse, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsMemberOf(member, recurse, localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsMemberOf(String member, boolean recurse, String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        boolean directflg = false;
        this.m_secureUtil.assertMember(member);
        this.m_member = member;
        Trace.out("checking if " + member + " is a member of group " + this.m_groupName);
        HashMap<String, Boolean> nodeMemberMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        boolean bl = directflg = !recurse;
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isMemberOfGrp = false;
            WinSecurityNative.checkMemberOfOSGroup(this.m_groupName, member, directflg, localNodeName, result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_MEMBER_OF_GROUP_FAILED, (Throwable)e, this.m_groupName, member);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_MEMBER_OF_GROUP_FAILED_NODE, (Throwable)e, this.m_groupName, member, localNodeName);
            }
            isMemberOfGrp = result.getBooleanResult();
            Trace.out("membership status = " + isMemberOfGrp);
            nodeMemberMap.put(localNodeName, isMemberOfGrp);
            return nodeMemberMap;
        }
        String[] args = new String[]{this.m_groupName, member, Boolean.toString(directflg)};
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        Trace.out("executing the is member of group commands");
        try {
            WinSecurityCommandExecution.executeCommands(localNodeName, nodeNames, WinSecurityCommand.CommandType.isMemberOfOSGroup, args, this.m_srcloc, failedNodes, resultMap);
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        for (Object node : resultMap.keySet()) {
            NativeResult nr = resultMap.get(node);
            boolean nodeStatus = nr.getBooleanResult();
            Trace.out("the group membership status is " + nodeStatus + " on node " + node);
            nodeMemberMap.put((String)node, nodeStatus);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_MEMBER_OF_GROUP_FAILED_NODE, resultMap, this.m_groupName, member, Utils.strListToList(failedNodes));
        }
        return nodeMemberMap;
    }
}

