/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.vm;

import java.io.File;
import java.util.HashMap;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.vm.OVMM;
import oracle.cluster.vm.OVMMArgs;
import oracle.cluster.vm.OVMMException;
import oracle.cluster.vm.VMFactory;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class OVMMImpl
extends SoftwareModuleImpl
implements OVMM {
    private static final String OVMM_CRED_PATH = "/ovm";
    private static final String OVMM_CRED_DOMAIN = "manager";
    private static final String OVMM_REST_PATH = "ovm/core/wsapi/rest/";
    private static final String OVMM_OVMMHOST_KEY = "OVMMHOST";
    private static final String OVMM_OVMMPORT_KEY = "OVMMPORT";
    private static final String OVMM_REST_KEY = "OVMMREST";
    String m_username = null;
    String m_ovmmhost = null;
    String m_ovmmport = null;
    String m_ovmmrest = null;

    public void create(OVMMArgs ovmmArgs) throws AlreadyExistsException, OVMMException {
        VMFactory.validateOVMMArgs4Create(ovmmArgs);
        boolean alreadyExists = false;
        try {
            this.loadAttributes();
            alreadyExists = true;
        }
        catch (NotExistsException notExistsException) {
            // empty catch block
        }
        if (alreadyExists) {
            throw new AlreadyExistsException((MessageKey)PrCzMsgID.OVMM_CREATE_FAILED_ALREADY_EXISTS, new Object[0]);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(OVMM_OVMMHOST_KEY, ovmmArgs.getOVMMHost());
        attributes.put(OVMM_OVMMPORT_KEY, ovmmArgs.getOVMMPort());
        attributes.put(OVMM_REST_KEY, OVMM_REST_PATH);
        Trace.out("in create");
        try {
            Util utl = new Util();
            String crsUser = utl.getCRSUser();
            File cred = new File(ovmmArgs.getWalletPath());
            if (!cred.isFile()) {
                throw new OVMMException((MessageKey)PrCzMsgID.OVMM_CREATE_FAILED_CRED, (Throwable)new CredentialsException((MessageKey)PrCzMsgID.OVMM_CREATE_FAILED_INVALID_WALLET, ovmmArgs.getWalletPath()), new Object[0]);
            }
            CredentialsFactory.getInstance().storeUserpassAndWalletCredentials(ovmmArgs.getUsername(), ovmmArgs.getPassword(), ovmmArgs.getWalletPath(), ovmmArgs.getWalletPassword(), attributes, OVMM_CRED_PATH, OVMM_CRED_DOMAIN, crsUser);
        }
        catch (CredentialsException e) {
            try {
                CredentialsFactory.getInstance().deleteCredentials(OVMM_CRED_PATH, OVMM_CRED_DOMAIN);
            }
            catch (NotExistsException ne) {
                Trace.out(ne.getMessage());
            }
            catch (CredentialsException ce) {
                Trace.out(ce.getMessage());
            }
            Trace.out(e.getMessage());
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_CREATE_FAILED_CRED, (Throwable)e, new Object[0]);
        }
        catch (UtilException e) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_CREATE_FAILED_GIUSER, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void modify(OVMMArgs ovmmArgs) throws NotExistsException, OVMMException {
        VMFactory.validateOVMMArgs4Modify(ovmmArgs);
        HashMap<String, String> attributes = new HashMap<String, String>();
        String ovmmport = ovmmArgs.getOVMMPort();
        String ovmmhost = ovmmArgs.getOVMMHost();
        if (null != ovmmhost) {
            attributes.put(OVMM_OVMMHOST_KEY, ovmmhost);
        }
        if (null != ovmmport) {
            attributes.put(OVMM_OVMMPORT_KEY, ovmmport);
        }
        try {
            Util utl = new Util();
            String crsUser = utl.getCRSUser();
            CredentialsFactory.getInstance().storeUserpassAndWalletCredentials(ovmmArgs.getUsername(), ovmmArgs.getPassword(), ovmmArgs.getWalletPath(), ovmmArgs.getWalletPassword(), attributes, OVMM_CRED_PATH, OVMM_CRED_DOMAIN, crsUser);
        }
        catch (CredentialsException e) {
            CredentialsException.CredError cr = e.getCredError();
            if (cr == CredentialsException.CredError.CRED_ERROR_USERPASS) {
                throw new OVMMException((MessageKey)PrCzMsgID.OVMM_MODIFY_FAILED_CRED_1, (Throwable)e, new Object[0]);
            }
            if (cr == CredentialsException.CredError.CRED_ERROR_ATTRIBUTES) {
                throw new OVMMException((MessageKey)PrCzMsgID.OVMM_MODIFY_FAILED_CRED_2, (Throwable)e, new Object[0]);
            }
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_MODIFY_FAILED_CRED, (Throwable)e, new Object[0]);
        }
        catch (UtilException e) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_MODIFY_FAILED_GIUSER, (Throwable)e, new Object[0]);
        }
    }

    protected void loadAttributes() throws NotExistsException, OVMMException {
        HashMap<String, String> attributes;
        String[] attrNames = new String[]{OVMM_OVMMHOST_KEY, OVMM_OVMMPORT_KEY, OVMM_REST_KEY};
        try {
            attributes = CredentialsFactory.getInstance().getAttributes(OVMM_CRED_PATH, OVMM_CRED_DOMAIN, attrNames);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCzMsgID.OVMM_RETRIEVE_FAILED_NOT_EXISTS, (Throwable)e, new Object[0]);
        }
        catch (CredentialsException e) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_RETRIEVE_FAILED_CRED, (Throwable)e, new Object[0]);
        }
        this.m_ovmmhost = attributes.get(OVMM_OVMMHOST_KEY);
        this.m_ovmmport = attributes.get(OVMM_OVMMPORT_KEY);
        this.m_ovmmrest = attributes.get(OVMM_REST_KEY);
    }

    protected void loadUsername() throws NotExistsException, OVMMException {
        try {
            this.m_username = CredentialsFactory.getInstance().getUsername(OVMM_CRED_PATH, OVMM_CRED_DOMAIN);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCzMsgID.OVMM_RETRIEVE_USERNAME_FAILED_NOT_EXISTS, (Throwable)e, new Object[0]);
        }
        catch (CredentialsException e) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_RETRIEVE_USERNAME_FAILED_CRED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void remove() throws NotExistsException, OVMMException {
        String[] vmNames = null;
        try {
            VMFactory.getInstance();
            vmNames = VMFactory.getVMResNames();
        }
        catch (SoftwareModuleException e) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_REMOVE_FAILED_VM, (Throwable)e, new Object[0]);
        }
        if (null != vmNames && vmNames.length > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(vmNames[0]);
            for (int i = 1; i < vmNames.length; ++i) {
                builder.append(", " + vmNames[i]);
            }
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_REMOVE_FAILED_VM_EXISTS, builder.toString());
        }
        try {
            CredentialsFactory.getInstance().deleteCredentials(OVMM_CRED_PATH, OVMM_CRED_DOMAIN);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCzMsgID.OVMM_REMOVE_FAILED_NOT_EXISTS, (Throwable)e, new Object[0]);
        }
        catch (CredentialsException e) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_REMOVE_FAILED_CRED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public String getUsername() throws NotExistsException, OVMMException {
        if (null == this.m_username) {
            this.loadUsername();
        }
        return this.m_username;
    }

    @Override
    public String getOVMMHost() throws NotExistsException, OVMMException {
        if (null == this.m_ovmmhost) {
            this.loadAttributes();
        }
        return this.m_ovmmhost;
    }

    @Override
    public String getOVMMPort() throws NotExistsException, OVMMException {
        if (null == this.m_ovmmport) {
            this.loadAttributes();
        }
        return this.m_ovmmport;
    }

    @Override
    public String getOVMMREST() throws NotExistsException, OVMMException {
        if (null == this.m_ovmmrest) {
            this.loadAttributes();
        }
        return this.m_ovmmrest;
    }
}

