/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.crs.CRSException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.common.sConstants;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class Utils {
    private static final String ACFSUTIL_NAME = "acfsutil";

    private Utils() {
    }

    public static String getEnumString(Enum[] eArray, String separator) {
        StringBuilder sb = new StringBuilder();
        if (eArray.length > 0) {
            for (int i = 0; i < eArray.length; ++i) {
                if (i > 0) {
                    sb.append(separator + eArray[i].toString());
                    continue;
                }
                sb.append(eArray[i].toString());
            }
        }
        return sb.toString();
    }

    public static String strArrToString(String[] strArr, String delim) {
        if (strArr == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (strArr.length > 0) {
            result.append(strArr[0]);
            for (int i = 1; i < strArr.length; ++i) {
                if (null != delim) {
                    result.append(delim);
                }
                result.append(strArr[i]);
            }
        }
        return result.toString();
    }

    public static String strListToList(List<String> strList) {
        StringBuilder sb = new StringBuilder();
        boolean needSeparator = false;
        for (String str : strList) {
            if (needSeparator) {
                sb.append(", ");
            } else {
                needSeparator = true;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String strListToList2(List<String> strList) {
        StringBuilder sb = new StringBuilder();
        boolean needSeparator = false;
        for (String str : strList) {
            if (needSeparator) {
                sb.append(",");
            } else {
                needSeparator = true;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String strArrToList(String[] strArr) {
        StringBuilder sb = new StringBuilder();
        boolean needSeparator = false;
        for (String str : strArr) {
            if (needSeparator) {
                sb.append(",");
            } else {
                needSeparator = true;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String[] convertListToStringArray(List<String> strList) {
        String[] strArr = new String[strList.size()];
        strList.toArray(strArr);
        return strArr;
    }

    public static List<String> convertStringToList(String str) {
        return new ArrayList<String>(Arrays.asList(str.split("\\s*,\\s*")));
    }

    public static String[] convertStringToArray(String str) {
        String[] arr = str.split("\\s*,\\s*");
        return arr;
    }

    public static <T extends ManageableEntity> String list2String(List<T> list, String separator) {
        if (list == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ManageableEntity elem : list) {
            Trace.out("element name = " + elem.getName());
            if (sb.length() == 0) {
                sb.append(elem.getName());
                continue;
            }
            sb.append(separator + elem.getName());
        }
        return sb.toString();
    }

    public static String nodeList2String(List<Node> list, String separator) throws NodeException {
        if (list == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Node elem : list) {
            Trace.out("element name = " + elem.getName());
            if (sb.length() == 0) {
                sb.append(elem.getName());
                continue;
            }
            sb.append(separator + elem.getName());
        }
        return sb.toString();
    }

    public static String getKnownHostsPath() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + sConstants.SSH_KNOWN_HOSTS;
    }

    public static String getRSADSAPath() {
        ClusterCmd clsCmd = new ClusterCmd();
        try {
            String filePath = System.getProperty("user.home") + System.getProperty("file.separator") + sConstants.RSA_FILE;
            if (clsCmd.fileExists(filePath)) {
                return filePath;
            }
            filePath = System.getProperty("user.home") + System.getProperty("file.separator") + sConstants.DSA_FILE;
            if (clsCmd.fileExists(filePath)) {
                return filePath;
            }
        }
        catch (ClusterException ce) {
            Trace.out("Exception in determining existence of a file on localnode" + ce.getMessage());
        }
        return null;
    }

    public static String getRootUserName() {
        return "root";
    }

    public static String getCurrentUser() {
        return System.getProperty("user.name");
    }

    public static boolean isPriviledgedPort(int port) {
        if (port >= 0 && port < 1023) {
            Trace.out("Port " + port + " is in privileged port range.");
            return true;
        }
        return false;
    }

    public static String getACFSUTILPath() throws InstallException {
        String binLoc = "";
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            binLoc = nativeSystem.getOFSUtilLocation();
        } else {
            String oraHomeLoc = null;
            ClusterwareInfo clstInfo = new ClusterwareInfo();
            String acfsutil = Utils.getACFSUTILExeName();
            if (oraHomeLoc == null) {
                oraHomeLoc = clstInfo.getCRSHome(new Version());
            }
            if (new File(oraHomeLoc + File.separator + "BIN" + File.separator + acfsutil).exists()) {
                binLoc = oraHomeLoc + File.separator + "BIN";
            }
        }
        return binLoc;
    }

    public static String getACFSUTILExeName() {
        return new SystemFactory().CreateSystem().getExeName(ACFSUTIL_NAME);
    }

    public static void assertInputNotNull(Object input, String argName) throws InvalidArgsException {
        if (input == null) {
            Trace.out("Exception thrown because " + argName + " was null.");
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, argName);
        }
    }

    public static void assertInput(String input, String argName) throws InvalidArgsException {
        if (input == null || input.trim().isEmpty()) {
            Trace.out("Exception thrown because " + argName + " was null or empty.");
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, argName);
        }
    }

    public static void assertInput(String[] input, String argName) throws InvalidArgsException {
        if (input == null || input.length == 0) {
            Trace.out("Exception thrown because " + argName + " was null or empty.");
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, argName);
        }
        for (String value : input) {
            Utils.assertInput(value, argName);
        }
    }

    public static String[] getStackTrace(Throwable t) {
        StackTraceElement[] stElem = t.getStackTrace();
        String[] stArr = new String[stElem.length + 1];
        stArr[0] = t.getMessage();
        int i = 1;
        for (StackTraceElement ste : stElem) {
            Trace.out("JAVA STACK: " + ste.toString());
            stArr[i++] = ste.toString();
        }
        return stArr;
    }

    public static String[] nodeList2StringArr(List<Node> nodeList) throws NodeException {
        if (nodeList == null || nodeList.isEmpty()) {
            return new String[0];
        }
        String[] nodeArr = new String[nodeList.size()];
        for (int i = 0; i < nodeArr.length; ++i) {
            nodeArr[i] = nodeList.get(i).getHostName();
        }
        return nodeArr;
    }

    public static Filter generateServerCategoryExpression(String[] nodeNames) throws CRSException {
        Object expression = null;
        CRSFactoryImpl crsFact = CRSFactoryImpl.getInstance();
        if (nodeNames == null || nodeNames.length == 0) {
            Trace.out("Empty node list, return null Filter");
            return expression;
        }
        Filter aux = null;
        for (int i = 0; i < nodeNames.length; ++i) {
            aux = crsFact.getFilter(Filter.Comparator.EQ, ResourceLiterals.NAME.toString(), nodeNames[i]);
            expression = i == 0 ? aux : crsFact.getFilter(Filter.Operator.OR, (Filter)expression, aux);
        }
        Trace.out("Expression: " + expression.toString());
        return expression;
    }

    public static String[] getNodeNamesFromCategoryExpression(String expression) {
        if (expression == null || expression.isEmpty()) {
            return new String[0];
        }
        String regexOrSplit = "(OR)|(\\|\\|)";
        String regexEqSplit = "[=]+";
        String[] serverSegment = expression.replaceAll("[\\(\\)]", "").split(regexOrSplit);
        String[] nodeNames = new String[serverSegment.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            String[] serverPart = serverSegment[i].split(regexEqSplit);
            nodeNames[i] = serverPart[1].trim();
        }
        return nodeNames;
    }

    public static String canonicalizePath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public static <K extends Enum> String enumMap2String(Map<K, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder mapStr = new StringBuilder();
        for (Enum key : map.keySet()) {
            mapStr.append(key.toString());
            mapStr.append('(');
            mapStr.append(map.get(key));
            mapStr.append(')');
        }
        return mapStr.toString();
    }

    public static Version getHomeVer(String home, boolean compatible) throws InstallException {
        Version ver;
        block6: {
            ver = null;
            ClusterwareInfo clwInfo = new ClusterwareInfo();
            try {
                Version version = ver = compatible ? clwInfo.getSRVCTLVersion(home) : clwInfo.getSRVCTLVersionNLS(home);
                if (!Version.isPre11i(ver)) break block6;
                try {
                    ver = clwInfo.getSQLPLUSVersion(home);
                    Trace.out((Object)"Retrieved version from path %s using SQLPlus", home);
                }
                catch (InstallException e) {
                    Trace.out((Object)"Failed to retrieve ver from %s using SQLPlus", home);
                    Trace.out((Object)"Error: %s", e.getMessage());
                    throw e;
                }
            }
            catch (InstallException e) {
                Trace.out((Object)"Failed to retrieve version from path %s using srvctl", home);
                Trace.out((Object)"Error: %s", e.getMessage());
                try {
                    ver = clwInfo.getSQLPLUSVersion(home);
                    Trace.out((Object)"Retrieved version from path %s using SQLPlus", home);
                }
                catch (InstallException ie) {
                    Trace.out((Object)"Failed to retrieve ver from path %s using SQLPlus", home);
                    Trace.out((Object)"Error: %s", ie.getMessage());
                    throw ie;
                }
            }
        }
        return ver;
    }

    public static String getFileNameFromPath(String path) {
        Path filePath = Paths.get(path, new String[0]);
        return filePath.getFileName().toString();
    }

    public static String convertToCSSNodeName(String nodeName) {
        int indx = (nodeName = nodeName.toLowerCase()).indexOf(46);
        if (indx > -1) {
            nodeName = nodeName.substring(0, indx);
        }
        return nodeName;
    }
}

