/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot.events;

import java.util.HashMap;
import java.util.Map;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.snapshot.events.Event;
import oracle.ops.mgmt.trace.Trace;

public class ResourceEvent
extends Event {
    private String m_profileOperation = null;
    public static final String DB_TYPE = ResourceLiterals.DATABASE_TYPE.toString();
    public static final String SVC_TYPE = ResourceLiterals.SERVICE_TYPE.toString();

    public ResourceEvent(Map<String, String> evtProp, Map<String, String> evtData) {
        super(new HashMap<String, String>(evtData), evtProp.get("NAME"));
        String resType;
        String val = (String)this.m_data.get("SERVICE_NAME");
        if (val != null) {
            this.m_data.put("SERVICE_NAME", this.getShortName(val));
        }
        if ((val = (String)this.m_data.get("GEN_SERVICE_NAME")) != null) {
            this.m_data.put("GEN_SERVICE_NAME", this.getShortName(val));
        }
        if ((val = (String)this.m_data.get("DB_UNIQUE_NAME")) != null) {
            this.m_data.put("DB_UNIQUE_NAME", this.getShortName(val));
        }
        if ((resType = evtProp.get("TYPE")).equals(DB_TYPE)) {
            this.m_evtType = Event.EvtType.DATABASE;
        } else if (resType.equals(SVC_TYPE)) {
            this.m_evtType = Event.EvtType.SERVICE;
        } else {
            this.m_evtType = Event.EvtType.UNSUPPORTED;
            Trace.out((Object)"Unsupported resource type: %s", resType);
            return;
        }
        this.m_profileOperation = evtData.get("PROFILE_OPERATION");
        if (this.m_profileOperation != null && this.m_profileOperation.equalsIgnoreCase("DELETE")) {
            this.m_operation = Event.Operation.DELETE;
        }
    }

    public String getProfileOperation() {
        return this.m_profileOperation;
    }
}

