/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot.events;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Event {
    static final String RESOURCE_STATE_CHANGE = "CRS_RESOURCE_STATE_CHANGE";
    static final String RESOURCE_PROFILE_CHANGE = "CRS_RESOURCE_PROFILE_CHANGE";
    static final String SERVER_STATE_CHANGE = "CRS_SERVER_STATE_CHANGE";
    static final String SERVER_POOL_PROFILE_CHANGE = "CRS_SERVER_POOL_PROFILE_CHANGE";
    static final String SERVER_POOL_STATE_CHANGE = "CRS_SERVER_POOL_STATE_CHANGE";
    static final String TEST_QUIT = "EONS_TEST_QUIT";
    static final String NAME = "NAME";
    static final String TYPE = "TYPE";
    static final String SEQUENCE_NUMBER = "SEQUENCE_NUMBER";
    static final String TRANSACTION_PART = "TRANSACTION_PART";
    static final String TRANSACTION_SIZE = "TRANSACTION_SIZE";
    static final String PROFILE_OPERATION_ATTR = "PROFILE_OPERATION";
    static final String PROFILE_OP_ADD = "ADD";
    static final String PROFILE_OP_DEL = "DELETE";
    static List<String> s_ignoreList = new LinkedList<String>();
    static final String[] s_ignoreNames = new String[]{"AFFECTED_SERVER", "AFFECTED_SERVER_STATE", "CLS_TINT", "ID", "PREVIOUS_STATE", "PREV_STATE_DETAILS", "REASON", "SEQUENCE_NUMBER", "SERVER_INCARNATION_NUMBER", "TIMESTAMP", "TRANSACTION_ID", "TRANSACTION_PART", "TRANSACTION_SIZE", "USER"};
    static final String SERVICE_NAME = "SERVICE_NAME";
    static final String GEN_SERVICE_NAME = "GEN_SERVICE_NAME";
    static final String DB_UNIQUE_NAME = "DB_UNIQUE_NAME";
    static Map<String, String> s_nameMap = new HashMap<String, String>();
    Map<String, String> m_data;
    String m_seqNum;
    EvtType m_evtType;
    String m_entityName;
    Operation m_operation = Operation.UPDATE;

    protected Event(Map<String, String> evtData, String entityName) {
        this.m_data = evtData;
        this.m_entityName = entityName;
        this.m_seqNum = evtData.get(SEQUENCE_NUMBER);
    }

    public Event(EvtType type, Map<String, String> evtData) {
        this(evtData, evtData.get(NAME));
        this.m_evtType = type;
    }

    protected void replaceData(Map<String, String> newData) {
        this.m_data = newData;
    }

    public EvtType getType() {
        return this.m_evtType;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public String getSeqNum() {
        return this.m_seqNum;
    }

    public Map<String, String> getDataMap() {
        return this.m_data;
    }

    public Map<String, String> attributesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.m_operation == Operation.DELETE) {
            return result;
        }
        for (Map.Entry<String, String> entry : this.m_data.entrySet()) {
            String name = entry.getKey();
            if (s_ignoreList.contains(name)) continue;
            if (s_nameMap.get(name) == null) {
                result.put(name, entry.getValue());
                continue;
            }
            result.put(s_nameMap.get(name), entry.getValue());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Event: type: ");
        sb.append((Object)this.m_evtType).append("; entity name: ").append(this.m_entityName);
        sb.append("; seqn: ").append(this.m_seqNum).append("; ");
        for (Map.Entry<String, String> en : this.m_data.entrySet()) {
            sb.append("<").append(en.getKey()).append(",").append(en.getValue()).append(">");
        }
        return sb.toString();
    }

    String getShortName(String val) {
        if (val == null) {
            return null;
        }
        int indx = val.indexOf(46);
        if (indx > 0) {
            return val.substring(0, indx);
        }
        return val;
    }

    static {
        for (String ignore : s_ignoreNames) {
            s_ignoreList.add(ignore);
        }
        s_nameMap.put("CURRENT_STATE", "STATE");
        s_nameMap.put("ASSIGNED_SERVERS", "ACTIVE_SERVERS");
    }

    static enum Operation {
        UPDATE,
        DELETE;

    }

    public static enum EvtType {
        DATABASE,
        SERVICE,
        SERVER,
        SERVERPOOL,
        RESOURCE_INSTANCE,
        TESTEXIT,
        UNSUPPORTED;

    }
}

