/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import oracle.cluster.crs.CRSActiveVersionException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.impl.crs.cops.Stat3;
import oracle.cluster.impl.snapshot.Cache;
import oracle.cluster.impl.snapshot.CacheController;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.snapshot.Snapshot;
import oracle.cluster.snapshot.SnapshotActiveVersionException;
import oracle.cluster.snapshot.SnapshotException;
import oracle.cluster.snapshot.SnapshotFactory;
import oracle.cluster.snapshot.SnapshotFatalException;
import oracle.ops.mgmt.nls.MessageKey;

public class SnapshotFactoryImpl {
    private static SnapshotFactoryImpl s_snapshotFactoryImpl = null;
    private CacheController m_cacheController = CacheController.getInstance();
    private static final String[] dbAttributes = new String[]{ResourceType.Database.NAME.name(), ResourceType.Database.BASE_TYPE.name(), ResourceType.Database.TYPE_VERSION.name(), ResourceType.Database.ORACLE_HOME.name(), ResourceType.Database.SERVER_POOLS.name(), ResourceType.Database.CLUSTER_DATABASE.name(), ResourceType.Database.ROLE.name(), ResourceType.Database.MANAGEMENT_POLICY.name(), ResourceType.Database.DATABASE_TYPE.name(), ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.Database.USR_ORA_DB_NAME.name(), ResourceType.Database.USR_ORA_DOMAIN.name(), ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name()};
    private static final String[] serviceAttributes = new String[]{ResourceType.Service.NAME.name(), ResourceType.Service.BASE_TYPE.name(), ResourceType.Service.TYPE_VERSION.name(), ResourceType.Service.TAF_POLICY.name(), ResourceType.Service.SERVICE_NAME.name(), ResourceType.Service.SERVER_POOLS.name(), ResourceType.Service.MANAGEMENT_POLICY.name(), ResourceType.Service.ROLE.name(), ResourceType.Service.DTP.name(), ResourceType.Service.AQ_HA_NOTIFICATION.name(), ResourceType.Service.FAILOVER_TYPE.name(), ResourceType.Service.FAILOVER_METHOD.name(), ResourceType.Service.FAILOVER_RETRIES.name(), ResourceType.Service.TAF_FAILOVER_DELAY.name(), ResourceType.Service.CLB_GOAL.name(), ResourceType.Service.RLB_GOAL.name(), ResourceType.Service.GEN_SERVICE_NAME.name()};
    private static final String[] serverPoolAttributes = new String[]{ResourceType.ServerPool.NAME.name(), ResourceType.ServerPool.MIN_SIZE.name(), ResourceType.ServerPool.MAX_SIZE.name(), ResourceType.ServerPool.IMPORTANCE.name(), ResourceType.ServerPool.PARENT_POOLS.name(), ResourceType.ServerPool.SERVER_NAMES.name(), ResourceType.ServerPool.EXCLUSIVE_POOLS.name(), ResourceType.ServerPool.ACTIVE_SERVERS.name()};
    private static final String[] serverAttributes = new String[]{ResourceType.Server.NAME.name(), ResourceType.Server.STATE.name(), ResourceType.Server.ACTIVE_POOLS.name(), ResourceType.Server.STATE_DETAILS.name()};

    public static SnapshotFactoryImpl getInstance() throws SnapshotException {
        if (s_snapshotFactoryImpl == null) {
            s_snapshotFactoryImpl = new SnapshotFactoryImpl();
        }
        return s_snapshotFactoryImpl;
    }

    public boolean isReady() {
        return this.m_cacheController.isReady();
    }

    public Snapshot getSnapshot() throws SnapshotException {
        return this.m_cacheController.getSnapshot();
    }

    public Snapshot getSimpleSnapshot() throws SnapshotException {
        SnapshotImpl result = null;
        Cache cache = Cache.getInstance();
        SnapshotFactoryImpl.initCache(cache);
        cache.setReadyFlag(true);
        result = (SnapshotImpl)cache.createSnapshot();
        return result;
    }

    public void stop() {
        if (this.m_cacheController.isRunning()) {
            this.m_cacheController.interrupt();
        }
    }

    public void start() throws SnapshotException {
        if (!this.m_cacheController.isRunning()) {
            this.m_cacheController.setDaemon(true);
            this.m_cacheController.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return this.m_cacheController.isRunning();
    }

    public long lastSeqN() {
        return this.m_cacheController.lastSeqN();
    }

    public void addSnapshotListener(SnapshotFactory.SnapshotListener listener) throws SnapshotException {
        this.m_cacheController.addSnapshotListener(listener);
    }

    public void removeSnapshotListener(SnapshotFactory.SnapshotListener listener) throws SnapshotException {
        this.m_cacheController.removeSnapshotListener(listener);
    }

    static Set<String> getAttNames(Cache.EntityType type) {
        HashSet<String> result = new HashSet<String>();
        switch (type) {
            case Resource: 
            case RInstance: {
                for (String s : dbAttributes) {
                    result.add(s);
                }
                for (String s : serviceAttributes) {
                    result.add(s);
                }
                break;
            }
            case Server: {
                for (String s : serverAttributes) {
                    result.add(s);
                }
                break;
            }
            case ServerPool: {
                for (String s : serverPoolAttributes) {
                    result.add(s);
                }
                break;
            }
        }
        return result;
    }

    static void initCache(Cache cache) throws SnapshotException {
        Stat3 stat = new Stat3();
        try {
            stat.addRequest(CRSEntity.Type.Resource, SnapshotFactoryImpl.getFilter(Cache.EntityType.Resource), new String[0]);
            stat.addRequest(CRSEntity.Type.ResourceInstance, SnapshotFactoryImpl.getFilter(Cache.EntityType.Resource), ResourceLiterals.NAME.toString(), ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.CRS_LAST_SERVER.toString(), ResourceLiterals.STATE_ATTR_NAME.toString(), ResourceLiterals.TARGET_ATTR_NAME.toString(), ResourceLiterals.CARDINALITY.toString(), ResourceLiterals.ID.toString(), ResourceLiterals.LAST_RESTART.toString(), ResourceLiterals.LAST_STATE_CHANGE.toString(), ResourceLiterals.STATE_DETAILS.toString(), ResourceLiterals.INTERNAL_STATE.toString(), ResourceLiterals.INSTANCE_COUNT.toString());
            stat.addRequest(CRSEntity.Type.ServerPool, SnapshotFactoryImpl.getFilter(Cache.EntityType.ServerPool), new String[0]);
            stat.addRequest(CRSEntity.Type.Server, SnapshotFactoryImpl.getFilter(Cache.EntityType.Server), new String[0]);
            CRSNative.performStat3(stat);
        }
        catch (CRSActiveVersionException e) {
            throw new SnapshotActiveVersionException((MessageKey)PrCrMsgID.WRONG_ACTIVE_VERSION, new Object[0]);
        }
        catch (CRSException e) {
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)e, new Object[0]);
        }
        cache.clear();
        cache.update(stat);
    }

    static Filter getFilter(Cache.EntityType type) throws CRSException {
        ExpressionFilter result = null;
        switch (type) {
            case Resource: 
            case RInstance: {
                SimpleFilter dbTypeFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
                SimpleFilter serverTypeFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
                result = new ExpressionFilter(Filter.Operator.OR, dbTypeFilter, serverTypeFilter);
            }
        }
        return result;
    }

    static Map<String, String> sortAttributes(Map<String, String> map) {
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(list, new ComparatorImplementation());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    static Map<String, Map<String, String>> sortEntities(Map<String, Map<String, String>> map) {
        if (map == null) {
            return new LinkedHashMap<String, Map<String, String>>();
        }
        LinkedList<Map.Entry<String, Map<String, String>>> list = new LinkedList<Map.Entry<String, Map<String, String>>>(map.entrySet());
        Collections.sort(list, new ComparatorImplementation());
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> en : map.entrySet()) {
            result.put(en.getKey(), SnapshotFactoryImpl.sortAttributes(en.getValue()));
        }
        return result;
    }

    private static final class ComparatorImplementation
    implements Comparator {
        private ComparatorImplementation() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)((Map.Entry)o1).getKey()).compareTo(((Map.Entry)o2).getKey());
        }
    }
}

