/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.cops.Stat3;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.snapshot.Snapshot;
import oracle.cluster.snapshot.SnapshotException;
import oracle.cluster.snapshot.SnapshotFatalException;
import oracle.cluster.snapshot.SnapshotNotReadyException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class Cache {
    private boolean m_readyFlag = false;
    private long m_seqNumber = -1L;
    private Map<String, Map<String, String>> m_resources = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> m_ris = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> m_pools = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> m_servers = new LinkedHashMap<String, Map<String, String>>();

    static synchronized Cache getInstance() {
        return new Cache();
    }

    boolean isReady() {
        return this.m_readyFlag;
    }

    synchronized boolean setReadyFlag(boolean newValue) {
        boolean oldValue = this.m_readyFlag;
        this.m_readyFlag = newValue;
        return oldValue;
    }

    synchronized void clear() {
        this.m_resources.clear();
        this.m_ris.clear();
        this.m_pools.clear();
        this.m_servers.clear();
        this.setReadyFlag(false);
        this.m_seqNumber = -1L;
    }

    synchronized void update(Stat3 stat3) throws SnapshotFatalException {
        long seqNumber = stat3.seqNumber();
        if (seqNumber < this.m_seqNumber) {
            Long gotSeq = seqNumber;
            Long haveSeq = this.m_seqNumber;
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_WRONG_SEQNUMBER, gotSeq, haveSeq);
        }
        this.update(seqNumber, EntityType.Resource, stat3.result().get(EntityType.Resource.value()));
        this.update(seqNumber, EntityType.RInstance, stat3.result().get(EntityType.RInstance.value()));
        this.update(seqNumber, EntityType.ServerPool, stat3.result().get(EntityType.ServerPool.value()));
        this.update(seqNumber, EntityType.Server, stat3.result().get(EntityType.Server.value()));
    }

    synchronized void update(long seqNumber, EntityType type, Map<String, Map<String, String>> data) throws SnapshotFatalException {
        if (this.m_seqNumber > seqNumber) {
            Long gotSeq = seqNumber;
            Long haveSeq = this.m_seqNumber;
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_WRONG_SEQNUMBER, gotSeq, haveSeq);
        }
        if (data == null || data.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> map = null;
        switch (type) {
            case Resource: {
                map = this.m_resources;
                break;
            }
            case RInstance: {
                map = this.m_ris;
                break;
            }
            case Server: {
                map = this.m_servers;
                break;
            }
            case ServerPool: {
                map = this.m_pools;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported type: " + type.toString());
            }
        }
        for (String entName : data.keySet()) {
            Map<String, String> newDescr = data.get(entName);
            if (newDescr == null || newDescr.isEmpty()) {
                Trace.out("about to remove " + entName);
                map.remove(entName);
                continue;
            }
            Map<String, String> currentDescr = map.get(entName);
            if (currentDescr == null) {
                currentDescr = new LinkedHashMap<String, String>();
                map.put(entName, currentDescr);
            }
            for (String newAttrName : newDescr.keySet()) {
                String newAttrValue = newDescr.get(newAttrName);
                if (newAttrValue == null) {
                    currentDescr.remove(newAttrName);
                    continue;
                }
                currentDescr.put(newAttrName, newAttrValue);
            }
        }
        this.m_seqNumber = seqNumber;
    }

    synchronized Snapshot createSnapshot() throws SnapshotException {
        if (!this.m_readyFlag) {
            throw new SnapshotNotReadyException((MessageKey)PrCrMsgID.SNAPSHOT_NOT_READY_CACHE, new Object[0]);
        }
        SnapshotImpl snapshot = new SnapshotImpl(this.m_seqNumber, this.m_resources, this.m_ris, this.m_pools, this.m_servers);
        return snapshot;
    }

    long getSeqN() {
        return this.m_seqNumber;
    }

    private Cache() {
    }

    public static enum EntityType {
        Resource(CRSEntity.Type.Resource.getValue(), "Resource"),
        RInstance(CRSEntity.Type.ResourceInstance.getValue(), "Resource Type"),
        ServerPool(CRSEntity.Type.ServerPool.getValue(), "Server Pool"),
        Server(CRSEntity.Type.Server.getValue(), "Server");

        private String m_name;
        private Integer m_value;

        public String toString() {
            return this.m_name;
        }

        public Integer value() {
            return this.m_value;
        }

        private EntityType(int value, String string2) {
            this.m_value = new Integer(value);
            this.m_name = string2;
        }

        public static EntityType getInstance(int i) throws SnapshotFatalException {
            if (i == CRSEntity.Type.Resource.getValue()) {
                return Resource;
            }
            if (i == CRSEntity.Type.ResourceInstance.getValue()) {
                return RInstance;
            }
            if (i == CRSEntity.Type.ServerPool.getValue()) {
                return ServerPool;
            }
            if (i == CRSEntity.Type.Server.getValue()) {
                return Server;
            }
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAP_INTERNAL_ERROR, "invalid type " + i);
        }
    }
}

