/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.server.SiteImpl;
import oracle.cluster.impl.server.SiteNativeException;
import oracle.cluster.server.Site;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;

public class SiteNativeResult
extends NativeResult {
    private boolean in_isExtendedCluster = false;
    private String in_nodeName = "";
    private String in_siteGUID = "";
    private List<Site> in_sites = new ArrayList<Site>();
    private static final String CLSU_GET_EXTENDED_CONF = "clsu_get_extended_conf";
    private static final String CLSU_GET_CLUSTER_SITES = "clsu_get_cluster_sites";
    private static final String CLSU_GET_NODE_SITE = "clsu_get_node_site";

    private SiteNativeException createException(String api, int rc, String genericMessage) {
        SiteNativeException newExc = new SiteNativeException(api, rc, genericMessage);
        Trace.out("New exception created:" + newExc);
        return newExc;
    }

    public boolean IsExtendedCluster() {
        return this.in_isExtendedCluster;
    }

    private void setIsExtendedCluster(int extended) {
        this.in_isExtendedCluster = extended == 3;
    }

    public String getSiteGUID(String nodename) {
        Trace.out("nodename is " + nodename);
        Trace.out("in_nodename is " + this.in_nodeName);
        if (nodename.equalsIgnoreCase(this.in_nodeName)) {
            return this.in_siteGUID;
        }
        return null;
    }

    private void addSiteGUID(String nodeName, String siteGUID) {
        this.in_nodeName = nodeName;
        this.in_siteGUID = siteGUID;
    }

    public void clearSiteGUID(String nodeName) {
        this.in_nodeName = nodeName;
        this.in_siteGUID = "";
    }

    public List<Site> getSites() {
        return this.in_sites;
    }

    private void addSite(String siteName, String siteGUID) {
        boolean found = false;
        for (Site site : this.in_sites) {
            if (!site.getSiteName().equalsIgnoreCase(siteName) || !site.getSiteGUID().equalsIgnoreCase(siteGUID)) continue;
            found = true;
            break;
        }
        if (!found) {
            SiteImpl site = new SiteImpl(siteName, siteGUID);
            this.in_sites.add(site);
        }
    }
}

