/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.CSSMode;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSServerEntity;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.server.NodeImpl;
import oracle.cluster.impl.server.ServerGroupImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.Site;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class ServerImpl
extends ManageableEntityImpl
implements Server {
    private Node m_node;
    private boolean m_cachedProfile;
    private Map<String, String> m_profile;
    private CRSServerEntity m_crsServer;
    private static String[] m_rimNodes = null;

    ServerImpl(Node node) throws ServerException {
        this(node, false);
    }

    ServerImpl(Node node, boolean cacheProfile) throws ServerException {
        this.m_node = node;
        try {
            this.m_displayName = this.m_name = this.m_node.getName();
            this.m_crsServer = CRSFactoryImpl.getInstance().getServer(this.m_name);
            if (cacheProfile) {
                List<String> attrList = ResourceType.getAttributeNames(ResourceType.Server.class);
                String[] attrNames = new String[attrList.size()];
                attrList.toArray(attrNames);
                this.m_profile = this.getAttributes(attrNames);
            }
            this.m_cachedProfile = cacheProfile;
        }
        catch (NodeException e) {
            throw new ServerException(e);
        }
        catch (CRSException e) {
            throw new ServerException(e);
        }
    }

    ServerImpl(String serverName, SnapshotImpl snapshot) throws ServerException {
        try {
            this.m_node = new NodeImpl(serverName, false);
        }
        catch (NodeException e) {
            throw new ServerException(e);
        }
        this.m_name = serverName;
        this.m_displayName = serverName;
        try {
            this.m_crsServer = CRSFactoryImpl.getInstance().getSnapshotServer(this.m_name, snapshot);
        }
        catch (CRSException e) {
            throw new ServerException(e);
        }
    }

    ServerImpl(String serverName, EntityOperations.EntityOpsMode mode) throws ServerException {
        try {
            this.m_node = new NodeImpl(serverName, false);
        }
        catch (NodeException e) {
            throw new ServerException(e);
        }
        this.m_name = serverName;
        this.m_displayName = serverName;
        try {
            this.m_crsServer = CRSFactoryImpl.getInstance().getServer(this.m_name, mode);
        }
        catch (CRSException e) {
            throw new ServerException(e);
        }
    }

    void create() throws ServerException {
        String server = null;
        try {
            server = this.m_node.getName();
        }
        catch (NodeException e) {
            throw new ServerException((MessageKey)PrCsMsgID.SVR_CREATE_FAILED, server, e);
        }
    }

    @Override
    public List<Server.ServerState> states() throws ServerException {
        String[] states = null;
        if (this.m_cachedProfile) {
            states = this.m_profile.get(ResourceType.Server.STATE.name()).split(" ");
        } else {
            try {
                states = this.m_crsServer.getAttribute(ResourceType.Server.STATE.name()).getValue().split(" ");
            }
            catch (CRSException e) {
                throw new ServerException(e);
            }
        }
        ArrayList<Server.ServerState> stateList = new ArrayList<Server.ServerState>(states.length);
        for (String state : states) {
            stateList.add(Server.ServerState.getMember(state));
        }
        return stateList;
    }

    @Override
    public Node node() throws ServerException {
        return this.m_node;
    }

    @Override
    public boolean isEnabled() throws ServerException {
        throw new ServerException((MessageKey)PrCsMsgID.GET_ENABLED_FAILED, "NOT IMPLEMENTED");
    }

    @Override
    public void enable() throws ServerException {
        throw new ServerException((MessageKey)PrCsMsgID.ENABLE_FAILED, "NOT IMPLEMENTED");
    }

    @Override
    public void disable() throws ServerException {
        throw new ServerException((MessageKey)PrCsMsgID.DISABLE_FAILED, "NOT IMPLEMENTED");
    }

    @Override
    public List<ServerGroup> serverGroups() throws NotExistsException, ServerException {
        String[] spNames;
        String attrName = ResourceType.Server.ACTIVE_POOLS.name();
        if (this.m_cachedProfile) {
            spNames = this.m_profile.get(attrName).split(" ");
        } else {
            Map<String, String> result = this.getAttributes(attrName);
            spNames = result.get(attrName).split(" ");
        }
        if (spNames.length == 0) {
            throw new NotExistsException((MessageKey)PrCsMsgID.UNASSIGNED_SERVER, this.m_name);
        }
        ArrayList<ServerGroup> spList = new ArrayList<ServerGroup>(spNames.length);
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            for (String name : spNames) {
                spList.add(new ServerGroupImpl(crsFactory.create(ResourceType.ServerPool.NAME.name(), name)));
            }
            return spList;
        }
        catch (CRSException e) {
            throw new ServerException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ServerImpl other = (ServerImpl)obj;
        return this.m_node.equals(other.m_node);
    }

    public int hashCode() {
        return this.m_node.hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    protected Map<String, String> getProfile() throws ServerException {
        if (this.m_cachedProfile) {
            return this.m_profile;
        }
        List<String> profile = ResourceType.getAttributeNames(ResourceType.Server.class);
        String[] attrNames = new String[profile.size()];
        profile.toArray(attrNames);
        return this.getAttributes(attrNames);
    }

    @Override
    public void setWorkload(int value) throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getWorkload() throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getMemorySize() throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getCPUCount() throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getCPUClockRate() throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public boolean isCPUHyperThreading() throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Server.ServerRole role() throws ServerException {
        try {
            if (new ClusterUtil().getCSSMode() == CSSMode.cssBCCLUSTERED) {
                if (m_rimNodes == null) {
                    m_rimNodes = new ClusterUtil().getRIMNodes();
                }
                for (String nodeName : m_rimNodes) {
                    if (!nodeName.equalsIgnoreCase(this.m_name)) continue;
                    return Server.ServerRole.RIM;
                }
            }
        }
        catch (ClusterUtilException e) {
            throw new ServerException(e);
        }
        return Server.ServerRole.HUB;
    }

    @Override
    public List<ServerCategory> serverCategories() throws ServerException {
        throw new RuntimeException("not implemented yet");
    }

    private Map<String, String> getAttributes(String ... attrList) throws ServerException {
        List<ResourceAttribute> attributes;
        try {
            attributes = this.m_crsServer.getAttributes(attrList);
        }
        catch (CRSAttributeNotFoundException ne) {
            throw new ServerException((MessageKey)PrCsMsgID.SERVER_NOT_EXISTS, this.m_name);
        }
        catch (CRSException e) {
            throw new ServerException(e);
        }
        LinkedHashMap<String, String> nvMap = new LinkedHashMap<String, String>(attributes.size());
        for (ResourceAttribute ra : attributes) {
            nvMap.put(ra.getName(), ra.getValue());
        }
        return nvMap;
    }

    @Override
    public Site site() throws ServerException {
        return null;
    }
}

