/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.NodeRole;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.server.NodeImpl;
import oracle.cluster.impl.server.ServerCategoryImpl;
import oracle.cluster.impl.server.ServerGroupImpl;
import oracle.cluster.impl.server.ServerImpl;
import oracle.cluster.impl.server.ServerPoolImpl;
import oracle.cluster.impl.server.SiteNative;
import oracle.cluster.impl.server.SiteNativeException;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerCategoryException;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.server.ServerPoolArgs;
import oracle.cluster.server.Site;
import oracle.cluster.server.SiteException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class ServerFactoryImpl {
    private static ServerFactoryImpl s_instance;
    private static String HUB;
    private static String LEAF;
    private static boolean debugEnabled;

    private ServerFactoryImpl() throws ServerException {
    }

    public static synchronized ServerFactoryImpl getInstance() throws ServerException {
        if (s_instance == null) {
            s_instance = new ServerFactoryImpl();
        }
        return s_instance;
    }

    public Node getNode(String nodename) throws NodeException {
        return this.getNode(nodename, true);
    }

    public Node getNode(String nodename, boolean chkMbrship) throws NodeException {
        return new NodeImpl(nodename, chkMbrship);
    }

    public Server createServer(Node node) throws ServerException {
        ServerImpl server = new ServerImpl(node);
        server.create();
        return server;
    }

    public Server createSnapshotServer(String srvName, SnapshotImpl snapshot) throws ServerException {
        return new ServerImpl(srvName, snapshot);
    }

    public Server getServer(Node node) throws ServerException {
        if (node == null) {
            throw new ServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        return new ServerImpl(node);
    }

    public Map<String, String> getProfile(Server server) throws ServerException {
        if (server == null) {
            throw new ServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "server", server);
        }
        return ((ServerImpl)server).getProfile();
    }

    public void evaluateServerPoolCreation(String serverPoolName, int minSize, int maxSize, int importance, Server ... serverList) throws ServerGroupException {
        ServerPoolImpl.evaluateServerPoolCreation(serverPoolName, minSize, maxSize, importance, serverList);
    }

    public void evaluateServerGroupCreation(String groupName, Server ... serverList) throws ServerGroupException {
        ServerGroupImpl.evaluateServerGroupCreation(groupName, serverList);
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        try {
            ServerPoolImpl spImpl = new ServerPoolImpl(CRSFactoryImpl.getInstance().create(ResourceType.ServerPool.NAME.name(), this.getServerGroupEntityName(serverPoolName)));
            spImpl.create(forceFlag, minSize, maxSize, importance, (String)null, serverList);
            return spImpl;
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, String category) throws AlreadyExistsException, ServerGroupException {
        try {
            ServerPoolImpl spImpl = new ServerPoolImpl(CRSFactoryImpl.getInstance().create(ResourceType.ServerPool.NAME.name(), this.getServerGroupEntityName(serverPoolName)));
            spImpl.create(forceFlag, minSize, maxSize, importance, category, new Server[0]);
            return spImpl;
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    public ServerPool getServerPool(String serverPoolName) throws NotExistsException, ServerGroupException {
        if (serverPoolName == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverPoolName", serverPoolName);
        }
        return this.getServerGroupEntity(serverPoolName, null);
    }

    public ServerGroup createServerGroup(boolean forceFlag, String serverGroupName, int minSize, int maxSize, int importance, String exclusiveGroups, List<ServerGroup> parentList, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        try {
            ServerGroupImpl sgImpl = new ServerGroupImpl(CRSFactoryImpl.getInstance().create(ResourceType.ServerPool.NAME.name(), this.getServerGroupEntityName(serverGroupName)));
            sgImpl.create(forceFlag, minSize, maxSize, importance, exclusiveGroups, parentList, serverList);
            return sgImpl;
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    public ServerGroup getServerGroup(String serverGroupName) throws NotExistsException, ServerGroupException {
        return this.getServerGroup(serverGroupName, null);
    }

    public ServerGroup getServerGroup(String serverGroupName, CRSEntity sibling) throws NotExistsException, ServerGroupException {
        if (serverGroupName == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverGroupName", serverGroupName);
        }
        return this.getServerGroupEntity(serverGroupName, sibling);
    }

    public void modifyServerPool(boolean forceFlag, String serverPoolName, ServerPoolArgs args) throws ServerGroupException, NotExistsException {
        ServerPoolImpl sp = (ServerPoolImpl)this.getServerPool(serverPoolName);
        sp.modify(forceFlag, args);
    }

    private ServerGroupImpl getServerGroupEntity(String serverGroupName, CRSEntity sibling) throws NotExistsException, ServerGroupException {
        String sgResName = this.getServerGroupEntityName(serverGroupName);
        try {
            return (ServerGroupImpl)this.getServerGroup(CRSFactoryImpl.getInstance().create(ResourceType.ServerPool.NAME.name(), sgResName), sibling);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_FAILED, sgResName, e);
        }
    }

    public List<ServerGroup> getServerGroups() throws NotExistsException, ServerGroupException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.ServerPool, null);
            if (resList.size() == 0) {
                throw new NotExistsException((MessageKey)PrCsMsgID.SP_NOT_EXISTS, resList.toString());
            }
            ArrayList<ServerGroup> sgList = new ArrayList<ServerGroup>(resList.size());
            for (ResourceAttribute attr : resList) {
                String sgName = attr.getValue();
                if (!sgName.equals(this.getServerGroupEntityName(sgName))) {
                    if (!debugEnabled) continue;
                    Trace.out("The server group " + sgName + " is neither a predefined (Free/Generic) servergroup, nor a servergroup starting with ora.");
                    continue;
                }
                try {
                    sgList.add(this.getServerGroup(attr));
                }
                catch (NotExistsException notExistsException) {}
            }
            if (sgList.size() > 0) {
                return Collections.unmodifiableList(sgList);
            }
            throw new NotExistsException((MessageKey)PrCsMsgID.SP_NOT_EXISTS, resList.toString());
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerPool.typeAsString());
        }
    }

    public ServerGroup getServerGroup(ResourceAttribute nameAttr) throws NotExistsException, ServerGroupException {
        return this.getServerGroup(nameAttr, null);
    }

    public ServerGroup getServerGroup(ResourceAttribute nameAttr, CRSEntity sibling) throws NotExistsException, ServerGroupException {
        ServerGroupImpl sgImpl = new ServerGroupImpl(nameAttr, sibling);
        sgImpl.crsEntity();
        return sgImpl;
    }

    public List<ServerPool> getServerPools(String scType) throws NotExistsException, ServerGroupException {
        if (scType == null || scType != null && !scType.equalsIgnoreCase(HUB) && !scType.equalsIgnoreCase(LEAF)) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scType");
        }
        ServerPool sp = null;
        ServerCategory sg = null;
        NodeRole expectedRole = scType.equalsIgnoreCase(HUB) ? NodeRole.HUB : NodeRole.RIM;
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter = this.getFilter4ServerPools();
            List<ResourceAttribute> nameAttrList = crsFactory.searchResources(CRSEntity.Type.ServerPool, filter);
            if (nameAttrList.size() == 0) {
                throw new NotExistsException((MessageKey)PrCsMsgID.NO_SP_FOUND, filter.toString());
            }
            ArrayList<ServerPool> spList = new ArrayList<ServerPool>(nameAttrList.size());
            for (ResourceAttribute attr : nameAttrList) {
                sp = this.getServerPool(attr.getValue());
                sg = sp.serverCategory();
                if (sg == null || !sg.getName().equalsIgnoreCase(scType) && sg.activeCSSRole() != expectedRole) continue;
                spList.add(this.getServerPool(attr.getValue()));
            }
            return Collections.unmodifiableList(spList);
        }
        catch (CRSException e) {
            Trace.out("Got CRSException.. " + e.getMessage());
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerPool.typeAsString());
        }
        catch (ServerCategoryException sce) {
            Trace.out("Got ServerCategoryException " + sce.getMessage());
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)sce, CRSEntity.Type.ServerPool.typeAsString());
        }
    }

    public List<ServerPool> getServerPools() throws NotExistsException, ServerGroupException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter = this.getFilter4ServerPools();
            List<ResourceAttribute> nameAttrList = crsFactory.searchResources(CRSEntity.Type.ServerPool, filter);
            if (nameAttrList.size() == 0) {
                throw new NotExistsException((MessageKey)PrCsMsgID.NO_SP_FOUND, filter.toString());
            }
            ArrayList<ServerPool> spList = new ArrayList<ServerPool>(nameAttrList.size());
            for (ResourceAttribute attr : nameAttrList) {
                spList.add(this.getServerPool(attr.getValue()));
            }
            return Collections.unmodifiableList(spList);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerPool.typeAsString());
        }
    }

    public Map<ServerPool, ServerPoolArgs> getServerPoolsInfo() throws ServerGroupException {
        LinkedHashMap<ServerPool, ServerPoolArgs> result = new LinkedHashMap<ServerPool, ServerPoolArgs>();
        String importanceAttrName = ResourceType.ServerPool.IMPORTANCE.name();
        String maxSizeAttrName = ResourceType.ServerPool.MAX_SIZE.name();
        String minSizeAttrName = ResourceType.ServerPool.MIN_SIZE.name();
        String serversAttrName = ResourceType.ServerPool.SERVER_NAMES.name();
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter = this.getFilter4ServerPools();
            Map<String, Map<String, String>> crsPoolMap = crsFactory.searchEntities(CRSEntity.Type.ServerPool, false, filter, importanceAttrName, maxSizeAttrName, minSizeAttrName, serversAttrName);
            for (String spName : crsPoolMap.keySet()) {
                Map<String, String> spDescr = crsPoolMap.get(spName);
                ServerPoolArgs args = new ServerPoolArgs();
                args.setImportance(Integer.parseInt(spDescr.get(importanceAttrName)));
                args.setMaxSize(Integer.parseInt(spDescr.get(maxSizeAttrName)));
                args.setMinSize(Integer.parseInt(spDescr.get(minSizeAttrName)));
                ArrayList<ServerImpl> serverList = new ArrayList<ServerImpl>();
                for (String serverName : spDescr.get(serversAttrName).split(String.valueOf(" "))) {
                    serverList.add(new ServerImpl(this.getNode(serverName, false), false));
                }
                try {
                    ServerPool sPool = this.getServerPool(spName);
                    result.put(sPool, args);
                    if (!debugEnabled) continue;
                    Trace.out("sp %s, imp %s, max %s, min %s, servers %s", spName, spDescr.get(importanceAttrName), spDescr.get(maxSizeAttrName), spDescr.get(minSizeAttrName), spDescr.get(serversAttrName));
                }
                catch (NotExistsException notExistsException) {}
            }
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerPool.typeAsString());
        }
        catch (NodeException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerPool.typeAsString());
        }
        catch (ServerException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerPool.typeAsString());
        }
        return result;
    }

    public String getServerGroupEntityName(String grpName) {
        if (grpName.equals(ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString()) || grpName.equals(ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString())) {
            return grpName;
        }
        if (!grpName.startsWith("ora.")) {
            return "ora." + grpName;
        }
        return grpName;
    }

    public ServerPool createLocalServerPool(String serverPoolName) throws ServerGroupException {
        try {
            ServerFactory sf = ServerFactory.getInstance();
            int importance = sf.getDefaultImportance();
            int min = sf.getDefaultMinSize();
            int max = -1;
            ServerPoolArgs args = new ServerPoolArgs();
            args.setMinSize(min);
            args.setMaxSize(max);
            args.setImportance(importance);
            return this.createLocalServerPool(serverPoolName, args);
        }
        catch (ServerException se) {
            Trace.out("Got ServerException " + se.getMessage());
            throw new ServerGroupException(se);
        }
    }

    public ServerPool createLocalServerPool(String serverPoolName, ServerPoolArgs SPargs) throws ServerGroupException {
        String spResName = ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString().equals(serverPoolName) || ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString().equals(serverPoolName) || serverPoolName.startsWith("ora.") ? serverPoolName : "ora." + serverPoolName;
        ServerPoolImpl sp = new ServerPoolImpl(spResName, EntityOperations.EntityOpsMode.Local);
        sp.modifyLocal(false, SPargs);
        return sp;
    }

    public Server createLocalServer(String name) throws ServerException {
        return new ServerImpl(name, EntityOperations.EntityOpsMode.Local);
    }

    public ServerPool createSnapshotServerPool(String spName, SnapshotImpl snapshot) throws ServerGroupException {
        return new ServerPoolImpl(spName, snapshot);
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, ServerPoolArgs args) throws ServerGroupException, NotExistsException {
        throw new RuntimeException("not implemented yet");
    }

    public List<Server> servers() throws ServerException {
        LinkedList<Server> result = new LinkedList<Server>();
        List<ResourceAttribute> nameAttrList = null;
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            nameAttrList = crsFactory.searchResources(CRSEntity.Type.Server, null);
            for (ResourceAttribute attr : nameAttrList) {
                result.add(this.getServer(this.getNode(attr.getValue(), false)));
            }
        }
        catch (CRSException e) {
            throw new ServerException(e);
        }
        catch (NodeException e) {
            throw new ServerException(e);
        }
        return result;
    }

    public boolean isExtendedCluster() throws SiteException {
        try {
            if (!Cluster.isCluster()) {
                return false;
            }
            return new SiteNative().queryIsExtendedCluster();
        }
        catch (SiteNativeException e) {
            throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_EXTENDED_CONF, (Throwable)e, new Object[0]);
        }
    }

    public List<Site> getConfiguredSites() throws SiteException {
        try {
            if (!Cluster.isCluster()) {
                return new ArrayList<Site>(0);
            }
            List<Site> sites = new SiteNative().querySites();
            return sites;
        }
        catch (SiteNativeException e) {
            throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_CLUSTER_SITES, (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_CLUSTER_SITES, (Throwable)e, new Object[0]);
        }
    }

    public List<Site> getSitesForNodes(String[] nodeNames) throws SiteException {
        ArrayList<Node> nodeList = new ArrayList<Node>(nodeNames.length);
        try {
            for (String nodeName : nodeNames) {
                Node node = this.getNode(nodeName);
                nodeList.add(node);
            }
        }
        catch (NodeException e) {
            throw new SiteException(e);
        }
        return this.getSitesForNodes(nodeList);
    }

    public List<Site> getSitesForNodes(List<Node> nodes) throws SiteException {
        try {
            if (!Cluster.isCluster()) {
                return new ArrayList<Site>(0);
            }
            List<Site> sites = new SiteNative().querySites(nodes);
            return sites;
        }
        catch (SiteNativeException e) {
            throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_NODE_SITE, (Throwable)e, new Object[0]);
        }
    }

    public Site getSiteForNode(String nodename) throws SiteException {
        Node node = null;
        try {
            node = this.getNode(nodename);
        }
        catch (NodeException ne) {
            throw new SiteException(ne);
        }
        return this.getSiteForNode(node);
    }

    public Site getSiteForNode(Node node) throws SiteException {
        try {
            if (!Cluster.isCluster()) {
                return null;
            }
            ArrayList<Node> nodes = new ArrayList<Node>(1);
            nodes.add(node);
            List<Site> sites = new SiteNative().querySites(nodes);
            Trace.out("Calling getSiteForNode, site number is " + sites.size());
            if (sites.size() < 1) {
                throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_NODE_SITE, node.getName());
            }
            return sites.get(0);
        }
        catch (SiteNativeException e) {
            throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_NODE_SITE, (Throwable)e, new Object[0]);
        }
        catch (NodeException e) {
            throw new SiteException((MessageKey)PrCsMsgID.FAILED_GET_NODE_SITE, (Throwable)e, new Object[0]);
        }
    }

    private Filter getFilter4ServerPools() throws CRSException {
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        Filter noParentsFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ServerPool.PARENT_POOLS.name(), "");
        Filter oraFilter = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceType.ServerPool.NAME.name(), "ora.");
        Filter genericFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ServerPool.NAME.name(), ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString());
        Filter freeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ServerPool.NAME.name(), ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString());
        Filter filter = crsFactory.getFilter(Filter.Operator.OR, genericFilter, freeFilter);
        filter = crsFactory.getFilter(Filter.Operator.OR, oraFilter, filter);
        filter = crsFactory.getFilter(Filter.Operator.AND, noParentsFilter, filter);
        return filter;
    }

    private String getServerCategoryEntityName(String categName) {
        String categoryName = categName;
        if (categName.equalsIgnoreCase(ResourceLiterals.HUB_SUFFIX.toString())) {
            return ResourceLiterals.HUB_CATEGORY.toString();
        }
        if (categName.equalsIgnoreCase(ResourceLiterals.RIM_SUFFIX.toString())) {
            return ResourceLiterals.RIM_CATEGORY.toString();
        }
        return categoryName;
    }

    public ServerCategory getServerCategory(String categoryName) throws NotExistsException, ServerCategoryException {
        String category = this.getServerCategoryEntityName(categoryName);
        ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.ServerCategory.NAME.name(), category);
        ServerCategoryImpl scImpl = new ServerCategoryImpl(nameAttr);
        scImpl.crsEntity();
        return scImpl;
    }

    public List<ServerCategory> getServerCategories() throws ServerCategoryException, NotExistsException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.ServerCategory, null);
            if (resList.size() == 0) {
                return new ArrayList<ServerCategory>(0);
            }
            ArrayList<ServerCategory> scList = new ArrayList<ServerCategory>(resList.size());
            for (ResourceAttribute attr : resList) {
                String scName = attr.getValue();
                if (!scName.equals(this.getServerCategoryEntityName(scName))) {
                    if (!debugEnabled) continue;
                    Trace.out("The server category " + scName + " should benamed as " + this.getServerCategoryEntityName(scName));
                    continue;
                }
                try {
                    scList.add(this.getServerCategory(attr.getValue()));
                }
                catch (NotExistsException notExistsException) {}
            }
            if (scList.size() > 0) {
                return Collections.unmodifiableList(scList);
            }
            throw new NotExistsException((MessageKey)PrCsMsgID.SP_NOT_EXISTS, resList.toString());
        }
        catch (CRSException e) {
            throw new ServerCategoryException((MessageKey)PrCsMsgID.SC_LOOKUP_VIA_FILTER_FAILED, (Throwable)e, CRSEntity.Type.ServerCategory.typeAsString());
        }
    }

    public ServerCategory createServerCategory(String serverCategoryName, String activeCSSRole, Filter expression) throws AlreadyExistsException, ServerCategoryException {
        try {
            ServerCategoryImpl scImpl = new ServerCategoryImpl(CRSFactoryImpl.getInstance().create(ResourceType.ServerCategory.NAME.name(), this.getServerCategoryEntityName(serverCategoryName)));
            scImpl.create(activeCSSRole, expression);
            return scImpl;
        }
        catch (CRSException e) {
            throw new ServerCategoryException(e);
        }
    }

    public ServerCategory getServerCategory(ServerGroup serverGroup) throws ServerGroupException {
        try {
            if (!serverGroup.isServerPool()) {
                return null;
            }
            ServerPool serverPool = ServerFactory.getInstance().getServerPool(serverGroup.getName());
            return serverPool.serverCategory();
        }
        catch (ServerCategoryException e) {
            throw new ServerGroupException(e);
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
    }

    public List<ServerGroup> getServerGrpList(String sglistStr, String delim) throws ServerException {
        try {
            ArrayList<ServerGroup> sglist = null;
            if (sglistStr != null && sglistStr.trim().length() != 0) {
                String[] sgValues = sglistStr.trim().split(delim);
                sglist = new ArrayList(sgValues.length);
                for (String sgName : sgValues) {
                    sglist.add(this.getServerGroup(sgName));
                }
            } else {
                sglist = new ArrayList<ServerGroup>(0);
            }
            return sglist;
        }
        catch (ServerException e) {
            throw new ServerException(e);
        }
        catch (NotExistsException e) {
            throw new ServerException(e);
        }
    }

    public String getServerGrpString(List<ServerGroup> sgList, String separator, boolean userAssigned) {
        if (sgList == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ServerGroup sg : sgList) {
            String name = userAssigned ? sg.getUserAssignedName() : sg.getName();
            Trace.out("==========server group name is " + name);
            if (sb.length() > 0) {
                sb.append(separator + name);
                continue;
            }
            sb.append(name);
        }
        return sb.toString();
    }

    static {
        HUB = ServerCategory.ServerCategoryType.HUB_CATEGORY.toString();
        LEAF = ServerCategory.ServerCategoryType.LEAF_CATEGORY.toString();
        debugEnabled = Trace.isLevelEnabled(5);
    }
}

