/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.regex.Pattern;
import oracle.cluster.common.NodeRole;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSServerCategoryEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerCategoryException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ServerCategoryImpl
extends ManageableEntityImpl
implements ServerCategory {
    protected ResourceAttribute m_nameAttr;
    protected CRSServerCategoryEntity m_crsServerCategory;

    ServerCategoryImpl(ResourceAttribute nameAttr) throws ServerCategoryException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ServerCategory.NAME.name())) {
                throw new ServerCategoryException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, new Object[0]);
            }
            String value = nameAttr.getValue();
            if (value == null || value.trim().length() == 0) {
                throw new ServerCategoryException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ServerCategory.NAME.name(), "'" + value + "'");
            }
            this.m_nameAttr = nameAttr;
            this.m_name = nameAttr.getValue();
            String[] valueArr = this.m_name.split(Pattern.quote(String.valueOf('.')));
            this.m_displayName = valueArr.length > 1 && this.m_name.startsWith("ora.") ? valueArr[1] : this.m_name;
            Trace.out("m_name = " + this.m_name + ", m_displayName = " + this.m_displayName);
            this.m_crsServerCategory = CRSFactoryImpl.getInstance().getServerCategory(this.m_name);
        }
        catch (CRSException e) {
            throw new ServerCategoryException(e);
        }
    }

    void create(String activecssrole, Filter expression) throws AlreadyExistsException, ServerCategoryException {
        try {
            this.m_crsServerCategory = CRSFactoryImpl.getInstance().createCategory(this.m_nameAttr.getValue(), activecssrole, expression);
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCsMsgID.SC_ALREADY_EXISTS, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServerCategoryException((MessageKey)PrCsMsgID.SC_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public NodeRole activeCSSRole() throws ServerCategoryException {
        return NodeRole.getEnumMember(this.getValue(ResourceType.ServerCategory.ACTIVE_CSS_ROLE.name()));
    }

    @Override
    public String expression() throws ServerCategoryException {
        return this.getValue(ResourceType.ServerCategory.EXPRESSION.name());
    }

    protected String getValue(String attrName) throws ServerCategoryException {
        try {
            ResourceAttribute attr = this.m_crsServerCategory.getAttribute(attrName);
            return attr.getValue();
        }
        catch (CRSException e) {
            throw new ServerCategoryException((MessageKey)PrCsMsgID.SC_GET_FAILED, (Throwable)e, attrName, this.getName());
        }
    }

    public CRSEntity crsEntity() throws NotExistsException, ServerCategoryException {
        try {
            if (this.m_crsServerCategory == null || !this.m_crsServerCategory.isRegistered()) {
                throw new NotExistsException((MessageKey)PrCsMsgID.SC_NOT_EXISTS, this.m_crsServerCategory != null ? this.m_crsServerCategory.entityName() : this.getName());
            }
            return this.m_crsServerCategory;
        }
        catch (CRSException e) {
            throw new ServerCategoryException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }
}

