/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.List;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.install.Install;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.storage.Storage;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

class NodeImpl
implements Node {
    private String m_nodeName;
    private String m_hostName;

    NodeImpl(String nodeName, boolean chkMbrship) throws NodeException {
        this.m_nodeName = nodeName.toLowerCase();
        int indx = this.m_nodeName.indexOf(46);
        if (indx > -1) {
            this.m_nodeName = this.m_nodeName.substring(0, indx);
        }
        try {
            this.m_hostName = !chkMbrship ? this.m_nodeName : Cluster.getHostName(this.m_nodeName);
        }
        catch (ClusterException e) {
            Trace.out("Check node membership: " + e.getMessage());
            throw new NodeException((MessageKey)PrCrMsgID.CLU_MBR_CHECK_FAILED, (Throwable)e, nodeName);
        }
    }

    @Override
    public String getName() throws NodeException {
        return this.m_nodeName;
    }

    @Override
    public String getHostName() throws NodeException {
        return this.m_hostName;
    }

    @Override
    public String getOSName() throws NodeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public String getOSVersion() throws NodeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<Storage> storages() throws NodeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<Install> installs() throws NodeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public Server server() throws NodeException {
        try {
            return ServerFactoryImpl.getInstance().getServer(this);
        }
        catch (ServerException e) {
            throw new NodeException((MessageKey)PrCsMsgID.SVR_GET_FAILED, (Throwable)e, this.m_nodeName);
        }
    }

    public boolean equals(Object obj) {
        try {
            if (this == obj) {
                Trace.out("this is the same as obj");
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                Trace.out("Either the obj is null or the class is different");
                return false;
            }
            NodeImpl node = (NodeImpl)obj;
            Trace.out("m_nodeName = %s, node.m_nodeName = %s ", this.m_nodeName, node.getName());
            return this.m_nodeName != null && this.m_nodeName.equalsIgnoreCase(node.getName());
        }
        catch (NodeException e) {
            Trace.out(e.getMessage());
            return false;
        }
    }

    public int hashCode() {
        return this.m_nodeName != null ? this.m_nodeName.hashCode() : 1234567;
    }

    public String toString() {
        return this.m_nodeName;
    }
}

