/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.util.List;
import oracle.cluster.deployment.ractrans.MultiTierTransfer;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.remote.Transfer;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;

public class TransferImpl
implements Transfer {
    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String tempDir, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, null, false, null, false, tempDir, nodeDestDirPathnames);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String tempDir, String[] nodeDestDirPathnames, List<NodeProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, null, false, null, false, tempDir, nodeDestDirPathnames, progressListeners);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String excludeListFile, String tempDir, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        this.assertInput(excludeListFile, "excludeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, null, false, excludeListFile, true, tempDir, nodeDestDirPathnames);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String excludeListFile, String tempDir, String[] nodeDestDirPathnames, List<NodeProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        this.assertInput(excludeListFile, "excludeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, null, false, excludeListFile, true, tempDir, nodeDestDirPathnames, progressListeners);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String tempDir, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        this.assertInput(excludeListFile, "excludeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, null, false, excludeListFile, excludePathnamesCanBeRegex, tempDir, nodeDestDirPathnames);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String tempDir, String[] nodeDestDirPathnames, List<NodeProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        this.assertInput(excludeListFile, "excludeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, null, false, excludeListFile, excludePathnamesCanBeRegex, tempDir, nodeDestDirPathnames, progressListeners);
    }

    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String topLevelDir, String includeListFile, String tempDir, String[] nodeNames, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        this.assertInput(includeListFile, "includeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, includeListFile, true, null, false, tempDir, nodeDestDirPathnames);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String tempDir, String[] nodeNames, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        this.assertInput(includeListFile, "includeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, null, false, tempDir, nodeDestDirPathnames);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String tempDir, String[] nodeNames, String[] nodeDestDirPathnames, List<NodeProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        this.assertInput(includeListFile, "includeListFile");
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, null, false, tempDir, nodeDestDirPathnames, progressListeners);
    }

    @Override
    public void transferDirStructureToNode(String oracleHome, String remoteNodeName, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String remoteNodeDestDir, RemoteUserInfo remoteUserInfo, String asUser) throws RemoteFileOpException, ClusterException {
        RapidTransfer rapidTransfer = new RapidTransfer();
        rapidTransfer.transferDirStructureToNode(oracleHome, remoteNodeName, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDir, remoteUserInfo, asUser, null);
    }

    public void transferDirStructureToNode(String oracleHome, String remoteNodeName, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String remoteNodeDestDir, RemoteUserInfo remoteUserInfo, String asUser, NodeProgressListener nodeProgressListener) throws RemoteFileOpException, ClusterException {
        if (nodeProgressListener == null) {
            Object[] args = new Object[]{"error-node-progress-listener"};
            throw new ClusterException(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, args));
        }
        RapidTransfer rapidTransfer = new RapidTransfer();
        rapidTransfer.transferDirStructureToNode(oracleHome, remoteNodeName, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDir, remoteUserInfo, asUser, nodeProgressListener);
    }

    @Override
    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser) throws RemoteFileOpException, ClusterException {
        RapidTransfer rapidTransfer = new RapidTransfer();
        rapidTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, remoteUserInfo, asUser, null);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser, NodeProgressListener nodeProgressListener) throws RemoteFileOpException, ClusterException {
        if (nodeProgressListener == null) {
            Object[] args = new Object[]{"error-node-progress-listener"};
            throw new ClusterException(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, args));
        }
        RapidTransfer rapidTransfer = new RapidTransfer();
        rapidTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, remoteUserInfo, asUser, nodeProgressListener);
    }

    private void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String tempDir, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        this.assertInput(oracleHome, "oracleHome");
        this.assertInput(javaNodeName, "javaNodeName");
        this.assertInput(topLevelDir, "topLevelDir");
        this.assertInput(tempDir, "tempDir");
        this.assertInputArray(nodeNames, "nodeNames");
        this.assertInputArray(nodeDestDirPathnames, "nodeDestDirPathnames");
        MultiTierTransfer mttransfer = new MultiTierTransfer();
        mttransfer.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, tempDir, nodeDestDirPathnames);
    }

    private void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String tempDir, String[] nodeDestDirPathnames, List<NodeProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        this.assertInput(oracleHome, "oracleHome");
        this.assertInput(javaNodeName, "javaNodeName");
        this.assertInput(topLevelDir, "topLevelDir");
        this.assertInput(tempDir, "tempDir");
        this.assertInputArray(nodeNames, "nodeNames");
        this.assertInputArray(nodeDestDirPathnames, "nodeDestDirPathnames");
        this.assertInputList(progressListeners, "progressListeners");
        MultiTierTransfer mttransfer = new MultiTierTransfer();
        mttransfer.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, tempDir, nodeDestDirPathnames, progressListeners);
    }

    private void assertInputList(List<? extends Object> list, String listName) throws ClusterException {
        if (list == null) {
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.INVALID_INPUT_ARG, true, listName));
        }
        int i = 0;
        for (Object object : list) {
            if (object == null) {
                throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.INVALID_ARRAY_ELEMENT, true, listName + ".get(" + i + ")"));
            }
            ++i;
        }
    }

    private void assertInput(Object arg, String argName) throws ClusterException {
        if (arg == null) {
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.INVALID_INPUT_ARG, true, argName));
        }
    }

    private void assertInputArray(Object[] array, String arrayName) throws ClusterException {
        if (array == null) {
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.INVALID_INPUT_ARG, true, arrayName));
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.INVALID_ARRAY_ELEMENT, true, arrayName + "[" + i + "]"));
        }
    }
}

