/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.util.Vector;
import oracle.cluster.impl.priv.JSChChannel;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.remote.SecureFileTransfer;
import oracle.cluster.remote.SecureFileTransferException;
import oracle.cluster.resources.PrCzMsgID;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class SecureFileTransferImpl
implements SecureFileTransfer,
Constants {
    private int m_port = 22;
    private Session m_session = null;
    private ChannelSftp m_sFTPChannel = null;
    private String m_node;

    public SecureFileTransferImpl(String node, oracle.cluster.install.UserInfo userInfo) throws SecureFileTransferException {
        try {
            this.m_node = node;
            JSch jsch = new JSch();
            JSch.setLogger((Logger)new JSChChannel.JschLogger());
            JSChChannel.PrivUserInfo ui = new JSChChannel.PrivUserInfo(userInfo.getPassword(), "");
            this.m_session = userInfo.getUsername() == null ? jsch.getSession(Utils.getRootUserName(), this.m_node, this.m_port) : jsch.getSession(userInfo.getUsername(), this.m_node, this.m_port);
            this.m_session.setUserInfo((UserInfo)ui);
            this.m_session.connect();
            Channel channel = this.m_session.openChannel("sftp");
            channel.connect();
            this.m_sFTPChannel = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            Trace.out("jsch exception while opening SFTP channel to node " + this.m_node + " message " + e.getMessage());
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_FAILED, (Throwable)e, this.m_node);
        }
    }

    @Override
    public boolean isConnected() {
        return this.m_sFTPChannel.isConnected();
    }

    @Override
    public void disconnect() {
        this.m_sFTPChannel.disconnect();
        if (this.m_session != null && this.m_session.isConnected()) {
            this.m_session.disconnect();
        }
    }

    @Override
    public void quit() {
        this.m_sFTPChannel.quit();
        if (this.m_session != null && this.m_session.isConnected()) {
            this.m_session.disconnect();
        }
    }

    @Override
    public void exit() {
        this.m_sFTPChannel.exit();
        if (this.m_session != null && this.m_session.isConnected()) {
            this.m_session.disconnect();
        }
    }

    @Override
    public void cd(String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.cd(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_CD_FAILED, (Throwable)se, path, this.m_node);
        }
    }

    @Override
    public void lcd(String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.lcd(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_LCD_FAILED, (Throwable)se, path);
        }
    }

    @Override
    public void put(String source, String destination) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.put(source, destination);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_PUT_FAILED, (Throwable)se, source, destination, this.m_node);
        }
    }

    @Override
    public void get(String source, String destination) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.get(source, destination);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_GET_FAILED, (Throwable)se, source, this.m_node, destination);
        }
    }

    @Override
    public Vector ls(String path) throws SecureFileTransferException {
        try {
            return this.m_sFTPChannel.ls(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_LIST_FAILED, (Throwable)se, path, this.m_node);
        }
    }

    @Override
    public void rename(String oldpath, String newpath) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.rename(oldpath, newpath);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_RENAME_FAILED, (Throwable)se, oldpath, newpath, this.m_node);
        }
    }

    @Override
    public void rm(String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.rm(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_RM_FAILED, (Throwable)se, path, this.m_node);
        }
    }

    @Override
    public void chgrp(int gid, String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.chgrp(gid, path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_CHGRP_FAILED, (Throwable)se, path, Integer.toString(gid), this.m_node);
        }
    }

    @Override
    public void chown(int uid, String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.chown(uid, path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_CHOWN_FAILED, (Throwable)se, path, Integer.toString(uid), this.m_node);
        }
    }

    @Override
    public void chmod(int permissions, String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.chmod(permissions, path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_CHMOD_FAILED, (Throwable)se, path, Integer.toString(permissions), this.m_node);
        }
    }

    @Override
    public void rmdir(String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.rmdir(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_RMDIR_FAILED, (Throwable)se, path, this.m_node);
        }
    }

    @Override
    public void mkdir(String path) throws SecureFileTransferException {
        try {
            this.m_sFTPChannel.mkdir(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_MKDIR_FAILED, (Throwable)se, path, this.m_node);
        }
    }

    @Override
    public String pwd() throws SecureFileTransferException {
        try {
            return this.m_sFTPChannel.pwd();
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_PWD_FAILED, (Throwable)se, this.m_node);
        }
    }

    @Override
    public String lpwd() {
        return this.m_sFTPChannel.lpwd();
    }

    @Override
    public String getHome() throws SecureFileTransferException {
        try {
            return this.m_sFTPChannel.getHome();
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_GET_HOMEDIR_FAILED, (Throwable)se, this.m_node);
        }
    }

    @Override
    public SftpATTRS stat(String path) throws SecureFileTransferException {
        try {
            return this.m_sFTPChannel.stat(path);
        }
        catch (SftpException se) {
            throw new SecureFileTransferException((MessageKey)PrCzMsgID.CHANNEL_SFTP_GET_ATTR_FAILED, (Throwable)se, path, this.m_node);
        }
    }

    @Override
    public boolean isExist(String path) {
        try {
            SftpATTRS attr = this.stat(path);
            if (attr == null) {
                return false;
            }
        }
        catch (SecureFileTransferException se) {
            Trace.out("Seems like the file (" + path + ") does not exist." + "Caught SftpException " + se.getMessage());
            return false;
        }
        return true;
    }
}

