/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.io.File;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.remote.CopyClientImpl;
import oracle.cluster.impl.remote.CopyCommandNoUserEqImpl;
import oracle.cluster.impl.remote.CopyListenerImpl;
import oracle.cluster.impl.remote.DirectoryImpl;
import oracle.cluster.impl.remote.ExecCommandImpl;
import oracle.cluster.impl.remote.ExecCommandNoUserEqImpl;
import oracle.cluster.impl.remote.SecureFileTransferImpl;
import oracle.cluster.impl.remote.TransferImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.CopyClient;
import oracle.cluster.remote.CopyListener;
import oracle.cluster.remote.CopyListenerException;
import oracle.cluster.remote.ExecCommand;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.IDInfo;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteArgs;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.remote.SecureFileTransfer;
import oracle.cluster.remote.SecureFileTransferException;
import oracle.cluster.remote.Transfer;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class RemoteFactoryImpl {
    private static RemoteFactoryImpl s_instance;
    private static MessageBundle msgBndl;
    private static final String ROOT;

    private RemoteFactoryImpl() {
    }

    public static synchronized RemoteFactoryImpl getInstance() {
        if (s_instance == null) {
            s_instance = new RemoteFactoryImpl();
        }
        return s_instance;
    }

    public ExecCommand getExecCommand() {
        return new ExecCommandImpl();
    }

    public Transfer getTransfer() {
        return new TransferImpl();
    }

    public CopyListener getCopyListener() throws CopyListenerException {
        return new CopyListenerImpl();
    }

    public CopyListener getCopyListener(String baseDir) throws CopyListenerException {
        return new CopyListenerImpl(baseDir);
    }

    public CopyClient getCopyClient() {
        return new CopyClientImpl();
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteArgs remoteArgs) {
        return new ExecCommandNoUserEqImpl(remoteArgs);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(UserInfo userInfo) throws InvalidArgsException {
        return new ExecCommandNoUserEqImpl(userInfo);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser) throws InvalidArgsException {
        return new ExecCommandNoUserEqImpl(userInfo, asUser);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser, String[] stdin) throws InvalidArgsException {
        return new ExecCommandNoUserEqImpl(userInfo, asUser, stdin);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser, NodeProgressListener npListener) throws InvalidArgsException {
        return new ExecCommandNoUserEqImpl(userInfo, asUser, npListener);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser, String[] stdin, NodeProgressListener npListener) throws InvalidArgsException {
        return new ExecCommandNoUserEqImpl(userInfo, asUser, stdin, npListener);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, UserInfo userInfo, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        try {
            CopyCommandNoUserEqImpl copyCmd = new CopyCommandNoUserEqImpl();
            copyCmd.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, userInfo, timeout);
        }
        catch (InvalidArgsException e) {
            Trace.out("InvalidArgsException caught: " + e.getMessage());
            throw new InvalidArgsException(e);
        }
        catch (ExecException e) {
            Trace.out("ExecException caught: " + e.getMessage());
            throw new ExecException(e);
        }
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, RemoteUserInfo userInfo, String asUser, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        CopyCommandNoUserEqImpl copyCmd = new CopyCommandNoUserEqImpl();
        UserInfo uinfo = null;
        uinfo = userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT ? new UserInfo(null, userInfo.getPassword()) : new UserInfo(userInfo.getUsername(), userInfo.getPassword());
        copyCmd.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, uinfo, timeout);
        ExecCommandNoUserEqImpl execCmd = new ExecCommandNoUserEqImpl(new RemoteArgs(userInfo));
        execCmd.runCmd("/usr/bin/chown", new String[]{asUser, destFile}, nodeList, timeout);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, String user, String password, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        CopyCommandNoUserEqImpl copyCmd = new CopyCommandNoUserEqImpl();
        copyCmd.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, user, password, timeout);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, String rootPassword, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        CopyCommandNoUserEqImpl copyCmd = new CopyCommandNoUserEqImpl();
        copyCmd.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, rootPassword, timeout);
    }

    public Map<String, CommandResult> createDirOnNodes(String[] nodeNames, String dirPathname, String asUser, RemoteUserInfo remoteUserInfo, Integer mode) throws ExecException, InvalidArgsException, CompositeOperationException {
        DirectoryImpl directoryImpl = new DirectoryImpl();
        return directoryImpl.createDirOnNodes(nodeNames, dirPathname, asUser, remoteUserInfo, mode);
    }

    public Map<String, CommandResult> removeDirOnNodes(String[] nodeNames, String dirPathname, RemoteUserInfo remoteUserInfo, String asUser, boolean isRecursive) throws ExecException, InvalidArgsException, CompositeOperationException {
        DirectoryImpl directoryImpl = new DirectoryImpl();
        return directoryImpl.removeDirOnNodes(nodeNames, dirPathname, remoteUserInfo, asUser, isRecursive);
    }

    public boolean isDirExists(String checkDirPath, String node, RemoteArgs remArgs) throws InvalidArgsException, ExecException {
        Utils.assertInput(checkDirPath, "checkDirPath");
        Utils.assertInput(node, "node");
        String pswd = remArgs.getPassword();
        Utils.assertInput(pswd, "password");
        String cmd = "/bin/sh";
        String argStr = null;
        argStr = remArgs.getAsUser() != null && remArgs.getMode() != ConfigurationSetup.ConfigMethod.ROOT ? " -c \\\"if [ -d " + checkDirPath + " ]; then echo exists; fi\\\"" : " -c \"if [ -d " + checkDirPath + " ]; then echo exists; fi\"";
        String[] args = new String[]{argStr};
        String[] env = new String[]{};
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        try {
            Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
            CommandResult result = resultMap.get(node);
            String[] resultStr = result.getResultString();
            if (resultStr != null && resultStr[0].equals("exists")) {
                return true;
            }
        }
        catch (CompositeOperationException e) {
            throw new ExecException(e);
        }
        return false;
    }

    public Map<String, CommandResult> isValidUser(String asUser, String[] nodeList, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(asUser, "asUser");
        this.validateNodePass(nodeList, uinfo.getPassword());
        String cmd = "/bin/true";
        String[] args = new String[]{};
        String[] env = new String[]{};
        RemoteArgs remArgs = new RemoteArgs(uinfo);
        remArgs.setAsUser(asUser);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        return execcmd.runCmd(cmd, args, env, nodeList, 120);
    }

    public boolean isDirEmpty(String targetDir, String node, RemoteArgs remArgs) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(targetDir, "targetDir");
        Utils.assertInput(node, "node");
        String cmd = "/bin/sh";
        String argStr = null;
        argStr = remArgs.getAsUser() != null ? "-c \\\"if [ `ls -A " + targetDir + " | wc -l` -eq 0 ]; then echo empty; fi\\\"" : "-c \"if [ `ls -A " + targetDir + " | wc -l` -eq 0 ]; then echo empty; fi\"";
        String[] args = new String[]{argStr};
        String[] env = new String[]{};
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
        CommandResult result = resultMap.get(node);
        String[] resultStr = result.getResultString();
        return resultStr != null && resultStr.length == 1 && resultStr[0].equals("empty");
    }

    public boolean isDirExistsAndWritable(String targetDir, String node, RemoteUserInfo userInfo, String asUser) throws InvalidArgsException, ExecException, CompositeOperationException {
        ExecCommandNoUserEq execcmd;
        Map<String, CommandResult> resultMap;
        CommandResult result;
        String[] resultStr;
        Utils.assertInput(targetDir, "targetDir");
        Utils.assertInput(node, "node");
        Utils.assertInput(asUser, "asUser");
        Utils.assertInput(userInfo.getPassword(), "password");
        String cmd = "/bin/sh";
        String argStr = null;
        argStr = userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT || asUser == null || asUser.trim().equals(ROOT) ? "-c \"if [ -d " + targetDir + " -a -w " + targetDir + " ]; then echo exists; fi\"" : "-c \\\"if [ -d " + targetDir + " -a -w " + targetDir + " ]; then echo exists; fi\\\"";
        String[] args = new String[]{argStr};
        String[] env = new String[]{};
        RemoteArgs remArgs = new RemoteArgs(userInfo);
        if (asUser != null && !asUser.equals(ROOT)) {
            remArgs.setAsUser(asUser);
        }
        return (resultStr = (result = (resultMap = (execcmd = this.getExecCommandNoUserEq(remArgs)).runCmd(cmd, args, env, new String[]{node}, 120)).get(node)).getResultString()) != null && resultStr.length == 1 && resultStr[0].equals("exists");
    }

    public boolean isFileExists(String targetFile, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        Utils.assertInput(targetFile, "targetFile");
        Utils.assertInput(node, "node");
        Utils.assertInput(userInfo.getPassword(), "password");
        String cmd = "/bin/sh";
        String argStr = "-c \"if [ -f " + targetFile + " ]; then echo exists; fi\"";
        String[] args = new String[]{argStr};
        String[] env = new String[]{};
        try {
            RemoteArgs remArgs = new RemoteArgs(userInfo);
            ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
            Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
            CommandResult result = resultMap.get(node);
            String[] resultStr = result.getResultString();
            if (resultStr != null && resultStr.length == 1 && resultStr[0].contains("exists")) {
                return true;
            }
        }
        catch (CompositeOperationException e) {
            throw new ExecException(e);
        }
        return false;
    }

    public boolean isRemoteNodePartOfCluster(String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        return this.isRemoteNodeHelper(node, userInfo, true);
    }

    public boolean isRemoteNodeSIHA(String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        return this.isRemoteNodeHelper(node, userInfo, false);
    }

    private boolean isRemoteNodeHelper(String node, RemoteUserInfo userInfo, boolean isCluster) throws InvalidArgsException, ExecException {
        Utils.assertInput(node, "node");
        Utils.assertInput(userInfo.getPassword(), "password");
        String olrFile = "/var/opt/oracle" + File.separator + "olr.loc";
        boolean isOlrFileExists = this.isFileExists(olrFile, node, userInfo);
        if (!isOlrFileExists) {
            return false;
        }
        return this.isConfigured(node, userInfo, isCluster);
    }

    public String[] getFileContents(String targetFile, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(node, "node");
        Utils.assertInput(targetFile, "targetFile");
        Utils.assertInput(userInfo.getPassword(), "password");
        String cmd = "/usr/bin/cat";
        String[] args = new String[]{targetFile};
        String[] env = new String[]{};
        RemoteArgs remArgs = new RemoteArgs(userInfo);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
        CommandResult result = resultMap.get(node);
        return result.getResultString();
    }

    public String getClusterwareVersion(String crsHome, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return this.getVersionHelper(crsHome, node, userInfo, true);
    }

    public String getSIHAVersion(String crsHome, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return this.getVersionHelper(crsHome, node, userInfo, false);
    }

    private String getVersionHelper(String crsHome, String node, RemoteUserInfo userInfo, boolean isCluster) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(node, "node");
        Utils.assertInput(crsHome, "crsHome");
        Utils.assertInput(userInfo.getPassword(), "password");
        Trace.out((Object)"Checking %s version", isCluster ? "cluster" : "SIHA");
        String cmd = isCluster ? crsHome + "/bin/crsctl query crs softwareversion " + node : crsHome + "/bin/crsctl query has softwareversion";
        String[] args = new String[]{};
        String[] env = new String[]{};
        String defaultVer = "12.2.0.0";
        RemoteArgs remArgs = new RemoteArgs(userInfo);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
        CommandResult result = resultMap.get(node);
        String[] resultStr = result.getResultString();
        if (resultStr != null && resultStr.length == 1) {
            String splitStringNode = "is";
            Trace.out("splitStringNode: " + splitStringNode);
            String splitResult = resultStr[0].split(splitStringNode)[1];
            Trace.out("splitResult: " + splitResult);
            int indexCl = splitResult.indexOf("]");
            int indexOp = splitResult.indexOf("[");
            if (indexOp != -1 && indexCl != -1) {
                Trace.out("Returning substring: " + splitResult.substring(indexOp + 1, indexCl));
                return splitResult.substring(indexOp + 1, indexCl);
            }
        }
        return defaultVer;
    }

    public String getCRSHomeOfRemoteCluster(String node, RemoteUserInfo uinfo, boolean checkForClusterExistence) throws InvalidArgsException, ExecException {
        Utils.assertInput(node, "node");
        Utils.assertInput(uinfo.getPassword(), "password");
        boolean isClusterExists = false;
        try {
            if (checkForClusterExistence) {
                isClusterExists = this.isRemoteNodePartOfCluster(node, uinfo);
            }
            if (!checkForClusterExistence || isClusterExists) {
                String olrFile = "/var/opt/oracle" + File.separator + "olr.loc";
                String[] contents = this.getFileContents(olrFile, node, uinfo);
                if (contents == null || contents.length == 0) {
                    throw new ExecException((MessageKey)PrCrMsgID.EMPTY_FILE, olrFile, node);
                }
                String splitDelim = "crs_home";
                String crsHome = contents[0].split(splitDelim)[1].split("=")[1];
                Trace.out("crsHome: " + crsHome);
                return crsHome;
            }
            throw new ExecException((MessageKey)PrCrMsgID.NO_CLUSTER, node);
        }
        catch (CompositeOperationException coe) {
            String errMsg = coe.getMessage();
            Trace.out("COException: " + errMsg);
            if (errMsg.contains("/usr/bin/cat")) {
                throw new ExecException((MessageKey)PrCcMsgID.NOT_IN_CLUSTER_OR_WRONG_PASSWORD, node);
            }
            throw new ExecException(coe);
        }
    }

    public String getRemoteClusterNodes(String crsHome, String node, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(node, "node");
        Utils.assertInput(crsHome, "crsHome");
        Utils.assertInput(uinfo.getPassword(), "password");
        String cmd = crsHome + "/bin/olsnodes";
        String[] args = new String[]{};
        String[] env = new String[]{};
        RemoteArgs remArgs = new RemoteArgs(uinfo);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
        CommandResult result = resultMap.get(node);
        String[] resultStr = result.getResultString();
        if (resultStr != null) {
            int index;
            String res = resultStr[0];
            String[] resArr = res.split("\\n");
            StringBuilder sb = new StringBuilder();
            for (index = 0; index < resArr.length - 1; ++index) {
                if (resArr[index] == null || resArr[index].trim().equals("")) continue;
                sb.append(resArr[index] + ",");
            }
            if (index == resArr.length - 1 && resArr[index] != null && !resArr[index].trim().equals("")) {
                sb.append(resArr[index]);
            }
            return sb.toString();
        }
        return null;
    }

    public String getRemoteClusterName(String crsHome, String node, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(node, "node");
        Utils.assertInput(crsHome, "crsHome");
        Utils.assertInput(uinfo.getPassword(), "password");
        String cmd = crsHome + "/bin/olsnodes -c";
        String[] args = new String[]{};
        String[] env = new String[]{};
        RemoteArgs remArgs = new RemoteArgs(uinfo);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
        CommandResult result = resultMap.get(node);
        return result.getResultString()[0];
    }

    public void deleteFileOnRemoteNode(String responseFile, String nodelist, RemoteArgs remArgs) throws InvalidArgsException, ExecException, CompositeOperationException {
        Utils.assertInput(nodelist, "nodelist");
        Utils.assertInput(responseFile, "responseFile");
        String cmd = "/usr/bin/rm -rf";
        String[] args = new String[]{responseFile};
        String[] env = new String[]{};
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        String[] nodeList = nodelist.split(",");
        execcmd.runCmd(cmd, args, env, nodeList, 120);
    }

    private void validateNodePass(String[] nodeList, String password) throws InvalidArgsException {
        if (nodeList == null || nodeList.length < 1) {
            Trace.out("Exception: nodeList is null or empty");
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        Utils.assertInputNotNull(password, "password");
    }

    public String getFileOwner(String targetFile, String node, RemoteUserInfo userInfo) throws InvalidArgsException, CompositeOperationException, ExecException {
        Utils.assertInput(targetFile, "RemoteFac-getFileOwner-targetFile");
        Utils.assertInput(node, "RemoteFac-getFileOwner-node");
        Utils.assertInputNotNull(userInfo, "RemoteFac-getFileOwner-userInfo");
        Trace.out("Verifying that %s exists on %s and that %s is a regular file ...", targetFile, node, targetFile);
        this.isFileExists(targetFile, node, userInfo);
        Trace.out("Retrieving file owner ...");
        String cmd = "ls -ld " + targetFile + " | awk '{print $3}'";
        Trace.out((Object)"Command to execute : %s", cmd);
        String[] args = new String[]{};
        String[] env = new String[]{};
        RemoteArgs remArgs = new RemoteArgs(userInfo);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = execcmd.runCmd(cmd, args, env, new String[]{node}, 120);
        CommandResult result = resultMap.get(node);
        String[] resultStr = result.getResultString();
        if (resultStr == null || resultStr.length != 1) {
            String errString = result.getErrorString();
            throw new ExecException((MessageKey)PrCfMsgID.REMOTE_EXECUTION_ERROR, node, errString != null ? errString : "");
        }
        return resultStr[0];
    }

    public IDInfo getIDInfo(String userName, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        Utils.assertInput(userName, "userName");
        Utils.assertInput(node, "node");
        Utils.assertInputNotNull(userInfo, "userInfo");
        String cmd = "/usr/bin/id";
        String[] args = DeterminePlatform.getOSName().equals("Solaris") || DeterminePlatform.getOSName().equals("SunOS") ? new String[]{"-a", userName} : new String[]{userName};
        String[] env = new String[]{};
        Trace.out("Executing id command ...");
        RemoteArgs remArgs = new RemoteArgs(userInfo);
        ExecCommandNoUserEq execCmd = this.getExecCommandNoUserEq(remArgs);
        Map<String, CommandResult> resultMap = null;
        try {
            resultMap = execCmd.runCmd(cmd, args, env, new String[]{node}, 36000);
        }
        catch (CompositeOperationException e) {
            Trace.out("Command failed during execution");
            throw new ExecException(e);
        }
        String[] resultStr = resultMap.get(node).getResultString();
        if (resultStr == null || resultStr.length < 1) {
            String errString = resultMap.get(node).getErrorString();
            throw new ExecException((MessageKey)PrCfMsgID.REMOTE_EXECUTION_ERROR, node, errString != null ? errString : "");
        }
        return new IDInfo(resultStr[0]);
    }

    public IDInfo getIDInfo(String userName, String node) throws InvalidArgsException, ExecException {
        Utils.assertInput(userName, "userName");
        Utils.assertInput(node, "node");
        String cmd = "/usr/bin/id";
        String[] args = DeterminePlatform.getOSName().equals("Solaris") || DeterminePlatform.getOSName().equals("SunOS") ? new String[]{"-a", userName} : new String[]{userName};
        String[] env = new String[]{};
        Trace.out("Executing id command ...");
        ExecCommand execCmd = this.getExecCommand();
        Map<String, CommandResult> resultMap = null;
        try {
            resultMap = execCmd.runCmd(cmd, args, env, new String[]{node});
        }
        catch (CompositeOperationException e) {
            Trace.out("Command failed during execution");
            throw new ExecException(e);
        }
        String[] resultStr = resultMap.get(node).getResultString();
        if (resultStr == null || resultStr.length < 1) {
            String errString = resultMap.get(node).getErrorString();
            throw new ExecException((MessageKey)PrCfMsgID.REMOTE_EXECUTION_ERROR, node, errString != null ? errString : "");
        }
        return new IDInfo(resultStr[0]);
    }

    public SecureFileTransfer getSecureFileTransfer(String node, UserInfo userInfo) throws SecureFileTransferException, InvalidArgsException {
        Utils.assertInput(node, "node");
        String pswd = userInfo.getPassword();
        Utils.assertInput(pswd, "password");
        return new SecureFileTransferImpl(node, userInfo);
    }

    private boolean isConfigured(String node, RemoteUserInfo userInfo, boolean isCluster) throws InvalidArgsException, ExecException {
        String ocrFile = "/var/opt/oracle" + File.separator + "ocr.loc";
        try {
            boolean isOcrFileExists = this.isFileExists(ocrFile, node, userInfo);
            if (!isOcrFileExists) {
                return false;
            }
            String[] ocrFileContents = this.getFileContents(ocrFile, node, userInfo);
            if (ocrFileContents == null || ocrFileContents.length == 0) {
                throw new ExecException((MessageKey)PrCrMsgID.EMPTY_FILE, ocrFile, node);
            }
            String ocrCnfgLocPropertyValue = ocrFileContents[0].split("ocrconfig_loc")[1].split("=")[1];
            String localOnlyPropVal = ocrFileContents[0].split("local_only")[1].split("=")[1];
            boolean localOnly = false;
            localOnly = localOnlyPropVal != null ? Boolean.parseBoolean(localOnlyPropVal.trim()) : false;
            if (isCluster) {
                return !localOnly && ocrCnfgLocPropertyValue != null;
            }
            return localOnly && ocrCnfgLocPropertyValue != null;
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException: " + e.getMessage());
            throw new ExecException(e);
        }
    }

    public void replaceTextInFile(String node, String crsHome, String file, String oldText, String newText, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        Trace.out("Replacing %s with %s in file %s on node %s using home %s", oldText, newText, file, node, crsHome);
        Utils.assertInput(node, "node");
        Utils.assertInput(crsHome, "crsHome");
        Utils.assertInput(file, "file");
        Utils.assertInput(oldText, "oldText");
        Utils.assertInputNotNull(newText, "newText");
        Utils.assertInput(uinfo.getPassword(), "password");
        String cmd = crsHome + Constants.FILE_SEPARATOR + Constants.PERL;
        String[] args = new String[]{"-p", "-i", "-e", "'s/" + oldText + "/" + newText + "/g'", file};
        String[] env = new String[]{};
        String[] nodes = new String[]{node};
        RemoteArgs remArgs = new RemoteArgs(uinfo);
        ExecCommandNoUserEq execcmd = this.getExecCommandNoUserEq(remArgs);
        execcmd.runCmd(cmd, args, env, nodes, 120);
    }

    static {
        ROOT = Utils.getRootUserName();
        msgBndl = MessageBundle.getMessageBundle(PrCrMsgID.facility);
        msgBndl.setPackage("oracle.cluster.resources");
    }
}

