/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Properties;
import java.util.Set;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.priv.JSChChannel;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.remote.ExecException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class JSCHCopyCommand
extends Command {
    private static final String ROOT = Utils.getRootUserName();
    private static final String PRESERVEOPTION = " -p ";
    private static final String PASSPHRASE = "passphrase";
    private static final int MILLISECONDCONVERTER = 1000;
    private static final String SUDO_S = " -S ";
    private final String SHELL_CMD_BEGIN = "/usr/bin/sh -c '(";
    private final String SHELL_CMD_END = " )'";
    private String m_sourceFile = null;
    private String[] m_nodeList = null;
    private String m_destFile = null;
    private boolean m_noPreserve = true;
    private oracle.cluster.install.UserInfo m_uinfo = null;
    private int m_timeout = 0;

    public JSCHCopyCommand(String sourceFile, String node, String destFile, boolean noPreserve, oracle.cluster.install.UserInfo uinfo, int timeout) throws InvalidArgsException {
        this.m_sourceFile = sourceFile;
        this.m_node = node;
        this.m_destFile = destFile;
        this.m_noPreserve = noPreserve;
        this.m_uinfo = uinfo;
        this.m_timeout = timeout;
        this.commandResult = new CommandResult();
        Utils.assertInput(sourceFile, "sourceFile");
        Utils.assertInput(destFile, "destFile");
        Utils.assertInput(node, "node");
        Utils.assertInputNotNull(uinfo, "uinfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        InputStream in;
        OutputStream out;
        Trace.out("Executing the copy of " + this.m_sourceFile + " to " + this.m_destFile + " on node " + this.m_node + " using JSCH");
        JSch jsch = null;
        Session session = null;
        JSChChannel.PrivUserInfo ui = null;
        ChannelExec channel = null;
        try {
            jsch = new JSch();
            String knownHostsPath = Utils.getKnownHostsPath();
            Trace.out("Setting known hosts path to " + knownHostsPath);
            jsch.setKnownHosts(knownHostsPath);
            JSch.setLogger((Logger)new JSChChannel.JschLogger());
            String pubkeyPath = Utils.getRSADSAPath();
            Trace.out("pubkeypath is " + pubkeyPath);
            if (this.m_uinfo.getUsername() == null || this.m_uinfo.getUsername().trim().equals(ROOT)) {
                session = jsch.getSession(ROOT, this.m_node);
                ui = new JSChChannel.PrivUserInfo(this.m_uinfo.getPassword(), PASSPHRASE);
            } else {
                if (pubkeyPath != null) {
                    jsch.addIdentity(pubkeyPath, PASSPHRASE);
                }
                session = jsch.getSession(this.m_uinfo.getUsername(), this.m_node);
                ui = new JSChChannel.PrivUserInfo(this.m_uinfo.getPassword(), PASSPHRASE);
            }
            Properties configProps = new Properties();
            configProps.put("PreferredAuthentications", "password,keyboard-interactive,publickey");
            session.setConfig(configProps);
            session.setPassword(this.m_uinfo.getPassword());
            session.setUserInfo((UserInfo)ui);
            session.connect(this.m_timeout * 1000);
            Trace.out("Setting command...");
            channel = (ChannelExec)session.openChannel("exec");
        }
        catch (JSchException e) {
            Trace.out("JSChException: " + e.getMessage());
            this.commandResult.setException((Exception)((Object)e));
            this.commandResult.setStatus(false);
            return false;
        }
        try {
            int i;
            Trace.out("Forming command...");
            String command = "/usr/bin/scp" + (this.m_noPreserve ? " " : PRESERVEOPTION) + "-t " + this.m_destFile;
            Trace.out("Command: " + command);
            channel.setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            StringBuffer buffer = new StringBuffer();
            while ((i = in.read()) != 0) {
                if (buffer.length() >= 65536) {
                    Trace.out("more than 64k " + buffer.toString());
                    break;
                }
                buffer.append((char)i);
            }
            Trace.out("printing buffer on connect:" + buffer.toString());
        }
        catch (JSchException e) {
            Trace.out("JSchException: " + e.getMessage());
            this.commandResult.setException((Exception)((Object)e));
            this.commandResult.setStatus(false);
            return false;
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            this.commandResult.setException(e);
            this.commandResult.setStatus(false);
            return false;
        }
        try {
            int len;
            Trace.out("Performing scp");
            File source = new File(this.m_sourceFile);
            String command = null;
            String preserveCode = "C0755";
            if (!this.m_noPreserve) {
                command = "T" + source.lastModified() / 1000L + " 0";
                command = command + " " + source.lastModified() / 1000L + " 0\n";
                Trace.out("Sending command " + command);
                out.write(command.getBytes());
                out.flush();
                if (this.checkAck(in) != 0) {
                    Trace.out("Ack shows an error in noPreserve section");
                    boolean bl = false;
                    return bl;
                }
                Set<PosixFilePermission> filePerm = null;
                try {
                    filePerm = Files.getPosixFilePermissions(Paths.get(this.m_sourceFile, new String[0]), new LinkOption[0]);
                }
                catch (IOException e) {
                    Trace.out("IOException: " + e.getMessage());
                    this.commandResult.setException(e);
                    this.commandResult.setStatus(false);
                    boolean bl = false;
                    Trace.out("End of command execution");
                    if (this.commandResult.getException() != null) {
                        Trace.out("Copy failed with error " + this.commandResult.getException().getMessage());
                        channel.disconnect();
                        session.disconnect();
                        Trace.out("disconnected channel in case of error");
                        return false;
                    }
                    int exitStatus = -1;
                    if (channel.isClosed()) {
                        exitStatus = channel.getExitStatus();
                        Trace.out("Exist status from channel is " + exitStatus);
                        this.commandResult.setOSErrCode(exitStatus);
                    }
                    channel.disconnect();
                    session.disconnect();
                    Trace.out("after disconnecting from channel");
                    this.commandResult.setStatus(true);
                    return true;
                }
                preserveCode = "C0" + String.valueOf(this.getPermissions(PosixFilePermissions.toString(filePerm)));
            }
            long filesize = source.length();
            command = preserveCode + " " + filesize + " ";
            command = this.m_sourceFile.lastIndexOf(47) > 0 ? command + this.m_sourceFile.substring(this.m_sourceFile.lastIndexOf(47) + 1) : command + this.m_sourceFile;
            command = command + "\n";
            Trace.out("Sending command " + command);
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                Trace.out("Ack shows an error");
                boolean bl = false;
                return bl;
            }
            Trace.out("Sending file stream...");
            FileInputStream fis = new FileInputStream(source);
            byte[] buf = new byte[1024];
            int total = 0;
            while ((len = fis.read(buf, 0, buf.length)) >= 0) {
                if (len == 0) {
                    Trace.out("zero bytes read");
                    continue;
                }
                total += len;
                out.write(buf, 0, len);
                out.flush();
            }
            Trace.out("Total bytes read :" + total);
            fis.close();
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                Trace.out("Ack shows an error");
                boolean bl = false;
                return bl;
            }
            Trace.out("Done copying file");
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            this.commandResult.setException(e);
            this.commandResult.setStatus(false);
            boolean bl = false;
            return bl;
        }
        finally {
            Trace.out("End of command execution");
            if (this.commandResult.getException() != null) {
                Trace.out("Copy failed with error " + this.commandResult.getException().getMessage());
                channel.disconnect();
                session.disconnect();
                Trace.out("disconnected channel in case of error");
                return false;
            }
            int exitStatus = -1;
            if (channel.isClosed()) {
                exitStatus = channel.getExitStatus();
                Trace.out("Exist status from channel is " + exitStatus);
                this.commandResult.setOSErrCode(exitStatus);
            }
            channel.disconnect();
            session.disconnect();
            Trace.out("after disconnecting from channel");
            this.commandResult.setStatus(true);
            return true;
        }
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        Trace.out("Ack received: " + b);
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                Trace.out("Error: " + sb.toString());
                this.commandResult.setException(new ExecException(sb.toString()));
                this.commandResult.setStatus(false);
            }
            if (b == 2) {
                Trace.out("Fatal Error: " + sb.toString());
                this.commandResult.setException(new ExecException(sb.toString()));
                this.commandResult.setStatus(false);
            }
        }
        return b;
    }

    private String waitTerminalLaunch(ByteArrayOutputStream os, ByteArrayOutputStream es) {
        String output = null;
        while (true) {
            Trace.out("reading output streams");
            output = es.toString();
            if (output != null && output.length() > 0) {
                Trace.out("breaking because error stream was written to: " + output);
                break;
            }
            output = os.toString();
            if (output != null && output.length() > 0) {
                Trace.out("breaking because output stream was written to:" + output);
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        return output;
    }

    private int getPermissions(String permissions) {
        int result = 0;
        int perm = 0;
        for (int i = 0; i < 3; ++i) {
            result *= 10;
            perm = 0;
            if (permissions.charAt(i * 3 + 0) == 'r') {
                perm += 4;
            }
            if (permissions.charAt(i * 3 + 1) == 'w') {
                perm += 2;
            }
            if (permissions.charAt(i * 3 + 2) == 'x') {
                ++perm;
            }
            result += perm;
        }
        return result;
    }
}

