/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;

public class DirectoryImpl {
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();

    public Map<String, CommandResult> createDirOnNodes(String[] nodeNames, String dirPathname, String asUser, RemoteUserInfo remoteUserInfo, Integer mode) throws ExecException, InvalidArgsException, CompositeOperationException {
        String[] mkdirArgs;
        String mkdirCmd;
        if (mode != null && (mode < 0 || mode > 777)) {
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        if (mode == null) {
            mkdirCmd = "/usr/bin/mkdir -p";
            mkdirArgs = new String[]{dirPathname};
        } else {
            mkdirCmd = "/usr/bin/mkdir -p -m ";
            mkdirArgs = new String[]{String.valueOf(mode), dirPathname};
        }
        ExecCommandNoUserEq execCommandNoUserEqmand = RemoteFactory.getInstance().getExecCommandNoUserEq(remoteUserInfo, asUser);
        return execCommandNoUserEqmand.runCmd(mkdirCmd, mkdirArgs, nodeNames, 120);
    }

    public Map<String, CommandResult> removeDirOnNodes(String[] nodeNames, String dirPathname, RemoteUserInfo remoteUserInfo, String asUser, boolean isRecursive) throws ExecException, InvalidArgsException, CompositeOperationException {
        String removeCmd = isRecursive ? "/usr/bin/rm -rf" : "/usr/bin/rmdir ";
        ExecCommandNoUserEq execCommandNoUserEqmand = RemoteFactory.getInstance().getExecCommandNoUserEq(remoteUserInfo, asUser);
        return execCommandNoUserEqmand.runCmd(removeCmd, new String[0], nodeNames, 120);
    }

    private void assertUnixSystem() throws InvalidArgsException {
        if (!IS_UNIX_SYSTEM) {
            throw new InvalidArgsException((MessageKey)PrCfMsgID.UNIX_SUPPORT_ONLY, new Object[0]);
        }
    }
}

