/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.Semaphore;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.remote.CopyListener;
import oracle.cluster.remote.CopyListenerException;
import oracle.cluster.remote.StreamCopy;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CopyListenerImpl
implements CopyListener {
    private ServerSocket m_srvSocket;
    private String m_hostName;
    private String m_filePath = null;
    private int m_port;
    private boolean m_isTimedOut = false;
    private boolean m_isSuccess = false;
    private boolean m_isSend = false;
    private static Exception m_exception;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final int COPY_TIMEOUT = 100000;

    public CopyListenerImpl() throws CopyListenerException {
        try {
            this.m_hostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.m_srvSocket = new ServerSocket(0);
            this.m_port = this.m_srvSocket.getLocalPort();
            Trace.out("Created copy listener with host " + this.m_hostName + " and port " + this.m_port + " ...");
        }
        catch (UnknownHostException e) {
            throw new CopyListenerException(e);
        }
        catch (IOException e) {
            throw new CopyListenerException(e);
        }
    }

    public CopyListenerImpl(String filePath) throws CopyListenerException {
        try {
            this.m_hostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.m_srvSocket = new ServerSocket(0);
            this.m_port = this.m_srvSocket.getLocalPort();
            this.m_filePath = filePath;
            Trace.out("Created copy listener with host " + this.m_hostName + " and port " + this.m_port + " ...");
        }
        catch (UnknownHostException e) {
            throw new CopyListenerException(e);
        }
        catch (IOException e) {
            throw new CopyListenerException(e);
        }
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public synchronized Exception getException() {
        return m_exception;
    }

    public static String generateClientMsg(CopyListener.ActionType actionType, String[] args) {
        StringBuilder cmdBuilder = new StringBuilder("qrm750k7aJFb");
        cmdBuilder.append(";==;" + actionType.toString());
        for (String arg : args) {
            cmdBuilder.append(";==;" + arg);
        }
        Trace.out("Client message generated: " + cmdBuilder.toString());
        return cmdBuilder.toString();
    }

    @Override
    public void run() {
        Trace.out("Starting copy listener ...");
        Socket clientSocket = null;
        try {
            Trace.out("CopyListener - Listening for a connection ...");
            clientSocket = this.m_srvSocket.accept();
            Trace.out("CopyListener - Accepted a connection");
            this.m_srvSocket.setSoTimeout(30000);
            this.handleClientRequests(clientSocket);
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            CopyListenerImpl.setException(e);
        }
        catch (CopyListenerException e) {
            Trace.out("CopyListenerException: " + e.getMessage());
            CopyListenerImpl.setException(e);
        }
    }

    private static synchronized void setException(Exception e) {
        m_exception = e;
    }

    private void handleClientRequests(Socket clientSocket) throws CopyListenerException {
        block8: {
            InputStream clientSocketInputStream = null;
            OutputStream clientSocketOutputStream = null;
            BufferedReader clientSocketReader = null;
            PrintWriter clientSocketWriter = null;
            Thread copyThread = null;
            try {
                clientSocketInputStream = clientSocket.getInputStream();
                clientSocketOutputStream = clientSocket.getOutputStream();
                clientSocketReader = new BufferedReader(new InputStreamReader(clientSocketInputStream));
                clientSocketWriter = new PrintWriter(clientSocketOutputStream, true);
                Trace.out("Looking for type of action to be done by listener");
                String msg = clientSocketReader.readLine();
                if (msg == null) break block8;
                try {
                    this.verifyMessageContainsKey(msg);
                }
                catch (CopyListenerException e) {
                    Trace.out("Message is invalid. Terminating ...");
                    CopyListenerImpl.setException(e);
                }
                Trace.out("Verified that the message contained key ...");
                CopyListener.ActionType actionType = this.getActionTypeFromMsg(msg);
                Trace.out("Action type to be performed: " + actionType.toString());
                switch (actionType) {
                    case COPYFROMME: {
                        CopyFromMeHandler copyFromMe = new CopyFromMeHandler(msg, clientSocketInputStream, clientSocketOutputStream);
                        copyThread = new Thread(copyFromMe);
                        copyThread.start();
                        break;
                    }
                    case COPYTOME: {
                        CopyToMeHandler copyToMe = new CopyToMeHandler(msg, clientSocketInputStream, clientSocketOutputStream);
                        copyThread = new Thread(copyToMe);
                        copyThread.start();
                        break;
                    }
                }
            }
            catch (IOException e) {
                Trace.out("IOException: " + e.getMessage());
                throw new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "CopyListener-handleClientRequests");
            }
        }
    }

    private void verifyMessageContainsKey(String msg) throws CopyListenerException {
        if (msg == null || msg.trim().isEmpty() || !msg.contains(";==;")) {
            Trace.out("CopyListener-verifyMessageContainsKey Invalid Message");
            throw new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyL-verifyMessage01");
        }
        try {
            String[] vals = msg.split(";==;");
            String key = vals[0];
            if (!key.equals("qrm750k7aJFb")) {
                Trace.out("CopyListener-verifyMessageContainsKey Key not present");
                throw new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyL-verifyMessage02");
            }
        }
        catch (PatternSyntaxException e) {
            Trace.out("CopyListener-verifyMessageContainsKey PSE: " + e.getMessage());
            throw new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyL-verifyMessage03");
        }
    }

    private CopyListener.ActionType getActionTypeFromMsg(String msg) throws CopyListenerException {
        if (msg == null || msg.trim().isEmpty() || !msg.contains(";==;")) {
            Trace.out("CopyListener-getActionTypeFromMsg Invalid Message");
            throw new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyListener-getActionTypeFromMsg");
        }
        String actionTypeStr = msg.split(";==;")[1];
        CopyListener.ActionType actionType = null;
        try {
            actionType = CopyListener.ActionType.getEnumMember(actionTypeStr);
        }
        catch (EnumConstantNotPresentException e) {
            Trace.out("ActionType not identified in client message");
            throw new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "CopyListener-getActionTypeFromMsg");
        }
        return actionType;
    }

    class CopyToMeHandler
    implements Runnable {
        private String m_msg;
        private InputStream m_socketInputStream;
        private OutputStream m_socketOutputStream;

        public CopyToMeHandler(String msg, InputStream socketInputStream, OutputStream socketOutputStream) {
            this.m_msg = msg;
            this.m_socketInputStream = socketInputStream;
            this.m_socketOutputStream = socketOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.m_msg == null || this.m_msg.trim().isEmpty() || !this.m_msg.contains(";==;")) {
                Trace.out("CopyListener-getActionTypeFromMsg Invalid Message");
                CopyListenerImpl.setException(new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyToMeHandler-run"));
                return;
            }
            String destPath = null;
            StreamCopy sockIn2FileStream = null;
            Thread copyThread = null;
            OutputStream fileStream = null;
            PrintWriter sockWriter = null;
            try {
                destPath = CopyListenerImpl.this.m_filePath;
                sockWriter = new PrintWriter(this.m_socketOutputStream, true);
                Trace.out("Sending SEND ack ...");
                sockWriter.println("READYTORECEIVE");
                Trace.out("SEND ack sent");
                Trace.out("Making sure that directory structure exists ...");
                File destFile = new File(destPath);
                File parentDirectory = new File(destFile.getParentFile().getAbsolutePath());
                parentDirectory.mkdirs();
                Trace.out("Directory structure now exists");
                Trace.out("Copying file to location " + destPath);
                fileStream = new FileOutputStream(destPath);
                Semaphore copyWait = new Semaphore(1);
                sockIn2FileStream = new StreamCopy(this.m_socketInputStream, fileStream, false, copyWait);
                copyThread = new Thread(sockIn2FileStream);
                Trace.out("Starting copy thread on receiver side ... ");
                copyThread.start();
                copyThread.join();
                copyWait.acquire();
                Trace.out("Acquired stream copy semaphore ...");
                if (sockIn2FileStream.isTimedOut()) {
                    CopyListenerImpl.setException(new CopyListenerException((MessageKey)PrCcMsgID.CMD_HANGED, "COPY"));
                    return;
                }
                if (!sockIn2FileStream.isSuccess()) {
                    CopyListenerImpl.setException(sockIn2FileStream.getException());
                    return;
                }
                Trace.out("File copy successful ...");
            }
            catch (IOException e) {
                Trace.out("IOException: " + e.getMessage());
                CopyListenerImpl.setException(e);
            }
            catch (InterruptedException e) {
                Trace.out("InterruptedException: " + e.getMessage());
                CopyListenerImpl.setException(e);
            }
            finally {
                try {
                    Trace.out("Closing socket streams");
                    fileStream.close();
                    this.m_socketInputStream.close();
                    this.m_socketOutputStream.close();
                }
                catch (IOException e) {
                    Trace.out("Error closing streams");
                }
            }
        }
    }

    class CopyFromMeHandler
    implements Runnable {
        private String m_msg;
        private InputStream m_socketInputStream;
        private OutputStream m_socketOutputStream;

        public CopyFromMeHandler(String msg, InputStream socketInputStream, OutputStream socketOutputStream) {
            this.m_msg = msg;
            this.m_socketInputStream = socketInputStream;
            this.m_socketOutputStream = socketOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.m_msg == null || this.m_msg.trim().isEmpty() || !this.m_msg.contains(";==;")) {
                Trace.out("CopyListener-getActionTypeFromMsg Invalid Message");
                CopyListenerImpl.setException(new CopyListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyFromMeHandler-run"));
                return;
            }
            String srcPath = null;
            StreamCopy fileStream2SockOut = null;
            Thread copyThread = null;
            InputStream fileStream = null;
            try {
                srcPath = CopyListenerImpl.this.m_filePath;
                fileStream = new FileInputStream(srcPath);
                Semaphore copyWait = new Semaphore(1);
                fileStream2SockOut = new StreamCopy(fileStream, this.m_socketOutputStream, true, copyWait);
                copyThread = new Thread(fileStream2SockOut);
                Trace.out("Starting copy thread on sender side ... ");
                copyThread.start();
                copyWait.acquire();
                if (fileStream2SockOut.isTimedOut()) {
                    CopyListenerImpl.setException(new CopyListenerException((MessageKey)PrCcMsgID.CMD_HANGED, "COPY"));
                    return;
                }
                if (!fileStream2SockOut.isSuccess()) {
                    CopyListenerImpl.setException(fileStream2SockOut.getException());
                    return;
                }
                Trace.out("File copy successful ...");
            }
            catch (IOException e) {
                Trace.out("IOException: " + e.getMessage());
                CopyListenerImpl.setException(e);
            }
            catch (InterruptedException e) {
                Trace.out("InterruptedException: " + e.getMessage());
                CopyListenerImpl.setException(e);
            }
            finally {
                try {
                    Trace.out("Closing socket streams");
                    fileStream.close();
                    this.m_socketInputStream.close();
                    this.m_socketOutputStream.close();
                }
                catch (IOException e) {
                    Trace.out("Error closing streams");
                }
            }
        }
    }
}

