/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.remote.JSCHCopyCommand;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.ExecException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.ConcurrencyTimeoutException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class CopyCommandNoUserEqImpl {
    private static final String ROOT = oracle.cluster.impl.util.Utils.getRootUserName();
    private static final String QUALIFIED_CLASSNAME_WITHIN_SRVM_JAR = "oracle.cluster.remote.ExecCommand";
    private String expectLocation = null;
    private String scriptLocalPath;

    public CopyCommandNoUserEqImpl() {
        String osName = DeterminePlatform.getOSName();
        this.expectLocation = osName.equals("Solaris") || osName.equals("SunOS") ? "/usr/local/bin/expect" : "/usr/bin/expect";
        this.scriptLocalPath = Utils.isDevelopmentEnv() ? "opsm/admin/copyhelper.exp" : "srvm/admin/copyhelper.exp";
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, UserInfo userInfo, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        String user = userInfo.getUsername();
        if (user == null) {
            user = ROOT;
        }
        String password = userInfo.getPassword();
        oracle.cluster.impl.util.Utils.assertInput(sourceFile, "sourceFile");
        oracle.cluster.impl.util.Utils.assertInput(destFile, "destFile");
        this.validateUserPass(nodeList, user, password);
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap resultMap = new HashMap();
        try {
            JSCHCopyCommand[] cmdArr = new JSCHCopyCommand[nodeList.length];
            for (int i = 0; i < nodeList.length; ++i) {
                cmdArr[i] = new JSCHCopyCommand(sourceFile, nodeList[i], destFile, noPreserve, userInfo, timeout);
            }
            this.parallelExecute(cmdArr, timeout, nodeList, failedNodes, resultMap);
            Trace.out("Parallel execute ended successfully");
        }
        catch (InvalidArgsException e) {
            Trace.out("InvalidArgsException caught: " + e.getMessage());
            throw new InvalidArgsException(e);
        }
        catch (ConcurrencyException e) {
            Trace.out("ConcurrencyException caught: " + e.getMessage());
            throw new ExecException((MessageKey)PrCfMsgID.COPY_FAILED_NODES, (Throwable)e, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
        catch (ConcurrencyTimeoutException e) {
            Trace.out("ConcurrencyTimeoutException caught: " + e.getMessage());
            throw new ExecException((MessageKey)PrCfMsgID.COPY_FAILED_NODES, (Throwable)e, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
        catch (CompositeOperationException coe) {
            Trace.out("CompositeOperationException caught: " + coe.getMessage());
            throw new CompositeOperationException((MessageKey)PrCfMsgID.COPY_FAILED_NODES, coe.getResultMap(), oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, String user, String password, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        this.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, new UserInfo(user, password), timeout);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, String rootPassword, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        this.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, new UserInfo(ROOT, rootPassword), timeout);
    }

    private void parallelExecute(JSCHCopyCommand[] cmdArr, int timeout, String[] nodeList, List<String> failedNodes, Map resultMap) throws ConcurrencyException, CompositeOperationException, ConcurrencyTimeoutException {
        ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(cmdArr, timeout, new Version());
        threadExec.submit();
        for (int i = 0; i < cmdArr.length; ++i) {
            CommandResult cr = cmdArr[i].getCommandResult();
            resultMap.put(nodeList[i], cr);
            Trace.out("OS Error code for node " + nodeList[i] + ":" + cr.getOSErrCode());
            if (cr.getStatus() && cr.getOSErrCode() == 0) continue;
            Trace.out("The copy Command failed for node " + nodeList[i]);
            failedNodes.add(nodeList[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCfMsgID.COPY_FAILED_NODES, resultMap, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
    }

    private void validateUserPass(String[] nodeList, String username, String password) throws InvalidArgsException {
        if (nodeList == null || nodeList.length < 1) {
            Trace.out("Exception: nodeList is null or empty");
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        oracle.cluster.impl.util.Utils.assertInputNotNull(password, "password");
    }
}

