/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Semaphore;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.remote.CopyListenerImpl;
import oracle.cluster.impl.remote.ExecCommandImpl;
import oracle.cluster.remote.CopyClient;
import oracle.cluster.remote.CopyClientException;
import oracle.cluster.remote.CopyListener;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.StreamCopy;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CopyClientImpl
implements CopyClient {
    @Override
    public void copyFrom(String host, int port, String srcPath, String destPath) throws CopyClientException, InvalidArgsException {
        if (host == null || port < 0 || srcPath == null || srcPath.trim().isEmpty() || destPath == null || destPath.trim().isEmpty() || !new File(srcPath).exists()) {
            Trace.out("Invalid arguments");
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyClientImpl-copyFrom");
        }
        Socket socketConnection = null;
        InputStream socketInputStream = null;
        OutputStream socketOutputStream = null;
        BufferedReader socketReader = null;
        PrintWriter socketWriter = null;
        Thread copyThread = null;
        StreamCopy fileStream2SockOut = null;
        InputStream fileStream = null;
        try {
            Trace.out("Copying client side from " + srcPath + " to destination " + destPath);
            socketConnection = new Socket(host, port);
            socketInputStream = socketConnection.getInputStream();
            socketOutputStream = socketConnection.getOutputStream();
            socketWriter = new PrintWriter(socketOutputStream, true);
            Trace.out("Sending action type message to CopyListener");
            String msg = CopyListenerImpl.generateClientMsg(CopyListener.ActionType.COPYTOME, new String[0]);
            socketWriter.println(msg);
            Trace.out("Sent connection message " + msg + " ...");
            socketReader = new BufferedReader(new InputStreamReader(socketInputStream));
            String receivedMsg = null;
            receivedMsg = socketReader.readLine();
            if (receivedMsg != null) {
                Trace.out("Received (supposed to be ACK): " + receivedMsg);
                if (!receivedMsg.equals("READYTORECEIVE")) {
                    Trace.out("Received message was not a SEND ACK. Erroring out ...");
                    throw new CopyClientException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyClientImpl-copyFrom-ACK1");
                }
                Trace.out("Received SEND ACK ...");
            }
            fileStream = new FileInputStream(srcPath);
            Semaphore copyWait = new Semaphore(1);
            fileStream2SockOut = new StreamCopy(fileStream, socketOutputStream, true, copyWait);
            copyThread = new Thread(fileStream2SockOut);
            Trace.out("Starting file copy");
            copyThread.start();
            copyWait.acquire();
            if (fileStream2SockOut.isTimedOut()) {
                throw new CopyClientException((MessageKey)PrCcMsgID.CMD_HANGED, "copyFrom");
            }
            if (!fileStream2SockOut.isSuccess()) {
                Exception e = fileStream2SockOut.getException();
                Trace.out("Error in copying file stream to socket output stream: " + e.getMessage());
                throw new CopyClientException(e);
            }
            Trace.out("File copy successful");
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            throw new CopyClientException(e);
        }
        catch (InterruptedException e) {
            Trace.out("InterruptedException: " + e.getMessage());
            throw new CopyClientException(e);
        }
        finally {
            try {
                fileStream.close();
                socketInputStream.close();
                socketOutputStream.close();
            }
            catch (IOException e) {
                Trace.out("Error closing streams");
            }
        }
    }

    @Override
    public void copyTo(String host, int port, String srcPath, String destPath) throws CopyClientException, InvalidArgsException {
        if (host == null || port < 0 || srcPath == null || srcPath.trim().isEmpty() || destPath == null || destPath.trim().isEmpty()) {
            Trace.out("Invalid arguments");
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CopyClientImpl-copyTo");
        }
        Socket socketConnection = null;
        InputStream socketInputStream = null;
        OutputStream socketOutputStream = null;
        Object socketReader = null;
        PrintWriter socketWriter = null;
        Thread copyThread = null;
        StreamCopy sockIn2FileStream = null;
        OutputStream fileStream = null;
        try {
            socketConnection = new Socket(host, port);
            socketInputStream = socketConnection.getInputStream();
            socketOutputStream = socketConnection.getOutputStream();
            socketWriter = new PrintWriter(socketOutputStream, true);
            Trace.out("Sending action type message to CopyListener");
            String msg = CopyListenerImpl.generateClientMsg(CopyListener.ActionType.COPYFROMME, new String[0]);
            socketWriter.println(msg);
            Trace.out("Sent connection message " + msg + " ...");
            Trace.out("Making sure that directory structure exists ...");
            File destFile = new File(destPath);
            File parentDirectory = new File(destFile.getParentFile().getAbsolutePath());
            boolean isCreate = parentDirectory.mkdirs();
            Trace.out(isCreate ? "Directory created successfully" : "Directory not created");
            Trace.out("Directory structure now exists");
            fileStream = new FileOutputStream(destPath);
            Semaphore copyWait = new Semaphore(1);
            sockIn2FileStream = new StreamCopy(socketInputStream, fileStream, false, copyWait);
            copyThread = new Thread(sockIn2FileStream);
            Trace.out("Starting file copy");
            copyThread.start();
            copyWait.acquire();
            if (sockIn2FileStream.isTimedOut()) {
                throw new CopyClientException((MessageKey)PrCcMsgID.CMD_HANGED, "copyTo");
            }
            if (!sockIn2FileStream.isSuccess()) {
                Exception e = sockIn2FileStream.getException();
                Trace.out("Error in copying file stream to socket output stream: " + e.getMessage());
                throw new CopyClientException(e);
            }
            Trace.out("File copy successful");
            Trace.out("Changing file permission of the copied files using command /usr/bin/chmod");
            new ExecCommandImpl().runCmd("/usr/bin/chmod", new String[]{"755", destPath}, new String[0]);
            Trace.out("File permissions of copied files changed successfully.");
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            throw new CopyClientException(e);
        }
        catch (InterruptedException e) {
            Trace.out("InterruptedException: " + e.getMessage());
            throw new CopyClientException(e);
        }
        catch (ExecException e) {
            Trace.out("ExecException: " + e.getMessage());
            throw new CopyClientException(e);
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException: " + e.getMessage());
            throw new CopyClientException(e);
        }
        finally {
            try {
                fileStream.close();
                socketInputStream.close();
                socketOutputStream.close();
            }
            catch (IOException e) {
                Trace.out("Error closing streams");
            }
        }
    }
}

