/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.priv;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.resources.PrCzMsgID;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class JSChChannel
implements Constants {
    private String m_node;
    private String m_user;
    private String m_pwd;
    private int m_timeout;
    private ChannelMode m_cMode;
    private String m_sudoPbrunLocation;
    private String m_cmdOutput = null;
    private ChannelProgressListener m_cpListener;
    private boolean m_requireTty = false;
    private String m_asUser = null;
    private static final String PASSWORD_PROMPT_REGEX = ".*:( )*$";
    private final String SUDO_S = " -S ";
    private final String SHELL_CMD_BEGIN = "/usr/bin/sh -c '(";
    private final String SHELL_CMD_END = " )'";
    private final String EXPORT_CMD = "export ";
    private final String NOPASSWD_REG_EXP = "(?s).*\\((ALL|ALL :.*|root)\\) NOPASSWD: ALL.*";
    private final String AUTHENTICATE_NOT = "!authenticate";
    private final String AUTHENTICATE = "authenticate";
    private final String LISTPW_NOT = "!listpw";
    private final String LISTPW_NEVER = "listpw=never";
    private static final int MILLISECONDCONVERTER = 1000;
    private static boolean m_nopasswdConfigured = false;

    JSChChannel(String node, String user, String password, ChannelMode cm, String sudoPbrunLocation, int timeout, ChannelProgressListener cpListener, boolean requireTty) {
        this.m_node = node;
        this.m_user = user;
        this.m_pwd = password;
        this.m_cMode = cm;
        this.m_timeout = timeout;
        this.m_cpListener = cpListener;
        this.m_sudoPbrunLocation = sudoPbrunLocation;
        this.m_requireTty = requireTty;
    }

    JSChChannel(String node, String user, String password, ChannelMode cm, String sudoPbrunLocation, int timeout, ChannelProgressListener cpListener, boolean requireTty, String asUser) {
        this(node, user, password, cm, sudoPbrunLocation, timeout, cpListener, requireTty);
        this.m_asUser = asUser;
    }

    public CommandResult execCommand(String command, String[] nameEnv, String[] valueEnv) {
        return this.execCommand(command, nameEnv, valueEnv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execCommand(String command, String[] nameEnv, String[] valueEnv, String[] stdin) {
        CommandResult result = new CommandResult();
        OutputStreamWriter osw = null;
        OutputStream inps = null;
        String outputBeforePasswd = null;
        String Passphrase = "passphrase";
        String isRHPSU = System.getProperty("RHP_SU_EXEC");
        Session session = null;
        ChannelExec channel = null;
        try {
            boolean sudoOutWithoutPasswd;
            ByteArrayOutputStream es;
            int exitstatus;
            block71: {
                int i;
                StringBuilder cmdBuilder;
                Trace.out("Entered execCommand");
                Trace.out("Command is being run in " + (Object)((Object)this.m_cMode) + " mode.");
                JSch jsch = new JSch();
                exitstatus = 1;
                String knownHostsPath = Utils.getKnownHostsPath();
                try {
                    Trace.out("setting known hosts path to " + knownHostsPath);
                    jsch.setKnownHosts(knownHostsPath);
                }
                catch (JSchException je) {
                    Trace.out("jsch exception while creating host key repository from file " + knownHostsPath + " message " + je.getMessage());
                    throw new ChannelException((MessageKey)PrCzMsgID.CHANNEL_FAILED_KNOWN_HOSTS, (Throwable)je, knownHostsPath, this.m_node);
                }
                JSch.setLogger((Logger)new JschLogger());
                if (this.m_user == null && this.m_cMode == ChannelMode.ROOT) {
                    this.getRootUserInfo();
                }
                PrivUserInfo ui = new PrivUserInfo(this.m_pwd, Passphrase);
                String pubkeyPath = Utils.getRSADSAPath();
                Trace.out("pubkeypath is " + pubkeyPath);
                if (null != pubkeyPath && this.m_cMode != ChannelMode.ROOT) {
                    jsch.addIdentity(pubkeyPath, Passphrase);
                }
                session = jsch.getSession(this.m_user, this.m_node);
                Properties configProps = new Properties();
                configProps.put("PreferredAuthentications", "password,keyboard-interactive,publickey");
                session.setConfig(configProps);
                session.setPassword(this.m_pwd);
                session.setUserInfo((UserInfo)ui);
                if (command.trim().equals(this.m_sudoPbrunLocation + " -k")) {
                    this.m_cMode = ChannelMode.SHELL;
                }
                if (this.m_cMode == ChannelMode.SUDO) {
                    if (" -l".trim().equalsIgnoreCase(command.trim())) {
                        this.m_requireTty = true;
                    }
                    session.connect(this.m_timeout * 1000);
                    if (nameEnv != null) {
                        cmdBuilder = new StringBuilder();
                        if (null != isRHPSU && isRHPSU.equals("true")) {
                            Trace.out("Executing the SU cmd from /tmp for RHP");
                            cmdBuilder.append("cd /tmp; ");
                        }
                        cmdBuilder.append(this.m_sudoPbrunLocation + " -S " + "/usr/bin/sh -c '(");
                        for (i = 0; i < nameEnv.length; ++i) {
                            cmdBuilder.append(nameEnv[i] + "=" + valueEnv[i] + " ");
                        }
                        if (this.m_asUser == null) {
                            cmdBuilder.append(command + " )'");
                        } else {
                            command = command.replaceAll("\\{", "\\\\\\\\\\\\{");
                            command = command.replaceAll("\\}", "\\\\\\\\\\\\}");
                            cmdBuilder.append("/bin/su " + this.m_asUser + " " + "-c" + " " + "\"" + command + "\"" + " )'");
                        }
                        command = cmdBuilder.toString();
                        Trace.out("executing cmd =" + command);
                    } else if (null == this.m_asUser) {
                        cmdBuilder = new StringBuilder();
                        if (null != isRHPSU && isRHPSU.equals("true")) {
                            Trace.out("Executing the SU cmd from /tmp for RHP");
                            cmdBuilder.append("cd /tmp; ");
                        }
                        cmdBuilder.append(this.m_sudoPbrunLocation + " -S " + command);
                        command = cmdBuilder.toString();
                        Trace.out("executing cmd =" + command);
                    } else {
                        command = command.replaceAll("\\{", "\\\\\\\\\\\\{");
                        command = command.replaceAll("\\}", "\\\\\\\\\\\\}");
                        command = null != isRHPSU && isRHPSU.equals("true") ? "cd /tmp; " + this.m_sudoPbrunLocation + " -S " + "/usr/bin/sh -c '(" + "/bin/su" + " " + this.m_asUser + " " + "-c" + " " + "\"" + command + "\"" + " )'" : this.m_sudoPbrunLocation + " -S " + "/usr/bin/sh -c '(" + "/bin/su" + " " + this.m_asUser + " " + "-c" + " " + "\"" + command + "\"" + " )'";
                    }
                } else {
                    session.connect(this.m_timeout * 1000);
                    if (nameEnv != null) {
                        cmdBuilder = new StringBuilder();
                        if (null != isRHPSU && isRHPSU.equals("true")) {
                            Trace.out("Executing the SU cmd from /tmp for RHP");
                            cmdBuilder.append("cd /tmp; ");
                        }
                        for (i = 0; i < nameEnv.length; ++i) {
                            cmdBuilder.append(nameEnv[i] + "=" + valueEnv[i] + " ");
                        }
                        if (null != this.m_asUser) {
                            cmdBuilder.append("/bin/su " + this.m_asUser + " " + "-c" + " " + "'" + command + "'");
                        } else {
                            cmdBuilder.append(command);
                        }
                        command = cmdBuilder.toString();
                    } else if (null != this.m_asUser) {
                        if (null != isRHPSU && isRHPSU.equals("true")) {
                            Trace.out("Executing the SU cmd from /tmp for RHP");
                            command = "cd /tmp;/bin/su " + this.m_asUser + " " + "-c" + " " + "'" + command + "'";
                        } else {
                            command = "/bin/su " + this.m_asUser + " " + "-c" + " " + "'" + command + "'";
                        }
                    } else if (null != isRHPSU && isRHPSU.equals("true")) {
                        Trace.out("Going to temp directory prior to executing command.");
                        command = "cd /tmp; " + command;
                    }
                }
                Trace.out("command = " + command);
                boolean isSearchPrompt = true;
                if (command.trim().endsWith(" -l") || command.trim().endsWith(" -k") || command.trim().endsWith(" -V") || m_nopasswdConfigured) {
                    isSearchPrompt = false;
                }
                channel = (ChannelExec)session.openChannel("exec");
                if (this.m_requireTty) {
                    Trace.out("requiretty set to true on node " + this.m_node);
                    channel.setPty(true);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                channel.setOutputStream((OutputStream)os);
                es = new ByteArrayOutputStream();
                channel.setErrStream((OutputStream)es);
                if (nameEnv != null) {
                    for (int i2 = 0; i2 < nameEnv.length; ++i2) {
                        Trace.out("setting env variable " + nameEnv[i2] + "=" + valueEnv[i2]);
                        channel.setEnv(nameEnv[i2], valueEnv[i2]);
                    }
                }
                channel.setCommand(command);
                if (this.m_cMode == ChannelMode.SUDO || stdin != null && stdin.length > 0) {
                    try {
                        Trace.out("Writing the sudo password/stdin");
                        inps = channel.getOutputStream();
                        osw = new OutputStreamWriter(inps);
                    }
                    catch (IOException ioe) {
                        Trace.out("IOE executing " + command + " on node " + this.m_node);
                        throw new ChannelException((MessageKey)PrCzMsgID.CHANNEL_FAILED, (Throwable)ioe, this.m_node, command);
                    }
                }
                channel.connect();
                if (null != this.m_cpListener) {
                    this.m_cpListener.updateStatus("START", this.m_node);
                }
                sudoOutWithoutPasswd = false;
                if (this.m_cMode != ChannelMode.SUDO && (stdin == null || stdin.length <= 0)) break block71;
                try {
                    block74: {
                        block72: {
                            block75: {
                                block73: {
                                    outputBeforePasswd = command.trim().endsWith(" -l") || this.m_requireTty && !m_nopasswdConfigured ? this.waitTerminalLaunch(os, es, isSearchPrompt) : es.toString();
                                    Trace.out("output before input is entered is " + outputBeforePasswd);
                                    if (!command.trim().endsWith(" -l") || outputBeforePasswd == null) break block72;
                                    int authIndex = outputBeforePasswd.lastIndexOf("!authenticate");
                                    int authIndex2 = outputBeforePasswd.lastIndexOf("authenticate");
                                    if (!outputBeforePasswd.matches("(?s).*\\((ALL|ALL :.*|root)\\) NOPASSWD: ALL.*") && (authIndex == -1 || authIndex2 - authIndex != 1)) break block73;
                                    Trace.out("sudo is configured for no password configuration on node " + this.m_node + "\n sudo -l output is: " + outputBeforePasswd);
                                    m_nopasswdConfigured = true;
                                    break block74;
                                }
                                if (!outputBeforePasswd.contains("!listpw") && !outputBeforePasswd.contains("listpw=never")) break block75;
                                Trace.out("sudo -l output is : " + outputBeforePasswd);
                                sudoOutWithoutPasswd = true;
                                break block74;
                            }
                            es.reset();
                            if (osw != null) {
                                osw.write(this.m_pwd);
                                osw.write(LINE_SEPARATOR);
                                osw.flush();
                                Trace.out("after writing password");
                            }
                            if (new InputStreamReader(channel.getInputStream()).ready() || outputBeforePasswd.matches(PASSWORD_PROMPT_REGEX)) break block74;
                            Trace.out("sudo -l output is : " + outputBeforePasswd);
                            sudoOutWithoutPasswd = true;
                            break block74;
                        }
                        es.reset();
                        if (!m_nopasswdConfigured && this.m_cMode == ChannelMode.SUDO && osw != null) {
                            osw.write(this.m_pwd);
                            osw.write(LINE_SEPARATOR);
                            osw.flush();
                            Trace.out("after writing password");
                        }
                        if (stdin != null && stdin.length > 0) {
                            for (String input : stdin) {
                                if (osw == null) continue;
                                osw.write(input);
                                osw.write(LINE_SEPARATOR);
                                osw.flush();
                                Trace.out("after writing stdin");
                            }
                        }
                    }
                    osw.close();
                }
                catch (IOException ioe) {
                    Trace.out("IOE executing " + command + " on node " + this.m_node);
                    throw new ChannelException((MessageKey)PrCzMsgID.CHANNEL_FAILED, (Throwable)ioe, this.m_node, command);
                }
            }
            try {
                InputStream in;
                if (command.trim().endsWith(" -l") && (sudoOutWithoutPasswd || m_nopasswdConfigured)) {
                    Trace.out("Using output before password");
                    in = new ByteArrayInputStream(outputBeforePasswd.getBytes());
                } else {
                    Trace.out("Using output after password/stdin have been written");
                    in = channel.getInputStream();
                }
                InputStreamReader inStream = new InputStreamReader(in);
                BufferedReader bufReader = new BufferedReader(inStream);
                String thisLine = null;
                while (true) {
                    if (bufReader.ready()) {
                        thisLine = bufReader.readLine();
                        Trace.out("read line is " + thisLine);
                        if (this.m_cpListener != null && this.m_cpListener instanceof NodeProgressListener) {
                            Trace.out("writing to listener: " + thisLine);
                            ((NodeProgressListener)this.m_cpListener).write(this.m_node, thisLine);
                        }
                        if (this.m_cmdOutput == null) {
                            this.m_cmdOutput = thisLine;
                            continue;
                        }
                        this.m_cmdOutput = this.m_cmdOutput + LINE_SEPARATOR + thisLine;
                        continue;
                    }
                    if (channel.isClosed()) {
                        exitstatus = channel.getExitStatus();
                        Trace.out("Exit Status from channel is " + exitstatus);
                        Trace.out("output is " + this.m_cmdOutput);
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ee) {
                        Trace.out("interrupted while waiting for cmd to write " + ee.getMessage());
                    }
                }
            }
            catch (IOException ioe) {
                try {
                    Trace.out("IOE executing " + command + " on node " + this.m_node);
                    throw new ChannelException((MessageKey)PrCzMsgID.CHANNEL_FAILED, (Throwable)ioe, this.m_node, command);
                }
                catch (Throwable throwable) {
                    Trace.out("end of command execution");
                    if (null != this.m_cpListener) {
                        this.m_cpListener.updateStatus("STOP", this.m_node);
                    }
                    channel.disconnect();
                    session.disconnect();
                    Trace.out("after disconnecting from channel");
                    if (this.m_cmdOutput != null && this.m_cmdOutput.toString().length() != 0) {
                        Trace.out("Received output :" + this.m_cmdOutput.toString() + ": from node " + this.m_node);
                        result.setOutputString(new String[]{this.m_cmdOutput.toString().trim()});
                        result.setResultString(new String[]{this.m_cmdOutput.toString().trim()});
                    }
                    if (es != null && es.size() > 0) {
                        Trace.out("error stream output is " + es.toString());
                        result.setOSString(es.toString().trim());
                    }
                    result.setOSErrCode(exitstatus);
                    result.setStatus(true);
                    throw throwable;
                }
            }
            Trace.out("end of command execution");
            if (null != this.m_cpListener) {
                this.m_cpListener.updateStatus("STOP", this.m_node);
            }
            channel.disconnect();
            session.disconnect();
            Trace.out("after disconnecting from channel");
            if (this.m_cmdOutput != null && this.m_cmdOutput.toString().length() != 0) {
                Trace.out("Received output :" + this.m_cmdOutput.toString() + ": from node " + this.m_node);
                result.setOutputString(new String[]{this.m_cmdOutput.toString().trim()});
                result.setResultString(new String[]{this.m_cmdOutput.toString().trim()});
            }
            if (es != null && es.size() > 0) {
                Trace.out("error stream output is " + es.toString());
                result.setOSString(es.toString().trim());
            }
            result.setOSErrCode(exitstatus);
            result.setStatus(true);
        }
        catch (JSchException e) {
            Trace.out("jsch exception while executing command " + command + " on node " + this.m_node + " message " + e.getMessage());
            ChannelException ce = new ChannelException((MessageKey)PrCzMsgID.CHANNEL_FAILED, (Throwable)e, this.m_node, command);
            result.setException(ce);
        }
        catch (ChannelException e) {
            Trace.out("channel exception whie executing command " + command + " on node " + this.m_node + " message " + e.getMessage());
            result.setException(e);
        }
        finally {
            Trace.out("Make sure that channel and session are disconnected");
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
        return result;
    }

    private void getRootUserInfo() {
        this.m_user = Utils.getRootUserName();
    }

    private String waitTerminalLaunch(ByteArrayOutputStream os, ByteArrayOutputStream es, boolean searchPromptPass) {
        String output = null;
        while (true) {
            Trace.out("reading output streams");
            output = es.toString();
            if (output != null && output.length() > 0) {
                Trace.out("error stream was written to: " + output);
                if (!searchPromptPass) break;
                if (output.matches(PASSWORD_PROMPT_REGEX)) {
                    Trace.out("Password prompt detected. Breaking");
                    break;
                }
            }
            if ((output = os.toString()) != null && output.length() > 0) {
                Trace.out("output stream was written to:" + output);
                if (!searchPromptPass) break;
                if (output.matches(PASSWORD_PROMPT_REGEX)) {
                    Trace.out("Password prompt detected. Breaking");
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        return output;
    }

    public static class PrivUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private volatile String m_Password = null;
        private volatile String m_Passphrase = null;
        boolean m_bConfirm = false;

        public PrivUserInfo(String password, String passphrase) {
            this.m_Password = password;
            this.m_Passphrase = passphrase;
        }

        public String getPassword() {
            Trace.out("returning password");
            return this.m_Password;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (prompt == null) {
                return null;
            }
            if (prompt.length > 0) {
                Trace.out("prompting user in keyboard interactive interaction: " + instruction + " : prompt: " + prompt[0] + " : echo: " + echo[0] + " : destination: " + destination);
            } else {
                Trace.out("prompting user in keyboard interactive interaction: " + instruction + " : destination: " + destination);
            }
            String[] response = new String[prompt.length];
            for (int i = 0; i < response.length; ++i) {
                response[i] = this.m_Password;
            }
            return response;
        }

        public boolean promptYesNo(String message) {
            Trace.out("prompt user for yes/no answer: " + message);
            return true;
        }

        public String getPassphrase() {
            Trace.out("return user passphrase");
            return this.m_Passphrase;
        }

        public boolean promptPassphrase(String message) {
            Trace.out("prompting user for passphrase: " + message);
            return true;
        }

        public boolean promptPassword(String message) {
            Trace.out("prompting user for password: " + message);
            return true;
        }

        public void showMessage(String message) {
            Trace.out(message);
        }
    }

    public static class JschLogger
    implements Logger {
        public boolean isEnabled(int level) {
            return Trace.isTraceEnabled();
        }

        public void log(int level, String message) {
            Trace.out(message);
        }
    }

    static enum ChannelMode {
        SUDO,
        ROOT,
        PBRUN,
        SHELL;

    }
}

