/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.policy;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.PolicySetter;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.ConfigPolicySet;
import oracle.cluster.policy.ConfigPolicySetException;
import oracle.cluster.policy.DatabaseRank;
import oracle.cluster.resources.PrCpMsgID;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.CryptoUtil;
import oracle.cluster.util.CryptoUtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ConfigPolicySetImpl
extends ManageableEntityImpl
implements ConfigPolicySet {
    protected List<ConfigPolicy> m_configPolicies;
    protected Set<String> m_poolNames = new HashSet<String>();
    protected String m_policyToActivate;
    protected String m_lastActivatedPolicy;

    @Override
    public List<ConfigPolicy> getConfigPolicies() {
        return this.m_configPolicies;
    }

    @Override
    public String lastActivatedPolicy() {
        return this.m_lastActivatedPolicy;
    }

    @Override
    public void setLastActivatedPolicy(String pName) {
        this.m_lastActivatedPolicy = pName;
    }

    @Override
    public void setPolicyToActivate(String policy) throws ConfigPolicySetException {
        if (null == policy) {
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_PARAMETER, policy);
        }
        this.m_policyToActivate = policy;
    }

    @Override
    public void setServerPoolNames(Set<String> poolNames) throws ConfigPolicySetException {
        if (null == poolNames) {
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_PARAMETER, poolNames);
        }
        this.m_poolNames = poolNames;
    }

    @Override
    public List<String> getServerPoolNames() {
        ArrayList<String> poolList = new ArrayList<String>(this.m_poolNames);
        return poolList;
    }

    @Override
    public void setPolicyList(List<ConfigPolicy> policyList) throws ConfigPolicySetException {
        if (null == policyList) {
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_PARAMETER, policyList);
        }
        this.m_configPolicies = policyList;
    }

    @Override
    public void register(boolean keepPools) throws ConfigPolicySetException, ServerGroupException, ConfigPolicyException {
        this.register(keepPools, true);
    }

    @Override
    public void register(boolean keepPools, boolean force) throws ConfigPolicySetException, ConfigPolicyException, ServerGroupException {
        this.register(keepPools, force, false);
    }

    protected void register(boolean keepPools, boolean force, boolean ignoreLastActivatePol) throws ConfigPolicySetException, ServerGroupException, ConfigPolicyException {
        this.validatePSData();
        Trace.out("data validated....all data correct");
        PolicySetter ps = new PolicySetter();
        CRSNative crn = new CRSNative();
        Trace.out("server pool names" + this.m_poolNames);
        Trace.out("last act pol name:::" + this.m_policyToActivate);
        try {
            if (this.m_policyToActivate != null) {
                this.ensurePolicyExistence(this.m_policyToActivate);
                String pol2act = new CryptoUtil().byte2Hex(new CryptoUtil().getHash(this.m_policyToActivate));
                ps.setPolicyToActivate(pol2act);
            }
        }
        catch (CryptoUtilException cue) {
            throw new ConfigPolicySetException(cue);
        }
        try {
            ps.setServerPoolNames(this.cvt2String(new ArrayList<String>(this.m_poolNames)));
        }
        catch (ServerException se) {
            throw new ServerGroupException(se);
        }
        ArrayList<PolicySetter.InternalPolicy> inpList = new ArrayList<PolicySetter.InternalPolicy>();
        for (ConfigPolicy cp : this.m_configPolicies) {
            String codedPolicyName;
            List<ServerPool> poolList = cp.getSPList();
            try {
                codedPolicyName = new CryptoUtil().byte2Hex(new CryptoUtil().getHash(cp.getName()));
            }
            catch (CryptoUtilException cue) {
                throw new ConfigPolicySetException(cue);
            }
            PolicySetter.InternalPolicy inp = ps.createInternalPolicy(codedPolicyName);
            Trace.out("policy name passed" + codedPolicyName);
            inp.setDescription("SRVM:" + cp.getName());
            ArrayList<PolicySetter.InternalPolicy.InternalSP> insList = new ArrayList<PolicySetter.InternalPolicy.InternalSP>();
            for (ServerPool sp : poolList) {
                Trace.out("server pool name" + sp.getName());
                Trace.out("server pool max" + sp.getMaxSize());
                Trace.out("server pool min" + sp.getMinSize());
                Trace.out("server pool imp" + sp.getImportance());
                PolicySetter.InternalPolicy.InternalSP ins = inp.createInternalSP(sp.getName());
                ins.setSpoolMax(sp.getMaxSize());
                ins.setSpoolMin(sp.getMinSize());
                ins.setSpoolImp(sp.getImportance());
                insList.add(ins);
            }
            inp.setSPList(insList);
            List<DatabaseRank> dbList = cp.getDBList();
            ArrayList<PolicySetter.InternalPolicy.InternalRes> insResList = new ArrayList<PolicySetter.InternalPolicy.InternalRes>();
            for (DatabaseRank db : dbList) {
                Trace.out("Database name " + db.getName());
                PolicySetter.InternalPolicy.InternalRes ins = inp.createInternalRes(db.getName(), db.getRank());
                Trace.out("Resource rank " + db.getRank());
                insResList.add(ins);
            }
            inp.setResList(insResList);
            inpList.add(inp);
        }
        ps.setPolicyList(inpList);
        ps.setKeepPoolsFlag(keepPools);
        ps.setForceFlag(force);
        ps.setIgnoreLastActivatedPol(ignoreLastActivatePol);
        try {
            CRSNative.regPolicySet(ps);
        }
        catch (CRSException e) {
            throw new ConfigPolicySetException(e);
        }
    }

    private String cvt2String(List<String> spList) throws ServerException {
        StringBuffer sb1 = new StringBuffer();
        ServerFactory sf = ServerFactory.getInstance();
        for (String s1 : spList) {
            sb1.append(sf.getServerGroupEntityName(s1) + " ");
        }
        Trace.out("cv2String = " + sb1.toString());
        return sb1.toString();
    }

    private String cvt2String1(List<String> stringList) {
        StringBuffer sb1 = new StringBuffer();
        String separator = System.getProperty("line.separator");
        for (String s1 : stringList) {
            sb1.append(s1);
            sb1.append(separator);
        }
        Trace.out("cvt2String1 returns" + sb1.toString());
        return sb1.toString();
    }

    private void ensurePolicyExistence(String pName) throws ConfigPolicySetException {
        ArrayList<String> polNames = new ArrayList<String>();
        for (ConfigPolicy cp : this.m_configPolicies) {
            polNames.add(cp.getName());
        }
        if (!polNames.contains(pName)) {
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_PARAMETER, pName);
        }
    }

    private void validatePSData() throws ConfigPolicySetException, ConfigPolicyException {
        Trace.out("Validating PolicySet data...");
        HashSet<String> poolSetForPolicySet = new HashSet<String>(this.m_poolNames);
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<String> policyNames = new ArrayList<String>();
        if (this.m_poolNames.size() != poolSetForPolicySet.size()) {
            String err = new ConfigPolicySetException((MessageKey)PrCpMsgID.DUPLICATE_SERVER_POOLS_FOUND_FOR_POLICYSET, this.m_poolNames).getMessage();
            errorMessages.add(err);
        }
        List<Object> dbPolicies = new ArrayList();
        for (int i = 0; i < this.m_configPolicies.size(); ++i) {
            String err;
            HashSet poolSet;
            ConfigPolicy cp = this.m_configPolicies.get(i);
            List<ServerPool> spList = cp.getSPList();
            ArrayList<String> poolNamesForPolicy = new ArrayList<String>();
            policyNames.add(cp.getName());
            List<DatabaseRank> dbList = cp.getDBList();
            for (int j = 0; j < spList.size(); ++j) {
                poolNamesForPolicy.add(spList.get(j).getName());
            }
            Trace.out("Validating Database data..." + dbList.toString());
            if (0 == i) {
                dbPolicies = dbList;
            }
            if ((poolSet = new HashSet(poolNamesForPolicy)).size() != poolSetForPolicySet.size()) {
                Trace.out("Unexpected number of Server Pools found in policy " + cp.getName());
                err = new ConfigPolicySetException((MessageKey)PrCpMsgID.DUPLICATE_SERVER_POOLS_FOUND_FOR_POLICY, cp.getName(), poolNamesForPolicy).getMessage();
                errorMessages.add(err);
            }
            if (!poolSet.containsAll(this.m_poolNames)) {
                err = new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_SERVER_POOL_LIST, poolNamesForPolicy, cp.getName()).getMessage();
                errorMessages.add(err);
            }
            if (dbPolicies.containsAll(dbList) && dbList.containsAll(dbPolicies)) continue;
            err = new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_RESOURCE_LIST, dbList, cp.getName()).getMessage();
            errorMessages.add(err);
        }
        HashSet policySet = new HashSet(policyNames);
        if (policySet.size() != policyNames.size()) {
            String err = new ConfigPolicySetException((MessageKey)PrCpMsgID.DUPLICATE_POLICIES_FOUND, policyNames).getMessage();
            errorMessages.add(err);
        }
        if (errorMessages.size() > 0) {
            String combinedErrorMessage = this.cvt2String1(errorMessages);
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.POLICYSET_INPUT_VALIDATION_FAILED, combinedErrorMessage);
        }
    }

    public String mangleName(String name) throws ConfigPolicySetException {
        StringBuffer ostr = new StringBuffer();
        if (name == null) {
            throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INVALID_PARAMETER, name);
        }
        for (int i = 0; i < name.length(); ++i) {
            ostr.append("\\u");
            String hex = null;
            Charset chSet1 = Charset.defaultCharset();
            String chSet = chSet1.toString();
            hex = chSet.equals("US-ASCII") ? Integer.toHexString(name.charAt(i) & 0xFF) : (chSet.equals("UTF-8") ? Integer.toHexString(name.charAt(i) & 0xFF) : (chSet.equals("UTF-16") ? Integer.toHexString(name.charAt(i) & 0xFFFF) : Integer.toHexString(name.charAt(i) & 0xFFFFFFFF)));
            for (int j = 0; j < 4 - hex.length(); ++j) {
                ostr.append("0");
            }
            ostr.append(hex.toLowerCase());
        }
        return new String(ostr);
    }
}

