/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.PolicyGetter;
import oracle.cluster.impl.policy.ConfigPolicySetImpl;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.ConfigPolicySet;
import oracle.cluster.policy.ConfigPolicySetException;
import oracle.cluster.resources.PrCpMsgID;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.CryptoUtil;
import oracle.cluster.util.CryptoUtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ConfigPolicySetFactoryImpl {
    private static ConfigPolicySetFactoryImpl s_instance;
    private static final String CURRENT_POLICY = "Current";
    private static final String FREE_POLICY = "Free";

    private ConfigPolicySetFactoryImpl() {
        Trace.out("Private constructor for ConfigPolicySetFactoryImpl");
    }

    public static synchronized ConfigPolicySetFactoryImpl getInstance() {
        if (null == s_instance) {
            s_instance = new ConfigPolicySetFactoryImpl();
        }
        return s_instance;
    }

    public void activatePolicy(String pName, boolean force) throws ConfigPolicyException, CRSException {
        try {
            String mangledName = new CryptoUtil().byte2Hex(new CryptoUtil().getHash(pName));
            CRSNative.activatePolicy(mangledName, force);
        }
        catch (CryptoUtilException cue) {
            throw new ConfigPolicyException(cue);
        }
    }

    public ConfigPolicy getLastActivatedPolicy() throws ConfigPolicyException, ConfigPolicySetException, SoftwareModuleException, ServerException {
        PolicyGetter pg = new PolicyGetter();
        try {
            CRSNative.getPolicySet(pg);
        }
        catch (CRSException e) {
            throw new ConfigPolicyException(e);
        }
        Map<String, ConfigPolicy> polMap = pg.getPolicyMap();
        String lastActivatedPolicy = pg.getLastActPol();
        ConfigPolicy cp = polMap.get(lastActivatedPolicy);
        return cp;
    }

    public ConfigPolicy getCurrentPolicy() throws ConfigPolicyException, ConfigPolicySetException, SoftwareModuleException, ServerException {
        PolicyGetter pg = new PolicyGetter(true);
        try {
            CRSNative.getPolicySet(pg);
        }
        catch (CRSException e) {
            throw new ConfigPolicyException(e);
        }
        Map<String, ConfigPolicy> polMap = pg.getPolicyMap();
        ConfigPolicy cp = polMap.get(CURRENT_POLICY);
        return cp;
    }

    public ConfigPolicySet getConfigPolicySet() throws ConfigPolicySetException, SoftwareModuleException, ConfigPolicyException, ServerException {
        PolicyGetter pg;
        ConfigPolicySetImpl cps;
        block4: {
            cps = new ConfigPolicySetImpl();
            pg = new PolicyGetter();
            try {
                CRSNative.getPolicySet(pg);
            }
            catch (CRSException e) {
                CRSNativeException ne;
                Throwable thr = e.getCause();
                if (thr == null || CRSNativeException.class.isInstance(thr)) {
                    // empty if block
                }
                if ((ne = (CRSNativeException)thr).getStatus() != 184) break block4;
                throw new ConfigPolicySetException((MessageKey)PrCpMsgID.POLICYSET_RETRIEVAL_FAILED, new Object[0]);
            }
        }
        cps.setLastActivatedPolicy(pg.getLastActPol());
        if (pg.getSpoolsForPset() != null && !pg.getSpoolsForPset().trim().isEmpty()) {
            cps.setServerPoolNames(new HashSet<String>(new ArrayList<String>(Arrays.asList(pg.getSpoolsForPset().split(" ")))));
        }
        cps.setPolicyList(pg.getCpList());
        return cps;
    }

    public ConfigPolicySet createConfigPolicySet() throws ConfigPolicySetException, SoftwareModuleException, ConfigPolicyException, ServerException {
        return new ConfigPolicySetImpl();
    }

    public static void removeDatabases() throws ConfigPolicySetException {
        ConfigPolicySetFactoryImpl configPolSetFactory = ConfigPolicySetFactoryImpl.getInstance();
        try {
            ConfigPolicySetImpl configPolicySet = (ConfigPolicySetImpl)configPolSetFactory.getConfigPolicySet();
            configPolicySet.register(true, true, true);
        }
        catch (ConfigPolicyException e) {
            throw new ConfigPolicySetException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ConfigPolicySetException(e);
        }
        catch (ServerException e) {
            throw new ConfigPolicySetException(e);
        }
    }
}

