/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.oc4j;

import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.oc4j.OC4JImpl;
import oracle.cluster.oc4j.OC4J;
import oracle.cluster.oc4j.OC4JException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.trace.Trace;

public class OC4JFactoryImpl {
    private final String LINUX_Z_SERIES_ARCH = "s390x";
    private static OC4JFactoryImpl s_cntrFactory;

    private OC4JFactoryImpl() {
    }

    public static synchronized OC4JFactoryImpl getInstance() {
        if (null == s_cntrFactory) {
            s_cntrFactory = new OC4JFactoryImpl();
        }
        return s_cntrFactory;
    }

    public OC4J createOC4J(Version version) throws AlreadyExistsException, OC4JException {
        return this.createOC4J(version, false);
    }

    public OC4J createOC4J(Version version, boolean isQOSMSrv) throws AlreadyExistsException, OC4JException {
        return this.createOC4J(version, isQOSMSrv, false);
    }

    public OC4J createOC4J(Version version, boolean isQOSMSrv, boolean isTLSEnabled) throws AlreadyExistsException, OC4JException {
        try {
            OC4JImpl cntrImpl = new OC4JImpl(CRSFactoryImpl.getInstance().create(ResourceType.OC4J.NAME.name(), OC4JImpl.getResourceName(isQOSMSrv)), isQOSMSrv);
            cntrImpl.create(version, isTLSEnabled);
            return cntrImpl;
        }
        catch (SoftwareModuleException e) {
            throw new OC4JException(e);
        }
        catch (CRSException e) {
            throw new OC4JException(e);
        }
    }

    public OC4J getOC4J() throws NotExistsException, OC4JException {
        return this.getOC4J(false);
    }

    public OC4J getOC4J(boolean isQOSMSrv) throws NotExistsException, OC4JException {
        try {
            OC4JImpl cntrImpl = new OC4JImpl(CRSFactoryImpl.getInstance().create(ResourceType.OC4J.NAME.name(), OC4JImpl.getResourceName(isQOSMSrv)), isQOSMSrv);
            CRSResource crsRes = cntrImpl.crsResource();
            return cntrImpl;
        }
        catch (CRSException e) {
            throw new OC4JException(e);
        }
        catch (SoftwareModuleException e) {
            throw new OC4JException(e);
        }
    }

    public void upgradeOC4J12102To122FirstPhase() throws UpgradeException {
        boolean isHPUXZLinux = false;
        boolean oc4jexists = true;
        OC4J oc4jRes = null;
        OC4J qosmSrvRes = null;
        String osName = DeterminePlatform.getOSName();
        Trace.out("OS name[" + osName + "]");
        Trace.out("Arch [" + System.getProperty("os.arch") + "]");
        try {
            if (osName.equals("Linux") && System.getProperty("os.arch").equals("s390x") || osName.equals("HP-UX")) {
                Trace.out("HPUX or Linux Z series: true");
                isHPUXZLinux = true;
            }
            oc4jRes = this.getOC4J();
        }
        catch (NotExistsException e) {
            oc4jexists = false;
        }
        catch (OC4JException oce) {
            Trace.out("OC4J exception:" + oce);
            throw new UpgradeException(oce);
        }
        if (!isHPUXZLinux) {
            try {
                qosmSrvRes = this.createOC4J(Version.get122Version(), true);
                if (oc4jexists) {
                    qosmSrvRes.setPort(oc4jRes.port());
                    qosmSrvRes.setHttpPort(oc4jRes.getHttpPort());
                }
            }
            catch (OC4JException oce) {
                Trace.out("OC4J exception:" + oce);
                throw new UpgradeException(oce);
            }
            catch (AlreadyExistsException aee) {
                Trace.out((Object)"Ignoring %s", aee.getClass().getSimpleName());
            }
        }
    }

    public void upgradeOC4J12102To122LastPhase() throws UpgradeException {
        boolean isHPUXZLinux = false;
        String osName = DeterminePlatform.getOSName();
        Trace.out("OS name[" + osName + "]");
        Trace.out("Arch [" + System.getProperty("os.arch") + "]");
        if (osName.equals("Linux") && System.getProperty("os.arch").equals("s390x") || osName.equals("HP-UX")) {
            Trace.out("HPUX or Linux Z series: true");
            isHPUXZLinux = true;
        }
        try {
            OC4J oc4jRes = this.getOC4J();
            try {
                if (oc4jRes.isRunning()) {
                    Trace.out("Stopping OC4J resource");
                    oc4jRes.stop(true);
                }
            }
            catch (AlreadyStoppedException ase) {
                Trace.out("OC4J already stopped, not an error");
            }
            oc4jRes.remove(true);
        }
        catch (AlreadyRunningException are) {
            Trace.out("QOSmServer already running");
        }
        catch (NotExistsException nee) {
            Trace.out("OC4J not configured, not an error");
        }
        catch (OC4JException oe) {
            throw new UpgradeException(oe);
        }
        catch (SoftwareModuleException sme) {
            throw new UpgradeException(sme);
        }
        this.startQoSMServer(isHPUXZLinux);
    }

    private void startQoSMServer(boolean isHPUXZLinux) throws UpgradeException {
        OC4J qosmSrvRes = null;
        if (!isHPUXZLinux) {
            try {
                qosmSrvRes = this.getOC4J(true);
                qosmSrvRes.start();
            }
            catch (OC4JException oe) {
                throw new UpgradeException(oe);
            }
            catch (NotExistsException neeq) {
                throw new UpgradeException(neeq);
            }
            catch (SoftwareModuleException sme) {
                throw new UpgradeException(sme);
            }
            catch (AlreadyRunningException are) {
                Trace.out("QOSmServer already running");
            }
        }
    }
}

