/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.Service;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.network.GlobalNetworkClassificationImpl;
import oracle.cluster.impl.network.SubnetImpl;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.trace.Trace;

public class VIPImpl
extends SoftwareModuleImpl
implements oracle.cluster.nodeapps.VIP {
    protected ResourceAttribute m_nameAttr;

    protected VIPImpl() {
    }

    VIPImpl(ResourceAttribute nameAttr) throws VIPException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.NAME.name())) {
                throw new VIPException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.ClusterVIP.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !".vip".toString().equalsIgnoreCase(String.valueOf('.') + value[2])) {
                throw new VIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ClusterVIP.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            this.m_displayName = attr.getValue();
            if (this.m_displayName.trim().equals("")) {
                this.m_displayName = value[1];
            }
        }
        catch (NotExistsException value) {
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
    }

    void create(VIPAddress vipAddress, String prefNode, int netNum, String subnetStr, DHCPServerType serverType, Version version) throws AlreadyExistsException, VIPException {
        this.create(vipAddress, prefNode, netNum, subnetStr, serverType, version, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create(VIPAddress vipAddress, String prefNode, int netNum, String subnetStr, DHCPServerType serverType, Version version, VIPAddress natAddress) throws AlreadyExistsException, VIPException {
        block42: {
            try {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
            catch (SoftwareModuleException sme) {
                throw new VIPException(sme);
            }
            NetworkImpl networkImpl = null;
            VIPException vipException = null;
            boolean netCreated = false;
            try {
                Network network;
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
                ResourceAttribute vipNetTypeAttr = crsFactory.create(ResourceType.ClusterVIP.NAME.name(), ResourceType.ClusterVIP.getVIPNetTypeName(netNum));
                if (!crsFactory.isRegistered(netAttr.getValue(), CRSEntity.Type.Resource)) {
                    networkImpl = new NetworkImpl(netAttr);
                    networkImpl.create(serverType, new GlobalNetworkClassificationImpl(vipAddress.getNetmask(), subnetStr, vipAddress.getInterfaces()), version);
                    network = networkImpl;
                } else {
                    network = NodeAppsFactoryImpl.getInstance().getNetwork(String.valueOf(netNum));
                }
                boolean isOPCEnv = false;
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                try {
                    isOPCEnv = clusterwareInfo.isOPCEnv();
                }
                catch (InstallException ie) {
                    Trace.out("Error detecting if OPC env. Details:\n" + ie.getMessage());
                    throw new VIPException(ie);
                }
                boolean isODALite = false;
                boolean isODASingleIP = false;
                if (!isOPCEnv) {
                    try {
                        isODALite = clusterwareInfo.isODALiteEnv();
                        if (!isODALite) {
                            isODASingleIP = clusterwareInfo.isODASingleIPEnv();
                        }
                    }
                    catch (InstallException ie) {
                        Trace.out("Error detecting if ODA Lite or ODA Single IP env. Details:\n" + ie.getMessage());
                        throw new VIPException(ie);
                    }
                }
                if (!(isOPCEnv || isODALite || isODASingleIP)) {
                    this.validateNetmask(vipAddress, network);
                }
                this.assertNettype(vipAddress, network);
                this.create(network, vipAddress.getUsrVIP(), vipAddress.getIPAddrType(), prefNode, version, natAddress, isOPCEnv);
            }
            catch (NetworkException ne) {
                vipException = new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)ne, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (CRSException crse) {
                vipException = new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crse, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (NotExistsException nee) {
                vipException = new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)nee, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (SoftwareModuleException sme) {
                String userAssignedName = this.getUserAssignedName();
                if (userAssignedName != null) {
                    vipException = new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)sme, this.m_nameAttr.getValue(), userAssignedName);
                }
                vipException = new VIPException((MessageKey)PrCrMsgID.RESOURCE_ADD_FAILED, (Throwable)sme, this.m_nameAttr.getValue());
            }
            finally {
                if (vipException == null) break block42;
                if (netCreated) {
                    try {
                        networkImpl.remove(true);
                    }
                    catch (AlreadyRunningException are) {
                        Trace.out(are);
                    }
                    catch (SoftwareModuleException sme) {
                        Trace.out(sme);
                    }
                }
                throw vipException;
            }
        }
    }

    private void assertNettype(VIPAddress vipAddress, Network network) throws VIPException {
        IPAddressUtil.IPAddrType vipAddrType = vipAddress.getIPAddrType();
        DHCPServerType networkType = null;
        try {
            if (vipAddrType == IPAddressUtil.IPAddrType.IPv4) {
                networkType = network.dhcpServerType();
            } else if (vipAddrType == IPAddressUtil.IPAddrType.IPv6) {
                networkType = network.dhcpServerTypeIPv6();
            }
        }
        catch (NetworkException ne) {
            throw new VIPException((MessageKey)PrCnMsgID.UNABLE_TO_DETERMINE_NETTYPE, (Throwable)ne, vipAddrType.toString().toLowerCase());
        }
        if (networkType != DHCPServerType.NONE && networkType != DHCPServerType.MIXED) {
            throw new VIPException((MessageKey)PrCnMsgID.DYNAMIC_NETTYPE, vipAddrType.toString().toLowerCase(), networkType.toString());
        }
    }

    private void assertAddressType(String vipAddressOrName, Network network) throws VIPException {
        IPAddressUtil.IPAddrType vipAddrType;
        Map<IPAddressUtil.IPAddrType, Subnet> subnetMap;
        int netNumber;
        try {
            netNumber = network.getNumber();
            subnetMap = network.subnets();
        }
        catch (NetworkException ne) {
            throw new VIPException(ne);
        }
        catch (NotExistsException nee) {
            throw new VIPException(nee);
        }
        try {
            vipAddrType = IPAddressUtil.getAddrTypeFromAddressOrName(vipAddressOrName);
        }
        catch (IPAddressException ipae) {
            throw new VIPException(ipae);
        }
        boolean networkContainsIPv4Subnet = subnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4);
        boolean networkContainsIPv6Subnet = subnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
        if (networkContainsIPv4Subnet && networkContainsIPv6Subnet || vipAddrType == IPAddressUtil.IPAddrType.BOTH) {
            return;
        }
        if (networkContainsIPv6Subnet && vipAddrType == IPAddressUtil.IPAddrType.IPv4) {
            List<InetAddress> ipv4VIPAddressList;
            try {
                ipv4VIPAddressList = IPAddressUtil.getAddrMapFromAddressOrName(vipAddressOrName).get((Object)IPAddressUtil.IPAddrType.IPv4);
            }
            catch (IPAddressException ipae) {
                throw new VIPException(ipae);
            }
            StringBuffer ipv4VIPAddresses = new StringBuffer();
            Iterator<InetAddress> ipv4VIPAddressListItr = ipv4VIPAddressList.iterator();
            while (ipv4VIPAddressListItr.hasNext()) {
                InetAddress ipv4VIPAddress = ipv4VIPAddressListItr.next();
                ipv4VIPAddresses.append(ipv4VIPAddress.getHostAddress());
                if (!ipv4VIPAddressListItr.hasNext()) continue;
                ipv4VIPAddresses.append(", ");
            }
            throw new VIPException((MessageKey)PrCnMsgID.VIP_RESOLVES_TO_ADDRESS_OF_DIFFERENT_TYPE_THAN_NETWORK, vipAddressOrName, "IPv4", ipv4VIPAddresses.toString(), netNumber);
        }
        if (networkContainsIPv4Subnet && vipAddrType == IPAddressUtil.IPAddrType.IPv6) {
            List<InetAddress> ipv6VIPAddressList;
            if (IPAddressUtil.isIPAddressString(vipAddressOrName)) {
                throw new VIPException((MessageKey)PrCnMsgID.VIP_ADDRESS_OF_DIFFERENT_TYPE_THAN_NETWORK, vipAddressOrName, vipAddrType.toString(), netNumber, "IPv6");
            }
            try {
                ipv6VIPAddressList = IPAddressUtil.getAddrMapFromAddressOrName(vipAddressOrName).get((Object)IPAddressUtil.IPAddrType.IPv6);
            }
            catch (IPAddressException ipae) {
                throw new VIPException(ipae);
            }
            StringBuffer ipv6VIPAddresses = new StringBuffer();
            Iterator<InetAddress> ipv6VIPAddressListItr = ipv6VIPAddressList.iterator();
            while (ipv6VIPAddressListItr.hasNext()) {
                InetAddress ipv6VIPAddress = ipv6VIPAddressListItr.next();
                ipv6VIPAddresses.append(ipv6VIPAddress.getHostAddress());
                if (!ipv6VIPAddressListItr.hasNext()) continue;
                ipv6VIPAddresses.append(", ");
            }
            throw new VIPException((MessageKey)PrCnMsgID.VIP_RESOLVES_TO_ADDRESS_OF_DIFFERENT_TYPE_THAN_NETWORK, vipAddressOrName, "IPv6", ipv6VIPAddresses.toString(), netNumber);
        }
    }

    private void validateNetmask(VIPAddress vipAddress, Network network) throws VIPException {
        if (vipAddress.getIPAddrType() == IPAddressUtil.IPAddrType.IPv4) {
            String networkSubnetMask;
            String vipNetmask = vipAddress.getNetmask();
            try {
                networkSubnetMask = network.subnet().subnetMaskAsStr();
            }
            catch (NotExistsException nee) {
                String netNumber = "<UNKNOWN>";
                try {
                    netNumber = String.valueOf(network.getNumber());
                }
                catch (NetworkException ne) {
                    Trace.out("Unable to determine the network number. Details:" + ne.getMessage());
                }
                throw new VIPException((MessageKey)PrCnMsgID.NO_NETWORK_SUBNET, "IPv4", netNumber);
            }
            catch (NetworkException ne) {
                throw new VIPException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_NETMASK_INFO, (Throwable)ne, new Object[0]);
            }
            if (!vipNetmask.equals(networkSubnetMask)) {
                throw new VIPException((MessageKey)PrCnMsgID.VIP_NETMASK_MISMATCH, vipNetmask, networkSubnetMask);
            }
            return;
        }
        if (vipAddress.getIPAddrType() == IPAddressUtil.IPAddrType.IPv6) {
            String networkPrefixLength;
            String vipPrefixLength = vipAddress.getNetmask();
            try {
                networkPrefixLength = network.subnet_ipv6().subnetMaskAsStr();
            }
            catch (NotExistsException nee) {
                String netNumber = "<UNKNOWN>";
                try {
                    netNumber = String.valueOf(network.getNumber());
                }
                catch (NetworkException ne) {
                    Trace.out("Unable to determine the network number. Details:" + ne.getMessage());
                }
                throw new VIPException((MessageKey)PrCnMsgID.NO_NETWORK_SUBNET, "IPv6", netNumber);
            }
            catch (NetworkException ne) {
                throw new VIPException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_NETMASK_INFO, (Throwable)ne, new Object[0]);
            }
            if (!vipPrefixLength.equals(networkPrefixLength)) {
                throw new VIPException((MessageKey)PrCnMsgID.VIP_PREFIX_LENGTH_MISMATCH, vipPrefixLength, networkPrefixLength);
            }
        }
    }

    protected boolean belongsToNetwork(VIPAddress vipAddress, Network network) throws VIPException {
        Map<IPAddressUtil.IPAddrType, Subnet> networkSubnetTypes;
        String networkNumber;
        String vipAddressStr = vipAddress.getIPAddress().getHostAddress();
        try {
            networkNumber = String.valueOf(network.getNumber());
        }
        catch (NetworkException ne) {
            networkNumber = "<UNKNOWN>";
        }
        try {
            networkSubnetTypes = network.subnets();
        }
        catch (NetworkException ne) {
            Trace.out("Unable to determine the netwotk address type");
            throw new VIPException((MessageKey)PrCnMsgID.UNABLE_TO_DETERMINE_IF_VIP_BELONGS_TO_NETWORK, (Throwable)ne, vipAddressStr, networkNumber);
        }
        catch (NotExistsException nee) {
            Trace.out("Unable to determine the netwotk subnet");
            throw new VIPException((MessageKey)PrCnMsgID.UNABLE_TO_DETERMINE_IF_VIP_BELONGS_TO_NETWORK, (Throwable)nee, vipAddressStr, networkNumber);
        }
        IPAddressUtil.IPAddrType vipAddressType = vipAddress.getIPAddrType();
        if (vipAddressType == IPAddressUtil.IPAddrType.BOTH) {
            try {
                if (network.addressType() != IPAddressUtil.IPAddrType.BOTH) {
                    Trace.out("The VIP address " + vipAddressStr + " does not belong to network with netnum=" + networkNumber);
                    return false;
                }
                Map<IPAddressUtil.IPAddrType, List<InetAddress>> vipAddressResolMap = IPAddressUtil.getAddrMapFromAddressOrName(vipAddress.getUsrVIP());
                List<InetAddress> ipv4List = vipAddressResolMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                String networkMask = networkSubnetTypes.get((Object)IPAddressUtil.IPAddrType.IPv4).subnetMaskAsStr();
                SubnetImpl compSubnet = null;
                boolean isSubnetMatch = true;
                for (InetAddress ipv4Inet : ipv4List) {
                    compSubnet = new SubnetImpl(ipv4Inet.getHostAddress(), networkMask);
                    isSubnetMatch &= network.compareMaskedSubnet(compSubnet);
                }
                List<InetAddress> ipv6List = vipAddressResolMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                networkMask = networkSubnetTypes.get((Object)IPAddressUtil.IPAddrType.IPv6).subnetMaskAsStr();
                for (InetAddress ipv6Inet : ipv6List) {
                    compSubnet = new SubnetImpl(ipv6Inet.getHostAddress(), networkMask);
                    isSubnetMatch &= network.compareMaskedSubnet(compSubnet);
                }
                return isSubnetMatch;
            }
            catch (NetworkException ne) {
                Trace.out("Could't retrieve information of network resource");
                throw new VIPException(ne);
            }
            catch (IPAddressException ipae) {
                Trace.out("An error occurred while getting information of VIP Address: " + ipae.getMessage());
                throw new VIPException(ipae);
            }
        }
        if (!networkSubnetTypes.containsKey((Object)vipAddressType)) {
            Trace.out("The VIP address " + vipAddressStr + " does not belong to network with netnum=" + networkNumber);
            return false;
        }
        String vipSubnetStr = vipAddress.getSubnet();
        String vipNetmaskOrPrefixLength = vipAddress.getNetmask();
        String networkSubnetStr = networkSubnetTypes.get((Object)vipAddressType).getName();
        String networkSubnetMaskStr = networkSubnetTypes.get((Object)vipAddressType).subnetMaskAsStr();
        try {
            vipSubnetStr = IPAddressUtil.applyNetmaskOrPrefixLength(vipSubnetStr, vipNetmaskOrPrefixLength);
            networkSubnetStr = IPAddressUtil.applyNetmaskOrPrefixLength(networkSubnetStr, networkSubnetMaskStr);
            return IPAddressUtil.sameIPAddresses(vipSubnetStr, networkSubnetStr);
        }
        catch (IPAddressException ipae) {
            Trace.out("An error occurred while comparing the VIP subnet \"" + vipSubnetStr + "\" with the netwotk subnet \"" + networkSubnetStr + "\". Details: " + ipae.getMessage());
            throw new VIPException((MessageKey)PrCnMsgID.UNABLE_TO_DETERMINE_IF_VIP_BELONGS_TO_NETWORK_INCL_SUBNET_INFO, (Throwable)ipae, vipAddressStr, networkNumber, networkSubnetStr);
        }
    }

    void create(Network network, String prefNode, Version version) throws AlreadyExistsException, VIPException {
        this.create(network, null, null, prefNode, version);
    }

    void create(Network network, String vnameorip, IPAddressUtil.IPAddrType ipAddrType, String prefNode, Version version) throws AlreadyExistsException, VIPException {
        this.create(network, vnameorip, ipAddrType, prefNode, version, null);
    }

    void create(Network network, String vnameorip, IPAddressUtil.IPAddrType ipAddrType, String prefNode, Version version, VIPAddress natAddress) throws AlreadyExistsException, VIPException {
        this.create(network, vnameorip, ipAddrType, prefNode, version, natAddress, false);
    }

    void create(Network network, String vnameorip, IPAddressUtil.IPAddrType ipAddrType, String prefNode, Version version, VIPAddress natAddress, boolean isOPCEnv) throws AlreadyExistsException, VIPException {
        Trace.out("Calling VIPImpl.create() with natAddress = " + natAddress);
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new VIPException(sme);
        }
        if (vnameorip != null) {
            this.assertAddressType(vnameorip, network);
        }
        if (prefNode != null) {
            this.assertExtendedNode(prefNode, network);
        }
        try {
            List<ResourceAttribute> attrList;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            int netNum = network.getNumber();
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
            ResourceAttribute vipNetTypeAttr = crsFactory.create(ResourceType.ClusterVIP.NAME.name(), ResourceType.ClusterVIP.getVIPNetTypeName(netNum));
            if (!crsFactory.isRegistered(vipNetTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                attrList = ResourceType.ClusterVIP.getVIPNetType(netNum);
                crsFactory.create(CRSEntity.Type.ResourceType, attrList);
            } else {
                attrList = crsFactory.getResourceTypeEntity(vipNetTypeAttr).getAttributes(new String[0]);
            }
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.VIP_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.HOSTING_MEMBERS.name())) {
                    attr.setValue(prefNode.toLowerCase());
                    continue;
                }
                if (vnameorip != null && attr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.USR_ORA_VIP.name())) {
                    DHCPServerType serverType = null;
                    Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = network.dhcpServerTypes();
                    if (ipAddrType == IPAddressUtil.IPAddrType.IPv4 && serverTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                        serverType = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                    } else if (ipAddrType == IPAddressUtil.IPAddrType.IPv6 && serverTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                        serverType = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                    }
                    if (serverType == DHCPServerType.NONE || serverType == DHCPServerType.MIXED) {
                        Trace.out(ipAddrType.toString() + " server type is \"" + serverType.toString() + "\". Therefore " + ResourceType.ClusterVIP.USR_ORA_VIP.name() + "=" + vnameorip);
                        attr.setValue(vnameorip);
                        continue;
                    }
                    Trace.out(ipAddrType.toString() + " server type (" + serverType.toString() + ") is not \"" + (Object)((Object)DHCPServerType.NONE) + "\". Therefore we do not set the " + ResourceType.ClusterVIP.USR_ORA_VIP.name());
                    continue;
                }
                if (natAddress != null && attr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.OPC_NAT_ADDRESS.name())) {
                    Trace.out("Set OPC_NAT_ADDRESS " + natAddress.getUsrVIP());
                    attr.setValue(natAddress.getUsrVIP());
                    continue;
                }
                if (!isOPCEnv || !attr.getName().equalsIgnoreCase(ResourceType.ClusterVIP.PLACEMENT.name())) continue;
                Trace.out("Set PLACEMENT to restricted");
                attr.setValue("restricted");
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            this.createVIPDepAttrs(attrList, network);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
            this.ntGrantAclsForTransparentHA();
        }
        catch (NetworkException e) {
            throw new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (CRSException crse) {
            throw new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crse, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException sme) {
            throw new VIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)sme, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws VIPException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                perm.ntgrantOraGridLsnrPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
    }

    void createVIPDepAttrs(List<ResourceAttribute> attrList, Network network) throws VIPException {
        this.createVIPDepAttrsHelper(attrList, network, true, true);
    }

    void upgradeVIPDepAttrs(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws VIPException {
        this.createVIPDepAttrsHelper(attrList, this.network(), inclStartDep, inclStopDep);
    }

    private void createVIPDepAttrsHelper(List<ResourceAttribute> attrList, Network network, boolean inclStartDep, boolean inclStopDep) throws VIPException {
        Trace.out("Calling createVIPDepAttrs");
        if (!inclStartDep && !inclStopDep) {
            return;
        }
        HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
        HashMap<String, String> condMap = new HashMap<String, String>();
        try {
            String netname = network.getName();
            Trace.out((Object)"In createVIPDepAttrs, netname is %s", netname);
            argMap.put("network", new RTEArg("network", RTEArg.RTEArgType.Res, network.getName()));
        }
        catch (RTENativeException e) {
            throw new VIPException(e);
        }
        try {
            String depHint;
            String dep;
            RTENativeResult result;
            String template;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (inclStartDep) {
                template = ResourceType.ClusterVIP.START_DEPENDENCIES_TEMPLATE.toString();
                result = crsFactory.rteEvalAttrValue(template, argMap, new Version().toString(), condMap, this.m_nameAttr.getValue());
                dep = result.getAttrValue();
                depHint = result.getAttrValueHint();
                Trace.out((Object)"START_DEPENDENCIES is %s", dep);
                Trace.out((Object)"START_DEPENDENCIES_RTE_INTERNAL is %s", depHint);
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dep));
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
            }
            if (inclStopDep) {
                template = ResourceType.ClusterVIP.STOP_DEPENDENCIES_TEMPLATE.toString();
                result = crsFactory.rteEvalAttrValue(template, argMap, new Version().toString(), condMap, this.m_nameAttr.getValue());
                dep = result.getAttrValue();
                depHint = result.getAttrValueHint();
                Trace.out((Object)"STOP_DEPENDENCIES is %s", dep);
                Trace.out((Object)"STOP_DEPENDENCIES_RTE_INTERNAL is %s", depHint);
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep));
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
            }
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
    }

    @Override
    public InetAddress address() throws VIPException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            String vipName = attr.getValue().trim();
            if (vipName.length() == 0) {
                vipName = this.m_crsResource.getName().split(Pattern.quote(String.valueOf('.')))[1];
            }
            Trace.out("vipName=" + vipName);
            return InetAddress.getByName(vipName);
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
        catch (UnknownHostException e) {
            throw new VIPException(e);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws VIPException {
        Map<IPAddressUtil.IPAddrType, List<InetAddress>> addressMap;
        HashMap<IPAddressUtil.IPAddrType, InetAddress> inetAddressMap = new HashMap<IPAddressUtil.IPAddrType, InetAddress>();
        String vipName = null;
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            vipName = attr.getValue().trim();
        }
        catch (CRSException crse) {
            throw new VIPException(crse);
        }
        int vipNameDelimiterIndex = vipName.indexOf(" ");
        if (vipNameDelimiterIndex != -1) {
            String ipv4Value = vipName.substring(0, vipNameDelimiterIndex);
            String ipv6Value = vipName.substring(vipNameDelimiterIndex + 1);
            try {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, InetAddress.getByName(ipv4Value));
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, InetAddress.getByName(ipv6Value));
            }
            catch (UnknownHostException uhe) {
                throw new VIPException((MessageKey)PrCnMsgID.UNKNOWN_HOST, (Throwable)uhe, vipName);
            }
            return inetAddressMap;
        }
        if (vipName.length() == 0) {
            return inetAddressMap;
        }
        Trace.out("vipName -->" + vipName);
        try {
            addressMap = IPAddressUtil.getAddrMapFromAddressOrName(vipName);
        }
        catch (IPAddressException ipae) {
            throw new VIPException(ipae);
        }
        if (addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
            inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, addressMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0));
        }
        if (addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
            inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0));
        }
        return inetAddressMap;
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> dynamicAddresses() throws VIPException {
        HashMap<IPAddressUtil.IPAddrType, InetAddress> inetAddressMap = new HashMap<IPAddressUtil.IPAddrType, InetAddress>();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.GEN_USR_ORA_VIP.name());
            String vipDynamicAddr = attr.getValue().trim();
            if (vipDynamicAddr.isEmpty()) {
                return inetAddressMap;
            }
            int vipDynamicAddrDelimiterIndex = vipDynamicAddr.indexOf(" ");
            if (vipDynamicAddrDelimiterIndex != -1) {
                String ipv4Value = vipDynamicAddr.substring(0, vipDynamicAddrDelimiterIndex);
                String ipv6Value = vipDynamicAddr.substring(vipDynamicAddrDelimiterIndex + 1);
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, InetAddress.getByName(ipv4Value));
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, InetAddress.getByName(ipv6Value));
                return inetAddressMap;
            }
            Trace.out("vipDynamicAddr =" + vipDynamicAddr);
            InetAddress inetAddress = InetAddress.getByName(vipDynamicAddr);
            if (inetAddress instanceof Inet4Address) {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, inetAddress);
            } else if (inetAddress instanceof Inet6Address) {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, inetAddress);
            }
            return inetAddressMap;
        }
        catch (CRSException crse) {
            throw new VIPException(crse);
        }
        catch (UnknownHostException uhe) {
            throw new VIPException(uhe);
        }
    }

    @Override
    public InetAddress dhcpaddress() throws VIPException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.GEN_USR_ORA_VIP.name());
            String dhcpvipName = attr.getValue().trim();
            Trace.out("dhcpvipName=" + dhcpvipName);
            if (dhcpvipName.length() == 0) {
                return null;
            }
            return InetAddress.getByName(dhcpvipName);
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
        catch (UnknownHostException e) {
            throw new VIPException(e);
        }
    }

    @Override
    public void modifyNatAddress(VIPAddress natAddress) throws VIPException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ClusterVIP.OPC_NAT_ADDRESS.name(), natAddress.getUsrVIP()));
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
    }

    @Override
    public void modifyAddress(VIPAddress vipAddress) throws VIPException {
        this.modifyAddress(vipAddress, false);
    }

    @Override
    public void modifyAddress(VIPAddress vipAddress, boolean skipVIPReachabilityCheck) throws VIPException {
        this.internalModifyAddress(vipAddress, skipVIPReachabilityCheck, true);
    }

    protected ResourceAttribute internalModifyAddress(VIPAddress vipAddress, boolean skipVIPReachabilityCheck, boolean isVIP) throws VIPException {
        String networkNumber;
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new VIPException(sme);
        }
        String valueToAdd = vipAddress.getUsrVIP();
        Map<IPAddressUtil.IPAddrType, List<InetAddress>> valueToAddNameResolutionMap = null;
        try {
            valueToAddNameResolutionMap = IPAddressUtil.resolveHostname(valueToAdd);
        }
        catch (IPAddressException ipae) {
            throw new VIPException(ipae);
        }
        Map<IPAddressUtil.IPAddrType, List<InetAddress>> existingValueNameResolutionMap = null;
        ResourceAttribute attr = null;
        String existingValue = null;
        int delimiterIndex = -50;
        boolean existingValueIsVIPName = false;
        try {
            attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            existingValue = attr.getValue().trim();
            Trace.out((Object)"Existing USR_ORA_VIP:\"%s\"", existingValue);
            delimiterIndex = existingValue.indexOf(" ");
            boolean bl = existingValueIsVIPName = delimiterIndex == -1 && !IPAddressUtil.isIPAddressString(existingValue);
            if (existingValueIsVIPName) {
                Trace.out((Object)"USR_ORA_VIP value: \"%s\" is hostname", existingValue);
                existingValueNameResolutionMap = IPAddressUtil.resolveHostname(existingValue);
            } else if (delimiterIndex == -1) {
                Trace.out((Object)"USR_ORA_VIP value: \"%s\" is single address", existingValue);
                existingValueNameResolutionMap = IPAddressUtil.getAddrMapFromAddressOrName(existingValue);
            } else {
                Trace.out((Object)"USR_ORA_VIP value: \"%s\" is a dual address config", existingValue);
                String ipv4Addr = existingValue.substring(0, delimiterIndex);
                String ipv6Addr = existingValue.substring(delimiterIndex + 1);
                existingValueNameResolutionMap = IPAddressUtil.getAddrMapFromAddressOrName(ipv4Addr);
                Map<IPAddressUtil.IPAddrType, List<InetAddress>> tmpMap = IPAddressUtil.getAddrMapFromAddressOrName(ipv6Addr);
                existingValueNameResolutionMap.put(IPAddressUtil.IPAddrType.IPv6, tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
            }
        }
        catch (IPAddressException ipae) {
            throw new VIPException(ipae);
        }
        catch (CRSException ex) {
            throw new VIPException(ex);
        }
        if (!skipVIPReachabilityCheck && valueToAddNameResolutionMap != null && existingValueNameResolutionMap != null) {
            ArrayList newValList = new ArrayList();
            if (valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                newValList.addAll(valueToAddNameResolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4));
            }
            if (valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                newValList.addAll(valueToAddNameResolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
            }
            if (existingValueNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                newValList.removeAll((Collection)existingValueNameResolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4));
            }
            if (existingValueNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                newValList.removeAll((Collection)existingValueNameResolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
            }
            Trace.out("Addresses to validate: " + ((Object)newValList).toString());
            try {
                for (InetAddress inet : newValList) {
                    if (!IPAddressUtil.isPingable(inet)) continue;
                    throw new VIPException((MessageKey)PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, inet.getHostAddress());
                }
            }
            catch (IPAddressException ipAddressException) {
                throw new VIPException(ipAddressException);
            }
        }
        Network network = this.network();
        try {
            networkNumber = String.valueOf(network.getNumber());
        }
        catch (NetworkException ne) {
            networkNumber = "<UNKNOWN>";
        }
        boolean isOPCEnv = false;
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        try {
            isOPCEnv = clusterwareInfo.isOPCEnv();
        }
        catch (InstallException ie) {
            Trace.out("Error detecting if OPC env. Details:\n" + ie.getMessage());
            throw new VIPException(ie);
        }
        boolean isODALite = false;
        boolean isODASingleIP = false;
        if (!isOPCEnv) {
            try {
                isODALite = clusterwareInfo.isODALiteEnv();
                if (!isODALite) {
                    isODASingleIP = clusterwareInfo.isODASingleIPEnv();
                }
            }
            catch (InstallException ie) {
                Trace.out("Error detecting if ODA Lite or ODA Single IP env. Details:\n" + ie.getMessage());
                throw new VIPException(ie);
            }
        }
        if (!(isOPCEnv || isODALite || isODASingleIP)) {
            this.validateNetmask(vipAddress, network);
            if (isVIP && !this.belongsToNetwork(vipAddress, network)) {
                IPAddressUtil.IPAddrType vipAddressType = vipAddress.getIPAddrType();
                String networkSubnetStr = "<UNKNOWN>";
                try {
                    Subnet networkSubnet = vipAddressType == IPAddressUtil.IPAddrType.IPv4 ? network.subnet() : network.subnet_ipv6();
                    networkSubnetStr = networkSubnet.getName();
                }
                catch (NetworkException ne) {
                    Trace.out("Unable to determine the netwotk subnet");
                }
                catch (NotExistsException nee) {
                    Trace.out("Unable to determine the netwotk subnet");
                }
                throw new VIPException((MessageKey)PrCnMsgID.VIP_DOES_NOT_BELONG_TO_NETWORK, vipAddress.getIPAddress().getHostAddress(), networkNumber, networkSubnetStr);
            }
        }
        try {
            Map<IPAddressUtil.IPAddrType, Subnet> networkSubnetMap;
            boolean valueToAddIsIP = IPAddressUtil.isIPAddressString(valueToAdd);
            try {
                networkSubnetMap = network.subnets();
            }
            catch (NotExistsException nee) {
                throw new VIPException(nee);
            }
            catch (NetworkException ne) {
                throw new VIPException(ne);
            }
            boolean hasIPv4Subnet = networkSubnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4);
            boolean hasIPv6Subnet = networkSubnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
            int usrOraVIPTokens = delimiterIndex == -1 ? 1 : 2;
            String nodeName = "<UNKNOWN>";
            try {
                nodeName = this.preferredNode().getName();
            }
            catch (NodeException ne) {
                Trace.out("Unable to retrieve the node name (not critical as it is used only for potential exception messages");
            }
            if (usrOraVIPTokens == 2) {
                if (valueToAddIsIP) {
                    String ipv4Value = existingValue.substring(0, delimiterIndex);
                    String ipv6Value = existingValue.substring(delimiterIndex + 1);
                    if (IPAddressUtil.isIPv4AddressString(valueToAdd)) {
                        ipv4Value = valueToAdd;
                    } else {
                        ipv6Value = valueToAdd;
                    }
                    attr.setValue(ipv4Value + " " + ipv6Value);
                } else if (!valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) || !valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                    throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_DOES_NOT_RESOLVE_TO_BOTH, nodeName, valueToAdd);
                }
            } else if (!existingValueIsVIPName) {
                if (valueToAddIsIP) {
                    boolean existingValueIsIPv4 = IPAddressUtil.isIPv4AddressString(existingValue);
                    boolean existingValueIsIPv6 = IPAddressUtil.isIPv6AddressString(existingValue);
                    boolean valueToAddIsIPv4 = IPAddressUtil.isIPv4AddressString(valueToAdd);
                    boolean valueToAddIsIPv6 = IPAddressUtil.isIPv6AddressString(valueToAdd);
                    if (existingValueIsIPv4 && valueToAddIsIPv4 || existingValueIsIPv6 && valueToAddIsIPv6) {
                        attr.setValue(valueToAdd);
                    } else if (existingValueIsIPv4 && valueToAddIsIPv6) {
                        attr.setValue(existingValue + " " + valueToAdd);
                    } else if (existingValueIsIPv6 && valueToAddIsIPv4) {
                        attr.setValue(valueToAdd + " " + existingValue);
                    }
                } else {
                    boolean existingValueIsIPv4 = IPAddressUtil.isIPv4AddressString(existingValue);
                    boolean existingValueIsIPv6 = IPAddressUtil.isIPv6AddressString(existingValue);
                    if (existingValueIsIPv4 && !valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                        throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_DOES_NOT_RESOLVE_TO_IPV4, nodeName, valueToAdd);
                    }
                    if (existingValueIsIPv6 && !valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                        throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_DOES_NOT_RESOLVE_TO_IPV6, nodeName, valueToAdd);
                    }
                    attr.setValue(valueToAdd);
                }
            } else if (existingValueIsVIPName) {
                boolean existingNameResolvesToIPv4 = existingValueNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4);
                boolean existingNameResolvesToIPv6 = existingValueNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
                if (valueToAddIsIP) {
                    boolean valueToAddIsIPv4 = IPAddressUtil.isIPv4AddressString(valueToAdd);
                    boolean valueToAddIsIPv6 = IPAddressUtil.isIPv6AddressString(valueToAdd);
                    if (existingNameResolvesToIPv4 && !valueToAddIsIPv4 && hasIPv4Subnet) {
                        try {
                            if (network.dhcpServerType() != DHCPServerType.DHCP) {
                                throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_RESOLVES_TO_IPV4_WHILE_NEW_VALUE_DOES_NOT, nodeName, valueToAdd);
                            }
                        }
                        catch (NetworkException ne) {
                            throw new VIPException(ne);
                        }
                    }
                    if (existingNameResolvesToIPv6 && !valueToAddIsIPv6 && hasIPv6Subnet) {
                        try {
                            if (network.dhcpServerType() != DHCPServerType.AUTOCONFIG) {
                                throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_RESOLVES_TO_IPV6_WHILE_NEW_VALUE_DOES_NOT, nodeName, valueToAdd);
                            }
                        }
                        catch (NetworkException ne) {
                            throw new VIPException(ne);
                        }
                    }
                    attr.setValue(valueToAdd);
                } else {
                    block82: {
                        boolean valueToAddResolvesToIPv4 = valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4);
                        boolean valueToAddResolvesToIPv6 = valueToAddNameResolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
                        if (existingNameResolvesToIPv4 && existingNameResolvesToIPv6) {
                            if (!valueToAddResolvesToIPv4 || !valueToAddResolvesToIPv6) {
                                if (!valueToAddResolvesToIPv4 && hasIPv4Subnet) {
                                    throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_RESOLVES_TO_IPV4_NETWORK_ERROR, valueToAdd, networkNumber);
                                }
                                if (!valueToAddResolvesToIPv6 && hasIPv6Subnet) {
                                    throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_RESOLVES_TO_IPV6_NETWORK_ERROR, valueToAdd, networkNumber);
                                }
                            }
                        } else {
                            if (existingNameResolvesToIPv4 && !valueToAddResolvesToIPv4 && hasIPv4Subnet) {
                                try {
                                    if (network.dhcpServerType() != DHCPServerType.DHCP) {
                                        throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_RESOLVES_TO_IPV4_WHILE_NEW_VALUE_DOES_NOT, nodeName, valueToAdd);
                                    }
                                    break block82;
                                }
                                catch (NetworkException ne) {
                                    throw new VIPException(ne);
                                }
                            }
                            if (existingNameResolvesToIPv6 && !valueToAddResolvesToIPv6 && hasIPv6Subnet) {
                                try {
                                    if (network.dhcpServerType() != DHCPServerType.AUTOCONFIG) {
                                        throw new VIPException((MessageKey)PrCtMsgID.VIPNAME_RESOLVES_TO_IPV6_WHILE_NEW_VALUE_DOES_NOT, nodeName, valueToAdd);
                                    }
                                }
                                catch (NetworkException ne) {
                                    throw new VIPException(ne);
                                }
                            }
                        }
                    }
                    attr.setValue(valueToAdd);
                }
            }
            Trace.out("Changing value of attribute \"" + attr.getName() + "\" to \"" + attr.getValue() + "\"");
            if (isVIP) {
                this.m_crsResource.update(attr);
            }
            return attr;
        }
        catch (CRSException crse) {
            throw new VIPException(crse);
        }
    }

    public void removeAddressType(IPAddressUtil.IPAddrType addrType) throws VIPException {
        if (addrType != IPAddressUtil.IPAddrType.IPv4 && addrType != IPAddressUtil.IPAddrType.IPv6 && addrType != IPAddressUtil.IPAddrType.BOTH) {
            throw new VIPException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "vip_error-02");
        }
        try {
            ResourceAttribute usrOraVIPAttr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            String existingValue = usrOraVIPAttr.getValue();
            int delimiterIndex = existingValue.indexOf(" ");
            if (addrType == IPAddressUtil.IPAddrType.BOTH) {
                usrOraVIPAttr.setValue("");
            } else if (delimiterIndex != -1) {
                String ipv4Value = existingValue.substring(0, delimiterIndex);
                String ipv6Value = existingValue.substring(delimiterIndex + 1);
                if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                    usrOraVIPAttr.setValue(ipv6Value);
                } else {
                    usrOraVIPAttr.setValue(ipv4Value);
                }
            } else if ((existingValue = existingValue.trim()).length() > 0) {
                try {
                    IPAddressUtil.IPAddrType vipAddrType = IPAddressUtil.getAddrTypeFromAddressOrName(existingValue.trim());
                    if (addrType == vipAddrType) {
                        usrOraVIPAttr.setValue("");
                    } else if (vipAddrType == IPAddressUtil.IPAddrType.BOTH) {
                        Network vipNetwork = this.network();
                        Map<IPAddressUtil.IPAddrType, DHCPServerType> nettypeMap = vipNetwork.dhcpServerTypes();
                        if (addrType == IPAddressUtil.IPAddrType.IPv4 && nettypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.AUTOCONFIG || addrType == IPAddressUtil.IPAddrType.IPv6 && nettypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.DHCP) {
                            usrOraVIPAttr.setValue("");
                        }
                    }
                }
                catch (IPAddressException ipae) {
                    throw new VIPException(ipae);
                }
                catch (NetworkException ne) {
                    throw new VIPException(ne);
                }
            }
            Trace.out("Changing value of attribute \"" + usrOraVIPAttr.getName() + "\" to \"" + usrOraVIPAttr.getValue() + "\"");
            this.m_crsResource.update(usrOraVIPAttr);
        }
        catch (CRSException crse) {
            throw new VIPException(crse);
        }
    }

    @Override
    public Network network() throws VIPException {
        try {
            return NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource);
        }
        catch (SoftwareModuleException e) {
            throw new VIPException(e);
        }
    }

    @Override
    public Node preferredNode() throws VIPException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.HOSTING_MEMBERS.name());
            return ServerFactoryImpl.getInstance().getNode(attr.getValue(), false);
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
        catch (NodeException ne) {
            throw new VIPException(ne);
        }
        catch (ServerException se) {
            throw new VIPException(se);
        }
    }

    @Override
    public Node runningNode() throws NotRunningException, VIPException {
        try {
            List<Node> nodeList = this.m_crsResource.fetchRunningNodes();
            if (nodeList.size() == 1) {
                return nodeList.get(0);
            }
            if (nodeList.size() == 0) {
                throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_RUNNING, this.m_crsResource.getName(), "");
            }
            StringBuilder sb = new StringBuilder();
            for (Node node : nodeList) {
                sb.append(node.getName() + " ");
            }
            throw new VIPException((MessageKey)PrCrMsgID.RES_STATE_INVALID, this.m_crsResource.getName(), sb.toString());
        }
        catch (NodeException e) {
            throw new VIPException(e);
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        this.relocate(false);
    }

    @Override
    public void relocate(boolean force) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate(force);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        this.relocateTo(tgtNode, false);
    }

    @Override
    public void relocateTo(Node tgtNode, boolean force) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode, force);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public List<Listener> listeners() throws NotExistsException, VIPException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<Service> services() throws NotExistsException, VIPException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public static String getResourceName(String nodeOrVipName) {
        try {
            return new VIP(nodeOrVipName).getResourceName();
        }
        catch (VirtualIPException e) {
            Trace.out(e);
            return "ora." + nodeOrVipName.toLowerCase() + ".vip";
        }
    }

    static String getUserAssignedName(String vipResName) throws VIPException {
        if (vipResName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "vipResName");
        }
        String[] value = vipResName.split(Pattern.quote(String.valueOf('.')));
        if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !".vip".toString().equalsIgnoreCase(String.valueOf('.') + value[2])) {
            throw new VIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ClusterVIP.NAME.name(), vipResName);
        }
        return value[1];
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, VIPException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new VIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, VIPException {
        this.remove(force, true);
    }

    protected void remove(boolean force, boolean isVIP) throws AlreadyRunningException, VIPException {
        String restype = null;
        String resname = null;
        String clientid = null;
        ClusterUtil clusterutil = null;
        DHCPServerType serverType = DHCPServerType.NONE;
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new VIPException(e);
        }
        try {
            serverType = this.network().dhcpServerType();
            if (serverType == DHCPServerType.DHCP || serverType == DHCPServerType.AUTOCONFIG) {
                clusterutil = new ClusterUtil();
                CRSResource crsRes = this.crsResource();
                ResourceAttribute attr = ((CRSResourceImpl)crsRes).getAttribute(ResourceLiterals.TYPE.name());
                resname = this.getName();
                restype = attr.getValue();
                clientid = clusterutil.getClientID(resname, restype);
                Trace.out("Network type is DHCP. Client id is " + clientid + "; Resource name is " + resname + "; Resource type is " + restype);
            }
        }
        catch (CRSException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        catch (ClusterUtilException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        catch (NotExistsException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        catch (NetworkException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        String node = null;
        Version version = null;
        if (isVIP) {
            block29: {
                try {
                    node = this.preferredNode().getName();
                }
                catch (NodeException e) {
                    if (!force) {
                        throw new VIPException(e);
                    }
                    String[] parts = this.m_nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
                    if (parts.length == 3) {
                        node = parts[1];
                    }
                }
                catch (VIPException e) {
                    if (force) break block29;
                    throw new VIPException(e);
                }
            }
            try {
                version = this.m_crsResource.version();
            }
            catch (CRSException e) {
                if (!force) {
                    throw new VIPException(e);
                }
                version = new Version();
            }
        }
        try {
            super.remove(force);
            if (isVIP && node != null && version != null) {
                OCRTree ocrTree = OCRTree.init(version);
                ocrTree.removeNodeConfiguration(node, true);
            }
        }
        catch (SoftwareModuleException e) {
            throw new VIPException(e);
        }
        catch (OCRException e) {
            throw new VIPException(e);
        }
        if (clientid != null && (serverType == DHCPServerType.DHCP || serverType == DHCPServerType.AUTOCONFIG)) {
            try {
                Trace.out("The server type is DHCP. Release the lease for VIP.");
                clusterutil.DHCPReleaseLease(clientid);
            }
            catch (ClusterUtilException e) {
                Trace.out("Got CRSException when calling clusterutil.DHCPReleaseLease: " + e.getMessage());
            }
            try {
                GNS gns = GNSFactory.getInstance().getGNS();
                String gnsname = clientid;
                Trace.out("Calling gns.deleteName for " + gnsname);
                gns.deleteName(gnsname);
            }
            catch (VIPNotFoundException e) {
                Trace.out("Got VIPNotFoundException when calling gns.deleteName: " + e.getMessage());
            }
            catch (GNSException e) {
                Trace.out("Got GNSException when calling gns.deleteName: " + e.getMessage());
            }
            catch (SoftwareModuleException e) {
                Trace.out("Got SoftwareModuleException when calling gns.deleteName: " + e.getMessage());
            }
            catch (NotExistsException e) {
                Trace.out("Got NotExistsException when calling gns.deleteName: " + e.getMessage());
            }
        }
    }

    private void assertExtendedNode(String node, Network network) throws VIPException {
        try {
            ClusterUtil cu = new ClusterUtil();
            String[] leafNodes = cu.getRIMNodes();
            Trace.out("Validating network %s for node %s", network.getUserAssignedName(), node);
            for (String lnode : leafNodes) {
                if (!lnode.equalsIgnoreCase(node) || network.isExtendedNW()) continue;
                throw new VIPException((MessageKey)PrCcMsgID.VIP_EXTENDED_ERROR, node, network.getUserAssignedName());
            }
        }
        catch (NetworkException | ClusterUtilException e) {
            throw new VIPException(e);
        }
    }
}

