/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.nodeapps.ONS;
import oracle.cluster.nodeapps.ONSException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ONSImpl
extends SoftwareModuleImpl
implements ONS {
    private ResourceAttribute m_nameAttr;
    private static final String ONS_WALLET_DOMAIN = "ons_wallet";

    ONSImpl(ResourceAttribute nameAttr) throws ONSException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ONS.NAME.name())) {
                throw new ONSException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.ONS.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.ONS.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new ONSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ONS.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    void create(String localPort, String remotePort, String[] remoteHosts, String emPort, Version version) throws AlreadyExistsException, ONSException {
        this.create(localPort, remotePort, remoteHosts, emPort, version, null);
    }

    @Override
    public void importWallet(String clientData) throws ONSException {
        int memberId = 0;
        try {
            CredentialsFactory cf = CredentialsFactory.getInstance();
            if (this.isSslUsed()) {
                String memberToDelete = this.m_crsResource.getAttribute(ResourceType.ONS.MEMBER_ID.name()).getValue();
                try {
                    memberId = Integer.parseInt(memberToDelete);
                }
                catch (NumberFormatException nfe) {
                    Trace.out("MEMBER_ID was not set");
                    throw new ONSException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "ons_member_id_not_set_error-01");
                }
                cf.deleteWallet(ONS_WALLET_DOMAIN, memberId);
            }
            memberId = cf.importWalletFromFile(clientData, ONS_WALLET_DOMAIN, ONS_WALLET_DOMAIN);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.MEMBER_ID.name(), String.valueOf(memberId)));
        }
        catch (CredentialsException e) {
            throw new ONSException(e);
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    private int importWalletInternal(String clientData) throws ONSException {
        int memberId;
        try {
            Util util = new Util();
            String user = util.getOracleUser(util.getCRSHome(), null);
            String pgroup = null;
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                pgroup = util.getPrimaryGroup(user);
            }
            memberId = CredentialsFactory.getInstance().importWalletFromFile(clientData, ONS_WALLET_DOMAIN, ONS_WALLET_DOMAIN, user, pgroup);
        }
        catch (CredentialsException e) {
            throw new ONSException(e);
        }
        catch (UtilException e) {
            throw new ONSException(e);
        }
        return memberId;
    }

    @Override
    public void deleteWallet() throws ONSException {
        try {
            int memberId = 0;
            memberId = Integer.parseInt(this.m_crsResource.getAttribute(ResourceType.ONS.MEMBER_ID.name()).getValue());
            CredentialsFactory.getInstance().deleteWallet(ONS_WALLET_DOMAIN, memberId);
        }
        catch (CredentialsException e) {
            throw new ONSException(e);
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    void create(String localPort, String remotePort, String[] remoteHosts, String emPort, Version version, String clientData) throws AlreadyExistsException, ONSException {
        Object nwImpl = null;
        ResourceAttribute netAttr = null;
        boolean isCluster = Cluster.isCluster();
        boolean useSsl = false;
        int memberId = 0;
        try {
            if (isCluster) {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
        }
        catch (SoftwareModuleException e) {
            throw new ONSException(e);
        }
        if (clientData != null) {
            memberId = this.importWalletInternal(clientData);
            Trace.out("imported wallet has member id: " + memberId);
            useSsl = true;
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute onsTypeAttr = crsFactory.create(ResourceType.ONS.NAME.name(), ResourceType.ONS.NAME.toString());
            if (isCluster) {
                netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(NodeAppsFactory.getInstance().getDefaultNetworkNumber())));
                if (!crsFactory.isRegistered(netAttr.getValue(), CRSEntity.Type.Resource)) {
                    throw new ONSException((MessageKey)PrCrMsgID.ONS_NETWORK_RES_NOT_EXISTS, new Object[0]);
                }
            } else {
                Trace.out("It is SIHA mode. So, there is no network required");
            }
            if (!crsFactory.isRegistered(onsTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                crsFactory.createResourceTypes();
            }
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(onsTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.ONS.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ONS.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.ONS_RES_DESC.toString());
                    continue;
                }
                if (localPort != null && attr.getName().equalsIgnoreCase(ResourceType.ONS.LOCAL_PORT.name())) {
                    attr.setValue(localPort);
                    continue;
                }
                if (remotePort != null && attr.getName().equalsIgnoreCase(ResourceType.ONS.REMOTE_PORT.name())) {
                    attr.setValue(remotePort);
                    continue;
                }
                if (emPort != null && attr.getName().equalsIgnoreCase(ResourceType.ONS.EM_PORT.name())) {
                    attr.setValue(emPort);
                    continue;
                }
                if (remoteHosts != null && attr.getName().equalsIgnoreCase(ResourceType.ONS.REMOTE_HOSTS.name())) {
                    attr.setValue(Utils.getString(remoteHosts, String.valueOf(" ")));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ONS.USE_SSL.name())) {
                    attr.setValue(useSsl ? ResourceLiterals.ONS_SSL_ENABLED_VALUE.toString() : ResourceLiterals.DISABLED_VALUE.toString());
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.ONS.MEMBER_ID.name())) continue;
                attr.setValue(String.valueOf(memberId));
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            if (isCluster) {
                Trace.out("Adding network dependency since we are in cluster");
                ResourceDependency hardDep = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency pullDep = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, pullDep)));
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP).toString()));
                this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            } else {
                Trace.out("about the create ONS resource for SIHA");
                this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            }
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ONSException((MessageKey)PrCrMsgID.DEP_RES_ATTR_ERR, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws ONSException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    @Override
    public int getLocalPort() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.LOCAL_PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public boolean isSslUsed() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.USE_SSL.name());
            return attr.getValue().equals(ResourceLiterals.ONS_SSL_ENABLED_VALUE.toString());
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    @Override
    public int getRemotePort() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.REMOTE_PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public int getEMPort() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.EM_PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getLogFile() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.LOG_FILE.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_LOG_FILE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getLogComp() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.LOG_COMP.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_LOG_COMP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getDebugFile() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.DEBUG_FILE.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_DEBUG_FILE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getDebugComp() throws ONSException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ONS.LOG_COMP.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.GET_LOG_COMP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public Map<String, Integer> getRemoteHosts() throws ONSException {
        try {
            String attrValue = this.m_crsResource.getAttribute(ResourceType.ONS.REMOTE_HOSTS.name()).getValue().trim();
            if (attrValue.length() == 0) {
                return new HashMap<String, Integer>(0);
            }
            String[] rhosts = attrValue.split(String.valueOf(" "));
            String rport = String.valueOf(this.getRemotePort());
            HashMap<String, Integer> map = new HashMap<String, Integer>(rhosts.length);
            for (int i = 0; i < rhosts.length; ++i) {
                if (rhosts[i].indexOf(58) > 0) {
                    String[] pair = rhosts[i].trim().split(String.valueOf(':'));
                    if (pair.length != 2) {
                        throw new ONSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ONS.REMOTE_HOSTS.name(), rhosts[i], attrValue);
                    }
                    map.put(pair[0], Integer.valueOf(pair[1]));
                    continue;
                }
                map.put(rhosts[i], Integer.valueOf(rport));
            }
            return map;
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    @Override
    public void setRemoteHosts(Map<String, Integer> remotePeers) throws ONSException {
        StringBuilder sb = new StringBuilder();
        try {
            for (String name : remotePeers.keySet()) {
                Integer intValue = remotePeers.get(name);
                String value = intValue != null ? intValue.toString() : null;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (value != null) {
                    sb.append(name + ':' + value);
                    continue;
                }
                sb.append(name);
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.REMOTE_HOSTS.name(), sb.toString()));
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    @Override
    public void useSsl(boolean useSsl) throws ONSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.USE_SSL.name(), useSsl ? ResourceLiterals.ONS_SSL_ENABLED_VALUE.toString() : ResourceLiterals.DISABLED_VALUE.toString()));
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ONSException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ONSException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ONSException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new ONSException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.ONS.toString();
    }

    @Override
    public void setLocalPort(int port) throws ONSException {
        this.setLocalPort(port, false);
    }

    @Override
    public void setLocalPort(int port, boolean skipPortCheck) throws ONSException {
        try {
            if (oracle.cluster.impl.util.Utils.isPriviledgedPort(port)) {
                Trace.out("Local port " + port + " is in privileged port range.");
                throw new ONSException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Integer.toString(port));
            }
            if (!skipPortCheck) {
                boolean isCluster = Cluster.isCluster();
                if (isCluster) {
                    Trace.out("Check port availability for all hub nodes");
                    String[] clusterNodes = new ClusterUtil().getHUBNodes();
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterNodes, new int[]{port});
                } else {
                    Trace.out("SIHA mode, check port availability in local node");
                    String[] clusterNodes = new String[]{"localnode"};
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterNodes, new int[]{port});
                }
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.LOCAL_PORT.name(), Integer.toString(port)));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_LOCAL_PORT_FAILED, (Throwable)e, String.valueOf(port));
        }
        catch (ClusterUtilException cue) {
            throw new ONSException(cue);
        }
        catch (SoftwareModuleException sme) {
            throw new ONSException(sme);
        }
        catch (CompositeOperationException coe) {
            throw new ONSException(coe);
        }
    }

    @Override
    public void setRemotePort(int remotePort) throws ONSException {
        this.setRemotePort(remotePort, false);
    }

    @Override
    public void setRemotePort(int remotePort, boolean skipPortCheck) throws ONSException {
        try {
            if (oracle.cluster.impl.util.Utils.isPriviledgedPort(remotePort)) {
                Trace.out("Remote port " + remotePort + " is in privileged port range.");
                throw new ONSException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Integer.toString(remotePort));
            }
            if (!skipPortCheck) {
                boolean isCluster = Cluster.isCluster();
                if (isCluster) {
                    Trace.out("Check port availability for all hub nodes");
                    String[] clusterNodes = new ClusterUtil().getHUBNodes();
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterNodes, new int[]{remotePort});
                } else {
                    Trace.out("SIHA mode, check port availability in local node");
                    String[] clusterNodes = new String[]{"localnode"};
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterNodes, new int[]{remotePort});
                }
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.REMOTE_PORT.name(), Integer.toString(remotePort)));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_REMOTE_PORT_FAILED, (Throwable)e, String.valueOf(remotePort));
        }
        catch (ClusterUtilException cue) {
            throw new ONSException(cue);
        }
        catch (SoftwareModuleException sme) {
            throw new ONSException(sme);
        }
        catch (CompositeOperationException coe) {
            throw new ONSException(coe);
        }
    }

    @Override
    public void setEMPort(int emPort) throws ONSException {
        this.setEMPort(emPort, false);
    }

    @Override
    public void setEMPort(int emPort, boolean skipPortCheck) throws ONSException {
        try {
            if (oracle.cluster.impl.util.Utils.isPriviledgedPort(emPort)) {
                Trace.out("Remote port " + emPort + " is in privileged port range.");
                throw new ONSException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Integer.toString(emPort));
            }
            if (!skipPortCheck) {
                boolean isCluster = Cluster.isCluster();
                if (isCluster) {
                    Trace.out("Check port availability for all hub nodes");
                    String[] clusterNodes = new ClusterUtil().getHUBNodes();
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterNodes, new int[]{emPort});
                } else {
                    Trace.out("SIHA mode, check port availability in local node");
                    String[] clusterNodes = new String[]{"localnode"};
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterNodes, new int[]{emPort});
                }
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.EM_PORT.name(), Integer.toString(emPort)));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_PORT_FAILED, (Throwable)e, String.valueOf(emPort));
        }
        catch (ClusterUtilException cue) {
            throw new ONSException(cue);
        }
        catch (SoftwareModuleException sme) {
            throw new ONSException(sme);
        }
        catch (CompositeOperationException coe) {
            throw new ONSException(coe);
        }
    }

    @Override
    public void setLogFile(String logFile) throws ONSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.LOG_FILE.name(), logFile.trim()));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_LOG_FILE_FAILED, (Throwable)e, logFile);
        }
    }

    @Override
    public void setLogComp(String logComp) throws ONSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.LOG_COMP.name(), logComp.trim()));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_LOG_COMP_FAILED, (Throwable)e, logComp);
        }
    }

    @Override
    public void setDebugFile(String debugFile) throws ONSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.DEBUG_FILE.name(), debugFile.trim()));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_DEBUG_FILE_FAILED, (Throwable)e, debugFile);
        }
    }

    @Override
    public void setDebugComp(String debugComp) throws ONSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.DEBUG_COMP.name(), debugComp.trim()));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_DEBUG_COMP_FAILED, (Throwable)e, debugComp);
        }
    }

    @Override
    public void setUseEVM(boolean useEvm) throws ONSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ONS.USE_EVM.name(), Boolean.toString(useEvm)));
        }
        catch (CRSException e) {
            throw new ONSException((MessageKey)PrCnMsgID.SET_USE_EVM_FAILED, (Throwable)e, Boolean.toString(useEvm));
        }
    }
}

