/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.Service;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.gns.GNSVIPException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceNames;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.gns.GNSFactoryImpl;
import oracle.cluster.impl.gns.GNSVIPImpl;
import oracle.cluster.impl.network.GlobalNetworkClassificationImpl;
import oracle.cluster.impl.network.NetworkAdapterImpl;
import oracle.cluster.impl.network.SubnetImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.nodeapps.VIPImpl;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.scan.ScanImpl;
import oracle.cluster.impl.scan.ScanVIPImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.GlobalNetworkClassification;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.GNSConstants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;

public class NetworkImpl
extends SoftwareModuleImpl
implements Network {
    private ResourceAttribute m_nameAttr;

    NetworkImpl(ResourceAttribute nameAttr) throws NetworkException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.Network.NAME.name())) {
                throw new NetworkException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.Network.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.NETWORK.toString().equalsIgnoreCase(value[2])) {
                throw new NetworkException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Network.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = value[1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        }
        catch (NotExistsException value) {
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
    }

    void create(DHCPServerType serverType, GlobalNetworkClassification gnwcls, Version version) throws AlreadyExistsException, NetworkException {
        this.create(serverType, gnwcls, null, version, false);
    }

    void create(DHCPServerType serverType, GlobalNetworkClassification gnwcls, String[] pingTargets, Version version, boolean isLeaf) throws AlreadyExistsException, NetworkException {
        String pingTargetAttr = null;
        this.validateNetwork(gnwcls);
        Subnet subnetInstance = gnwcls.subNet();
        IPAddressUtil.IPAddrType subnetAddrType = subnetInstance.getIPAddrType();
        if (subnetAddrType == IPAddressUtil.IPAddrType.IPv4 && serverType == DHCPServerType.AUTOCONFIG) {
            throw new NetworkException((MessageKey)PrCnMsgID.INVALID_NETWORK_TYPE_FOR_IPV4_NETWORK, serverType.toString());
        }
        if (subnetAddrType == IPAddressUtil.IPAddrType.IPv6 && serverType == DHCPServerType.DHCP) {
            throw new NetworkException((MessageKey)PrCnMsgID.INVALID_NETWORK_TYPE_FOR_IPV6_NETWORK, serverType.toString());
        }
        String netmask = subnetInstance.subnetMaskAsStr();
        String subnet = subnetInstance.getName();
        String[] ifList = gnwcls.getNetworkInterfaceNames();
        String ifListStr = "";
        if (ifList != null && ifList.length > 0) {
            for (int i = 0; i < ifList.length; ++i) {
                ifListStr = ifListStr + ifList[i] + ", ";
            }
        }
        if (pingTargets != null) {
            pingTargetAttr = this.buildPingTargetString(pingTargets);
        }
        try {
            NodeAppsFactoryImpl nodeAppsFactoryImpl = NodeAppsFactoryImpl.getInstance();
            nodeAppsFactoryImpl.assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException(sme);
        }
        try {
            Object vipNetAttr;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute networkTypeAttr = crsFactory.create(ResourceType.Network.NAME.name(), ResourceType.Network.NAME.toString());
            if (crsFactory.upgradeMode() || !crsFactory.isRegistered(networkTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                Trace.out("Calling createResourceTypes when creating network");
                crsFactory.createResourceTypes();
            }
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(networkTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            if (serverType != DHCPServerType.NONE && !crsFactory.isRegistered(((ResourceAttribute)(vipNetAttr = crsFactory.create(ResourceType.ClusterVIP.NAME.name(), ResourceType.ClusterVIP.getVIPNetTypeName(this.getNumber())))).getValue(), CRSEntity.Type.ResourceType)) {
                crsFactory.create(CRSEntity.Type.ResourceType, ResourceType.ClusterVIP.getVIPNetType(this.getNumber()));
            }
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.Network.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.Network.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.NETWORK_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.Network.USR_ORA_AUTO.name())) {
                    attr.setValue(serverType.toString());
                    continue;
                }
                if (netmask != null && attr.getName().equalsIgnoreCase(ResourceType.Network.USR_ORA_NETMASK.name())) {
                    attr.setValue(netmask);
                    continue;
                }
                if (subnet != null && attr.getName().equalsIgnoreCase(ResourceType.Network.USR_ORA_SUBNET.name())) {
                    if (subnetInstance.getIPAddrType() == IPAddressUtil.IPAddrType.IPv4 || subnetInstance.getIPAddrType() == IPAddressUtil.IPAddrType.IPv6) {
                        attr.setValue(subnet);
                        continue;
                    }
                    attr.setValue("");
                    continue;
                }
                if (subnet != null && attr.getName().equalsIgnoreCase(ResourceType.Network.ADDRESS_TYPE.name())) {
                    if (subnetInstance.getIPAddrType() == IPAddressUtil.IPAddrType.IPv4) {
                        attr.setValue(IPAddressUtil.IPAddrType.IPv4.toString());
                        continue;
                    }
                    if (subnetInstance.getIPAddrType() == IPAddressUtil.IPAddrType.IPv6) {
                        attr.setValue(IPAddressUtil.IPAddrType.IPv6.toString());
                        continue;
                    }
                    attr.setValue("");
                    continue;
                }
                if (ifList != null && attr.getName().equalsIgnoreCase(ResourceType.Network.USR_ORA_IF.name())) {
                    attr.setValue(CRSFactoryImpl.getInstance().convertArrToCRSAttrValue(ifList));
                    continue;
                }
                if (isLeaf && attr.getName().equalsIgnoreCase(ResourceType.Network.SERVER_CATEGORY.name())) {
                    attr.setValue(ResourceLiterals.RIM_CATEGORY.toString());
                    continue;
                }
                if (pingTargetAttr == null || !attr.getName().equalsIgnoreCase(ResourceType.Network.PING_TARGET.name())) continue;
                attr.setValue(pingTargetAttr);
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                perm.ntgrantOraGridLsnrPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException crse) {
            throw new NetworkException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crse, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws NetworkException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                perm.ntgrantOraGridLsnrPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
    }

    @Override
    public int getNumber() throws NetworkException {
        String[] value = this.m_nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        return Integer.parseInt(value[1].substring(ResourceLiterals.NET.toString().length()));
    }

    @Override
    public Subnet subnet() throws NotExistsException, NetworkException {
        return this.subnet(IPAddressUtil.IPAddrType.IPv4);
    }

    @Override
    public Subnet subnet_ipv6() throws NotExistsException, NetworkException {
        return this.subnet(IPAddressUtil.IPAddrType.IPv6);
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, Subnet> subnets() throws NotExistsException, NetworkException {
        HashMap<IPAddressUtil.IPAddrType, Subnet> map = new HashMap<IPAddressUtil.IPAddrType, Subnet>(2);
        this.assertCrsResource();
        try {
            String subnetStr = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_SUBNET.name()).getValue().trim();
            if (subnetStr.length() == 0) {
                throw new NotExistsException((MessageKey)PrCnMsgID.SUBNET_NOT_EXISTS, this.m_crsResource.getName());
            }
            String netmaskStr = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_NETMASK.name()).getValue().trim();
            if (netmaskStr.length() == 0) {
                throw new NotExistsException((MessageKey)PrCnMsgID.NETMASK_NOT_EXISTS, this.m_crsResource.getName());
            }
            String[] subnetTokens = subnetStr.split(" ");
            String[] netmaskTokens = netmaskStr.split(" ");
            for (int i = 0; i < subnetTokens.length; ++i) {
                if (IPAddressUtil.isIPv4AddressString(subnetTokens[i])) {
                    map.put(IPAddressUtil.IPAddrType.IPv4, new SubnetImpl(subnetTokens[i], netmaskTokens[i]));
                    continue;
                }
                if (!IPAddressUtil.isIPv6AddressString(subnetTokens[i])) continue;
                map.put(IPAddressUtil.IPAddrType.IPv6, new SubnetImpl(subnetTokens[i], netmaskTokens[i]));
            }
            if (map.isEmpty()) {
                throw new NotExistsException((MessageKey)PrCnMsgID.NETMASK_NOT_EXISTS, this.m_crsResource.getName());
            }
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
        return map;
    }

    private Subnet subnet(IPAddressUtil.IPAddrType ipAddrType) throws NotExistsException, NetworkException {
        try {
            String subnetStr = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_SUBNET.name()).getValue().trim();
            if (subnetStr.length() == 0) {
                throw new NotExistsException((MessageKey)PrCnMsgID.SUBNET_NOT_EXISTS, this.m_crsResource.getName());
            }
            String netmaskStr = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_NETMASK.name()).getValue().trim();
            if (netmaskStr.length() == 0) {
                throw new NotExistsException((MessageKey)PrCnMsgID.NETMASK_NOT_EXISTS, this.m_crsResource.getName());
            }
            String[] subnetTokens = subnetStr.split(" ");
            String[] netmaskTokens = netmaskStr.split(" ");
            for (int i = 0; i < subnetTokens.length; ++i) {
                if ((ipAddrType != IPAddressUtil.IPAddrType.IPv4 || !IPAddressUtil.isIPv4AddressString(subnetTokens[i])) && (ipAddrType != IPAddressUtil.IPAddrType.IPv6 || !IPAddressUtil.isIPv6AddressString(subnetTokens[i]))) continue;
                return new SubnetImpl(subnetTokens[i], netmaskTokens[i]);
            }
            throw new NotExistsException((MessageKey)PrCnMsgID.SUBNET_NOT_EXISTS, this.m_crsResource.getName());
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
    }

    @Override
    public IPAddressUtil.IPAddrType addressType() throws NetworkException {
        this.assertCrsResource();
        try {
            String addressTypeStr = this.m_crsResource.getAttribute(ResourceType.Network.ADDRESS_TYPE.name()).getValue().trim();
            if (addressTypeStr.length() == 0) {
                throw new NetworkException((MessageKey)PrCnMsgID.ADDRESS_TYPE_NOT_EXISTS, this.m_crsResource.getName());
            }
            try {
                return IPAddressUtil.getIPAddrTypeMember(addressTypeStr);
            }
            catch (EnumConstantNotPresentException ecnpe) {
                throw new NetworkException((MessageKey)PrCnMsgID.ADDRESS_TYPE_NOT_EXISTS, this.m_crsResource.getName());
            }
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
    }

    @Override
    public void setAddressType(IPAddressUtil.IPAddrType addressType) throws NetworkException {
        String addressTypeStr;
        boolean clearIPv4 = false;
        boolean clearIPv6 = false;
        this.assertCrsResource();
        try {
            addressTypeStr = this.m_crsResource.getAttribute(ResourceType.Network.ADDRESS_TYPE.name()).getValue().trim();
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
        this.assertMixed();
        if (addressType == IPAddressUtil.IPAddrType.IPv4) {
            if (addressTypeStr.equals(IPAddressUtil.IPAddrType.IPv4.toString())) {
                return;
            }
            if (addressTypeStr.equals(IPAddressUtil.IPAddrType.IPv6.toString())) {
                throw new NetworkException((MessageKey)PrCtMsgID.SETTING_ADDR_TYPE_TO_IPV4_NOT_ALLOWED, new Object[0]);
            }
            clearIPv6 = addressTypeStr.equals(IPAddressUtil.IPAddrType.BOTH.toString());
        }
        if (addressType == IPAddressUtil.IPAddrType.IPv6) {
            if (addressTypeStr.equals(IPAddressUtil.IPAddrType.IPv6.toString())) {
                return;
            }
            if (addressTypeStr.equals(IPAddressUtil.IPAddrType.IPv4.toString())) {
                throw new NetworkException((MessageKey)PrCtMsgID.SETTING_ADDR_TYPE_TO_IPV6_NOT_ALLOWED, new Object[0]);
            }
            clearIPv4 = addressTypeStr.equals(IPAddressUtil.IPAddrType.BOTH.toString());
        }
        if (clearIPv4) {
            DHCPServerType ipv6Nettype = this.dhcpServerTypeIPv6();
            if (ipv6Nettype == DHCPServerType.MIXED) {
                throw new NetworkException((MessageKey)PrCnMsgID.TRANSITION_TO_MIXED_NETWORK_ERROR, "IPv6");
            }
            if (ipv6Nettype == DHCPServerType.NONE) {
                try {
                    this.validateVIPs(IPAddressUtil.IPAddrType.IPv6);
                    this.validateScanVIPs(IPAddressUtil.IPAddrType.IPv6);
                }
                catch (NetworkException ne) {
                    throw new NetworkException((MessageKey)PrCnMsgID.MODIFY_NETWORK_ADDRESS_TYPE_FAILED, (Throwable)ne, new Object[0]);
                }
            }
            this.validateGnsVIP(IPAddressUtil.IPAddrType.IPv6);
        } else if (clearIPv6) {
            DHCPServerType ipv4Nettype = this.dhcpServerType();
            if (ipv4Nettype == DHCPServerType.MIXED) {
                throw new NetworkException((MessageKey)PrCnMsgID.TRANSITION_TO_MIXED_NETWORK_ERROR, "IPv4");
            }
            if (ipv4Nettype == DHCPServerType.NONE) {
                try {
                    this.validateVIPs(IPAddressUtil.IPAddrType.IPv4);
                    this.validateScanVIPs(IPAddressUtil.IPAddrType.IPv4);
                }
                catch (NetworkException ne) {
                    throw new NetworkException((MessageKey)PrCnMsgID.MODIFY_NETWORK_ADDRESS_TYPE_FAILED, (Throwable)ne, new Object[0]);
                }
            }
            this.validateGnsVIP(IPAddressUtil.IPAddrType.IPv4);
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        attrNames.add(ResourceType.Network.USR_ORA_AUTO.name());
        attrNames.add(ResourceType.Network.USR_ORA_SUBNET.name());
        attrNames.add(ResourceType.Network.USR_ORA_NETMASK.name());
        attrNames.add(ResourceType.Network.USR_ORA_IF.name());
        attrNames.add(ResourceType.Network.ADDRESS_TYPE.name());
        try {
            this.updateNetworkResourceAttributes(attrNames, null, null, clearIPv4, clearIPv6);
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
        if (clearIPv4 || clearIPv6) {
            if (clearIPv4) {
                this.removeAddressTypeFromVIPs(IPAddressUtil.IPAddrType.IPv4);
                this.removeAddressTypeFromScanVIPs(IPAddressUtil.IPAddrType.IPv4);
                this.removeAddressTypeFromGNSVIP(IPAddressUtil.IPAddrType.IPv4);
            } else {
                this.removeAddressTypeFromVIPs(IPAddressUtil.IPAddrType.IPv6);
                this.removeAddressTypeFromScanVIPs(IPAddressUtil.IPAddrType.IPv6);
                this.removeAddressTypeFromGNSVIP(IPAddressUtil.IPAddrType.IPv6);
            }
        }
    }

    private void validateVIPs(IPAddressUtil.IPAddrType addressType) throws NetworkException {
        List<VIP> vipList = this.getVIPs();
        for (VIP currVIP : vipList) {
            String nodeName;
            Map<IPAddressUtil.IPAddrType, InetAddress> addressMap;
            try {
                addressMap = currVIP.addresses();
            }
            catch (VIPException vipe) {
                String resourceName;
                try {
                    resourceName = currVIP.crsResource().getName();
                }
                catch (CRSException crse) {
                    Trace.out("Unable to determine VIP resource name. Details:" + crse.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (NotExistsException nee) {
                    Trace.out("Unable to determine VIP resource name. Details:" + nee.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (VIPException vipex) {
                    Trace.out("Unable to determine VIP resource name. Details:" + vipex.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_VIP_ADDRESS, (Throwable)vipe, resourceName);
            }
            if (addressMap.containsKey((Object)addressType)) continue;
            int netnum = this.getNumber();
            try {
                nodeName = currVIP.preferredNode().getName();
            }
            catch (NodeException ne) {
                Trace.out("Unable to determine the hosting node of the VIP. Details:" + ne.getMessage());
                nodeName = "<UNKNOWN>";
            }
            catch (VIPException vipex) {
                Trace.out("Unable to determine the hosting node of the VIP. Details:" + vipex.getMessage());
                nodeName = "<UNKNOWN>";
            }
            throw new NetworkException((MessageKey)PrCnMsgID.VIP_DOES_NOT_CONTAIN_ADDRESS_TYPE, nodeName, String.valueOf(netnum), addressType.toString());
        }
    }

    private void validateGnsVIP(IPAddressUtil.IPAddrType addressType) throws NetworkException {
        try {
            GNSFactory gnsf = GNSFactory.getInstance();
            GNSVIP gvip = gnsf.getGNSVIP();
            Map<IPAddressUtil.IPAddrType, InetAddress> addrMap = gvip.addresses();
            Trace.out((Object)"Validating if GNS VIP has %s address", addressType.toString());
            if (addressType.equals((Object)IPAddressUtil.IPAddrType.BOTH)) {
                IPAddressUtil.IPAddrType missingType = null;
                if (!addrMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                    missingType = IPAddressUtil.IPAddrType.IPv4;
                }
                if (!addrMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                    missingType = IPAddressUtil.IPAddrType.IPv6;
                }
                if (missingType != null) {
                    throw new NetworkException((MessageKey)PrCnMsgID.GNS_VIP_DOES_NOT_CONTAIN_ADDRESS_TYPE, missingType.toString());
                }
            } else if (!addrMap.containsKey((Object)addressType)) {
                throw new NetworkException((MessageKey)PrCnMsgID.GNS_VIP_DOES_NOT_CONTAIN_ADDRESS_TYPE, addressType.toString());
            }
        }
        catch (VIPNotFoundException ex) {
            Trace.out("GNS VIP does not exist. Not an error");
        }
        catch (SoftwareModuleException ex) {
            throw new NetworkException(ex);
        }
    }

    @Override
    public List<VIP> getVIPs() throws NetworkException {
        int netNumber = this.getNumber();
        try {
            NodeAppsFactoryImpl nodeAppsFactoryImpl = NodeAppsFactoryImpl.getInstance();
            return nodeAppsFactoryImpl.getVIPs(netNumber);
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException((MessageKey)PrCnMsgID.VIP_LIST_RETRIEVAL_ERROR, (Throwable)sme, netNumber);
        }
    }

    @Override
    public void removeAddrTypeFromVIPs(IPAddressUtil.IPAddrType addrType) throws NetworkException, VIPException {
        List<VIP> vipList = this.getVIPs();
        for (VIP currVip : vipList) {
            ((VIPImpl)currVip).removeAddressType(addrType);
        }
    }

    private void removeAddressTypeFromVIPs(IPAddressUtil.IPAddrType addressType) throws NetworkException {
        List<VIP> vipList;
        int netNumber = this.getNumber();
        try {
            NodeAppsFactoryImpl nodeAppsFactoryImpl = NodeAppsFactoryImpl.getInstance();
            vipList = nodeAppsFactoryImpl.getVIPs(netNumber);
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException((MessageKey)PrCnMsgID.VIP_LIST_RETRIEVAL_ERROR, (Throwable)sme, netNumber);
        }
        for (VIP currVIP : vipList) {
            try {
                ((VIPImpl)currVIP).removeAddressType(addressType);
            }
            catch (VIPException vipe) {
                String resourceName;
                try {
                    resourceName = currVIP.crsResource().getName();
                }
                catch (CRSException crse) {
                    Trace.out("Unable to determine VIP resource name. Details:" + crse.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (NotExistsException nee) {
                    Trace.out("Unable to determine VIP resource name. Details:" + nee.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (VIPException vipex) {
                    Trace.out("Unable to determine VIP resource name. Details:" + vipex.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_REMOVE_VIP_ADDRESS_PART, (Throwable)vipe, addressType.toString(), resourceName);
            }
        }
    }

    private void removeAddressTypeFromGNSVIP(IPAddressUtil.IPAddrType ipAddrType) throws NetworkException {
        GNSVIPImpl vip = null;
        try {
            if (this.isDefault()) {
                vip = (GNSVIPImpl)GNSFactoryImpl.getInstance().getVIP();
                vip.removeAddressType(ipAddrType);
            } else {
                Trace.out("GNS VIP cannot be configured for non-default networks");
            }
        }
        catch (VIPNotFoundException ve) {
            Trace.out("GNS VIP not found.");
        }
        catch (GNSVIPException ge) {
            throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_REMOVE_GNS_VIP_ADDRESS_PART, (Throwable)ge, ipAddrType.toString());
        }
        catch (SoftwareModuleException se) {
            throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_REMOVE_GNS_VIP_ADDRESS_PART, (Throwable)se, ipAddrType.toString());
        }
    }

    private void validateScanVIPs(IPAddressUtil.IPAddrType addressType) throws NetworkException {
        int i;
        InetAddress[] scanNameResolutionAddresses;
        String scanName;
        List<ScanVIP> scanVipList;
        int netNumber = this.getNumber();
        try {
            ScanFactory scanFactory = ScanFactory.getInstance();
            Scan scan = scanFactory.getScan(netNumber);
            try {
                scanVipList = scanFactory.getScanVIPs(netNumber);
            }
            catch (NotExistsException nee) {
                Trace.out("No SCAN VIPs found");
                return;
            }
            catch (ScanVIPException svipe) {
                throw new NetworkException((MessageKey)PrCnMsgID.SCAN_VIP_LIST_RETRIEVAL_ERROR, (Throwable)svipe, netNumber);
            }
            if (scan.network().getNumber() != netNumber) {
                return;
            }
            scanName = scanVipList.get(0).getScanName();
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException((MessageKey)PrCnMsgID.SCAN_NAME_RETRIEVAL_ERROR, (Throwable)sme, netNumber);
        }
        try {
            scanNameResolutionAddresses = InetAddress.getAllByName(scanName);
        }
        catch (UnknownHostException uhe) {
            throw new NetworkException((MessageKey)PrCnMsgID.UNKNOWN_HOST, scanName);
        }
        ArrayList<Inet4Address> scanNameIPv4AddressList = new ArrayList<Inet4Address>(scanNameResolutionAddresses.length);
        ArrayList<Inet6Address> scanNameIPv6AddressList = new ArrayList<Inet6Address>(scanNameResolutionAddresses.length);
        if (addressType == IPAddressUtil.IPAddrType.IPv4) {
            for (i = 0; i < scanNameResolutionAddresses.length; ++i) {
                if (!(scanNameResolutionAddresses[i] instanceof Inet4Address)) continue;
                scanNameIPv4AddressList.add((Inet4Address)scanNameResolutionAddresses[i]);
            }
        } else if (addressType == IPAddressUtil.IPAddrType.IPv6) {
            for (i = 0; i < scanNameResolutionAddresses.length; ++i) {
                if (!(scanNameResolutionAddresses[i] instanceof Inet6Address)) continue;
                scanNameIPv6AddressList.add((Inet6Address)scanNameResolutionAddresses[i]);
            }
        } else {
            for (i = 0; i < scanNameResolutionAddresses.length; ++i) {
                if (scanNameResolutionAddresses[i] instanceof Inet4Address) {
                    scanNameIPv4AddressList.add((Inet4Address)scanNameResolutionAddresses[i]);
                    continue;
                }
                scanNameIPv6AddressList.add((Inet6Address)scanNameResolutionAddresses[i]);
            }
            if (scanNameIPv4AddressList.size() != scanNameIPv6AddressList.size()) {
                throw new NetworkException((MessageKey)PrCnMsgID.SCAN_NAME_RESOLVES_TO_UNEQUAL_NUMBER_OF_IPV4_IPV6_ADDRESSES, scanName, scanNameIPv4AddressList.size(), scanNameIPv6AddressList.size());
            }
        }
        for (ScanVIP currScanVIP : scanVipList) {
            Map<IPAddressUtil.IPAddrType, InetAddress> addressMap;
            try {
                addressMap = currScanVIP.addresses();
            }
            catch (ScanVIPException svipe) {
                String resourceName;
                try {
                    resourceName = currScanVIP.crsResource().getName();
                }
                catch (CRSException crse) {
                    Trace.out("Unable to determine SCAN VIP resource name. Details:" + crse.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (NotExistsException nee) {
                    Trace.out("Unable to determine SCAN VIP resource name. Details:" + nee.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (ScanVIPException vipex) {
                    Trace.out("Unable to determine SCAN VIP resource name. Details:" + vipex.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_SCAN_VIP_ADDRESS, (Throwable)svipe, resourceName);
            }
            boolean mismatch = true;
            if (addressType == IPAddressUtil.IPAddrType.BOTH) {
                mismatch = !addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) || !addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
            } else {
                boolean bl = mismatch = !addressMap.containsKey((Object)addressType);
            }
            if (!mismatch) {
                if (addressType == IPAddressUtil.IPAddrType.IPv4 || addressType == IPAddressUtil.IPAddrType.BOTH) {
                    boolean bl = mismatch = !scanNameIPv4AddressList.remove(addressMap.get((Object)IPAddressUtil.IPAddrType.IPv4));
                }
                if (addressType == IPAddressUtil.IPAddrType.IPv6 || addressType == IPAddressUtil.IPAddrType.BOTH) {
                    boolean bl = mismatch = !scanNameIPv6AddressList.remove(addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
                }
            }
            if (!mismatch) continue;
            throw new NetworkException((MessageKey)PrCnMsgID.SCAN_NAME_RESOLVES_TO_DIFFERENT_ADDRESSES_THAN_EXISTING_SCAN_VIPS, scanName);
        }
        if (scanNameIPv4AddressList.size() != 0 && scanNameIPv6AddressList.size() != 0) {
            throw new NetworkException((MessageKey)PrCnMsgID.SCAN_NAME_RESOLVES_TO_DIFFERENT_ADDRESSES_THAN_EXISTING_SCAN_VIPS, scanName);
        }
    }

    private void removeAddressTypeFromScanVIPs(IPAddressUtil.IPAddrType addressType) throws NetworkException {
        List<ScanVIP> scanVipList;
        int netNumber = this.getNumber();
        try {
            ScanFactoryImpl scanFactoryImpl = ScanFactoryImpl.getInstance();
            scanVipList = scanFactoryImpl.getScanVIPs(netNumber);
            Network scanNetwork = scanFactoryImpl.getScan().network();
            if (scanNetwork.getNumber() != netNumber) {
                return;
            }
        }
        catch (NotExistsException nee) {
            Trace.out("There exist no configured SCAN VIPs on the cluster");
            return;
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException((MessageKey)PrCnMsgID.SCAN_VIP_LIST_RETRIEVAL_ERROR, (Throwable)sme, netNumber);
        }
        for (ScanVIP currScanVIP : scanVipList) {
            try {
                ((ScanVIPImpl)currScanVIP).removeAddressType(addressType);
            }
            catch (ScanVIPException svipe) {
                String resourceName;
                try {
                    resourceName = currScanVIP.crsResource().getName();
                }
                catch (CRSException crse) {
                    Trace.out("Unable to determine SCAN VIP resource name. Details:" + crse.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (NotExistsException nee) {
                    Trace.out("Unable to determine SCAN VIP resource name. Details:" + nee.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                catch (ScanVIPException vipex) {
                    Trace.out("Unable to determine SCAN VIP resource name. Details:" + vipex.getMessage());
                    resourceName = "<UNKNOWN>";
                }
                throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_REMOVE_SCAN_VIP_ADDRESS_PART, (Throwable)svipe, addressType.toString(), resourceName);
            }
        }
    }

    @Override
    public List<NetworkAdapter> networkAdapters() throws NetworkException {
        ArrayList<NetworkAdapter> netAdapterList = new ArrayList<NetworkAdapter>();
        this.assertCrsResource();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_IF.name());
            List<String> netList = CRSFactoryImpl.getInstance().convertCRSAttrValueToArr(attr);
            for (String netIF : netList) {
                Trace.out("Add adapter " + netIF);
                netAdapterList.add(new NetworkAdapterImpl(netIF));
            }
        }
        catch (CRSException ce) {
            throw new NetworkException(ce);
        }
        return netAdapterList;
    }

    @Override
    public DHCPServerType dhcpServerType() throws NetworkException {
        Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = this.dhcpServerTypes();
        return serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
    }

    @Override
    public DHCPServerType dhcpServerTypeIPv6() throws NetworkException {
        Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = this.dhcpServerTypes();
        return serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, DHCPServerType> dhcpServerTypes() throws NetworkException {
        HashMap<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = new HashMap<IPAddressUtil.IPAddrType, DHCPServerType>(2);
        try {
            this.assertCrsResource();
            String usr_ora_auto = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_AUTO.name()).getValue().trim();
            String[] usr_ora_auto_tokens = usr_ora_auto.split(" ");
            if (usr_ora_auto_tokens.length == 1) {
                try {
                    serverTypeMap.put(this.addressType(), DHCPServerType.getMember(usr_ora_auto_tokens[0].trim()));
                }
                catch (IllegalArgumentException iae) {
                    throw new NetworkException((MessageKey)PrCnMsgID.UNKNOWN_DHCP_SERVER, usr_ora_auto_tokens[0].trim(), iae, this.m_crsResource.getName());
                }
            }
            if (usr_ora_auto_tokens.length == 2) {
                try {
                    serverTypeMap.put(IPAddressUtil.IPAddrType.IPv4, DHCPServerType.getMember(usr_ora_auto_tokens[0].trim()));
                }
                catch (IllegalArgumentException iae) {
                    throw new NetworkException((MessageKey)PrCnMsgID.UNKNOWN_DHCP_SERVER, usr_ora_auto_tokens[0].trim(), iae, this.m_crsResource.getName());
                }
                try {
                    serverTypeMap.put(IPAddressUtil.IPAddrType.IPv6, DHCPServerType.getMember(usr_ora_auto_tokens[1].trim()));
                }
                catch (IllegalArgumentException iae) {
                    throw new NetworkException((MessageKey)PrCnMsgID.UNKNOWN_DHCP_SERVER, usr_ora_auto_tokens[0].trim(), iae, this.m_crsResource.getName());
                }
            }
            return serverTypeMap;
        }
        catch (CRSException crse) {
            throw new NetworkException((MessageKey)PrCnMsgID.GET_DHCP_SERVER_TYPE_FAILED, (Throwable)crse, new Object[0]);
        }
    }

    @Override
    public void setDHCPServerType(DHCPServerType netType) throws NetworkException {
        this.setDHCPServerType(netType, IPAddressUtil.IPAddrType.IPv4, false);
    }

    @Override
    public void setDHCPServerTypeIPv6(DHCPServerType netType) throws NetworkException {
        this.setDHCPServerType(netType, IPAddressUtil.IPAddrType.IPv6, false);
    }

    @Override
    public void setDHCPServerType(DHCPServerType serverType, IPAddressUtil.IPAddrType addrType, boolean checkAgainstExistingAddrType) throws NetworkException {
        if (addrType == IPAddressUtil.IPAddrType.IPv4 && serverType == DHCPServerType.AUTOCONFIG || addrType == IPAddressUtil.IPAddrType.IPv6 && serverType == DHCPServerType.DHCP) {
            Object[] args = new Object[]{serverType.toString(), addrType.toString().toLowerCase()};
            throw new NetworkException((MessageKey)PrCnMsgID.INVALID_DHCP_SERVER_TYPE_FOR_SPECIFIED_NETWORK, args);
        }
        try {
            this.assertCrsResource();
            this.assertMixed(serverType, addrType);
            Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = this.dhcpServerTypes();
            DHCPServerType existingServerType = serverTypeMap.get((Object)addrType);
            if (existingServerType == serverType) {
                Trace.out("EXIT_INFO-->There is nothing to be done. The " + addrType.toString() + " server type value is already \"" + serverType.toString() + "\"");
                return;
            }
            String newValue = serverType.toString();
            if (serverType == DHCPServerType.NONE) {
                this.assertStaticSCAN(addrType);
            }
            IPAddressUtil.IPAddrType existingAddrType = this.addressType();
            if (serverType == DHCPServerType.MIXED && (serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.NONE || serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.NONE)) {
                Trace.out("Trying to get GNS factory");
                GNSFactory gnsFactory = GNSFactory.getInstance();
                Trace.out("got GNS factory");
                boolean doGnsExists = false;
                GNS gns = null;
                try {
                    gns = gnsFactory.getGNS();
                    doGnsExists = gns.isGNSConfigured(false);
                }
                catch (NotExistsException nee) {
                    Trace.out("GNS is not configured.");
                }
                if (!doGnsExists) {
                    throw new NetworkException((MessageKey)PrCnMsgID.NETTYPE_MIXED_MODIFICATION_FAILED, new Object[0]);
                }
                if (GNSConstants.NOT_FORWARDING_DOMAIN.toString().equalsIgnoreCase(gns.getSubdomain())) {
                    Trace.out("GNS was configured without subdomain");
                    throw new NetworkException((MessageKey)PrCnMsgID.NETTYPE_MIXED_GNS_SUBDOMAIN_ERROR, new Object[0]);
                }
            }
            if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                if (checkAgainstExistingAddrType && existingAddrType == IPAddressUtil.IPAddrType.IPv6) {
                    Trace.out("Setting the ADDRESS_TYPE to 'IPv4' is not allowed unless the ADDRESS_TYPE is 'BOTH' (or 'IPv4')");
                    throw new NetworkException((MessageKey)PrCnMsgID.SETTING_ADDR_TYPE_TO_IPV4_NOT_ALLOWED, new Object[0]);
                }
                if (existingServerType == DHCPServerType.NONE && serverType == DHCPServerType.DHCP || existingServerType == DHCPServerType.DHCP && serverType == DHCPServerType.NONE) {
                    throw new NetworkException((MessageKey)PrCnMsgID.NOT_ALLOWED_DHCP_SERVER_TYPE_MODIFICATION, existingServerType.toString(), serverType.toString());
                }
                if (serverTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                    newValue = newValue + " " + serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6).toString();
                }
                if (existingServerType == DHCPServerType.MIXED && serverType == DHCPServerType.DHCP) {
                    if (this.dhcpServerTypes().get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.AUTOCONFIG) {
                        this.removeAddressTypeFromVIPs(IPAddressUtil.IPAddrType.BOTH);
                        this.removeAddressTypeFromScanVIPs(IPAddressUtil.IPAddrType.BOTH);
                    } else {
                        this.removeAddressTypeFromVIPs(addrType);
                        this.removeAddressTypeFromScanVIPs(addrType);
                    }
                }
                Trace.out("INFO-->About to set \"" + ResourceType.Network.USR_ORA_AUTO.name() + "=" + newValue + "\"");
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Network.USR_ORA_AUTO.name(), newValue));
            } else if (addrType == IPAddressUtil.IPAddrType.IPv6) {
                if (checkAgainstExistingAddrType && existingAddrType == IPAddressUtil.IPAddrType.IPv4) {
                    Trace.out("Setting the ADDRESS_TYPE to 'IPv6' is not allowed unless the ADDRESS_TYPE is 'BOTH' (or 'IPv6')");
                    throw new NetworkException((MessageKey)PrCnMsgID.SETTING_ADDR_TYPE_TO_IPV6_NOT_ALLOWED, new Object[0]);
                }
                if (existingServerType == DHCPServerType.NONE && serverType == DHCPServerType.AUTOCONFIG || existingServerType == DHCPServerType.AUTOCONFIG && serverType == DHCPServerType.NONE) {
                    Trace.out("ERROR_INFO-->Modifying the server type from \"" + existingServerType.toString() + "\" to \"" + serverType.toString() + "\" directly is not allowed");
                    throw new NetworkException((MessageKey)PrCnMsgID.NOT_ALLOWED_DHCP_SERVER_TYPE_MODIFICATION, existingServerType.toString(), serverType.toString());
                }
                if (serverTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                    newValue = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4).toString() + " " + newValue;
                }
                if (existingServerType == DHCPServerType.MIXED && serverType == DHCPServerType.AUTOCONFIG) {
                    if (this.dhcpServerTypes().get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.DHCP) {
                        this.removeAddressTypeFromVIPs(IPAddressUtil.IPAddrType.BOTH);
                        this.removeAddressTypeFromScanVIPs(IPAddressUtil.IPAddrType.BOTH);
                    } else {
                        this.removeAddressTypeFromVIPs(addrType);
                        this.removeAddressTypeFromScanVIPs(addrType);
                    }
                }
                Trace.out("INFO-->About to set \"" + ResourceType.Network.USR_ORA_AUTO.name() + "=" + newValue + "\"");
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Network.USR_ORA_AUTO.name(), newValue));
            }
        }
        catch (SoftwareModuleException | CRSException | VIPNotFoundException e) {
            throw new NetworkException((MessageKey)PrCnMsgID.SET_DHCP_SERVER_TYPE_FAILED_FOR_SPECIFIED_ADDR_TYPE, addrType.toString().toLowerCase(), serverType.toString(), e);
        }
    }

    @Override
    public VIP vip(Node node) throws NotExistsException, NetworkException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    public List<Listener> listeners() throws NotExistsException, NetworkException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public List<Service> services() throws NotExistsException, NetworkException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, NetworkException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new NetworkException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, NetworkException {
        try {
            String vipNetType = ResourceType.ClusterVIP.getVIPNetTypeName(Integer.parseInt(NetworkImpl.getNumber(this.m_nameAttr.getValue())));
            NodeAppsFactoryImpl nodeAppsFactoryImpl = NodeAppsFactoryImpl.getInstance();
            nodeAppsFactoryImpl.assertRoot();
            try {
                DatabaseFactory dbFact = DatabaseFactory.getInstance();
                List<Database> dbList = dbFact.getDatabases();
                int netNum = this.getNumber();
                for (Database db : dbList) {
                    try {
                        if (db.getDefaultNetwork().getNumber() != netNum) continue;
                        throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_CONFLICT_DATABASE, netNum, db.getName());
                    }
                    catch (NotExistsException notExistsException) {
                    }
                }
            }
            catch (NotExistsException notExistsException) {
                // empty catch block
            }
            super.remove(force);
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException(sme);
        }
    }

    @Override
    public boolean compareAdapters(List<NetworkAdapter> adapterList) throws NetworkException {
        if (adapterList == null) {
            Trace.out("adapterList is null");
            return true;
        }
        Trace.out("adapterList size is " + adapterList.size());
        List<NetworkAdapter> nwAList = this.networkAdapters();
        if (adapterList.size() == 0 && nwAList.size() == 0) {
            return true;
        }
        boolean match = false;
        if (adapterList.size() != nwAList.size()) {
            return false;
        }
        for (NetworkAdapter nwa : nwAList) {
            match = false;
            for (NetworkAdapter adapter : adapterList) {
                if (!nwa.equals(adapter)) continue;
                match = true;
                break;
            }
            if (match) continue;
            break;
        }
        return match;
    }

    @Override
    public boolean compareSubnet(Subnet subnet) throws NetworkException {
        return this.compareSubnet(subnet, false);
    }

    private boolean compareSubnet(Subnet subnet, boolean applyNetmask) throws NetworkException {
        Subnet networkSubnet;
        if (subnet == null) {
            Trace.out("The provided subnet to compare against the network address is null");
            return false;
        }
        try {
            Map<IPAddressUtil.IPAddrType, Subnet> subnetMap = this.subnets();
            networkSubnet = subnetMap.get((Object)subnet.getIPAddrType());
            if (networkSubnet == null) {
                Trace.out("No " + subnet.getIPAddrType().toString() + " network subnet found to compare against the provided " + subnet.getIPAddrType().toString() + " subnet");
                return false;
            }
        }
        catch (NotExistsException nee) {
            throw new NetworkException(nee);
        }
        String netmaskStr = subnet.subnetMaskAsStr();
        String netwotkNetmaskStr = networkSubnet.subnetMaskAsStr();
        boolean match = netmaskStr.equals(netwotkNetmaskStr);
        if (match) {
            String subnetStr = subnet.getName();
            String networkSubnetStr = networkSubnet.getName();
            try {
                if (applyNetmask) {
                    subnetStr = IPAddressUtil.applyNetmaskOrPrefixLength(subnetStr, netmaskStr);
                    networkSubnetStr = IPAddressUtil.applyNetmaskOrPrefixLength(networkSubnetStr, netwotkNetmaskStr);
                }
                match = IPAddressUtil.sameIPAddresses(subnetStr, networkSubnetStr);
            }
            catch (IPAddressException ipae) {
                Trace.out("IPAddressException encountered while comparing the IP address \"" + subnet.getName() + "\" with the IP adress \"" + networkSubnet.getName() + "\". Details: " + ipae.getMessage());
                match = false;
            }
        }
        Trace.out("Comparing the network subnet \"" + networkSubnet.getName() + "/" + networkSubnet.subnetMaskAsStr() + "\" with the provided subnet \"" + subnet.getName() + "/" + subnet.subnetMaskAsStr() + "\" returns " + match);
        return match;
    }

    @Override
    public boolean compareMaskedSubnet(Subnet subnet) throws NetworkException {
        return this.compareSubnet(subnet, true);
    }

    @Override
    public boolean isLeafNW() throws NetworkException {
        return this.checkCategoryConfig(ServerCategory.ServerCategoryType.LEAF_CATEGORY);
    }

    @Override
    public boolean isExtendedNW() throws NetworkException {
        return this.checkCategoryConfig(ServerCategory.ServerCategoryType.NONE);
    }

    private boolean checkCategoryConfig(ServerCategory.ServerCategoryType category) throws NetworkException {
        this.assertCrsResource();
        try {
            ServerCategory.ServerCategoryType netwType = this.m_crsResource.getServerCategory();
            boolean isCategory = category.toString().equalsIgnoreCase(netwType.toString());
            Trace.out("Is network category " + category.toString() + ": " + isCategory);
            return isCategory;
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
    }

    public static String getResourceName(String netNum) {
        return ResourceNames.getNetworkResourceName(netNum);
    }

    public static String getNumber(String netResName) throws NetworkException {
        if (netResName == null) {
            throw new NetworkException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, ResourceType.Network.NAME.name(), netResName);
        }
        String[] value = netResName.split(Pattern.quote(String.valueOf('.')));
        if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.NETWORK.toString().equalsIgnoreCase(value[2])) {
            throw new NetworkException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Network.NAME.name(), netResName);
        }
        return value[1].substring(ResourceLiterals.NET.toString().length());
    }

    @Override
    public String[] getPingTargets() throws NetworkException {
        this.assertCrsResource();
        try {
            String currVal = this.m_crsResource.getAttribute(ResourceType.Network.PING_TARGET.name()).getValue();
            String[] pingTargets = currVal.isEmpty() ? new String[]{} : currVal.split(" ");
            return pingTargets;
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
    }

    public static String getFilter() {
        return "ora." + ResourceLiterals.NET.toString() + ResourceLiterals.STAR.toString() + '.' + ResourceLiterals.NETWORK.toString();
    }

    @Override
    public void modifyNetwork(GlobalNetworkClassification gnwcls) throws NetworkException {
        this.modifyNetwork(gnwcls, null);
    }

    @Override
    public void modifyNetwork(String[] pingTargets) throws NetworkException {
        this.modifyNetwork(null, pingTargets);
    }

    @Override
    public void modifyNetwork(GlobalNetworkClassification gnwcls, String[] pingTargets) throws NetworkException {
        ArrayList<String> attrNames = new ArrayList<String>();
        Subnet subnetInstance = null;
        String subnet = null;
        String netmask = null;
        this.assertMixed();
        if (gnwcls != null) {
            this.validateNetwork(gnwcls);
            subnetInstance = gnwcls.subNet();
            subnet = subnetInstance.getName().trim();
            netmask = subnetInstance.subnetMaskAsStr().trim();
            try {
                NodeAppsFactoryImpl nodeAppsFactoryImpl = NodeAppsFactoryImpl.getInstance();
                nodeAppsFactoryImpl.assertRoot();
                boolean isUniqueSubnet = false;
                try {
                    isUniqueSubnet = nodeAppsFactoryImpl.isUniqueSubnet(subnet, this);
                }
                catch (NetworkException ne) {
                    throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_VERIFY_SUBNET_UNIQUENESS, subnet);
                }
                if (!isUniqueSubnet) {
                    throw new NetworkException((MessageKey)PrCnMsgID.SUBNET_ALREADY_IN_USE, subnet);
                }
            }
            catch (SoftwareModuleException sme) {
                throw new NetworkException(sme);
            }
            attrNames.add(ResourceType.Network.USR_ORA_AUTO.name());
            attrNames.add(ResourceType.Network.USR_ORA_SUBNET.name());
            attrNames.add(ResourceType.Network.USR_ORA_NETMASK.name());
            attrNames.add(ResourceType.Network.USR_ORA_IF.name());
            attrNames.add(ResourceType.Network.ADDRESS_TYPE.name());
        }
        String newPingtarget = null;
        if (pingTargets != null) {
            newPingtarget = this.buildPingTargetString(pingTargets);
            attrNames.add(ResourceType.Network.PING_TARGET.name());
        }
        try {
            this.updateNetworkResourceAttributes(attrNames, gnwcls, newPingtarget, false, false);
        }
        catch (CRSException crse) {
            if (gnwcls != null && subnetInstance != null) {
                String ipAddrType;
                StringBuilder newAdapt = new StringBuilder();
                String string = ipAddrType = subnetInstance.getIPAddrType() != null ? subnetInstance.getIPAddrType().toString() : "";
                if (subnetInstance.getIPAddrType() == IPAddressUtil.IPAddrType.IPv4) {
                    throw new NetworkException((MessageKey)PrCnMsgID.MODIFY_NETWORK_FAILED, (Throwable)crse, this.getNumber(), subnet, netmask, ipAddrType, newAdapt.toString());
                }
                throw new NetworkException((MessageKey)PrCnMsgID.MODIFY_NETWORK_FAILED_IPV6, (Throwable)crse, this.getNumber(), subnet, netmask, ipAddrType, newAdapt.toString());
            }
            throw new NetworkException(crse);
        }
    }

    @Override
    public void setAddrTypeToBoth() throws NetworkException {
        NodeAppsFactoryImpl nodeAppsFactoryImpl;
        try {
            nodeAppsFactoryImpl = NodeAppsFactoryImpl.getInstance();
            nodeAppsFactoryImpl.assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException(sme);
        }
        this.assertCrsResource();
        this.assertMixed();
        Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = this.dhcpServerTypes();
        boolean ipv4NettypeIsStatic = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.NONE;
        boolean ipv6NettypeIsStatic = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.NONE;
        this.validateGnsVIP(IPAddressUtil.IPAddrType.BOTH);
        if (ipv4NettypeIsStatic) {
            this.validateVIPs(IPAddressUtil.IPAddrType.IPv4);
            if (ipv6NettypeIsStatic) {
                this.validateVIPs(IPAddressUtil.IPAddrType.IPv6);
                this.validateScanVIPs(IPAddressUtil.IPAddrType.BOTH);
            } else {
                this.validateScanVIPs(IPAddressUtil.IPAddrType.IPv4);
            }
        } else if (ipv6NettypeIsStatic) {
            this.validateVIPs(IPAddressUtil.IPAddrType.IPv6);
            this.validateScanVIPs(IPAddressUtil.IPAddrType.IPv6);
        }
        try {
            String subnetAttrValue = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_SUBNET.name()).getValue().trim();
            boolean hasBothSubnetTypes = subnetAttrValue.contains(" ");
            if (!hasBothSubnetTypes) {
                if (IPAddressUtil.isIPv4AddressString(subnetAttrValue)) {
                    throw new NetworkException((MessageKey)PrCnMsgID.CANNOT_CHANGE_NETWORK_ADDR_TYPE_TO_BOTH_MISSING_SUBNET, "IPv4");
                }
                if (IPAddressUtil.isIPv6AddressString(subnetAttrValue)) {
                    throw new NetworkException((MessageKey)PrCnMsgID.CANNOT_CHANGE_NETWORK_ADDR_TYPE_TO_BOTH_MISSING_SUBNET, "IPv6");
                }
                Trace.out("Internal error: USR_ORA_SUBNET was expected to have either a valid IPv4 or a valid IPv6 value, while 'USR_ORA_SUBNET=" + subnetAttrValue + "'");
                throw new NetworkException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "subnet_error-01");
            }
            if (ipv4NettypeIsStatic || ipv6NettypeIsStatic) {
                String[] nodes;
                try {
                    ClusterUtil clusterUtil = new ClusterUtil();
                    nodes = clusterUtil.getHUBNodes();
                }
                catch (ClusterUtilException cue) {
                    throw new NetworkException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_HUB_NODES, (Throwable)cue, new Object[0]);
                }
                int netNum = this.getNumber();
                StringBuilder nodesWithoutVIPs = new StringBuilder("");
                StringBuilder nodesWithMissingIPv4VIPs = new StringBuilder("");
                StringBuilder nodesWithMissingIPv6VIPs = new StringBuilder("");
                try {
                    Map<String, VIP> vipMap = nodeAppsFactoryImpl.getConfiguredVIPs(netNum);
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!vipMap.containsKey(nodes[i])) {
                            nodesWithoutVIPs.append(nodes[i]);
                            nodesWithoutVIPs.append(",");
                            nodesWithoutVIPs.append(" ");
                            continue;
                        }
                        VIP vip = vipMap.get(nodes[i]);
                        Map<IPAddressUtil.IPAddrType, InetAddress> currVIPAddrMap = vip.addresses();
                        if (ipv4NettypeIsStatic && !currVIPAddrMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                            nodesWithMissingIPv4VIPs.append(nodes[i]);
                            nodesWithMissingIPv4VIPs.append(",");
                            nodesWithMissingIPv4VIPs.append(" ");
                        }
                        if (!ipv6NettypeIsStatic || currVIPAddrMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) continue;
                        nodesWithMissingIPv6VIPs.append(nodes[i]);
                        nodesWithMissingIPv6VIPs.append(",");
                        nodesWithMissingIPv6VIPs.append(" ");
                    }
                }
                catch (VIPException vipex) {
                    throw new NetworkException((MessageKey)PrCnMsgID.CANNOT_CHANGE_NETWORK_ADDR_TYPE_TO_BOTH_MISSING_VIPS, (Throwable)vipex, new Object[0]);
                }
                StringBuilder errorMessage = new StringBuilder();
                if (nodesWithoutVIPs.length() > 0) {
                    errorMessage.append(MessageBundle.getMessage(PrCnMsgID.NODES_WITHOUT_CONFIGURED_VIPS, false, nodesWithoutVIPs.substring(0, nodesWithoutVIPs.length() - 2)));
                    errorMessage.append("\n");
                }
                if (nodesWithMissingIPv4VIPs.length() > 0) {
                    errorMessage.append(MessageBundle.getMessage(PrCnMsgID.NODES_WITHOUT_IPV4_VIPS, false, netNum, nodesWithMissingIPv4VIPs.substring(0, nodesWithMissingIPv4VIPs.length() - 2)));
                    errorMessage.append("\n");
                }
                if (nodesWithMissingIPv6VIPs.length() > 0) {
                    errorMessage.append(MessageBundle.getMessage(PrCnMsgID.NODES_WITHOUT_IPV6_VIPS, false, netNum, nodesWithMissingIPv6VIPs.substring(0, nodesWithMissingIPv6VIPs.length() - 2)));
                    errorMessage.append("\n");
                }
                if (errorMessage.length() > 0) {
                    throw new NetworkException((MessageKey)PrCnMsgID.CANNOT_CHANGE_NETWORK_ADDR_TYPE_TO_BOTH_MISSING_VIPS, errorMessage.toString());
                }
            }
            ResourceAttribute addressTypeAttr = new ResourceAttribute(ResourceType.Network.ADDRESS_TYPE.name(), IPAddressUtil.IPAddrType.BOTH.toString());
            this.m_crsResource.update(addressTypeAttr);
        }
        catch (CRSException crse) {
            throw new NetworkException(crse);
        }
    }

    @Override
    public void extendToLeaf(boolean doExtend) throws NetworkException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Network.SERVER_CATEGORY.name());
            if (doExtend) {
                Trace.out("Cleaning SERVER_CATEGORY attribute");
                attr.setValue("");
            } else {
                Trace.out("Setting SERVER_CATEGORY attribute to HUB");
                attr.setValue(ResourceLiterals.HUB_CATEGORY.toString());
            }
            this.m_crsResource.update(attr);
        }
        catch (CRSException ce) {
            throw new NetworkException(ce);
        }
    }

    private void updateNetworkResourceAttributes(List<String> attrNames, GlobalNetworkClassification gnwcls, String pingTargets, boolean clearIPv4, boolean clearIPv6) throws CRSAttributeNotFoundException, CRSException, NetworkException {
        EntityOperations entityOperations = EntityOperations.getInstance(EntityOperations.EntityOpsMode.CRS);
        this.assertCrsResource();
        List<ResourceAttribute> attrList = entityOperations.getResourceStat(this.m_crsResource, null, attrNames.toArray(new String[0]));
        if (attrList.size() != attrNames.size()) {
            ArrayList<String> attrNamesFound = new ArrayList<String>(attrList.size());
            for (ResourceAttribute resourceAttribute : attrList) {
                attrNamesFound.add(resourceAttribute.getName());
            }
            StringBuilder expectedButnotFoundAttrNames = new StringBuilder("");
            for (String currAttrName : attrNames) {
                if (attrNamesFound.contains(currAttrName)) continue;
                expectedButnotFoundAttrNames.append(currAttrName);
                expectedButnotFoundAttrNames.append(", ");
            }
            throw CRSAttributeNotFoundException.getInstance(expectedButnotFoundAttrNames.toString());
        }
        ArrayList<ResourceAttribute> resourceAttrToUpdateList = new ArrayList<ResourceAttribute>(attrNames.size());
        Subnet subnetInstace = gnwcls != null ? gnwcls.subNet() : null;
        for (ResourceAttribute currAttr : attrList) {
            String newAttrValue;
            String tokenToUpdate;
            String string = currAttr.getName();
            String currAttrValue = currAttr.getValue();
            String[] tokens = currAttrValue.split(" ");
            if (string.equals(ResourceType.Network.USR_ORA_SUBNET.name())) {
                if (clearIPv4 || clearIPv6) {
                    if (clearIPv4) {
                        tokens = this.clearIPv4Value(tokens);
                    } else if (clearIPv6) {
                        tokens = this.clearIPv6Value(tokens);
                    }
                } else {
                    tokenToUpdate = subnetInstace.getName();
                    tokens = this.updateSubnet(tokens, tokenToUpdate);
                }
                newAttrValue = tokens.length == 1 ? tokens[0] : tokens[0] + " " + tokens[1];
                Trace.out("New value for attribute \"" + string + "\": " + newAttrValue);
                currAttr.setValue(newAttrValue);
                resourceAttrToUpdateList.add(currAttr);
                continue;
            }
            if (string.equals(ResourceType.Network.USR_ORA_NETMASK.name())) {
                if (clearIPv4 || clearIPv6) {
                    if (clearIPv4) {
                        tokens = this.clearIPv4Value(tokens);
                    } else if (clearIPv6) {
                        tokens = this.clearIPv6Value(tokens);
                    }
                } else {
                    tokenToUpdate = subnetInstace.subnetMaskAsStr();
                    tokens = this.updateNetmask(tokens, tokenToUpdate);
                }
                newAttrValue = tokens.length == 1 ? tokens[0] : tokens[0] + " " + tokens[1];
                Trace.out("New value for attribute \"" + string + "\": " + newAttrValue);
                currAttr.setValue(newAttrValue);
                resourceAttrToUpdateList.add(currAttr);
                continue;
            }
            if (string.equals(ResourceType.Network.USR_ORA_IF.name())) {
                if (gnwcls == null) continue;
                String[] ifList = gnwcls.getNetworkInterfaceNames();
                newAttrValue = CRSFactoryImpl.getInstance().convertArrToCRSAttrValue(ifList);
                if (!newAttrValue.trim().equals("")) {
                    String subnet = null;
                    String netmask = null;
                    IPAddressUtil.IPAddrType addrTypeToModify = gnwcls.subNet().getIPAddrType();
                    if (addrTypeToModify == IPAddressUtil.IPAddrType.IPv4) {
                        try {
                            Subnet ipv6Subnet = this.subnet_ipv6();
                            subnet = ipv6Subnet.getName();
                            netmask = ipv6Subnet.subnetMaskAsStr();
                        }
                        catch (NotExistsException nee) {
                            Trace.out("No IPv6 subnet found. Therefore, validating interface \"" + newAttrValue + "\" against IPv6 subnet/prefix length is not required");
                        }
                    } else if (addrTypeToModify == IPAddressUtil.IPAddrType.IPv6) {
                        try {
                            Subnet ipv4Subnet = this.subnet();
                            subnet = ipv4Subnet.getName();
                            netmask = ipv4Subnet.subnetMaskAsStr();
                        }
                        catch (NotExistsException nee) {
                            Trace.out("No IPv4 subnet found. Therefore, validating interface \"" + newAttrValue + "\" against IPv4 subnet/netmask is not required");
                        }
                    }
                    if (subnet != null && netmask != null) {
                        String[] interfaces = new String[]{newAttrValue};
                        Trace.out("Checking if 'oifcfg iflist -p -n' returns a match for '" + subnet + "/" + netmask + "/" + interfaces[0] + "' as expected");
                        GlobalNetworkClassificationImpl gnwclsToValidate = new GlobalNetworkClassificationImpl(subnet, netmask, interfaces);
                        this.validateNetwork(gnwclsToValidate);
                        Trace.out("Successful interface validation");
                    }
                    currAttr.setValue(newAttrValue);
                    resourceAttrToUpdateList.add(currAttr);
                    continue;
                }
                IPAddressUtil.IPAddrType addrTypeToObtainInterfaceName = gnwcls.subNet().getIPAddrType() == IPAddressUtil.IPAddrType.IPv4 ? IPAddressUtil.IPAddrType.IPv6 : IPAddressUtil.IPAddrType.IPv4;
                try {
                    Subnet subnet = this.subnet(addrTypeToObtainInterfaceName);
                    Trace.out(addrTypeToObtainInterfaceName.toString() + " subnet found which means that we" + " keep the exising USR_ORA_IF value (USR_ORA_IF=" + currAttrValue + ").");
                }
                catch (NotExistsException nee) {
                    Trace.out("No " + addrTypeToObtainInterfaceName.toString() + " subnet found which means that we" + " should clear USR_ORA_IF");
                    currAttr.setValue("");
                    resourceAttrToUpdateList.add(currAttr);
                }
                continue;
            }
            if (string.equals(ResourceType.Network.ADDRESS_TYPE.name())) {
                Object[] args;
                if (!clearIPv4 && !clearIPv6) continue;
                newAttrValue = null;
                if (clearIPv4) {
                    if (currAttrValue.trim().equals(IPAddressUtil.IPAddrType.IPv4.toString())) {
                        args = new Object[]{"IPv4", "IPv6"};
                        throw new CRSException((MessageKey)PrCnMsgID.INVALID_ADDRESS_TYPE_MODIFICATION, args);
                    }
                    if (currAttrValue.equals(IPAddressUtil.IPAddrType.BOTH.toString())) {
                        newAttrValue = IPAddressUtil.IPAddrType.IPv6.toString();
                    }
                }
                if (clearIPv6) {
                    if (currAttrValue.equals(IPAddressUtil.IPAddrType.IPv6.toString())) {
                        args = new Object[]{"IPv6", "IPv4"};
                        throw new CRSException((MessageKey)PrCnMsgID.INVALID_ADDRESS_TYPE_MODIFICATION, args);
                    }
                    if (currAttrValue.equals(IPAddressUtil.IPAddrType.BOTH.toString())) {
                        String string2 = newAttrValue = clearIPv4 ? "" : IPAddressUtil.IPAddrType.IPv4.toString();
                    }
                }
                if (newAttrValue == null) continue;
                Trace.out("New value for attribute \"" + string + "\": " + newAttrValue);
                currAttr.setValue(newAttrValue);
                resourceAttrToUpdateList.add(currAttr);
                continue;
            }
            if (string.equals(ResourceType.Network.USR_ORA_AUTO.name())) {
                String usr_ora_auto_value;
                String usr_ora_auto = this.m_crsResource.getAttribute(ResourceType.Network.USR_ORA_AUTO.name()).getValue().trim();
                String[] usr_ora_auto_tokens = usr_ora_auto.split(" ");
                if (clearIPv4 || clearIPv6) {
                    if (usr_ora_auto_tokens.length != 2) {
                        Object[] args = new Object[]{usr_ora_auto};
                        throw new NetworkException((MessageKey)PrCtMsgID.UNEXPECTED_USR_ORA_AUTO_VALUE, args);
                    }
                    if (clearIPv4) {
                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Network.USR_ORA_AUTO.name(), usr_ora_auto_tokens[1]));
                        continue;
                    }
                    if (!clearIPv6) continue;
                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Network.USR_ORA_AUTO.name(), usr_ora_auto_tokens[0]));
                    continue;
                }
                if (usr_ora_auto_tokens.length != 1) continue;
                IPAddressUtil.IPAddrType networkAddrType = this.addressType();
                IPAddressUtil.IPAddrType subnetAddrType = subnetInstace.getIPAddrType();
                if (networkAddrType == IPAddressUtil.IPAddrType.IPv4 && subnetAddrType == IPAddressUtil.IPAddrType.IPv6) {
                    usr_ora_auto_value = usr_ora_auto_tokens[0] + " " + (Object)((Object)DHCPServerType.NONE);
                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Network.USR_ORA_AUTO.name(), usr_ora_auto_value));
                    continue;
                }
                if (networkAddrType != IPAddressUtil.IPAddrType.IPv6 || subnetAddrType != IPAddressUtil.IPAddrType.IPv4) continue;
                usr_ora_auto_value = (Object)((Object)DHCPServerType.NONE) + " " + usr_ora_auto_tokens[0];
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Network.USR_ORA_AUTO.name(), usr_ora_auto_value));
                continue;
            }
            if (pingTargets == null || !string.equals(ResourceType.Network.PING_TARGET.name())) continue;
            newAttrValue = pingTargets;
            currAttr.setValue(newAttrValue);
            resourceAttrToUpdateList.add(currAttr);
        }
        try {
            this.m_crsResource.update(resourceAttrToUpdateList);
        }
        catch (AlreadyExistsException aee) {
            throw new CRSException(aee);
        }
    }

    private String[] clearIPv4Value(String[] attrValueTokens) throws CRSException {
        if (attrValueTokens.length == 1 && IPAddressUtil.isIPv4AddressString(attrValueTokens[0])) {
            Object[] args = new Object[]{"IPv4", "IPv6"};
            throw new CRSException((MessageKey)PrCnMsgID.INVALID_ADDRESS_TYPE_MODIFICATION, args);
        }
        if (attrValueTokens.length == 2) {
            String ipv6Value = attrValueTokens[1];
            attrValueTokens = new String[]{ipv6Value};
        }
        return attrValueTokens;
    }

    private String[] clearIPv6Value(String[] attrValueTokens) throws CRSException {
        if (attrValueTokens.length == 1) {
            try {
                Integer.valueOf(attrValueTokens[0]);
                Object[] args = new Object[]{"IPv6", "IPv4"};
                throw new CRSException((MessageKey)PrCnMsgID.INVALID_ADDRESS_TYPE_MODIFICATION, args);
            }
            catch (NumberFormatException args) {}
        } else if (attrValueTokens.length == 2) {
            String ipv4Value = attrValueTokens[0];
            attrValueTokens = new String[]{ipv4Value};
        }
        return attrValueTokens;
    }

    private String[] updateSubnet(String[] attrValueTokens, String newValue) {
        if (IPAddressUtil.isIPv4AddressString(newValue)) {
            if (attrValueTokens.length == 1) {
                if (IPAddressUtil.isIPv4AddressString(attrValueTokens[0])) {
                    attrValueTokens[0] = newValue;
                } else {
                    String ipv6Subnet = attrValueTokens[0];
                    attrValueTokens = new String[]{newValue, ipv6Subnet};
                }
            } else if (attrValueTokens.length == 2) {
                attrValueTokens[0] = newValue;
            }
        } else if (IPAddressUtil.isIPv6AddressString(newValue)) {
            if (attrValueTokens.length == 1) {
                if (IPAddressUtil.isIPv6AddressString(attrValueTokens[0])) {
                    attrValueTokens[0] = newValue;
                } else {
                    String ipv4Subnet = attrValueTokens[0];
                    attrValueTokens = new String[]{ipv4Subnet, newValue};
                }
            } else if (attrValueTokens.length == 2) {
                attrValueTokens[1] = newValue;
            }
        }
        return attrValueTokens;
    }

    private String[] updateNetmask(String[] attrValueTokens, String newValue) throws NetworkException {
        boolean newValueIsIPv4 = false;
        boolean newValueIsIPv6 = false;
        try {
            Integer.valueOf(newValue);
            newValueIsIPv6 = true;
        }
        catch (NumberFormatException nfe) {
            newValueIsIPv4 = IPAddressUtil.isIPv4AddressString(newValue);
        }
        if (!newValueIsIPv4 && !newValueIsIPv6) {
            throw new NetworkException((MessageKey)PrCnMsgID.INVALID_NETMASK, newValue);
        }
        if (attrValueTokens.length == 2) {
            if (newValueIsIPv4) {
                attrValueTokens[0] = newValue;
            } else {
                attrValueTokens[1] = newValue;
            }
            return attrValueTokens;
        }
        if (attrValueTokens.length == 1) {
            boolean existingValueIsIPv4 = false;
            boolean existingValueIsIPv6 = false;
            try {
                Integer.valueOf(attrValueTokens[0]);
                existingValueIsIPv6 = true;
            }
            catch (NumberFormatException nfe) {
                existingValueIsIPv4 = true;
            }
            if (existingValueIsIPv4 && newValueIsIPv4 || existingValueIsIPv6 && newValueIsIPv6) {
                attrValueTokens[0] = newValue;
                return attrValueTokens;
            }
            if (existingValueIsIPv4 && newValueIsIPv6) {
                String ipv4Netmask = attrValueTokens[0];
                attrValueTokens = new String[]{ipv4Netmask, newValue};
                return attrValueTokens;
            }
            if (existingValueIsIPv6 && newValueIsIPv4) {
                String ipv6PrefixLength = attrValueTokens[0];
                attrValueTokens = new String[]{newValue, ipv6PrefixLength};
                return attrValueTokens;
            }
        }
        throw new NetworkException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "netmask_error-01");
    }

    private void validateNetwork(GlobalNetworkClassification gnwcls) throws NetworkException {
        List<OIFCFGResult> oifcfgResults;
        String gnwinterfaces;
        Subnet gnwclsSubnet = gnwcls.subNet();
        String gnwclsSubnetMask = gnwclsSubnet.subnetMaskAsStr();
        String gnwclsSubnetStr = gnwclsSubnet.getName();
        if (gnwclsSubnetMask == null || gnwclsSubnetStr == null) {
            Trace.out("Validate network with null value: netmask = " + gnwclsSubnetMask + ", subnet = " + gnwclsSubnetStr);
            return;
        }
        try {
            new VIPAddress(gnwclsSubnetStr, gnwclsSubnetMask, null);
        }
        catch (VirtualIPException e) {
            throw new NetworkException(e);
        }
        try {
            gnwinterfaces = CRSFactoryImpl.getInstance().convertArrToCRSAttrValue(gnwcls.getNetworkInterfaceNames());
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
        Trace.out("Validate network - Subnet: " + gnwclsSubnetStr + ", Netmask: " + gnwclsSubnetMask + ", Interfaces: " + gnwinterfaces);
        String localnode = "localnode";
        try {
            String bindir = new Util().getCRSHome() + File.separator + "bin";
            Trace.out("Calling " + bindir + File.separator + "oifcfg for node " + localnode);
            oifcfgResults = new ClusterwareInfo().listInterfaces(localnode, bindir, false);
        }
        catch (UtilException e) {
            throw new NetworkException((MessageKey)PrCtMsgID.GETCRSHOME_FAIL, e.getMessage());
        }
        catch (InstallException e) {
            throw new NetworkException((MessageKey)PrCtMsgID.OIFCFG_FAIL, e.getMessage());
        }
        String netmask = "";
        boolean found = false;
        for (OIFCFGResult oifcfgResult : oifcfgResults) {
            boolean subnetMatch;
            String ifName;
            block25: {
                ifName = oifcfgResult.getInterfaceName();
                String subnet = oifcfgResult.getSubnet().getHostAddress();
                if (oifcfgResult.getType() == IPAddressUtil.IPAddrType.IPv4 || oifcfgResult.getType() == IPAddressUtil.IPAddrType.IPv6) {
                    netmask = oifcfgResult.getSubnetMaskAsString();
                }
                Trace.out("Check interface: " + ifName + ", subnet: " + subnet + ", netmask: " + netmask);
                subnetMatch = false;
                try {
                    List<Network> networkList;
                    if (gnwcls.subNet().getIPAddrType() == IPAddressUtil.IPAddrType.IPv4) {
                        subnetMatch = IPAddressUtil.sameIPAddresses(subnet, gnwclsSubnetStr);
                        break block25;
                    }
                    if (gnwcls.subNet().getIPAddrType() != IPAddressUtil.IPAddrType.IPv6) break block25;
                    int prefixLength = Integer.valueOf(gnwclsSubnetMask);
                    String gnwclsSubnetAfterApplyingPrefixLengthStr = IPAddressUtil.keepLeftHandBits(gnwclsSubnetStr, prefixLength);
                    if (!gnwclsSubnetStr.startsWith("fe80:")) {
                        subnetMatch = IPAddressUtil.sameIPAddresses(subnet, gnwclsSubnetAfterApplyingPrefixLengthStr);
                        break block25;
                    }
                    try {
                        networkList = NodeAppsFactory.getInstance().getNetworks();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new NetworkException(sme);
                    }
                    catch (NotExistsException e) {
                        networkList = null;
                    }
                    if (networkList != null) {
                        SubnetImpl gnwclsSubnetAfterApplyingPrefixLength = new SubnetImpl(gnwclsSubnetAfterApplyingPrefixLengthStr, gnwclsSubnetMask);
                        int gnwclsNetNum = this.getNumber();
                        for (Network currNetwork : networkList) {
                            if (gnwclsNetNum == currNetwork.getNumber() || !currNetwork.compareSubnet(gnwclsSubnetAfterApplyingPrefixLength)) continue;
                            StringBuffer networkInterfaces = new StringBuffer();
                            List<NetworkAdapter> netList = gnwcls.networkAdapters();
                            for (NetworkAdapter currNetworkAdapter : netList) {
                                networkInterfaces.append(currNetworkAdapter.getAdapterName());
                            }
                            StringBuffer existingNetworkInterfaces = new StringBuffer();
                            List<NetworkAdapter> existingNetList = currNetwork.networkAdapters();
                            for (NetworkAdapter currNetworkAdapter : existingNetList) {
                                existingNetworkInterfaces.append(currNetworkAdapter.getAdapterName());
                            }
                            String existingNewtorkSubnet = "";
                            try {
                                existingNewtorkSubnet = currNetwork.subnet_ipv6().getName();
                            }
                            catch (NotExistsException nee) {
                                Trace.out("No IPv6 subnet found for network \"" + currNetwork.getName() + "\"");
                            }
                            throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_CONFLICT_SUBNET, gnwclsNetNum, gnwclsSubnetStr, networkInterfaces.toString(), currNetwork.getNumber(), existingNewtorkSubnet, existingNetworkInterfaces.toString());
                        }
                    }
                    found = true;
                }
                catch (IPAddressException ipae) {
                    throw new NetworkException(ipae);
                }
            }
            if (subnetMatch && netmask.equals(gnwclsSubnetMask) && gnwcls.containsInterface(ifName)) {
                found = true;
                break;
            }
            if (!gnwclsSubnetStr.startsWith("10.") && !gnwclsSubnetStr.startsWith("0.")) continue;
            Trace.out("Allows 10.x.x.x IP or 0.x.x.x IP " + gnwclsSubnetStr + " for testing");
            found = true;
        }
        if (!found) {
            Trace.out("Network not found, validation failed");
            throw new NetworkException((MessageKey)PrCnMsgID.VALIDATE_NETWORK_FAILED, gnwclsSubnetStr, gnwclsSubnetMask, gnwinterfaces);
        }
    }

    private String buildPingTargetString(String[] pingTargets) throws NetworkException {
        StringBuilder result = new StringBuilder("");
        HashSet<String> addedPingt = new HashSet<String>(pingTargets.length);
        if (pingTargets.length != 0) {
            for (String pt : pingTargets) {
                try {
                    if (pt == null) continue;
                    boolean isNumericIP = IPAddressUtil.isIPAddressString(pt);
                    InetAddress inet = InetAddress.getByName(pt.trim());
                    String currIPAddress = inet.getHostAddress();
                    if (addedPingt.contains(currIPAddress)) {
                        throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_DUPLICATED_PING_TARGET, new Object[0]);
                    }
                    result.append(" ");
                    addedPingt.add(currIPAddress);
                    if (isNumericIP) {
                        Trace.out("Ping Target is IP address: " + currIPAddress);
                        result.append(currIPAddress);
                        continue;
                    }
                    Trace.out("Ping Target is hostname: " + pt.trim());
                    result.append(inet.getHostName());
                }
                catch (UnknownHostException ex) {
                    throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_INVALID_PING_TARGET, pt);
                }
            }
        }
        return result.toString().trim();
    }

    private void assertMixed() throws NetworkException {
        this.assertMixed(null, null);
    }

    private boolean isDefault() {
        try {
            if (this.getNumber() == 1) {
                return true;
            }
        }
        catch (NetworkException ne) {
            Trace.out("An error ocurred getting the network number for thisresource");
        }
        return false;
    }

    private void assertMixed(DHCPServerType newServerType, IPAddressUtil.IPAddrType addrType) throws NetworkException {
        Map<IPAddressUtil.IPAddrType, DHCPServerType> curServerTypeMap = this.dhcpServerTypes();
        boolean isIPv4Mixed = false;
        boolean isIPv6Mixed = false;
        if (curServerTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && curServerTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.MIXED) {
            isIPv4Mixed = true;
        }
        if (curServerTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && curServerTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.MIXED) {
            isIPv6Mixed = true;
        }
        if (newServerType != null && addrType != null && curServerTypeMap.containsKey((Object)addrType) && curServerTypeMap.get((Object)addrType) == DHCPServerType.MIXED && newServerType != DHCPServerType.MIXED) {
            Trace.out((Object)"Allow change of network type for the %s subnet", addrType.toString());
            return;
        }
        if (isIPv4Mixed || isIPv6Mixed) {
            Trace.out("Error, network is configured as mixed, cannot makeany other change");
            throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_SUBNET_MIXED_ERROR, new Object[0]);
        }
    }

    private void assertStaticSCAN(IPAddressUtil.IPAddrType ipType) throws NetworkException {
        try {
            ScanFactoryImpl scanFact = ScanFactoryImpl.getInstance();
            ScanImpl scan = (ScanImpl)scanFact.getScan(this.getNumber());
            List<ScanVIP> svipLst = scan.vips();
            if (!svipLst.isEmpty()) {
                String scanName = svipLst.get(0).getScanName();
                scanFact.assertStaticAddr(ipType, scanName);
            } else {
                Trace.out("No SCAN are configured for this network, skip check");
            }
        }
        catch (ScanException se) {
            Trace.out("No SCAN configured for this network, do not check SCAN VIPs");
        }
        catch (NotExistsException nee) {
            Trace.out("No SCAN VIPs are configured for this SCAN");
            throw new NetworkException(nee);
        }
        catch (SoftwareModuleException sme) {
            throw new NetworkException(sme);
        }
    }

    private void assertCrsResource() throws NetworkException {
        try {
            if (this.m_crsResource == null || !this.m_crsResource.isRegistered()) {
                throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_NOT_EXIST, new Object[0]);
            }
        }
        catch (CRSException ce) {
            throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_NOT_EXIST, (Throwable)ce, new Object[0]);
        }
    }
}

