/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nfs;

import java.util.List;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.hanfs.MountFS;
import oracle.cluster.hanfs.MountFSArgs;
import oracle.cluster.hanfs.MountFSException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.hanfs.MountFSImpl;
import oracle.cluster.nfs.NFS;
import oracle.cluster.nfs.NFSException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.trace.Trace;

public class NFSImpl
extends SoftwareModuleImpl
implements NFS {
    private static String REMOVE_SPEC_CHARS = "[^a-zA-Z0-9]";
    protected ResourceAttribute m_nameAttr;
    private MountFSImpl m_mountFS;

    public NFSImpl(MountFS mtFS) {
        this.m_mountFS = (MountFSImpl)mtFS;
    }

    public NFSImpl(ResourceAttribute nameAttr) throws NFSException {
        try {
            this.m_mountFS = new MountFSImpl(nameAttr);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void create(String mountPointPath, String exportPath, String exportServer, String user, String mountOptions) throws AlreadyExistsException, NFSException {
        try {
            this.m_mountFS.create(mountPointPath, exportPath, exportServer, user, mountOptions);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void modifyNFS(FileSystemOptionalArgs fsOptionalArgs) throws NFSException {
        try {
            MountFSArgs mtArgs = new MountFSArgs();
            String exportServer = fsOptionalArgs.getExportServer();
            String exportPath = fsOptionalArgs.getExportPath();
            String mountOptions = fsOptionalArgs.getFSOptions();
            if (exportServer != null && exportServer.length() > 0) {
                mtArgs.setExportServer(exportServer);
            }
            if (exportPath != null && exportPath.length() > 0) {
                mtArgs.setExportPath(exportPath);
            }
            if (mountOptions != null) {
                mtArgs.setMountOptions(mountOptions);
            }
            this.m_mountFS.modifyMountFS(mtArgs);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, NFSException {
        try {
            this.m_mountFS.remove(force);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public String getExportServer() throws NFSException {
        try {
            return this.m_mountFS.getExportServer();
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void setExportServer(String exportServer) throws NFSException {
        try {
            this.m_mountFS.setExportServer(exportServer);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public String getExportPath() throws NFSException {
        try {
            return this.m_mountFS.getExportPath();
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void setExportPath(String exportPath) throws NFSException {
        try {
            this.m_mountFS.setExportPath(exportPath);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public String getMountPointPath() throws NFSException {
        try {
            return this.m_mountFS.getMountPointPath();
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public String getNFSName() {
        return this.m_mountFS.getMountFSName();
    }

    @Override
    public String getName() {
        return this.m_mountFS.getName();
    }

    @Override
    public String getMountOptions() throws NFSException {
        try {
            return this.m_mountFS.getMountOptions();
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void setMountOptions(String mountOptions) throws NFSException {
        try {
            this.m_mountFS.setMountOptions(mountOptions);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void setUser(String user) throws NFSException {
        try {
            this.m_mountFS.setUser(user);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public boolean isGHCreated() throws NFSException {
        try {
            return this.m_mountFS.isGHCreated();
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void setGHCreated(boolean ghCreated) throws NFSException {
        try {
            this.m_mountFS.setGHCreated(ghCreated);
        }
        catch (MountFSException e) {
            Trace.out("Got CRSException: " + e.getMessage());
            throw new NFSException(e);
        }
    }

    public static String getResourceName(String nfsResName) {
        return MountFSImpl.getResourceName(nfsResName);
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, NFSException {
        try {
            Trace.out("calling parent's crsResource");
            return this.m_mountFS.crsResource();
        }
        catch (SoftwareModuleException sme) {
            throw new NFSException(sme);
        }
    }

    public static String hashMountPath(String mountpath) throws NFSException {
        try {
            return MountFSImpl.hashMountPath(mountpath);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    @Override
    public void start(List<Node> nodes) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        this.m_mountFS.start(nodes);
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        this.m_mountFS.start();
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        this.m_mountFS.stop(force);
    }

    @Override
    public void stop(List<Node> nodes, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        this.m_mountFS.stop(nodes, force);
    }

    @Override
    public boolean isEnabled() throws SoftwareModuleException {
        return this.m_mountFS.isEnabled();
    }

    @Override
    public boolean isEnabled(Node node) throws SoftwareModuleException {
        return this.m_mountFS.isEnabled(node);
    }

    @Override
    public boolean isRunning() throws SoftwareModuleException {
        return this.m_mountFS.isRunning();
    }

    @Override
    public boolean isRunning(Node node) throws SoftwareModuleException {
        return this.m_mountFS.isRunning(node);
    }
}

