/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nfs;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.hanfs.MountFS;
import oracle.cluster.hanfs.MountFSArgs;
import oracle.cluster.hanfs.MountFSException;
import oracle.cluster.impl.hanfs.HANFSFactoryImpl;
import oracle.cluster.impl.nfs.NFSImpl;
import oracle.cluster.nfs.NFS;
import oracle.cluster.nfs.NFSException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;

public class NFSFactoryImpl {
    private static NFSFactoryImpl s_instance;
    private HANFSFactoryImpl m_hFactory;
    private static String m_crsHome;

    private NFSFactoryImpl() throws SoftwareModuleException {
        try {
            m_crsHome = new Util().getCRSHome();
            this.m_hFactory = HANFSFactoryImpl.getInstance();
        }
        catch (UtilException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public static synchronized NFSFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new NFSFactoryImpl();
        }
        return s_instance;
    }

    public NFS createNFS(String mountPointPath, String name, String exportPath, String exportServer) throws AlreadyExistsException, NFSException {
        try {
            MountFS mtFS = this.m_hFactory.createMountFS(mountPointPath, name, exportPath, exportServer);
            return new NFSImpl(mtFS);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    public NFS createNFS(FileSystemOptionalArgs fsOptionalArgs) throws AlreadyExistsException, NFSException {
        try {
            MountFSArgs mtArgs = new MountFSArgs();
            if (fsOptionalArgs.getMountPointPath() != null) {
                mtArgs.setMountPointPath(fsOptionalArgs.getMountPointPath());
            }
            if (fsOptionalArgs.getNFSName() != null) {
                mtArgs.setMountFSName(fsOptionalArgs.getNFSName());
            }
            if (fsOptionalArgs.getExportServer() != null) {
                mtArgs.setExportServer(fsOptionalArgs.getExportServer());
            }
            if (fsOptionalArgs.getExportPath() != null) {
                mtArgs.setExportPath(fsOptionalArgs.getExportPath());
            }
            if (fsOptionalArgs.getFSOptions() != null) {
                mtArgs.setMountOptions(fsOptionalArgs.getFSOptions());
            }
            if (fsOptionalArgs.getUser() != null) {
                mtArgs.setUser(fsOptionalArgs.getUser());
            }
            return new NFSImpl(this.m_hFactory.createMountFS(mtArgs));
        }
        catch (SoftwareModuleException sme) {
            throw new NFSException(sme);
        }
    }

    public NFS getNFS(String mountpointpath) throws NotExistsException, NFSException {
        try {
            return new NFSImpl(this.m_hFactory.getMountFS(mountpointpath));
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    public NFS getNFSbyName(String resName) throws NotExistsException, NFSException {
        try {
            return new NFSImpl(this.m_hFactory.getMountFSbyName(resName));
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    public List<NFS> getNFSList() throws NotExistsException, NFSException {
        try {
            List<MountFS> mtFSList = this.m_hFactory.getMountFSList();
            ArrayList<NFS> nfsList = new ArrayList<NFS>(mtFSList.size());
            for (MountFS mt : mtFSList) {
                nfsList.add(new NFSImpl(mt));
            }
            return nfsList;
        }
        catch (MountFSException sme) {
            throw new NFSException(sme);
        }
    }

    public void validateMountNFS(String mountPointPath) throws NFSException {
        try {
            this.m_hFactory.validateMountFS(mountPointPath);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }

    public void validateExportServer(String addressOrName) throws NFSException {
        try {
            this.m_hFactory.validateExportServer(addressOrName);
        }
        catch (MountFSException mfe) {
            throw new NFSException(mfe);
        }
    }
}

